/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder.transform;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;

public abstract class Transform {
    public abstract MethodHandle up(MethodHandle var1);

    public abstract MethodType down(MethodType var1);

    public abstract String toString();

    public abstract String toJava(MethodType var1);

    protected static void buildClassArguments(StringBuilder builder, Class<?>[] types) {
        boolean second2 = false;
        for (Class<?> cls : types) {
            if (second2) {
                builder.append(", ");
            }
            second2 = true;
            Transform.buildClassArgument(builder, cls);
        }
    }

    protected static void buildClassArgument(StringBuilder builder, Class cls) {
        Transform.buildClass(builder, cls);
        builder.append(".class");
    }

    protected static void buildClassCast(StringBuilder builder, Class cls) {
        builder.append('(');
        Transform.buildClass(builder, cls);
        builder.append(')');
    }

    protected static void buildPrimitiveJava(StringBuilder builder, Object value2) {
        builder.append(value2.toString());
        if (value2.getClass() == Float.class) {
            builder.append('F');
        }
        if (value2.getClass() == Long.class) {
            builder.append('L');
        }
    }

    private static void buildClass(StringBuilder builder, Class cls) {
        int arrayDims = 0;
        Class<?> tmp = cls;
        while (tmp.isArray()) {
            ++arrayDims;
            tmp = tmp.getComponentType();
        }
        builder.append(tmp.getName());
        if (arrayDims > 0) {
            while (arrayDims > 0) {
                builder.append("[]");
                --arrayDims;
            }
        }
    }

    public static String generateMethodType(MethodType source2) {
        StringBuilder builder = new StringBuilder("MethodType.methodType(");
        Transform.buildClassArgument(builder, (Class)source2.returnType());
        if (source2.parameterCount() > 0) {
            builder.append(", ");
            Transform.buildClassArguments(builder, source2.parameterArray());
        }
        builder.append(")");
        return builder.toString();
    }
}

