/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.jruby.ir.IRFlags;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.LoadLocalVarInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.StoreLocalVarInstr;
import org.jruby.ir.interpreter.FullInterpreterContext;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.passes.LiveVariableAnalysis;
import org.jruby.ir.representations.BasicBlock;

public class OptimizeDynScopesPass
extends CompilerPass {
    @Override
    public String getLabel() {
        return "Optimize Dynamic Scopes";
    }

    @Override
    public String getShortLabel() {
        return "Opt Dyn Scopes";
    }

    private void setupLocalVarReplacement(LocalVariable v, FullInterpreterContext fic, Map<Operand, Operand> varRenameMap) {
        if (varRenameMap.get(v) == null) {
            varRenameMap.put(v, fic.getNewTemporaryVariableFor(v));
        }
    }

    private void decrementScopeDepth(LocalVariable v, Map<Operand, Operand> varRenameMap) {
        if (varRenameMap.get(v) == null) {
            varRenameMap.put(v, v.cloneForDepth(v.getScopeDepth() - 1));
        }
    }

    public void eliminateLocalVars(FullInterpreterContext fic) {
        assert (fic.getScope().getClosures().isEmpty()) : "We assume that if a scope has nested closures, it uses a dynamic scoope.";
        HashMap<Operand, Operand> varRenameMap = new HashMap<Operand, Operand>();
        fic.setDynamicScopeEliminated(true);
        boolean parentScopeNeeded = false;
        for (BasicBlock b2 : fic.getCFG().getBasicBlocks()) {
            ListIterator<Instr> instrs = b2.getInstrs().listIterator();
            while (instrs.hasNext()) {
                Variable v;
                Instr i2 = instrs.next();
                if (i2 instanceof ResultInstr && (v = ((ResultInstr)((Object)i2)).getResult()) instanceof LocalVariable && !v.isSelf()) {
                    LocalVariable lv = (LocalVariable)v;
                    if (lv.getScopeDepth() == 0) {
                        this.setupLocalVarReplacement(lv, fic, varRenameMap);
                    } else {
                        parentScopeNeeded = true;
                        this.decrementScopeDepth(lv, varRenameMap);
                    }
                }
                for (Variable v2 : i2.getUsedVariables()) {
                    StoreLocalVarInstr slvi;
                    LoadLocalVarInstr llvi;
                    if (!(v2 instanceof LocalVariable) || v2.isSelf()) continue;
                    LocalVariable lv = (LocalVariable)v2;
                    if (lv.getScopeDepth() == 0) {
                        if (i2 instanceof LoadLocalVarInstr) {
                            llvi = (LoadLocalVarInstr)i2;
                            if (llvi.getLocalVar() == lv) {
                                instrs.remove();
                            }
                        } else if (i2 instanceof StoreLocalVarInstr && (slvi = (StoreLocalVarInstr)i2).getLocalVar() == lv) {
                            instrs.remove();
                        }
                        this.setupLocalVarReplacement(lv, fic, varRenameMap);
                        continue;
                    }
                    if (i2 instanceof LoadLocalVarInstr) {
                        llvi = (LoadLocalVarInstr)i2;
                        if (llvi.getLocalVar() == lv) {
                            llvi.decrementLVarScopeDepth();
                        }
                    } else if (i2 instanceof StoreLocalVarInstr && (slvi = (StoreLocalVarInstr)i2).getLocalVar() == lv) {
                        slvi.decrementLVarScopeDepth();
                    }
                    parentScopeNeeded = true;
                    this.decrementScopeDepth(lv, varRenameMap);
                }
            }
        }
        if (parentScopeNeeded) {
            fic.setReuseParentDynScope(true);
        }
        for (BasicBlock b2 : fic.getCFG().getBasicBlocks()) {
            for (Instr i2 : b2.getInstrs()) {
                i2.renameVars(varRenameMap);
            }
        }
        new LiveVariableAnalysis().invalidate(fic);
    }

    @Override
    public Object execute(FullInterpreterContext fic, Object ... data2) {
        if (fic.getFlags().contains((Object)IRFlags.REQUIRES_DYNSCOPE)) {
            return null;
        }
        if (fic.getFlags().contains((Object)IRFlags.HAS_END_BLOCKS)) {
            return null;
        }
        if (fic.isEND()) {
            return null;
        }
        this.eliminateLocalVars(fic);
        return null;
    }

    @Override
    public boolean invalidate(FullInterpreterContext fic) {
        return false;
    }
}

