/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.unicode.UnicodeEncoding;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Sprintf;
import org.jruby.util.StringSupport;
import org.jruby.util.io.EncodingUtils;

public class RubyStringBuilder {
    public static RubyString types(ThreadContext context, RubyModule type2) {
        return RubyStringBuilder.inspectIdentifierByteList(context.runtime, type2.toRubyString(context).getByteList());
    }

    public static RubyString types(Ruby runtime2, RubyModule type2) {
        ThreadContext context = runtime2.getCurrentContext();
        return RubyStringBuilder.inspectIdentifierByteList(runtime2, type2.toRubyString(context).getByteList());
    }

    public static RubyString types(Ruby runtime2, RubyModule type1, RubyModule type2) {
        ThreadContext context = runtime2.getCurrentContext();
        RubyString fullTypeName = type1.toRubyString(context).catString("::").cat(type2.toRubyString(context));
        return RubyStringBuilder.inspectIdentifierByteList(runtime2, fullTypeName.getByteList());
    }

    public static RubyString ids(Ruby runtime2, String id2) {
        ByteList identifier = runtime2.newSymbol(id2).getBytes();
        return RubyStringBuilder.inspectIdentifierByteList(runtime2, identifier);
    }

    public static RubyString ids(Ruby runtime2, IRubyObject object) {
        ByteList identifier = object instanceof RubyString ? ((RubyString)object).getByteList() : (object instanceof RubySymbol ? ((RubySymbol)object).getBytes() : object.convertToString().getByteList());
        return RubyStringBuilder.inspectIdentifierByteList(runtime2, identifier);
    }

    public static RubyString inspectIdentifierByteList(Ruby runtime2, ByteList byteList) {
        Encoding enc = byteList.getEncoding();
        byte[] bytes2 = byteList.getUnsafeBytes();
        int p2 = byteList.getBegin();
        int end2 = p2 + byteList.getRealSize();
        RubyString result2 = RubyString.newStringLight(runtime2, new ByteList(end2 - p2 + 2));
        result2.getByteList().setBegin(1);
        Encoding resultEnc = runtime2.getDefaultInternalEncoding();
        boolean isUnicode = enc.isUnicode();
        boolean asciiCompat = enc.isAsciiCompatible();
        boolean needsQuotes = false;
        if (resultEnc == null) {
            resultEnc = runtime2.getDefaultExternalEncoding();
        }
        if (!resultEnc.isAsciiCompatible()) {
            resultEnc = USASCIIEncoding.INSTANCE;
        }
        result2.associateEncoding(resultEnc);
        int prev = p2;
        Encoding actEnc = EncodingUtils.getActualEncoding(enc, byteList);
        if (actEnc != enc) {
            enc = actEnc;
            if (isUnicode) {
                isUnicode = enc instanceof UnicodeEncoding;
            }
        }
        while (p2 < end2) {
            String format;
            int n = StringSupport.preciseLength(enc, bytes2, p2, end2);
            if (!StringSupport.MBCLEN_CHARFOUND_P(n)) {
                if (p2 > prev) {
                    result2.cat(bytes2, prev, p2 - prev);
                }
                if (end2 < p2 + (n = enc.minLength())) {
                    n = end2 - p2;
                }
                while (n-- > 0) {
                    result2.modifyExpand(result2.size() + 4);
                    Sprintf.sprintf(runtime2, result2.getByteList(), (CharSequence)"\\x%02X", bytes2[p2] & 0xFF);
                    prev = ++p2;
                }
                continue;
            }
            n = StringSupport.MBCLEN_CHARFOUND_LEN(n);
            int c = enc.mbcToCode(bytes2, p2, end2);
            int cc = 0;
            if ((asciiCompat || isUnicode) && (c == 34 || c == 92 || c == 35 && (p2 += n) < end2 && StringSupport.MBCLEN_CHARFOUND_P(StringSupport.preciseLength(enc, bytes2, p2, end2)) && ((cc = StringSupport.codePoint(runtime2, enc, bytes2, p2, end2)) == 36 || cc == 64 || cc == 123))) {
                if (p2 - n > prev) {
                    result2.cat(bytes2, prev, p2 - n - prev);
                }
                result2.cat(92);
                if (asciiCompat || enc == resultEnc) {
                    prev = p2 - n;
                    continue;
                }
            }
            switch (c) {
                case 10: {
                    cc = 110;
                    break;
                }
                case 13: {
                    cc = 114;
                    break;
                }
                case 9: {
                    cc = 116;
                    break;
                }
                case 12: {
                    cc = 102;
                    break;
                }
                case 11: {
                    cc = 118;
                    break;
                }
                case 8: {
                    cc = 98;
                    break;
                }
                case 7: {
                    cc = 97;
                    break;
                }
                case 27: {
                    cc = 101;
                    break;
                }
                default: {
                    cc = 0;
                }
            }
            if (cc != 0) {
                if (p2 - n > prev) {
                    result2.cat(bytes2, prev, p2 - n - prev);
                }
                result2.cat(92);
                result2.cat(cc);
                prev = p2;
                continue;
            }
            if (enc == resultEnc && enc.isPrint(c) || asciiCompat && c < 128 && c > 0 && enc.isPrint(c)) continue;
            if (p2 - n > prev) {
                result2.cat(bytes2, prev, p2 - n - prev);
            }
            if (!(format = StringSupport.escapedCharFormat(c, isUnicode)).equals("%c")) {
                needsQuotes = true;
            }
            Sprintf.sprintf(runtime2, result2.getByteList(), (CharSequence)format, (long)c & 0xFFFFFFFFL);
            prev = p2;
        }
        if (p2 > prev) {
            result2.cat(bytes2, prev, p2 - prev);
        }
        if (needsQuotes) {
            result2.prepend(34);
            result2.cat(34);
        }
        return result2;
    }

    public static String str(Ruby runtime2, IRubyObject value2, String message2) {
        RubyString buf = (RubyString)value2.asString().dup();
        RubyStringBuilder.cat(runtime2, buf, message2);
        return buf.toString();
    }

    public static String str(Ruby runtime2, String message2, IRubyObject value2) {
        RubyString buf = runtime2.newString(message2);
        buf.cat19(value2.asString());
        return buf.toString();
    }

    public static String str(Ruby runtime2, String messageBegin, IRubyObject value2, String messageEnd) {
        RubyString buf = runtime2.newString(messageBegin);
        buf.cat19(value2.asString());
        RubyStringBuilder.cat(runtime2, buf, messageEnd);
        return buf.toString();
    }

    public static String str(Ruby runtime2, IRubyObject value2, String message2, IRubyObject value22) {
        RubyString buf = (RubyString)value2.asString().dup();
        RubyStringBuilder.cat(runtime2, buf, message2);
        buf.cat19(value22.asString());
        return buf.toString();
    }

    public static String str(Ruby runtime2, IRubyObject value2, String message2, IRubyObject value22, String message22) {
        RubyString buf = (RubyString)value2.asString().dup();
        RubyStringBuilder.cat(runtime2, buf, message2);
        buf.cat19(value22.asString());
        RubyStringBuilder.cat(runtime2, buf, message22);
        return buf.toString();
    }

    public static String str(Ruby runtime2, String messageBegin, IRubyObject value2, String messageMiddle, IRubyObject value22) {
        RubyString buf = runtime2.newString(messageBegin);
        buf.cat19(value2.asString());
        RubyStringBuilder.cat(runtime2, buf, messageMiddle);
        buf.cat19(value22.asString());
        return buf.toString();
    }

    public static String str(Ruby runtime2, String messageBegin, IRubyObject value2, String messageMiddle, IRubyObject value22, String messageEnd) {
        RubyString buf = runtime2.newString(messageBegin);
        buf.cat19(value2.asString());
        RubyStringBuilder.cat(runtime2, buf, messageMiddle);
        buf.cat19(value22.asString());
        RubyStringBuilder.cat(runtime2, buf, messageEnd);
        return buf.toString();
    }

    public static String str(Ruby runtime2, String messageBegin, IRubyObject value2, String messageMiddle, IRubyObject value22, String messageMiddle2, IRubyObject value3, String messageEnd) {
        RubyString buf = runtime2.newString(messageBegin);
        buf.cat19(value2.asString());
        RubyStringBuilder.cat(runtime2, buf, messageMiddle);
        buf.cat19(value22.asString());
        RubyStringBuilder.cat(runtime2, buf, messageMiddle2);
        buf.cat19(value3.asString());
        RubyStringBuilder.cat(runtime2, buf, messageEnd);
        return buf.toString();
    }

    public static String str(Ruby runtime2, String messageBegin, IRubyObject value2, String messageMiddle, RubyString value22, String messageMiddle2, IRubyObject value3, String messageMiddle3, RubyString value4, String messageEnd) {
        RubyString buf = runtime2.newString(messageBegin);
        buf.cat19(value2.asString());
        RubyStringBuilder.cat(runtime2, buf, messageMiddle);
        buf.cat19(value22);
        RubyStringBuilder.cat(runtime2, buf, messageMiddle2);
        buf.cat19(value3.asString());
        RubyStringBuilder.cat(runtime2, buf, messageMiddle3);
        buf.cat19(value4);
        RubyStringBuilder.cat(runtime2, buf, messageEnd);
        return buf.toString();
    }

    public static RubyString cat(Ruby runtime2, RubyString str, String value2) {
        EncodingUtils.encStrBufCat(runtime2, str, value2);
        return str;
    }

    public static RubyString cat(Ruby runtime2, RubyString buf, int b2) {
        EncodingUtils.encStrBufCat(runtime2, buf, new byte[]{(byte)b2});
        return buf;
    }

    public static RubyString cat(Ruby runtime2, RubyString buf, byte[] bytes2) {
        EncodingUtils.encStrBufCat(runtime2, buf, bytes2);
        return buf;
    }

    public static RubyString cat(Ruby runtime2, RubyString buf, ByteList bytes2) {
        EncodingUtils.encStrBufCat(runtime2, buf, bytes2);
        return buf;
    }
}

