/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaAccessibleObject;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.InternalJavaProxy;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.RubyStringBuilder;

@JRubyClass(name={"Java::JavaMethod"})
public class JavaMethod
extends JavaCallable {
    private final Method method;
    private final Class<?> boxedReturnType;
    private final boolean isFinal;
    private final JavaUtil.JavaConverter returnConverter;

    public final Method getValue() {
        return this.method;
    }

    public static RubyClass createJavaMethodClass(Ruby runtime2, RubyModule javaModule) {
        RubyClass result2 = javaModule.defineClassUnder("JavaMethod", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaAccessibleObject.registerRubyMethods(runtime2, result2);
        JavaCallable.registerRubyMethods(runtime2, result2);
        result2.defineAnnotatedMethods(JavaMethod.class);
        return result2;
    }

    public JavaMethod(Ruby runtime2, Method method2) {
        super(runtime2, runtime2.getJavaSupport().getJavaMethodClass(), method2.getParameterTypes());
        this.method = method2;
        this.isFinal = Modifier.isFinal(method2.getModifiers());
        Class<?> returnType = method2.getReturnType();
        this.boxedReturnType = returnType.isPrimitive() && returnType != Void.TYPE ? CodegenUtils.getBoxType(returnType) : returnType;
        if (JavaUtil.CAN_SET_ACCESSIBLE) {
            try {
                if (Modifier.isPublic(method2.getModifiers()) && !Modifier.isPublic(method2.getDeclaringClass().getModifiers())) {
                    method2.setAccessible(true);
                }
            }
            catch (SecurityException se) {
                runtime2.getWarnings().warn("failed to setAccessible: " + method2 + ", exception follows: " + se.getMessage());
            }
        }
        this.returnConverter = JavaUtil.getJavaConverter(returnType);
    }

    @Deprecated
    public static JavaMethod create(Ruby runtime2, Method method2) {
        return new JavaMethod(runtime2, method2);
    }

    @Deprecated
    public static JavaMethod create(Ruby runtime2, Class<?> javaClass, String methodName, Class<?>[] argumentTypes) {
        try {
            return JavaMethod.create(runtime2, javaClass.getMethod(methodName, argumentTypes));
        }
        catch (NoSuchMethodException e) {
            throw runtime2.newNameError(RubyModule.undefinedMethodMessage(runtime2, RubyStringBuilder.ids(runtime2, methodName), RubyStringBuilder.ids(runtime2, javaClass.getName()), false), methodName);
        }
    }

    @Deprecated
    public static JavaMethod createDeclared(Ruby runtime2, Class<?> javaClass, String methodName, Class<?>[] argumentTypes) {
        try {
            return JavaMethod.create(runtime2, javaClass.getDeclaredMethod(methodName, argumentTypes));
        }
        catch (NoSuchMethodException e) {
            throw runtime2.newNameError(RubyModule.undefinedMethodMessage(runtime2, RubyStringBuilder.ids(runtime2, methodName), RubyStringBuilder.ids(runtime2, javaClass.getName()), false), methodName);
        }
    }

    public static JavaMethod getMatchingDeclaredMethod(Ruby runtime2, Class<?> javaClass, String methodName, Class<?>[] argumentTypes) {
        try {
            return new JavaMethod(runtime2, javaClass.getDeclaredMethod(methodName, argumentTypes));
        }
        catch (NoSuchMethodException e) {
            block2: for (Method method2 : javaClass.getDeclaredMethods()) {
                if (!method2.getName().equals(methodName)) continue;
                Class<?>[] targetTypes = method2.getParameterTypes();
                if (targetTypes.length == 0 && argumentTypes.length == 0) {
                    return new JavaMethod(runtime2, method2);
                }
                for (int i2 = 0; i2 < argumentTypes.length; ++i2) {
                    if (i2 >= targetTypes.length || !targetTypes[i2].isAssignableFrom(argumentTypes[i2])) continue block2;
                }
                return new JavaMethod(runtime2, method2);
            }
            return null;
        }
    }

    @Override
    public final boolean equals(Object other) {
        return other instanceof JavaMethod && this.method.equals(((JavaMethod)other).method);
    }

    @Override
    public final int hashCode() {
        return this.method.hashCode();
    }

    @Override
    @JRubyMethod
    public RubyString name() {
        return this.getRuntime().newString(this.method.getName());
    }

    @Override
    @JRubyMethod(name={"public?"})
    public RubyBoolean public_p() {
        return this.getRuntime().newBoolean(Modifier.isPublic(this.method.getModifiers()));
    }

    @JRubyMethod(name={"final?"})
    public RubyBoolean final_p() {
        return this.getRuntime().newBoolean(Modifier.isFinal(this.method.getModifiers()));
    }

    @JRubyMethod(rest=true)
    public IRubyObject invoke(ThreadContext context, IRubyObject[] args2) {
        Object javaInvokee;
        this.checkArity(args2.length - 1);
        IRubyObject invokee = args2[0];
        Object[] arguments = this.convertArguments(args2, 1);
        if (invokee.isNil()) {
            return this.invokeWithExceptionHandling(context, this.method, null, arguments);
        }
        if (!this.isStatic()) {
            JavaProxyClass jpc;
            JavaProxyMethod jpm;
            javaInvokee = JavaUtil.unwrapJavaValue(invokee);
            if (javaInvokee == null) {
                throw this.getRuntime().newTypeError("invokee not a java object");
            }
            if (!this.method.getDeclaringClass().isInstance(javaInvokee)) {
                throw this.getRuntime().newTypeError("invokee not instance of method's class (got" + javaInvokee.getClass().getName() + " wanted " + this.method.getDeclaringClass().getName() + ")");
            }
            if (javaInvokee instanceof InternalJavaProxy && !this.isFinal && (jpm = (jpc = ((InternalJavaProxy)javaInvokee).___getProxyClass()).getMethod(this.method.getName(), this.parameterTypes)) != null && jpm.hasSuperImplementation()) {
                return this.invokeWithExceptionHandling(context, jpm.getSuperMethod(), javaInvokee, arguments);
            }
        } else {
            javaInvokee = null;
        }
        return this.invokeWithExceptionHandling(context, this.method, javaInvokee, arguments);
    }

    @JRubyMethod(rest=true)
    public IRubyObject invoke_static(ThreadContext context, IRubyObject[] args2) {
        this.checkArity(args2.length);
        Object[] arguments = this.convertArguments(args2, 0);
        return this.invokeWithExceptionHandling(context, this.method, null, arguments);
    }

    @JRubyMethod
    public IRubyObject return_type() {
        Class<?> klass = this.method.getReturnType();
        if (klass.equals(Void.TYPE)) {
            return this.getRuntime().getNil();
        }
        return JavaClass.get(this.getRuntime(), klass);
    }

    @JRubyMethod
    public IRubyObject type_parameters() {
        return Java.getInstance(this.getRuntime(), this.method.getTypeParameters());
    }

    public IRubyObject invokeDirect(ThreadContext context, Object javaInvokee, Object[] args2) {
        this.checkArity(args2.length);
        this.checkInstanceof(javaInvokee);
        if (this.mightBeProxy(javaInvokee)) {
            return this.tryProxyInvocation(context, javaInvokee, args2);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee, args2);
    }

    public IRubyObject invokeDirect(ThreadContext context, Object javaInvokee) {
        assert (this.method.getDeclaringClass().isInstance(javaInvokee));
        this.checkArity(0);
        if (this.mightBeProxy(javaInvokee)) {
            return this.tryProxyInvocation(context, javaInvokee);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee);
    }

    public IRubyObject invokeDirect(ThreadContext context, Object javaInvokee, Object arg0) {
        assert (this.method.getDeclaringClass().isInstance(javaInvokee));
        this.checkArity(1);
        if (this.mightBeProxy(javaInvokee)) {
            return this.tryProxyInvocation(context, javaInvokee, arg0);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee, arg0);
    }

    public IRubyObject invokeDirect(ThreadContext context, Object javaInvokee, Object arg0, Object arg1) {
        assert (this.method.getDeclaringClass().isInstance(javaInvokee));
        this.checkArity(2);
        if (this.mightBeProxy(javaInvokee)) {
            return this.tryProxyInvocation(context, javaInvokee, arg0, arg1);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee, arg0, arg1);
    }

    public IRubyObject invokeDirect(ThreadContext context, Object javaInvokee, Object arg0, Object arg1, Object arg2) {
        assert (this.method.getDeclaringClass().isInstance(javaInvokee));
        this.checkArity(3);
        if (this.mightBeProxy(javaInvokee)) {
            return this.tryProxyInvocation(context, javaInvokee, arg0, arg1, arg2);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee, arg0, arg1, arg2);
    }

    public IRubyObject invokeDirect(ThreadContext context, Object javaInvokee, Object arg0, Object arg1, Object arg2, Object arg3) {
        assert (this.method.getDeclaringClass().isInstance(javaInvokee));
        this.checkArity(4);
        if (this.mightBeProxy(javaInvokee)) {
            return this.tryProxyInvocation(context, javaInvokee, arg0, arg1, arg2, arg3);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee, arg0, arg1, arg2, arg3);
    }

    public IRubyObject invokeStaticDirect(ThreadContext context, Object[] args2) {
        this.checkArity(args2.length);
        return this.invokeDirectWithExceptionHandling(context, this.method, (Object)null, args2);
    }

    public IRubyObject invokeStaticDirect(ThreadContext context) {
        this.checkArity(0);
        return this.invokeDirectWithExceptionHandling(context, this.method, null);
    }

    public IRubyObject invokeStaticDirect(ThreadContext context, Object arg0) {
        this.checkArity(1);
        return this.invokeDirectWithExceptionHandling(context, this.method, null, arg0);
    }

    public IRubyObject invokeStaticDirect(ThreadContext context, Object arg0, Object arg1) {
        this.checkArity(2);
        return this.invokeDirectWithExceptionHandling(context, this.method, null, arg0, arg1);
    }

    public IRubyObject invokeStaticDirect(ThreadContext context, Object arg0, Object arg1, Object arg2) {
        this.checkArity(3);
        return this.invokeDirectWithExceptionHandling(context, this.method, null, arg0, arg1, arg2);
    }

    public IRubyObject invokeStaticDirect(ThreadContext context, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.checkArity(4);
        return this.invokeDirectWithExceptionHandling(context, this.method, null, arg0, arg1, arg2, arg3);
    }

    private void checkInstanceof(Object javaInvokee) throws RaiseException {
        if (!this.method.getDeclaringClass().isInstance(javaInvokee)) {
            throw this.getRuntime().newTypeError("invokee not instance of method's class (got" + javaInvokee.getClass().getName() + " wanted " + this.method.getDeclaringClass().getName() + ")");
        }
    }

    private IRubyObject invokeWithExceptionHandling(ThreadContext context, Method method2, Object javaInvokee, Object[] arguments) {
        try {
            Object result2 = method2.invoke(javaInvokee, arguments);
            return this.returnConverter.convert(this.getRuntime(), result2);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(iae, method2, arguments);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(iae, method2);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    private IRubyObject invokeDirectSuperWithExceptionHandling(ThreadContext context, Method method2, Object javaInvokee, Object ... arguments) {
        try {
            Object result2 = method2.invoke(javaInvokee, arguments);
            return this.convertReturn(result2);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(iae, method2, arguments);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(iae, method2);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    private IRubyObject invokeDirectWithExceptionHandling(ThreadContext context, Method method2, Object javaInvokee, Object[] arguments) {
        try {
            Object result2 = method2.invoke(javaInvokee, arguments);
            return this.convertReturn(result2);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(iae, method2, arguments);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(iae, method2);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    private IRubyObject invokeDirectWithExceptionHandling(ThreadContext context, Method method2, Object javaInvokee) {
        try {
            Object result2 = method2.invoke(javaInvokee, new Object[0]);
            return this.convertReturn(result2);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(iae, method2, new Object[0]);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(iae, method2);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    private IRubyObject invokeDirectWithExceptionHandling(ThreadContext context, Method method2, Object javaInvokee, Object arg0) {
        try {
            Object result2 = method2.invoke(javaInvokee, arg0);
            return this.convertReturn(result2);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(iae, method2, arg0);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(iae, method2);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    private IRubyObject invokeDirectWithExceptionHandling(ThreadContext context, Method method2, Object javaInvokee, Object arg0, Object arg1) {
        try {
            Object result2 = method2.invoke(javaInvokee, arg0, arg1);
            return this.convertReturn(result2);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(iae, method2, arg0, arg1);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(iae, method2);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    private IRubyObject invokeDirectWithExceptionHandling(ThreadContext context, Method method2, Object javaInvokee, Object arg0, Object arg1, Object arg2) {
        try {
            Object result2 = method2.invoke(javaInvokee, arg0, arg1, arg2);
            return this.convertReturn(result2);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(iae, method2, arg0, arg1, arg2);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(iae, method2);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    private IRubyObject invokeDirectWithExceptionHandling(ThreadContext context, Method method2, Object javaInvokee, Object arg0, Object arg1, Object arg2, Object arg3) {
        try {
            Object result2 = method2.invoke(javaInvokee, arg0, arg1, arg2, arg3);
            return this.convertReturn(result2);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(iae, method2, arg0, arg1, arg2, arg3);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(iae, method2);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    private IRubyObject convertReturn(Object result2) {
        if (result2 != null && result2.getClass() != this.boxedReturnType) {
            return JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), result2);
        }
        return JavaUtil.convertJavaToUsableRubyObjectWithConverter(this.getRuntime(), result2, this.returnConverter);
    }

    public String getName() {
        return this.method.getName();
    }

    @Override
    public Class<?>[] getExceptionTypes() {
        return this.method.getExceptionTypes();
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return this.method.getGenericParameterTypes();
    }

    @Override
    public Type[] getGenericExceptionTypes() {
        return this.method.getGenericExceptionTypes();
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        return this.method.getParameterAnnotations();
    }

    @Override
    public final boolean isVarArgs() {
        return this.method.isVarArgs();
    }

    @Override
    protected String nameOnInspection() {
        return this.getType().toString() + '/' + this.method.getName();
    }

    @Override
    @JRubyMethod
    public RubyString inspect() {
        StringBuilder str = new StringBuilder();
        str.append("#<");
        str.append(this.getType().toString()).append('/').append(this.method.getName());
        JavaMethod.inspectParameterTypes(str, this);
        str.append('>');
        return RubyString.newString(this.getRuntime(), str);
    }

    @JRubyMethod(name={"static?"})
    public RubyBoolean static_p() {
        return this.getRuntime().newBoolean(this.isStatic());
    }

    public RubyBoolean bridge_p() {
        return this.getRuntime().newBoolean(this.method.isBridge());
    }

    private boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    @Override
    public final int getModifiers() {
        return this.method.getModifiers();
    }

    @Override
    public String toGenericString() {
        return this.method.toGenericString();
    }

    @Override
    public final AccessibleObject accessibleObject() {
        return this.method;
    }

    private boolean mightBeProxy(Object javaInvokee) {
        return javaInvokee instanceof InternalJavaProxy && !this.isFinal;
    }

    private IRubyObject tryProxyInvocation(ThreadContext context, Object javaInvokee, Object ... args2) {
        JavaProxyClass jpc = ((InternalJavaProxy)javaInvokee).___getProxyClass();
        JavaProxyMethod jpm = jpc.getMethod(this.method.getName(), this.parameterTypes);
        if (jpm != null && jpm.hasSuperImplementation()) {
            return this.invokeDirectSuperWithExceptionHandling(context, jpm.getSuperMethod(), javaInvokee, args2);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee, args2);
    }

    private IRubyObject tryProxyInvocation(ThreadContext context, Object javaInvokee) {
        JavaProxyClass jpc = ((InternalJavaProxy)javaInvokee).___getProxyClass();
        JavaProxyMethod jpm = jpc.getMethod(this.method.getName(), this.parameterTypes);
        if (jpm != null && jpm.hasSuperImplementation()) {
            return this.invokeDirectSuperWithExceptionHandling(context, jpm.getSuperMethod(), javaInvokee, new Object[0]);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee);
    }

    private IRubyObject tryProxyInvocation(ThreadContext context, Object javaInvokee, Object arg0) {
        JavaProxyClass jpc = ((InternalJavaProxy)javaInvokee).___getProxyClass();
        JavaProxyMethod jpm = jpc.getMethod(this.method.getName(), this.parameterTypes);
        if (jpm != null && jpm.hasSuperImplementation()) {
            return this.invokeDirectSuperWithExceptionHandling(context, jpm.getSuperMethod(), javaInvokee, arg0);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee, arg0);
    }

    private IRubyObject tryProxyInvocation(ThreadContext context, Object javaInvokee, Object arg0, Object arg1) {
        JavaProxyClass jpc = ((InternalJavaProxy)javaInvokee).___getProxyClass();
        JavaProxyMethod jpm = jpc.getMethod(this.method.getName(), this.parameterTypes);
        if (jpm != null && jpm.hasSuperImplementation()) {
            return this.invokeDirectSuperWithExceptionHandling(context, jpm.getSuperMethod(), javaInvokee, arg0, arg1);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee, arg0, arg1);
    }

    private IRubyObject tryProxyInvocation(ThreadContext context, Object javaInvokee, Object arg0, Object arg1, Object arg2) {
        JavaProxyClass jpc = ((InternalJavaProxy)javaInvokee).___getProxyClass();
        JavaProxyMethod jpm = jpc.getMethod(this.method.getName(), this.parameterTypes);
        if (jpm != null && jpm.hasSuperImplementation()) {
            return this.invokeDirectSuperWithExceptionHandling(context, jpm.getSuperMethod(), javaInvokee, arg0, arg1, arg2);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee, arg0, arg1, arg2);
    }

    private IRubyObject tryProxyInvocation(ThreadContext context, Object javaInvokee, Object arg0, Object arg1, Object arg2, Object arg3) {
        JavaProxyClass jpc = ((InternalJavaProxy)javaInvokee).___getProxyClass();
        JavaProxyMethod jpm = jpc.getMethod(this.method.getName(), this.parameterTypes);
        if (jpm != null && jpm.hasSuperImplementation()) {
            return this.invokeDirectSuperWithExceptionHandling(context, jpm.getSuperMethod(), javaInvokee, arg0, arg1, arg2, arg3);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee, arg0, arg1, arg2, arg3);
    }

    public static RaiseException newMethodNotFoundError(Ruby runtime2, Class target, String prettyName, String simpleName) {
        return runtime2.newNameError("java method not found: " + target.getName() + "." + prettyName, simpleName);
    }

    public static RaiseException newArgSizeMismatchError(Ruby runtime2, Class ... argTypes) {
        return runtime2.newArgumentError("argument count mismatch for method signature " + CodegenUtils.prettyParams(argTypes));
    }
}

