/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.ConvertDouble;
import org.jruby.util.Numeric;
import org.jruby.util.Sprintf;

@JRubyClass(name={"Float"}, parent="Numeric", include={"Precision"})
public class RubyFloat
extends RubyNumeric {
    public static final int ROUNDS = 1;
    public static final int RADIX = 2;
    public static final int MANT_DIG = 53;
    public static final int DIG = 15;
    public static final int MIN_EXP = -1021;
    public static final int MAX_EXP = 1024;
    public static final int MAX_10_EXP = 308;
    public static final int MIN_10_EXP = -307;
    public static final double EPSILON = 2.220446049250313E-16;
    public static final double INFINITY = Double.POSITIVE_INFINITY;
    public static final double NAN = Double.NaN;
    private final double value;
    static final int DBL_MANT_DIG = 53;
    static final int FLT_RADIX = 2;
    private static final ByteList NAN_BYTELIST = new ByteList("nan".getBytes());
    private static final ByteList NEGATIVE_INFINITY_BYTELIST = new ByteList("-inf".getBytes());
    private static final ByteList INFINITY_BYTELIST = new ByteList("inf".getBytes());

    public static RubyClass createFloatClass(Ruby runtime) {
        RubyClass floatc = runtime.defineClass("Float", runtime.getNumeric(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setFloat(floatc);
        floatc.setClassIndex(ClassIndex.FLOAT);
        floatc.setReifiedClass(RubyFloat.class);
        floatc.kindOf = new RubyModule.JavaClassKindOf(RubyFloat.class);
        floatc.getSingletonClass().undefineMethod("new");
        floatc.defineConstant("ROUNDS", RubyFixnum.newFixnum(runtime, 1L));
        floatc.defineConstant("RADIX", RubyFixnum.newFixnum(runtime, 2L));
        floatc.defineConstant("MANT_DIG", RubyFixnum.newFixnum(runtime, 53L));
        floatc.defineConstant("DIG", RubyFixnum.newFixnum(runtime, 15L));
        floatc.defineConstant("MIN_EXP", RubyFixnum.newFixnum(runtime, -1021L));
        floatc.defineConstant("MAX_EXP", RubyFixnum.newFixnum(runtime, 1024L));
        floatc.defineConstant("MIN_10_EXP", RubyFixnum.newFixnum(runtime, -307L));
        floatc.defineConstant("MAX_10_EXP", RubyFixnum.newFixnum(runtime, 308L));
        floatc.defineConstant("MIN", RubyFloat.newFloat(runtime, Double.MIN_VALUE));
        floatc.defineConstant("MAX", RubyFloat.newFloat(runtime, Double.MAX_VALUE));
        floatc.defineConstant("EPSILON", RubyFloat.newFloat(runtime, 2.220446049250313E-16));
        floatc.defineConstant("INFINITY", RubyFloat.newFloat(runtime, Double.POSITIVE_INFINITY));
        floatc.defineConstant("NAN", RubyFloat.newFloat(runtime, Double.NaN));
        floatc.defineAnnotatedMethods(RubyFloat.class);
        return floatc;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.FLOAT;
    }

    public RubyFloat(Ruby runtime) {
        this(runtime, 0.0);
    }

    public RubyFloat(Ruby runtime, double value2) {
        super(runtime.getFloat());
        this.value = value2;
        this.flags |= FROZEN_F;
    }

    @Override
    public RubyClass getSingletonClass() {
        throw this.getRuntime().newTypeError("can't define singleton");
    }

    @Override
    public Class<?> getJavaClass() {
        return Double.TYPE;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public long getLongValue() {
        return (long)this.value;
    }

    @Override
    public int getIntValue() {
        return (int)this.value;
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return BigInteger.valueOf((long)this.value);
    }

    @Override
    public RubyFloat convertToFloat() {
        return this;
    }

    protected int compareValue(RubyNumeric other) {
        double otherVal = other.getDoubleValue();
        return this.getValue() > otherVal ? 1 : (this.getValue() < otherVal ? -1 : 0);
    }

    public static RubyFloat newFloat(Ruby runtime, double value2) {
        return new RubyFloat(runtime, value2);
    }

    @Deprecated
    public static IRubyObject induced_from(ThreadContext context, IRubyObject recv2, IRubyObject number) {
        if (number instanceof RubyFixnum || number instanceof RubyBignum || number instanceof RubyRational) {
            return number.callMethod(context, "to_f");
        }
        if (number instanceof RubyFloat) {
            return number;
        }
        throw recv2.getRuntime().newTypeError("failed to convert " + number.getMetaClass() + " into Float");
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        ASCIIEncoding ascii;
        Ruby runtime = this.getRuntime();
        if (Double.isInfinite(this.value)) {
            return RubyString.newString(runtime, this.value < 0.0 ? "-Infinity" : "Infinity");
        }
        if (Double.isNaN(this.value)) {
            return RubyString.newString(runtime, "NaN");
        }
        ByteList buf = new ByteList();
        Sprintf.sprintf(buf, Locale.US, (CharSequence)"%#.20g", this);
        int e = buf.indexOf(101);
        if (e == -1) {
            e = buf.getRealSize();
        }
        if (!(ascii = ASCIIEncoding.INSTANCE).isDigit(buf.get(e - 1))) {
            buf.setRealSize(0);
            Sprintf.sprintf(buf, Locale.US, (CharSequence)"%#.14e", this);
            e = buf.indexOf(101);
            if (e == -1) {
                e = buf.getRealSize();
            }
        }
        int p2 = e;
        while (buf.get(p2 - 1) == 48 && ascii.isDigit(buf.get(p2 - 2))) {
            --p2;
        }
        System.arraycopy(buf.getUnsafeBytes(), e, buf.getUnsafeBytes(), p2, buf.getRealSize() - e);
        buf.setRealSize(p2 + buf.getRealSize() - e);
        buf.setEncoding(USASCIIEncoding.INSTANCE);
        return runtime.newString(buf);
    }

    @Override
    @JRubyMethod(name={"coerce"}, required=1)
    public IRubyObject coerce(IRubyObject other) {
        return this.getRuntime().newArray((IRubyObject)RubyKernel.new_float(this, other), (IRubyObject)this);
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus() {
        return RubyFloat.newFloat(this.getRuntime(), -this.value);
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case FIXNUM: 
            case BIGNUM: 
            case FLOAT: {
                return RubyFloat.newFloat(this.getRuntime(), this.value + ((RubyNumeric)other).getDoubleValue());
            }
        }
        return this.coerceBin(context, RubyFloat.sites((ThreadContext)context).op_plus, other);
    }

    public IRubyObject op_plus(ThreadContext context, double other) {
        return RubyFloat.newFloat(this.getRuntime(), this.value + other);
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_minus(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case FIXNUM: 
            case BIGNUM: 
            case FLOAT: {
                return RubyFloat.newFloat(this.getRuntime(), this.value - ((RubyNumeric)other).getDoubleValue());
            }
        }
        return this.coerceBin(context, RubyFloat.sites((ThreadContext)context).op_minus, other);
    }

    public IRubyObject op_minus(ThreadContext context, double other) {
        return RubyFloat.newFloat(this.getRuntime(), this.value - other);
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case FIXNUM: 
            case BIGNUM: 
            case FLOAT: {
                return RubyFloat.newFloat(this.getRuntime(), this.value * ((RubyNumeric)other).getDoubleValue());
            }
        }
        return this.coerceBin(context, RubyFloat.sites((ThreadContext)context).op_times, other);
    }

    public IRubyObject op_mul(ThreadContext context, double other) {
        return RubyFloat.newFloat(this.getRuntime(), this.value * other);
    }

    @JRubyMethod(name={"/"}, required=1)
    public IRubyObject op_fdiv(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case FIXNUM: 
            case BIGNUM: 
            case FLOAT: {
                return RubyFloat.newFloat(this.getRuntime(), this.value / ((RubyNumeric)other).getDoubleValue());
            }
        }
        return this.coerceBin(context, RubyFloat.sites((ThreadContext)context).op_quo, other);
    }

    public IRubyObject op_fdiv(ThreadContext context, double other) {
        return RubyFloat.newFloat(this.getRuntime(), this.value / other);
    }

    @JRubyMethod(name={"quo"})
    public IRubyObject magnitude(ThreadContext context, IRubyObject other) {
        return RubyFloat.sites((ThreadContext)context).op_quo.call(context, (IRubyObject)this, (IRubyObject)this, other);
    }

    public IRubyObject op_mod(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case FIXNUM: 
            case BIGNUM: 
            case FLOAT: {
                double y = ((RubyNumeric)other).getDoubleValue();
                return this.op_mod(context, y);
            }
        }
        return this.coerceBin(context, RubyFloat.sites((ThreadContext)context).op_mod, other);
    }

    public IRubyObject op_mod(ThreadContext context, double other) {
        double x = this.value;
        double mod = Math.IEEEremainder(x, other);
        if (other * mod < 0.0) {
            mod += other;
        }
        return RubyFloat.newFloat(this.getRuntime(), mod);
    }

    @JRubyMethod(name={"%", "modulo"}, required=1)
    public IRubyObject op_mod19(ThreadContext context, IRubyObject other) {
        if (!other.isNil() && other instanceof RubyNumeric && ((RubyNumeric)other).getDoubleValue() == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
        return this.op_mod(context, other);
    }

    @Override
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case FIXNUM: 
            case BIGNUM: 
            case FLOAT: {
                double y = ((RubyNumeric)other).getDoubleValue();
                double x = this.value;
                double mod = Math.IEEEremainder(x, y);
                if (Double.isNaN(mod)) {
                    throw this.getRuntime().newFloatDomainError("NaN");
                }
                double div = Math.floor(x / y);
                if (y * mod < 0.0) {
                    mod += y;
                }
                Ruby runtime = this.getRuntime();
                IRubyObject car = RubyFloat.dbl2num(runtime, div);
                RubyFloat cdr = RubyFloat.newFloat(runtime, mod);
                return RubyArray.newArray(runtime, car, cdr);
            }
        }
        return this.coerceBin(context, RubyFloat.sites((ThreadContext)context).divmod, other);
    }

    @Override
    @JRubyMethod(name={"divmod"}, required=1)
    public IRubyObject divmod19(ThreadContext context, IRubyObject other) {
        if (!other.isNil() && other instanceof RubyNumeric && ((RubyNumeric)other).getDoubleValue() == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
        return this.divmod(context, other);
    }

    public IRubyObject op_pow(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case FIXNUM: 
            case BIGNUM: 
            case FLOAT: {
                return RubyFloat.newFloat(context.runtime, Math.pow(this.value, ((RubyNumeric)other).getDoubleValue()));
            }
        }
        return this.coerceBin(context, RubyFloat.sites((ThreadContext)context).op_exp, other);
    }

    public IRubyObject op_pow(ThreadContext context, double other) {
        return RubyFloat.newFloat(context.runtime, Math.pow(this.value, other));
    }

    @JRubyMethod(name={"**"}, required=1)
    public IRubyObject op_pow19(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case FIXNUM: 
            case BIGNUM: 
            case FLOAT: {
                double d_other = ((RubyNumeric)other).getDoubleValue();
                if (this.value < 0.0 && d_other != (double)Math.round(d_other)) {
                    RubyComplex complex = RubyComplex.newComplexRaw(context.runtime, this);
                    return RubyFloat.sites((ThreadContext)context).op_exp.call(context, (IRubyObject)complex, (IRubyObject)complex, other);
                }
                return this.op_pow(context, other);
            }
        }
        return this.coerceBin(context, RubyFloat.sites((ThreadContext)context).op_exp, other);
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (Double.isNaN(this.value)) {
            return context.runtime.getFalse();
        }
        switch (other.getMetaClass().getClassIndex()) {
            case FIXNUM: 
            case BIGNUM: 
            case FLOAT: {
                return RubyBoolean.newBoolean(context.runtime, this.value == ((RubyNumeric)other).getDoubleValue());
            }
        }
        return super.op_num_equal(context, other);
    }

    public IRubyObject op_equal(ThreadContext context, double other) {
        if (Double.isNaN(this.value)) {
            return context.runtime.getFalse();
        }
        return RubyBoolean.newBoolean(context.runtime, this.value == other);
    }

    public boolean fastEqual(RubyFloat other) {
        if (Double.isNaN(this.value)) {
            return false;
        }
        return this.value == other.value;
    }

    @Override
    public final int compareTo(IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case FIXNUM: 
            case BIGNUM: 
            case FLOAT: {
                return Double.compare(this.value, ((RubyNumeric)other).getDoubleValue());
            }
        }
        ThreadContext context = this.getRuntime().getCurrentContext();
        return (int)this.coerceCmp(context, RubyFloat.sites((ThreadContext)context).op_cmp, other).convertToInteger().getLongValue();
    }

    @Override
    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        switch (other.getMetaClass().getClassIndex()) {
            case FIXNUM: 
            case BIGNUM: {
                if (Double.isInfinite(this.value)) {
                    return this.value > 0.0 ? RubyFixnum.one(runtime) : RubyFixnum.minus_one(runtime);
                }
            }
            case FLOAT: {
                double b2 = ((RubyNumeric)other).getDoubleValue();
                return RubyFloat.dbl_cmp(runtime, this.value, b2);
            }
        }
        JavaSites.FloatSites sites = RubyFloat.sites(context);
        if (Double.isInfinite(this.value) && sites.respond_to_infinite.respondsTo(context, other, other, true)) {
            IRubyObject infinite = sites.infinite.call(context, other, other);
            if (infinite.isNil()) {
                return this.value > 0.0 ? RubyFixnum.one(runtime) : RubyFixnum.minus_one(runtime);
            }
            long sign2 = RubyFixnum.fix2long(infinite);
            if (sign2 > 0L) {
                return this.value > 0.0 ? RubyFixnum.zero(runtime) : RubyFixnum.minus_one(runtime);
            }
            return this.value < 0.0 ? RubyFixnum.zero(runtime) : RubyFixnum.one(runtime);
        }
        return this.coerceCmp(context, sites.op_cmp, other);
    }

    public IRubyObject op_cmp(ThreadContext context, double other) {
        return RubyFloat.dbl_cmp(context.runtime, this.value, other);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case FIXNUM: 
            case BIGNUM: 
            case FLOAT: {
                double b2 = ((RubyNumeric)other).getDoubleValue();
                return RubyBoolean.newBoolean(context.runtime, !Double.isNaN(b2) && this.value > b2);
            }
        }
        return this.coerceRelOp(context, RubyFloat.sites((ThreadContext)context).op_gt, other);
    }

    public IRubyObject op_gt(ThreadContext context, double other) {
        return RubyBoolean.newBoolean(context.runtime, !Double.isNaN(other) && this.value > other);
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case FIXNUM: 
            case BIGNUM: 
            case FLOAT: {
                double b2 = ((RubyNumeric)other).getDoubleValue();
                return RubyBoolean.newBoolean(context.runtime, !Double.isNaN(b2) && this.value >= b2);
            }
        }
        return this.coerceRelOp(context, RubyFloat.sites((ThreadContext)context).op_ge, other);
    }

    public IRubyObject op_ge(ThreadContext context, double other) {
        return RubyBoolean.newBoolean(context.runtime, !Double.isNaN(other) && this.value >= other);
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case FIXNUM: 
            case BIGNUM: 
            case FLOAT: {
                double b2 = ((RubyNumeric)other).getDoubleValue();
                return RubyBoolean.newBoolean(context.runtime, !Double.isNaN(b2) && this.value < b2);
            }
        }
        return this.coerceRelOp(context, RubyFloat.sites((ThreadContext)context).op_lt, other);
    }

    public IRubyObject op_lt(ThreadContext context, double other) {
        return RubyBoolean.newBoolean(context.runtime, !Double.isNaN(other) && this.value < other);
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case FIXNUM: 
            case BIGNUM: 
            case FLOAT: {
                double b2 = ((RubyNumeric)other).getDoubleValue();
                return RubyBoolean.newBoolean(context.runtime, !Double.isNaN(b2) && this.value <= b2);
            }
        }
        return this.coerceRelOp(context, RubyFloat.sites((ThreadContext)context).op_le, other);
    }

    public IRubyObject op_le(ThreadContext context, double other) {
        return RubyBoolean.newBoolean(context.runtime, !Double.isNaN(other) && this.value <= other);
    }

    @Override
    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(IRubyObject other) {
        return this.getRuntime().newBoolean(this.equals(other));
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof RubyFloat && this.equals((RubyFloat)other);
    }

    private boolean equals(RubyFloat that) {
        if (Double.isNaN(this.value) || Double.isNaN(that.value)) {
            return false;
        }
        double val1 = this.value == -0.0 ? 0.0 : this.value;
        double val2 = that.value == -0.0 ? 0.0 : that.value;
        return Double.doubleToLongBits(val1) == Double.doubleToLongBits(val2);
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @Override
    public final int hashCode() {
        double val = this.value == 0.0 ? -0.0 : this.value;
        long l = Double.doubleToLongBits(val);
        return (int)(l ^ l >>> 32);
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f() {
        return this;
    }

    @Override
    @JRubyMethod(name={"abs"})
    public IRubyObject abs(ThreadContext context) {
        if (Double.doubleToLongBits(this.value) < 0L) {
            return RubyFloat.newFloat(context.runtime, Math.abs(this.value));
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"magnitude"})
    public IRubyObject magnitude(ThreadContext context) {
        return this.abs(context);
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.value == 0.0);
    }

    @Override
    @JRubyMethod(name={"truncate", "to_i", "to_int"})
    public IRubyObject truncate() {
        double f = this.value;
        if (f > 0.0) {
            f = Math.floor(f);
        }
        if (f < 0.0) {
            f = Math.ceil(f);
        }
        return RubyFloat.dbl2num(this.getRuntime(), f);
    }

    @Override
    @JRubyMethod(name={"numerator"})
    public IRubyObject numerator(ThreadContext context) {
        if (Double.isInfinite(this.value) || Double.isNaN(this.value)) {
            return this;
        }
        return super.numerator(context);
    }

    @Override
    @JRubyMethod(name={"denominator"})
    public IRubyObject denominator(ThreadContext context) {
        if (Double.isInfinite(this.value) || Double.isNaN(this.value)) {
            return RubyFixnum.one(context.runtime);
        }
        return super.denominator(context);
    }

    @JRubyMethod(name={"to_r"})
    public IRubyObject to_r(ThreadContext context) {
        long[] exp = new long[1];
        double f = Numeric.frexp(this.value, exp);
        f = Numeric.ldexp(f, 53L);
        long n = exp[0] - 53L;
        Ruby runtime = context.runtime;
        IRubyObject rf = RubyNumeric.dbl2num(runtime, f);
        RubyFixnum rn = RubyFixnum.newFixnum(runtime, n);
        return Numeric.f_mul(context, rf, Numeric.f_expt(context, RubyFixnum.newFixnum(runtime, 2L), rn));
    }

    @JRubyMethod(name={"rationalize"}, optional=1)
    public IRubyObject rationalize(ThreadContext context, IRubyObject[] args2) {
        IRubyObject b2;
        IRubyObject a;
        if (Numeric.f_negative_p(context, this)) {
            return Numeric.f_negate(context, ((RubyFloat)Numeric.f_abs(context, this)).rationalize(context, args2));
        }
        Ruby runtime = context.runtime;
        RubyFixnum one = RubyFixnum.one(runtime);
        RubyFixnum two = RubyFixnum.two(runtime);
        if (args2.length != 0) {
            IRubyObject eps = Numeric.f_abs(context, args2[0]);
            a = Numeric.f_sub(context, this, eps);
            b2 = Numeric.f_add(context, this, eps);
        } else {
            long[] exp = new long[1];
            double f = Numeric.frexp(this.value, exp);
            f = Numeric.ldexp(f, 53L);
            long n = exp[0] - 53L;
            IRubyObject rf = RubyNumeric.dbl2num(runtime, f);
            RubyFixnum rn = RubyFixnum.newFixnum(runtime, n);
            if (Numeric.f_zero_p(context, rf) || !Numeric.f_negative_p(context, rn) && !Numeric.f_zero_p(context, rn)) {
                return RubyRational.newRationalRaw(runtime, Numeric.f_lshift(context, rf, rn));
            }
            a = RubyRational.newRationalRaw(runtime, Numeric.f_sub(context, Numeric.f_mul(context, two, rf), one), Numeric.f_lshift(context, one, Numeric.f_sub(context, one, rn)));
            b2 = RubyRational.newRationalRaw(runtime, Numeric.f_add(context, Numeric.f_mul(context, two, rf), one), Numeric.f_lshift(context, one, Numeric.f_sub(context, one, rn)));
        }
        if (RubyFloat.sites((ThreadContext)context).op_equal.call(context, a, a, b2).isTrue()) {
            return Numeric.f_to_r(context, this);
        }
        IRubyObject[] ary = new IRubyObject[]{a, b2};
        IRubyObject[] ans = Numeric.nurat_rationalize_internal(context, ary);
        return RubyRational.newRationalRaw(runtime, ans[0], ans[1]);
    }

    @Override
    @JRubyMethod(name={"floor"})
    public IRubyObject floor() {
        return RubyFloat.dbl2num(this.getRuntime(), Math.floor(this.value));
    }

    @Override
    @JRubyMethod(name={"ceil"})
    public IRubyObject ceil() {
        return RubyFloat.dbl2num(this.getRuntime(), Math.ceil(this.value));
    }

    @Override
    public IRubyObject round() {
        return RubyFloat.dbl2num(this.getRuntime(), this.val2dbl());
    }

    @JRubyMethod(name={"round"}, optional=1)
    public IRubyObject round(ThreadContext context, IRubyObject[] args2) {
        if (args2.length == 0) {
            return this.round();
        }
        double digits = RubyFloat.num2long(args2[0]);
        double magnifier = Math.pow(10.0, Math.abs(digits));
        double number = this.value;
        if (Double.isInfinite(this.value)) {
            if (digits <= 0.0) {
                throw context.runtime.newFloatDomainError(this.value < 0.0 ? "-Infinity" : "Infinity");
            }
            return this;
        }
        if (Double.isNaN(this.value)) {
            if (digits <= 0.0) {
                throw context.runtime.newFloatDomainError("NaN");
            }
            return this;
        }
        double binexp = this.value == 0.0 ? 0.0 : Math.ceil(Math.log(this.value) / Math.log(2.0));
        double d = binexp > 0.0 ? binexp / 4.0 : binexp / 3.0 - 1.0;
        if (digits >= 17.0 - d) {
            return RubyFloat.newFloat(context.runtime, number);
        }
        double d2 = binexp > 0.0 ? binexp / 3.0 + 1.0 : binexp / 4.0;
        if (digits < -d2) {
            return RubyFloat.dbl2num(context.runtime, 0.0);
        }
        if (Double.isInfinite(magnifier)) {
            if (digits < 0.0) {
                number = 0.0;
            }
        } else {
            number = digits < 0.0 ? (number /= magnifier) : (number *= magnifier);
            number = (double)Math.round(Math.abs(number)) * Math.signum(number);
            number = digits < 0.0 ? (number *= magnifier) : (number /= magnifier);
        }
        if (digits > 0.0) {
            return RubyFloat.newFloat(context.runtime, number);
        }
        if (number > 9.223372036854776E18 || number < -9.223372036854776E18) {
            BigDecimal roundedNumber = new BigDecimal(Double.toString(number));
            return RubyBignum.newBignum(context.runtime, roundedNumber.toBigInteger());
        }
        return RubyFloat.dbl2num(context.runtime, (long)number);
    }

    private double val2dbl() {
        double f = this.value;
        if (f > 0.0) {
            if (this.value - (f = Math.floor(f)) >= 0.5) {
                f += 1.0;
            }
        } else if (f < 0.0 && (f = Math.ceil(f)) - this.value >= 0.5) {
            f -= 1.0;
        }
        return f;
    }

    @JRubyMethod(name={"nan?"})
    public IRubyObject nan_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), Double.isNaN(this.value));
    }

    @JRubyMethod(name={"infinite?"})
    public IRubyObject infinite_p() {
        if (Double.isInfinite(this.value)) {
            return RubyFixnum.newFixnum(this.getRuntime(), this.value < 0.0 ? -1L : 1L);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"finite?"})
    public IRubyObject finite_p() {
        if (Double.isInfinite(this.value) || Double.isNaN(this.value)) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getTrue();
    }

    private ByteList marshalDump() {
        if (Double.isInfinite(this.value)) {
            return this.value < 0.0 ? NEGATIVE_INFINITY_BYTELIST : INFINITY_BYTELIST;
        }
        if (Double.isNaN(this.value)) {
            return NAN_BYTELIST;
        }
        ByteList byteList = new ByteList();
        Sprintf.sprintf(byteList, Locale.US, (CharSequence)"%.17g", RubyArray.newArray(this.getRuntime(), this));
        return byteList;
    }

    public static void marshalTo(RubyFloat aFloat, MarshalStream output) throws IOException {
        output.registerLinkTarget(aFloat);
        output.writeString(aFloat.marshalDump());
    }

    public static RubyFloat unmarshalFrom(UnmarshalStream input) throws IOException {
        ByteList value2 = input.unmarshalString();
        RubyFloat result2 = value2.equals(NAN_BYTELIST) ? RubyFloat.newFloat(input.getRuntime(), Double.NaN) : (value2.equals(NEGATIVE_INFINITY_BYTELIST) ? RubyFloat.newFloat(input.getRuntime(), Double.NEGATIVE_INFINITY) : (value2.equals(INFINITY_BYTELIST) ? RubyFloat.newFloat(input.getRuntime(), Double.POSITIVE_INFINITY) : RubyFloat.newFloat(input.getRuntime(), ConvertDouble.byteListToDouble19(value2, false))));
        input.registerLinkTarget(result2);
        return result2;
    }

    @JRubyMethod(name={"next_float"})
    public IRubyObject next_float() {
        return RubyFloat.newFloat(this.getRuntime(), Math.nextAfter(this.value, Double.POSITIVE_INFINITY));
    }

    @JRubyMethod(name={"prev_float"})
    public IRubyObject prev_float() {
        return RubyFloat.newFloat(this.getRuntime(), Math.nextAfter(this.value, Double.NEGATIVE_INFINITY));
    }

    private static JavaSites.FloatSites sites(ThreadContext context) {
        return context.sites.Float;
    }
}

