/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;

public class AttrAssignNode
extends Node
implements INameNode,
IArgumentNode {
    protected final Node receiverNode;
    private String name;
    private Node argsNode;
    private final boolean isLazy;

    public AttrAssignNode(ISourcePosition position, Node receiverNode, String name2, Node argsNode, boolean isLazy) {
        super(position, receiverNode != null && receiverNode.containsVariableAssignment() || argsNode != null && argsNode.containsVariableAssignment());
        assert (receiverNode != null) : "receiverNode is not null";
        this.receiverNode = receiverNode;
        this.name = name2;
        this.argsNode = argsNode;
        this.isLazy = isLazy;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ATTRASSIGNNODE;
    }

    public Object accept(NodeVisitor visitor) {
        return visitor.visitAttrAssignNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public Node setArgsNode(Node argsNode) {
        this.argsNode = argsNode;
        return this;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.argsNode);
    }
}

