/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.addons;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class KernelJavaAddons {
    @JRubyMethod
    public static IRubyObject to_java(ThreadContext context, IRubyObject fromObject) {
        if (fromObject instanceof RubyArray) {
            JavaClass targetType = context.runtime.getJavaSupport().getObjectJavaClass();
            return targetType.javaArrayFromRubyArray(context, (RubyArray)fromObject);
        }
        return Java.getInstance(context.runtime, fromObject.toJava(Object.class));
    }

    @JRubyMethod
    public static IRubyObject to_java(ThreadContext context, IRubyObject fromObject, IRubyObject type2) {
        if (type2.isNil()) {
            return KernelJavaAddons.to_java(context, fromObject);
        }
        Ruby runtime = context.runtime;
        JavaClass targetType = KernelJavaAddons.getTargetType(context, runtime, type2);
        if (fromObject instanceof RubyArray) {
            return targetType.javaArrayFromRubyArray(context, (RubyArray)fromObject);
        }
        return Java.getInstance(runtime, fromObject.toJava(targetType.javaClass()));
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_signature(IRubyObject recv2, IRubyObject[] args2) {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_name(IRubyObject recv2, IRubyObject[] args2) {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_implements(IRubyObject recv2, IRubyObject[] args2) {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_annotation(IRubyObject recv2, IRubyObject[] args2) {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_require(IRubyObject recv2, IRubyObject[] args2) {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_package(IRubyObject recv2, IRubyObject[] args2) {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_field(IRubyObject recv2, IRubyObject[] args2) {
        return recv2.getRuntime().getNil();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static JavaClass getTargetType(ThreadContext context, Ruby runtime, IRubyObject type2) {
        if (type2 instanceof RubyString || type2 instanceof RubySymbol) {
            JavaClass targetType = runtime.getJavaSupport().getNameClassMap().get(type2.asJavaString());
            if (targetType != null) return targetType;
            return JavaClass.forNameVerbose(runtime, type2.asJavaString());
        }
        if (type2 instanceof RubyModule && type2.respondsTo("java_class")) {
            return (JavaClass)Helpers.invoke(context, type2, "java_class");
        }
        if (!(type2 instanceof JavaProxy)) throw runtime.newTypeError("unable to convert to type: " + type2);
        Object wrapped = ((JavaProxy)type2).getObject();
        if (!(wrapped instanceof Class)) throw runtime.newTypeError("not a valid target type: " + type2);
        return JavaClass.get(runtime, (Class)wrapped);
    }
}

