/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RescueEQQInstr
extends ResultBaseInstr
implements FixedArityInstr {
    public RescueEQQInstr(Variable result2, Operand v1, Operand v2) {
        super(Operation.RESCUE_EQQ, result2, new Operand[]{v1, v2});
        assert (result2 != null) : "RescueEQQInstr result is null";
    }

    public Operand getArg1() {
        return this.operands[0];
    }

    public Operand getArg2() {
        return this.operands[1];
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new RescueEQQInstr(ii.getRenamedVariable(this.result), this.getArg1().cloneForInlining(ii), this.getArg2().cloneForInlining(ii));
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getArg1());
        e.encode(this.getArg2());
    }

    public static RescueEQQInstr decode(IRReaderDecoder d) {
        return new RescueEQQInstr(d.decodeVariable(), d.decodeOperand(), d.decodeOperand());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        IRubyObject excType = (IRubyObject)this.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
        Object excObj = this.getArg2().retrieve(context, self2, currScope, currDynScope, temp);
        return IRRuntimeHelpers.isExceptionHandled(context, excType, excObj);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.RescueEQQInstr(this);
    }
}

