/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.List;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyEnumerable;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.TypeConverter;

@JRubyClass(name={"Range"}, include={"Enumerable"})
public class RubyRange
extends RubyObject {
    private IRubyObject begin;
    private IRubyObject end;
    private boolean isExclusive;
    private static final ObjectAllocator RANGE_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyRange(runtime, klass);
        }
    };
    private static byte[] DOTDOTDOT = "...".getBytes();
    private static byte[] DOTDOT = "..".getBytes();
    private static final ObjectMarshal RANGE_MARSHAL = new ObjectMarshal(){

        @Override
        public void marshalTo(Ruby runtime, Object obj, RubyClass type2, MarshalStream marshalStream) throws IOException {
            RubyRange range = (RubyRange)obj;
            marshalStream.registerLinkTarget(range);
            List<Variable<Object>> attrs = range.getVariableList();
            attrs.add(new VariableEntry<IRubyObject>("begin", range.begin));
            attrs.add(new VariableEntry<IRubyObject>("end", range.end));
            attrs.add(new VariableEntry<RubyBoolean>("excl", range.isExclusive ? runtime.getTrue() : runtime.getFalse()));
            marshalStream.dumpVariables(attrs);
        }

        @Override
        public Object unmarshalFrom(Ruby runtime, RubyClass type2, UnmarshalStream unmarshalStream) throws IOException {
            RubyRange range = (RubyRange)type2.allocate();
            unmarshalStream.registerLinkTarget(range);
            unmarshalStream.defaultVariablesUnmarshal(range);
            range.begin = (IRubyObject)range.removeInternalVariable("begin");
            range.end = (IRubyObject)range.removeInternalVariable("end");
            range.isExclusive = ((IRubyObject)range.removeInternalVariable("excl")).isTrue();
            return range;
        }
    };

    public static RubyClass createRangeClass(Ruby runtime) {
        RubyClass result2 = runtime.defineClass("Range", runtime.getObject(), RANGE_ALLOCATOR);
        runtime.setRange(result2);
        result2.setClassIndex(ClassIndex.RANGE);
        result2.setReifiedClass(RubyRange.class);
        result2.kindOf = new RubyModule.JavaClassKindOf(RubyRange.class);
        result2.setMarshal(RANGE_MARSHAL);
        result2.includeModule(runtime.getEnumerable());
        result2.defineAnnotatedMethods(RubyRange.class);
        return result2;
    }

    private RubyRange(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
        this.begin = this.end = runtime.getNil();
    }

    public static RubyRange newRange(ThreadContext context, IRubyObject begin2, IRubyObject end2, boolean isExclusive) {
        RubyRange range = new RubyRange(context.runtime, context.runtime.getRange());
        range.init(context, begin2, end2, isExclusive);
        return range;
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone) {
        RubyRange range = (RubyRange)clone;
        range.begin = this.begin;
        range.end = this.end;
        range.isExclusive = this.isExclusive;
    }

    final boolean checkBegin(long length2) {
        long beg = RubyNumeric.num2long(this.begin);
        return !(beg < 0L ? (beg += length2) < 0L : length2 < beg);
    }

    final long[] begLen(long len, int err) {
        long beg = RubyNumeric.num2long(this.begin);
        long end2 = RubyNumeric.num2long(this.end);
        if (beg < 0L && (beg += len) < 0L) {
            if (err != 0) {
                throw this.getRuntime().newRangeError(beg + ".." + (this.isExclusive ? "." : "") + end2 + " out of range");
            }
            return null;
        }
        if (err == 0 || err == 2) {
            if (beg > len) {
                if (err != 0) {
                    throw this.getRuntime().newRangeError(beg + ".." + (this.isExclusive ? "." : "") + end2 + " out of range");
                }
                return null;
            }
            if (end2 > len) {
                end2 = len;
            }
        }
        if (end2 < 0L) {
            end2 += len;
        }
        if (!this.isExclusive) {
            ++end2;
        }
        if ((len = end2 - beg) < 0L) {
            len = 0L;
        }
        return new long[]{beg, len};
    }

    final long begLen0(long len) {
        long beg = RubyNumeric.num2long(this.begin);
        if (beg < 0L && (beg += len) < 0L) {
            throw this.getRuntime().newRangeError(beg + ".." + (this.isExclusive ? "." : "") + this.end + " out of range");
        }
        return beg;
    }

    final long begLen1(long len, long beg) {
        long end2 = RubyNumeric.num2long(this.end);
        if (end2 < 0L) {
            end2 += len;
        }
        if (!this.isExclusive) {
            ++end2;
        }
        if ((len = end2 - beg) < 0L) {
            len = 0L;
        }
        return len;
    }

    final int[] begLenInt(int len, int err) {
        int beg = RubyNumeric.num2int(this.begin);
        int end2 = RubyNumeric.num2int(this.end);
        if (beg < 0 && (beg += len) < 0) {
            if (err != 0) {
                throw this.getRuntime().newRangeError(beg + ".." + (this.isExclusive ? "." : "") + end2 + " out of range");
            }
            return null;
        }
        if (err == 0 || err == 2) {
            if (beg > len) {
                if (err != 0) {
                    throw this.getRuntime().newRangeError(beg + ".." + (this.isExclusive ? "." : "") + end2 + " out of range");
                }
                return null;
            }
            if (end2 > len) {
                end2 = len;
            }
        }
        if (end2 < 0) {
            end2 += len;
        }
        if (!this.isExclusive) {
            ++end2;
        }
        if ((len = end2 - beg) < 0) {
            len = 0;
        }
        return new int[]{beg, len};
    }

    private void init(ThreadContext context, IRubyObject begin2, IRubyObject end2, boolean isExclusive) {
        if (!(begin2 instanceof RubyFixnum) || !(end2 instanceof RubyFixnum)) {
            try {
                IRubyObject result2 = Helpers.invokedynamic(context, begin2, MethodNames.OP_CMP, end2);
                if (result2.isNil()) {
                    throw this.getRuntime().newArgumentError("bad value for range");
                }
            }
            catch (RaiseException re) {
                throw this.getRuntime().newArgumentError("bad value for range");
            }
        }
        this.begin = begin2;
        this.end = end2;
        this.isExclusive = isExclusive;
    }

    @JRubyMethod(required=2, optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block unusedBlock) {
        if (!this.begin.isNil() || !this.end.isNil()) {
            throw this.getRuntime().newNameError("`initialize' called twice", "initialize");
        }
        this.init(context, args2[0], args2[1], args2.length > 2 && args2[2].isTrue());
        return this.getRuntime().getNil();
    }

    @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject original) {
        if (!this.begin.isNil() || !this.end.isNil()) {
            throw context.runtime.newNameError("`initialize' called twice", "initialize");
        }
        RubyRange other = (RubyRange)original;
        this.init(context, other.begin, other.end, other.isExclusive);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        long hash2;
        long h = hash2 = this.isExclusive ? 1L : 0L;
        long v = Helpers.invokedynamic(context, this.begin, MethodNames.HASH).convertToInteger().getLongValue();
        hash2 ^= v << 1;
        v = Helpers.invokedynamic(context, this.end, MethodNames.HASH).convertToInteger().getLongValue();
        hash2 ^= v << 9;
        return this.getRuntime().newFixnum(hash2 ^= h << 24);
    }

    private IRubyObject inspectValue(final ThreadContext context, IRubyObject value2) {
        return this.getRuntime().execRecursiveOuter(new Ruby.RecursiveFunction(){

            @Override
            public IRubyObject call(IRubyObject obj, boolean recur) {
                if (recur) {
                    return RubyString.newString(context.runtime, RubyRange.this.isExclusive ? "(... ... ...)" : "(... .. ...)");
                }
                return RubyObject.inspect(context, obj);
            }
        }, value2);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        RubyString i1 = ((RubyString)this.inspectValue(context, this.begin)).strDup(context.runtime);
        RubyString i2 = (RubyString)this.inspectValue(context, this.end);
        i1.cat(this.isExclusive ? DOTDOTDOT : DOTDOT);
        i1.append(i2);
        i1.infectBy(i2);
        return i1;
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        RubyString i1 = this.begin.asString().strDup(context.runtime);
        RubyString i2 = this.end.asString();
        i1.cat(this.isExclusive ? DOTDOTDOT : DOTDOT);
        i1.append(i2);
        i1.infectBy(i2);
        return i1;
    }

    @JRubyMethod(name={"exclude_end?"})
    public RubyBoolean exclude_end_p() {
        return this.getRuntime().newBoolean(this.isExclusive);
    }

    @Override
    @JRubyMethod(name={"==", "eql?"}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyRange)) {
            return this.getRuntime().getFalse();
        }
        RubyRange otherRange = (RubyRange)other;
        if (RubyRange.equalInternal(context, this.begin, otherRange.begin) && RubyRange.equalInternal(context, this.end, otherRange.end) && this.isExclusive == otherRange.isExclusive) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    private IRubyObject rangeLt(ThreadContext context, IRubyObject a, IRubyObject b2) {
        IRubyObject result2 = Helpers.invokedynamic(context, a, MethodNames.OP_CMP, b2);
        if (result2.isNil()) {
            return null;
        }
        return RubyComparable.cmpint(context, result2, a, b2) < 0 ? this.getRuntime().getTrue() : null;
    }

    private IRubyObject rangeLe(ThreadContext context, IRubyObject a, IRubyObject b2) {
        IRubyObject result2 = Helpers.invokedynamic(context, a, MethodNames.OP_CMP, b2);
        if (result2.isNil()) {
            return null;
        }
        int c = RubyComparable.cmpint(context, result2, a, b2);
        if (c == 0) {
            return RubyFixnum.zero(this.getRuntime());
        }
        return c < 0 ? this.getRuntime().getTrue() : null;
    }

    private void rangeEach(ThreadContext context, RangeCallBack callback) {
        IRubyObject v = this.begin;
        if (this.isExclusive) {
            while (this.rangeLt(context, v, this.end) != null) {
                callback.call(context, v);
                v = v.callMethod(context, "succ");
            }
        } else {
            IRubyObject c;
            while ((c = this.rangeLe(context, v, this.end)) != null && c.isTrue()) {
                callback.call(context, v);
                if (c != RubyFixnum.zero(this.getRuntime())) {
                    v = v.callMethod(context, "succ");
                    continue;
                }
                break;
            }
        }
    }

    @JRubyMethod
    public IRubyObject to_a(ThreadContext context, Block block) {
        Ruby runtime = context.runtime;
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            long base;
            long size2;
            long lim = ((RubyFixnum)this.end).getLongValue();
            if (!this.isExclusive) {
                ++lim;
            }
            if ((size2 = lim - (base = ((RubyFixnum)this.begin).getLongValue())) > Integer.MAX_VALUE) {
                throw runtime.newRangeError("Range size too large for to_a");
            }
            if (size2 < 0L) {
                return RubyArray.newEmptyArray(runtime);
            }
            IRubyObject[] array = new IRubyObject[(int)size2];
            int i2 = 0;
            while ((long)i2 < size2) {
                array[i2] = RubyFixnum.newFixnum(runtime, base + (long)i2);
                ++i2;
            }
            return RubyArray.newArrayNoCopy(runtime, array);
        }
        return RubyEnumerable.to_a(context, this);
    }

    public IRubyObject each(ThreadContext context, Block block) {
        return this.each19(context, block);
    }

    private void fixnumEach(ThreadContext context, Ruby runtime, Block block) {
        long to = ((RubyFixnum)this.end).getLongValue();
        if (this.isExclusive) {
            if (to == Long.MIN_VALUE) {
                return;
            }
            --to;
        }
        long from = ((RubyFixnum)this.begin).getLongValue();
        if (block.getSignature() == Signature.NO_ARGUMENTS) {
            long i2;
            IRubyObject nil = runtime.getNil();
            for (i2 = from; i2 < to; ++i2) {
                block.yield(context, nil);
            }
            if (i2 <= to) {
                block.yield(context, nil);
            }
        } else {
            long i3;
            for (i3 = from; i3 < to; ++i3) {
                block.yield(context, RubyFixnum.newFixnum(runtime, i3));
            }
            if (i3 <= to) {
                block.yield(context, RubyFixnum.newFixnum(runtime, i3));
            }
        }
    }

    @JRubyMethod(name={"each"})
    public IRubyObject each19(ThreadContext context, final Block block) {
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "each", this.enumSizeFn(context));
        }
        if (this.begin instanceof RubyTime) {
            throw runtime.newTypeError("can't iterate from Time");
        }
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            this.fixnumEach(context, runtime, block);
        } else if (this.begin instanceof RubySymbol) {
            this.begin.asString().uptoCommon19(context, this.end.asString(), this.isExclusive, block, true);
        } else {
            IRubyObject tmp = this.begin.checkStringType();
            if (!tmp.isNil()) {
                ((RubyString)tmp).uptoCommon19(context, this.end, this.isExclusive, block);
            } else {
                if (!this.begin.respondsTo("succ")) {
                    throw this.getRuntime().newTypeError("can't iterate from " + this.begin.getMetaClass().getName());
                }
                this.rangeEach(context, new RangeCallBack(){

                    @Override
                    void call(ThreadContext context, IRubyObject arg2) {
                        block.yield(context, arg2);
                    }
                });
            }
        }
        return this;
    }

    public IRubyObject step(ThreadContext context, IRubyObject step2, Block block) {
        return this.step19(context, step2, block);
    }

    public IRubyObject step(ThreadContext context, Block block) {
        return this.step19(context, block);
    }

    private void fixnumStep(ThreadContext context, Ruby runtime, long step2, Block block) {
        long i2;
        long tov;
        long to = ((RubyFixnum)this.end).getLongValue();
        if (this.isExclusive) {
            if (to == Long.MIN_VALUE) {
                return;
            }
            --to;
        }
        if (to < (tov = Long.MAX_VALUE - step2)) {
            tov = to;
        }
        for (i2 = ((RubyFixnum)this.begin).getLongValue(); i2 <= tov; i2 += step2) {
            block.yield(context, RubyFixnum.newFixnum(runtime, i2));
        }
        if (i2 <= to) {
            block.yield(context, RubyFixnum.newFixnum(runtime, i2));
        }
    }

    @JRubyMethod(name={"step"})
    public IRubyObject step19(ThreadContext context, Block block) {
        return block.isGiven() ? this.stepCommon19(context, RubyFixnum.one(context.runtime), block) : RubyEnumerator.enumeratorizeWithSize(context, this, "step", this.stepSizeFn(context));
    }

    @JRubyMethod(name={"step"})
    public IRubyObject step19(ThreadContext context, IRubyObject step2, Block block) {
        RubyFixnum zero;
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, (IRubyObject)this, "step", new IRubyObject[]{step2}, this.stepSizeFn(context));
        }
        if (!(step2 instanceof RubyNumeric)) {
            step2 = step2.convertToInteger("to_int");
        }
        if (step2.callMethod(context, "<", zero = RubyFixnum.zero(runtime)).isTrue()) {
            throw runtime.newArgumentError("step can't be negative");
        }
        if (!step2.callMethod(context, ">", zero).isTrue()) {
            throw runtime.newArgumentError("step can't be 0");
        }
        return this.stepCommon19(context, step2, block);
    }

    private IRubyObject stepCommon19(ThreadContext context, IRubyObject step2, Block block) {
        Ruby runtime = context.runtime;
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum && step2 instanceof RubyFixnum) {
            this.fixnumStep(context, runtime, ((RubyFixnum)step2).getLongValue(), block);
        } else if (this.begin instanceof RubyFloat || this.end instanceof RubyFloat || step2 instanceof RubyFloat) {
            RubyNumeric.floatStep19(context, runtime, this.begin, this.end, step2, this.isExclusive, block);
        } else if (this.begin instanceof RubyNumeric || !TypeConverter.checkIntegerType(runtime, this.begin, "to_int").isNil() || !TypeConverter.checkIntegerType(runtime, this.end, "to_int").isNil()) {
            this.numericStep19(context, runtime, step2, block);
        } else {
            IRubyObject tmp = this.begin.checkStringType();
            if (!tmp.isNil()) {
                StepBlockCallBack callback = new StepBlockCallBack(block, RubyFixnum.one(runtime), step2);
                Block blockCallback = CallBlock.newCallClosure((IRubyObject)this, (RubyModule)runtime.getRange(), Signature.ONE_ARGUMENT, (BlockCallback)callback, context);
                ((RubyString)tmp).uptoCommon19(context, this.end, this.isExclusive, blockCallback);
            } else {
                if (!this.begin.respondsTo("succ")) {
                    throw runtime.newTypeError("can't iterate from " + this.begin.getMetaClass().getName());
                }
                this.rangeEach(context, new StepBlockCallBack(block, RubyFixnum.one(runtime), step2));
            }
        }
        return this;
    }

    private void numericStep19(ThreadContext context, Ruby runtime, IRubyObject step2, Block block) {
        String method = this.isExclusive ? "<" : "<=";
        IRubyObject beg = this.begin;
        long i2 = 0L;
        while (beg.callMethod(context, method, this.end).isTrue()) {
            block.yield(context, beg);
            beg = this.begin.callMethod(context, "+", RubyFixnum.newFixnum(runtime, ++i2).callMethod(context, "*", step2));
        }
    }

    private RubyEnumerator.SizeFn enumSizeFn(final ThreadContext context) {
        final RubyRange self2 = this;
        return new RubyEnumerator.SizeFn(){

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                return self2.size(context);
            }
        };
    }

    private RubyEnumerator.SizeFn stepSizeFn(final ThreadContext context) {
        final RubyRange self2 = this;
        return new RubyEnumerator.SizeFn(){

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                IRubyObject step2;
                Ruby runtime = context.runtime;
                IRubyObject begin2 = self2.begin;
                IRubyObject end2 = self2.end;
                if (args2 != null && args2.length > 0) {
                    step2 = args2[0];
                    if (!(step2 instanceof RubyNumeric)) {
                        step2.convertToInteger();
                    }
                } else {
                    step2 = RubyFixnum.one(runtime);
                }
                if (step2.callMethod(context, "<", RubyFixnum.zero(runtime)).isTrue()) {
                    throw runtime.newArgumentError("step can't be negative");
                }
                if (!step2.callMethod(context, ">", RubyFixnum.zero(runtime)).isTrue()) {
                    throw runtime.newArgumentError("step can't be 0");
                }
                if (begin2 instanceof RubyNumeric && end2 instanceof RubyNumeric) {
                    return RubyNumeric.intervalStepSize(context, begin2, end2, step2, self2.isExclusive);
                }
                return runtime.getNil();
            }
        };
    }

    public RubyBoolean include_p(ThreadContext context, IRubyObject obj) {
        return (RubyBoolean)this.include_p19(context, obj);
    }

    @JRubyMethod(name={"include?", "member?"}, frame=true)
    public IRubyObject include_p19(ThreadContext context, IRubyObject obj) {
        Ruby runtime = context.runtime;
        if (this.begin instanceof RubyNumeric || this.end instanceof RubyNumeric || !TypeConverter.convertToTypeWithCheck(this.begin, runtime.getInteger(), "to_int").isNil() || !TypeConverter.convertToTypeWithCheck(this.end, runtime.getInteger(), "to_int").isNil()) {
            return this.cover_p(context, obj);
        }
        if (this.begin instanceof RubyString && this.end instanceof RubyString && ((RubyString)this.begin).getByteList().getRealSize() == 1 && ((RubyString)this.end).getByteList().getRealSize() == 1) {
            if (obj.isNil()) {
                return runtime.getFalse();
            }
            if (obj instanceof RubyString) {
                ByteList Vbytes = ((RubyString)obj).getByteList();
                if (Vbytes.getRealSize() != 1) {
                    return runtime.getFalse();
                }
                int v = Vbytes.getUnsafeBytes()[Vbytes.getBegin()] & 0xFF;
                ByteList Bbytes = ((RubyString)this.begin).getByteList();
                int b2 = Bbytes.getUnsafeBytes()[Bbytes.getBegin()] & 0xFF;
                ByteList Ebytes = ((RubyString)this.end).getByteList();
                int e = Ebytes.getUnsafeBytes()[Ebytes.getBegin()] & 0xFF;
                if (Encoding.isAscii(v) && Encoding.isAscii(b2) && Encoding.isAscii(e)) {
                    if (b2 <= v && v < e || !this.isExclusive && v == e) {
                        return runtime.getTrue();
                    }
                    return runtime.getFalse();
                }
            }
        }
        return Helpers.invokeSuper(context, (IRubyObject)this, obj, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"==="})
    public IRubyObject eqq_p19(ThreadContext context, IRubyObject obj) {
        return this.callMethod(context, "include?", obj);
    }

    @JRubyMethod(name={"cover?"})
    public IRubyObject cover_p(ThreadContext context, IRubyObject obj) {
        if (this.rangeLe(context, this.begin, obj) == null) {
            return context.runtime.getFalse();
        }
        return context.runtime.newBoolean(this.isExclusive ? this.rangeLt(context, obj, this.end) != null : this.rangeLe(context, obj, this.end) != null);
    }

    @JRubyMethod(frame=true)
    public IRubyObject min(ThreadContext context, Block block) {
        IRubyObject receiver2 = this.getReceiverForMinMax(context, this.end, block);
        if (receiver2.isNil()) {
            return receiver2;
        }
        return Helpers.invokeSuper(context, receiver2, block);
    }

    @JRubyMethod(frame=true)
    public IRubyObject max(ThreadContext context, Block block) {
        IRubyObject rangeEnd;
        if (this.isExclusive) {
            if (!(this.end instanceof RubyInteger)) {
                throw context.runtime.newTypeError("cannot exclude non Integer end value");
            }
            if (!(this.begin instanceof RubyInteger)) {
                throw context.runtime.newTypeError("cannot exclude end value with non Integer begin value");
            }
            rangeEnd = RubyFixnum.newFixnum(context.runtime, ((RubyFixnum)this.end).getLongValue() - 1L);
        } else {
            rangeEnd = this.end;
        }
        IRubyObject receiver2 = this.getReceiverForMinMax(context, rangeEnd, block);
        if (receiver2.isNil()) {
            return receiver2;
        }
        return Helpers.invokeSuper(context, receiver2, block);
    }

    @JRubyMethod(frame=true)
    public IRubyObject min(ThreadContext context, IRubyObject arg2, Block block) {
        if (block.isGiven()) {
            return Helpers.invokeSuper(context, this, block);
        }
        return this.first(context, arg2);
    }

    @JRubyMethod(frame=true)
    public IRubyObject max(ThreadContext context, IRubyObject arg2, Block block) {
        if (block.isGiven()) {
            return Helpers.invokeSuper(context, this, block);
        }
        return ((RubyArray)this.last(context, arg2)).reverse();
    }

    private boolean rangeEmpty_p(ThreadContext context) {
        int cmp2 = RubyComparable.cmpint(context, Helpers.invokedynamic(context, this.begin, MethodNames.OP_CMP, this.end), this.begin, this.end);
        return cmp2 > 0 || cmp2 == 0 && this.isExclusive;
    }

    private IRubyObject getReceiverForMinMax(ThreadContext context, IRubyObject rangeEnd, Block block) {
        RubyObject receiver2;
        if (block.isGiven()) {
            receiver2 = this;
        } else {
            if (this.rangeEmpty_p(context)) {
                return context.runtime.getNil();
            }
            receiver2 = RubyArray.newArray(context.runtime, new IRubyObject[]{this.begin, rangeEnd});
        }
        return receiver2;
    }

    @JRubyMethod
    public IRubyObject first(ThreadContext context) {
        return this.begin;
    }

    @JRubyMethod
    public IRubyObject begin(ThreadContext context) {
        return this.begin;
    }

    @JRubyMethod
    public IRubyObject first(ThreadContext context, IRubyObject arg2) {
        final Ruby runtime = context.runtime;
        final int num = RubyNumeric.num2int(arg2);
        if (num < 0) {
            throw context.runtime.newArgumentError("negative array size (or size too big)");
        }
        final RubyArray result2 = runtime.newArray(num);
        try {
            RubyEnumerable.callEach(runtime, context, (IRubyObject)this, Signature.ONE_ARGUMENT, new BlockCallback(){
                int n;
                {
                    this.n = num;
                }

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    if (this.n-- <= 0) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    result2.append(largs[0]);
                    return runtime.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod
    public IRubyObject last(ThreadContext context) {
        return this.end;
    }

    @JRubyMethod
    public IRubyObject end(ThreadContext context) {
        return this.end;
    }

    @JRubyMethod
    public IRubyObject last(ThreadContext context, IRubyObject arg2) {
        return ((RubyArray)RubyKernel.new_array(context, this, this)).last(arg2);
    }

    @JRubyMethod
    public IRubyObject size(ThreadContext context) {
        if (this.begin instanceof RubyNumeric && this.end instanceof RubyNumeric) {
            return RubyNumeric.intervalStepSize(context, this.begin, this.end, RubyFixnum.one(context.runtime), this.isExclusive);
        }
        return context.nil;
    }

    private static final class StepBlockCallBack
    extends RangeCallBack
    implements BlockCallback {
        final Block block;
        IRubyObject iter;
        final IRubyObject step;

        StepBlockCallBack(Block block, IRubyObject iter, IRubyObject step2) {
            this.block = block;
            this.iter = iter;
            this.step = step2;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block originalBlock) {
            this.call(context, args2[0]);
            return context.runtime.getNil();
        }

        @Override
        void call(ThreadContext context, IRubyObject arg2) {
            this.iter = this.iter instanceof RubyFixnum ? RubyFixnum.newFixnum(context.runtime, ((RubyFixnum)this.iter).getLongValue() - 1L) : this.iter.callMethod(context, "-", RubyFixnum.one(context.runtime));
            if (this.iter == RubyFixnum.zero(context.runtime)) {
                this.block.yield(context, arg2);
                this.iter = this.step;
            }
        }
    }

    private static abstract class RangeCallBack {
        private RangeCallBack() {
        }

        abstract void call(ThreadContext var1, IRubyObject var2);
    }
}

