/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyProc;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.ClosureAcceptingInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.SimpleSourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class BuildLambdaInstr
extends ResultBaseInstr
implements FixedArityInstr,
ClosureAcceptingInstr {
    private final ISourcePosition position;

    public BuildLambdaInstr(Variable result2, Operand lambdaBody, ISourcePosition position) {
        super(Operation.LAMBDA, result2, new Operand[]{lambdaBody});
        this.position = position;
    }

    public String getLambdaBodyName() {
        return "";
    }

    public ISourcePosition getPosition() {
        return this.position;
    }

    @Override
    public boolean computeScopeFlags(IRScope scope) {
        scope.getFlags().add(IRFlags.BINDING_HAS_ESCAPED);
        return true;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new BuildLambdaInstr(ii.getRenamedVariable(this.getResult()), this.getLambdaBody().cloneForInlining(ii), this.position);
    }

    public Operand getLambdaBody() {
        return this.operands[0];
    }

    @Override
    public Operand getClosureArg() {
        return this.operands[0];
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getLambdaBody());
        e.encode(this.getPosition().getFile());
        e.encode(this.getPosition().getLine());
    }

    public static BuildLambdaInstr decode(IRReaderDecoder d) {
        return new BuildLambdaInstr(d.decodeVariable(), d.decodeOperand(), new SimpleSourcePosition(d.decodeString(), d.decodeInt()));
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        ((WrappedIRClosure)this.getLambdaBody()).getClosure().getStaticScope().determineModule();
        Block block = (Block)this.getLambdaBody().retrieve(context, self2, currScope, currDynScope, temp);
        return RubyProc.newProc(context.runtime, block, Block.Type.LAMBDA, this.position.getFile(), this.position.getLine());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BuildLambdaInstr(this);
    }
}

