/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Fcntl;
import jnr.constants.platform.OpenFlags;
import jnr.enxio.channels.NativeDeviceChannel;
import jnr.enxio.channels.NativeSelectableChannel;
import jnr.posix.POSIX;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFile;
import org.jruby.RubyFileStat;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProcess;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.ThreadedRunnable;
import org.jruby.platform.Platform;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.util.ByteList;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.ShellLauncher;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.ChannelFD;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.io.FilenoUtil;
import org.jruby.util.io.IOEncodable;
import org.jruby.util.io.IOOptions;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;
import org.jruby.util.io.POSIXProcess;
import org.jruby.util.io.PopenExecutor;
import org.jruby.util.io.PosixShim;
import org.jruby.util.io.STDIO;
import org.jruby.util.io.SelectExecutor;

@JRubyClass(name={"IO"}, include={"Enumerable"})
public class RubyIO
extends RubyObject
implements IOEncodable {
    public static final ByteList PARAGRAPH_DELIMETER = ByteList.create("PARAGRPH_DELIM_MRK_ER");
    public static final ByteList PARAGRAPH_SEPARATOR = ByteList.create("\n\n");
    public static final String CLOSED_STREAM_MSG = "closed stream";
    private static ObjectAllocator IO_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyIO(runtime, klass);
        }
    };
    private static final String VENDOR;
    private static final String msgEINTR = "Interrupted system call";
    private static final byte[] EMPTY_BYTE_ARRAY;
    private static final ByteList RECURSIVE_BYTELIST;
    private static final Set<String> UNSUPPORTED_SPAWN_OPTIONS;
    private static final Set<String> ALL_SPAWN_OPTIONS;
    private static final byte[] NEWLINE_BYTES;
    protected OpenFile openFile;
    protected boolean popenSpecial;

    public RubyIO(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    public RubyIO(Ruby runtime, OutputStream outputStream) {
        this(runtime, outputStream, true);
    }

    public RubyIO(Ruby runtime, OutputStream outputStream, boolean autoclose2) {
        super(runtime, runtime.getIO());
        if (outputStream == null) {
            throw runtime.newRuntimeError("Opening null stream");
        }
        this.openFile = this.MakeOpenFile();
        this.openFile.setFD(new ChannelFD(Channels.newChannel(outputStream), runtime.getPosix(), runtime.getFilenoUtil()));
        this.openFile.setMode(66);
        this.openFile.setAutoclose(autoclose2);
    }

    public RubyIO(Ruby runtime, InputStream inputStream) {
        super(runtime, runtime.getIO());
        if (inputStream == null) {
            throw runtime.newRuntimeError("Opening null stream");
        }
        this.openFile = this.MakeOpenFile();
        this.openFile.setFD(new ChannelFD(Channels.newChannel(inputStream), runtime.getPosix(), runtime.getFilenoUtil()));
        this.openFile.setMode(1);
    }

    public RubyIO(Ruby runtime, Channel channel) {
        this(runtime, runtime.getIO(), channel);
    }

    public RubyIO(Ruby runtime, RubyClass klass, Channel channel) {
        super(runtime, klass);
        if (channel == null) {
            throw runtime.newRuntimeError("Opening null channel");
        }
        ThreadContext context = runtime.getCurrentContext();
        this.initializeCommon(context, new ChannelFD(channel, runtime.getPosix(), runtime.getFilenoUtil()), (IRubyObject)runtime.newFixnum(ModeFlags.oflagsFrom(runtime.getPosix(), channel)), context.nil);
    }

    public RubyIO(Ruby runtime, ShellLauncher.POpenProcess process, IOOptions ioOptions) {
        super(runtime, runtime.getIO());
        ioOptions = this.updateIOOptionsFromOptions(runtime.getCurrentContext(), null, ioOptions);
        this.openFile = this.MakeOpenFile();
        this.setupPopen(ioOptions.getModeFlags(), process);
    }

    public static RubyIO prepStdio(Ruby runtime, InputStream f, Channel c, int fmode, RubyClass klass, String path2) {
        RubyIO io2 = RubyIO.prepIO(runtime, c, fmode | 0x10000 | EncodingUtils.DEFAULT_TEXTMODE, klass, path2);
        OpenFile fptr = io2.getOpenFileChecked();
        if (f == System.in) {
            fptr.fd().realFileno = 0;
        }
        RubyIO.prepStdioEcflags(fptr, fmode);
        fptr.stdio_file = f;
        return RubyIO.recheckTTY(runtime, fptr, io2);
    }

    public static RubyIO prepStdio(Ruby runtime, OutputStream f, Channel c, int fmode, RubyClass klass, String path2) {
        RubyIO io2 = RubyIO.prepIO(runtime, c, fmode | 0x10000 | EncodingUtils.DEFAULT_TEXTMODE, klass, path2);
        OpenFile fptr = io2.getOpenFileChecked();
        if (f == System.out) {
            fptr.fd().realFileno = 1;
        } else if (f == System.err) {
            fptr.fd().realFileno = 2;
        }
        RubyIO.prepStdioEcflags(fptr, fmode);
        fptr.stdio_file = f;
        return RubyIO.recheckTTY(runtime, fptr, io2);
    }

    private static RubyIO recheckTTY(Ruby runtime, OpenFile fptr, RubyIO io2) {
        fptr.checkTTY();
        return io2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void prepStdioEcflags(OpenFile fptr, int fmode) {
        boolean locked = fptr.lock();
        try {
            fptr.encs.ecflags |= EncodingUtils.ECONV_DEFAULT_NEWLINE_DECORATOR;
            if (EncodingUtils.TEXTMODE_NEWLINE_DECORATOR_ON_WRITE != 0) {
                fptr.encs.ecflags |= EncodingUtils.TEXTMODE_NEWLINE_DECORATOR_ON_WRITE;
                if ((fmode & 1) != 0) {
                    fptr.encs.ecflags |= 0x100;
                }
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
    }

    private static RubyIO prepIO(Ruby runtime, Channel fd, int fmode, RubyClass klass, String path2) {
        RubyIO io2 = (RubyIO)klass.allocate();
        OpenFile fp = io2.MakeOpenFile();
        fp.setChannel(fd);
        fp.setMode(fmode);
        fp.checkTTY();
        if (path2 != null) {
            fp.setPath(path2);
        }
        return io2;
    }

    public static RubyIO newIO(Ruby runtime, Channel channel) {
        return new RubyIO(runtime, channel);
    }

    public OpenFile getOpenFile() {
        return this.openFile;
    }

    public OpenFile getOpenFileChecked() {
        this.openFile.checkClosed();
        return this.openFile;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.FILE;
    }

    public static RubyClass createIOClass(Ruby runtime) {
        RubyClass ioClass = runtime.defineClass("IO", runtime.getObject(), IO_ALLOCATOR);
        ioClass.setClassIndex(ClassIndex.IO);
        ioClass.setReifiedClass(RubyIO.class);
        ioClass.kindOf = new RubyModule.JavaClassKindOf(RubyIO.class);
        ioClass.includeModule(runtime.getEnumerable());
        ioClass.defineAnnotatedMethods(RubyIO.class);
        ioClass.setConstant("SEEK_SET", runtime.newFixnum(0));
        ioClass.setConstant("SEEK_CUR", runtime.newFixnum(1));
        ioClass.setConstant("SEEK_END", runtime.newFixnum(2));
        ioClass.defineModuleUnder("WaitReadable");
        ioClass.defineModuleUnder("WaitWritable");
        return ioClass;
    }

    public OutputStream getOutStream() {
        return new OutputStream(){
            final Ruby runtime;
            {
                this.runtime = RubyIO.this.getRuntime();
            }

            @Override
            public void write(int b2) throws IOException {
                RubyIO.this.putc(this.runtime.getCurrentContext(), this.runtime.newFixnum(b2));
            }

            @Override
            public void write(byte[] b2) throws IOException {
                RubyIO.this.write(this.runtime.getCurrentContext(), RubyString.newStringNoCopy(this.runtime, b2));
            }

            @Override
            public void write(byte[] b2, int off, int len) throws IOException {
                RubyIO.this.write(this.runtime.getCurrentContext(), RubyString.newStringNoCopy(this.runtime, b2, off, len));
            }

            @Override
            public void flush() throws IOException {
                RubyIO.this.flush(this.runtime.getCurrentContext());
            }

            @Override
            public void close() throws IOException {
                RubyIO.this.close();
            }
        };
    }

    public InputStream getInStream() {
        return new InputStream(){
            final Ruby runtime;
            {
                this.runtime = RubyIO.this.getRuntime();
            }

            @Override
            public int read() throws IOException {
                return RubyIO.this.getByte(this.runtime.getCurrentContext());
            }

            @Override
            public int read(byte[] b2) throws IOException {
                return this.read(b2, 0, b2.length);
            }

            @Override
            public int read(byte[] b2, int off, int len) throws IOException {
                RubyFixnum c = this.runtime.newFixnum(len);
                RubyString s2 = RubyString.newStringNoCopy(this.runtime, b2, off, len);
                IRubyObject i2 = RubyIO.this.read(this.runtime.getCurrentContext(), c, s2);
                if (i2.isNil()) {
                    return -1;
                }
                return s2.size();
            }

            @Override
            public long skip(long n) throws IOException {
                return RubyIO.this.seek(this.runtime.getCurrentContext(), this.runtime.newFixnum(1), this.runtime.newFixnum(n)).getLongValue();
            }

            @Override
            public int available() throws IOException {
                if (RubyIO.this instanceof RubyFile) {
                    long size2 = ((RubyFixnum)((RubyFile)RubyIO.this).size(this.runtime.getCurrentContext())).getLongValue();
                    if (size2 == 0L) {
                        return 0;
                    }
                    if (size2 >= 0L) {
                        return (int)(size2 - RubyIO.this.pos(this.runtime.getCurrentContext()).getLongValue());
                    }
                }
                return 0;
            }

            @Override
            public void close() throws IOException {
                RubyIO.this.close();
            }
        };
    }

    public Channel getChannel() {
        return this.openFile.channel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RubyIO reopenIO(ThreadContext context, RubyIO nfile) {
        OpenFile orig;
        Ruby runtime = context.runtime;
        long pos2 = 0L;
        nfile = TypeConverter.ioGetIO(runtime, nfile);
        OpenFile fptr = this.getOpenFileChecked();
        if (fptr == (orig = nfile.getOpenFileChecked())) {
            return this;
        }
        if (fptr.IS_PREP_STDIO() && (fptr.stdio_file == System.in && !orig.isReadable() || fptr.stdio_file == System.out && !orig.isWritable() || fptr.stdio_file == System.err && !orig.isWritable())) {
            throw runtime.newArgumentError(fptr.PREP_STDIO_NAME() + " can't change access mode from \"" + fptr.getModeAsString(runtime) + "\" to \"" + orig.getModeAsString(runtime) + "\"");
        }
        boolean locked = fptr.lock();
        try {
            if (fptr.isWritable()) {
                if (fptr.io_fflush(context) < 0) {
                    throw runtime.newErrnoFromErrno(fptr.errno(), fptr.getPath());
                }
            } else {
                fptr.tell(context);
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        locked = orig.lock();
        try {
            if (orig.isReadable()) {
                pos2 = orig.tell(context);
            }
            if (orig.isWritable() && orig.io_fflush(context) < 0) {
                throw runtime.newErrnoFromErrno(orig.errno(), fptr.getPath());
            }
        }
        finally {
            if (locked) {
                orig.unlock();
            }
        }
        locked = fptr.lock();
        boolean locked2 = orig.lock();
        try {
            fptr.setMode(orig.getMode() | fptr.getMode() & 0x10008);
            fptr.setProcess(orig.getProcess());
            fptr.setLineNumber(orig.getLineNumber());
            if (orig.getPath() != null) {
                fptr.setPath(orig.getPath());
            } else if (!fptr.IS_PREP_STDIO()) {
                fptr.setPath(null);
            }
            fptr.setFinalizer(orig.getFinalizer());
            ChannelFD fd = fptr.fd();
            ChannelFD fd2 = orig.fd();
            if (fd != fd2) {
                if (fptr.IS_PREP_STDIO() || fd.bestFileno() <= 2 || fptr.stdio_file == null) {
                    this.checkReopenCloexecDup2(runtime, orig, fd2, fd);
                    fptr.setFD(fd);
                } else {
                    if (fptr.stdio_file != null) {
                        try {
                            fptr.stdio_file.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    fptr.clearStdio();
                    fptr.setFD(null);
                    this.checkReopenCloexecDup2(runtime, orig, fd2, fd);
                    fptr.setFD(fd);
                }
                if (orig.isReadable() && pos2 >= 0L) {
                    fptr.checkReopenSeek(context, runtime, pos2);
                    orig.checkReopenSeek(context, runtime, pos2);
                }
            }
            if (fptr.isBinmode()) {
                this.setBinmode();
            }
        }
        finally {
            if (locked2) {
                orig.unlock();
            }
            if (locked) {
                fptr.unlock();
            }
        }
        return this;
    }

    private void checkReopenCloexecDup2(Ruby runtime, OpenFile orig, ChannelFD oldfd, ChannelFD newfd) {
        OpenFile.cloexecDup2(new PosixShim(runtime), oldfd, newfd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBinmode() {
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            if (fptr.readconv != null) {
                fptr.readconv.binmode();
            }
            if (fptr.writeconv != null) {
                fptr.writeconv.binmode();
            }
            fptr.setBinmode();
            fptr.clearTextMode();
            fptr.writeconvPreEcflags &= 0xFFFFC0FF;
            if (OpenFlags.O_BINARY.defined()) {
                // empty if block
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"reopen"}, required=1, optional=1)
    public IRubyObject reopen(ThreadContext context, IRubyObject[] args2) {
        IRubyObject tmp;
        Ruby runtime = context.runtime;
        RubyIO file2 = this;
        IRubyObject fname = context.nil;
        IRubyObject nmode = context.nil;
        IRubyObject opt = context.nil;
        int[] oflags_p = new int[]{0};
        switch (args2.length) {
            case 3: {
                opt = TypeConverter.checkHashType(runtime, args2[2]);
                if (opt.isNil()) {
                    throw this.getRuntime().newArgumentError(3, 2);
                }
            }
            case 2: {
                if (opt.isNil()) {
                    opt = TypeConverter.checkHashType(runtime, args2[1]);
                    if (opt.isNil()) {
                        nmode = args2[1];
                        opt = context.nil;
                    }
                } else {
                    nmode = args2[1];
                }
            }
            case 1: {
                fname = args2[0];
            }
        }
        if (args2.length == 1 && !(tmp = TypeConverter.ioCheckIO(runtime, fname)).isNil()) {
            return file2.reopenIO(context, (RubyIO)tmp);
        }
        fname = StringSupport.checkEmbeddedNulls(runtime, RubyFile.get_path(context, fname));
        OpenFile fptr = file2.openFile;
        if (fptr == null) {
            fptr = file2.openFile = this.MakeOpenFile();
        }
        boolean locked = fptr.lock();
        try {
            IOEncodable convconfig;
            if (!nmode.isNil() || !opt.isNil()) {
                convconfig = new IOEncodable.ConvConfig();
                Object vmode_vperm = EncodingUtils.vmodeVperm(nmode, null);
                int[] fmode_p = new int[]{0};
                EncodingUtils.extractModeEncoding(context, convconfig, vmode_vperm, opt, oflags_p, fmode_p);
                if (fptr.IS_PREP_STDIO() && (fptr.getMode() & 3 & (fmode_p[0] & 3)) != (fptr.getMode() & 3)) {
                    throw runtime.newArgumentError(fptr.PREP_STDIO_NAME() + " can't change access mode from \"" + fptr.getModeAsString(runtime) + "\" to \"" + OpenFile.getStringFromMode(fmode_p[0]));
                }
                fptr.setMode(fmode_p[0]);
                fptr.encs = convconfig;
            } else {
                oflags_p[0] = OpenFile.getModeFlagsAsIntFrom(fptr.getMode());
            }
            fptr.setPath(fname.toString());
            if (fptr.fd() == null) {
                fptr.setFD(RubyIO.sysopen(runtime, fptr.getPath(), oflags_p[0], 438));
                fptr.clearStdio();
                convconfig = file2;
                return convconfig;
            }
            if (fptr.isWritable() && fptr.io_fflush(context) < 0) {
                throw runtime.newErrnoFromErrno(fptr.errno(), fptr.getPath());
            }
            fptr.rbuf.len = 0;
            fptr.rbuf.off = 0;
            if (fptr.isStdio()) {
                fptr.setFD(RubyIO.sysopen(runtime, fptr.getPath(), oflags_p[0], 438));
            } else {
                ChannelFD tmpfd = RubyIO.sysopen(runtime, fptr.getPath(), oflags_p[0], 438);
                Errno err = null;
                if (OpenFile.cloexecDup2(fptr.posix, tmpfd, fptr.fd()) < 0) {
                    err = fptr.errno();
                }
                if (err != null) {
                    throw runtime.newErrnoFromErrno(err, fptr.getPath());
                }
                fptr.setFD(tmpfd);
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        return file2;
    }

    public IRubyObject getline(ThreadContext context, IRubyObject separator) {
        return this.getline(context, separator, -1L, null);
    }

    public IRubyObject getline(ThreadContext context, IRubyObject separator, long limit2) {
        return this.getline(context, separator, limit2, null);
    }

    private IRubyObject getline(ThreadContext context, IRubyObject separator, long limit2, ByteListCache cache) {
        return this.getlineInner(context, separator, (int)limit2, cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject getlineInner(ThreadContext context, IRubyObject rs, int _limit, ByteListCache cache) {
        Ruby runtime = context.runtime;
        IRubyObject str = context.nil;
        boolean noLimit = false;
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            Encoding enc;
            fptr.checkCharReadable(context);
            if (rs.isNil() && _limit < 0) {
                str = fptr.readAll(context, 0, context.nil);
                if (((RubyString)str).size() == 0) {
                    IRubyObject iRubyObject = context.nil;
                    return iRubyObject;
                }
            } else {
                if (_limit == 0) {
                    RubyString rubyString = RubyString.newEmptyString(runtime, fptr.readEncoding(runtime));
                    return rubyString;
                }
                if (rs == runtime.getGlobalVariables().getDefaultSeparator() && _limit < 0 && !fptr.needsReadConversion() && (enc = fptr.readEncoding(runtime)).isAsciiCompatible()) {
                    fptr.NEED_NEWLINE_DECORATOR_ON_READ_CHECK();
                    IRubyObject iRubyObject = fptr.getlineFast(context, enc, this);
                    return iRubyObject;
                }
            }
            int newline = -1;
            byte[] rsptrBytes = null;
            int rsptr = 0;
            int rslen = 0;
            boolean rspara = false;
            int extraLimit = 16;
            fptr.SET_BINARY_MODE();
            enc = this.getReadEncoding();
            if (!rs.isNil()) {
                RubyString rsStr = (RubyString)rs;
                ByteList rsByteList = rsStr.getByteList();
                rslen = rsByteList.getRealSize();
                if (rslen == 0) {
                    rsptrBytes = PARAGRAPH_SEPARATOR.unsafeBytes();
                    rsptr = PARAGRAPH_SEPARATOR.getBegin();
                    rslen = 2;
                    rspara = true;
                    fptr.swallow(context, 10);
                    rs = null;
                    if (!enc.isAsciiCompatible()) {
                        rs = RubyString.newUsAsciiStringShared(runtime, rsptrBytes, rsptr, rslen);
                        rs = EncodingUtils.rbStrEncode(context, rs, runtime.getEncodingService().convertEncodingToRubyEncoding(enc), 0, context.nil);
                        rs.setFrozen(true);
                        rsStr = (RubyString)rs;
                        rsByteList = rsStr.getByteList();
                        rsptrBytes = rsByteList.getUnsafeBytes();
                        rsptr = rsByteList.getBegin();
                        rslen = rsByteList.getRealSize();
                    }
                } else {
                    rsptrBytes = rsByteList.unsafeBytes();
                    rsptr = rsByteList.getBegin();
                }
                newline = rsptrBytes[rsptr + rslen - 1] & 0xFF;
            }
            ByteList buf = cache != null ? cache.allocate(0) : new ByteList(0);
            try {
                int c;
                boolean bufferString = str instanceof RubyString;
                ByteList[] strPtr = new ByteList[]{bufferString ? ((RubyString)str).getByteList() : null};
                int[] limit_p = new int[]{_limit};
                while ((c = fptr.appendline(context, newline, strPtr, limit_p)) != -1) {
                    int pp;
                    int p2;
                    int s2;
                    if (c == newline) {
                        if (strPtr[0].getRealSize() < rslen) continue;
                        s2 = strPtr[0].getBegin();
                        int e = s2 + strPtr[0].getRealSize();
                        p2 = e - rslen;
                        pp = enc.leftAdjustCharHead(strPtr[0].getUnsafeBytes(), s2, p2, e);
                        if (pp != p2) continue;
                        if (ByteList.memcmp(strPtr[0].getUnsafeBytes(), p2, rsptrBytes, rsptr, rslen) == 0) break;
                    }
                    if (limit_p[0] != 0) continue;
                    s2 = strPtr[0].getBegin();
                    p2 = s2 + strPtr[0].getRealSize();
                    pp = enc.leftAdjustCharHead(strPtr[0].getUnsafeBytes(), s2, p2 - 1, p2);
                    if (extraLimit != 0 && StringSupport.MBCLEN_NEEDMORE_P(StringSupport.preciseLength(enc, strPtr[0].getUnsafeBytes(), pp, p2))) {
                        limit_p[0] = 1;
                        --extraLimit;
                        continue;
                    }
                    noLimit = true;
                    break;
                }
                _limit = limit_p[0];
                if (strPtr[0] != null) {
                    if (bufferString) {
                        if (strPtr[0] != ((RubyString)str).getByteList()) {
                            ((RubyString)str).setValue(strPtr[0]);
                        }
                    } else {
                        str = runtime.newString(strPtr[0]);
                    }
                }
                if (rspara && c != -1) {
                    fptr.swallow(context, 10);
                }
                if (!str.isNil()) {
                    str = EncodingUtils.ioEncStr(runtime, str, fptr);
                }
            }
            finally {
                if (cache != null) {
                    cache.release(buf);
                }
            }
            if (!str.isNil() && !noLimit) {
                fptr.incrementLineno(runtime);
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        return str;
    }

    @Override
    public Encoding getEnc() {
        return this.openFile.encs.enc;
    }

    public Encoding getReadEncoding() {
        return this.openFile.readEncoding(this.getRuntime());
    }

    @Override
    public Encoding getEnc2() {
        return this.openFile.encs.enc2;
    }

    public Encoding getInputEncoding() {
        return this.openFile.inputEncoding(this.getRuntime());
    }

    public static boolean restartSystemCall(Exception e) {
        return VENDOR.startsWith("Apple") && e.getMessage().equals(msgEINTR);
    }

    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyClass klass = (RubyClass)recv2;
        if (block.isGiven()) {
            String className = klass.getName();
            context.runtime.getWarnings().warn(IRubyWarnings.ID.BLOCK_NOT_ACCEPTED, className + "::new() does not take block; use " + className + "::open() instead");
        }
        return klass.newInstance(context, args2, block);
    }

    @JRubyMethod(rest=true, meta=true)
    public static IRubyObject for_fd(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyClass klass = (RubyClass)recv2;
        return klass.newInstance(context, args2, block);
    }

    private IRubyObject initializeCommon(ThreadContext context, int fileno2, IRubyObject vmodeArg, IRubyObject opt) {
        ChannelFD fd;
        Ruby runtime = context.runtime;
        if (!FilenoUtil.isFake(fileno2)) {
            fd = runtime.getFilenoUtil().getWrapperFromFileno(fileno2);
            if (fd == null) {
                fd = new ChannelFD(new NativeDeviceChannel(fileno2), runtime.getPosix(), runtime.getFilenoUtil());
            }
        } else {
            ChannelFD descriptor = runtime.getFilenoUtil().getWrapperFromFileno(fileno2);
            if (descriptor == null) {
                throw runtime.newErrnoEBADFError();
            }
            fd = descriptor;
        }
        if (!fd.ch.isOpen()) {
            throw runtime.newErrnoEBADFError();
        }
        return this.initializeCommon(context, fd, vmodeArg, opt);
    }

    private IRubyObject initializeCommon(ThreadContext context, ChannelFD fd, IRubyObject vmodeArg, IRubyObject opt) {
        Ruby runtime = context.runtime;
        int[] oflags_p = new int[]{ModeFlags.RDONLY};
        if (!(opt == null || opt.isNil() || opt instanceof RubyHash || opt.respondsTo("to_hash"))) {
            throw runtime.newArgumentError("last argument must be a hash!");
        }
        if (opt != null && !opt.isNil()) {
            opt = opt.convertToHash();
        }
        if (!fd.ch.isOpen()) {
            throw runtime.newErrnoEBADFError();
        }
        Object pm = EncodingUtils.vmodeVperm(vmodeArg, runtime.newFixnum(0));
        int[] fmode_p = new int[]{0};
        IOEncodable.ConvConfig convconfig = new IOEncodable.ConvConfig();
        EncodingUtils.extractModeEncoding(context, convconfig, pm, opt, oflags_p, fmode_p);
        oflags_p[0] = ModeFlags.oflagsFrom(runtime.getPosix(), fd.ch);
        int ofmode = ModeFlags.getOpenFileFlagsFor(oflags_p[0]);
        if (EncodingUtils.vmode(pm) == null || EncodingUtils.vmode(pm).isNil()) {
            fmode_p[0] = ofmode;
        } else if ((~ofmode & fmode_p[0] & 3) != 0) {
            throw runtime.newErrnoEINVALError();
        }
        if (opt != null && !opt.isNil() && ((RubyHash)opt).op_aref(context, runtime.newSymbol("autoclose")) == runtime.getFalse()) {
            fmode_p[0] = fmode_p[0] | 0x10000;
        }
        this.MakeOpenFile();
        this.openFile.setFD(fd);
        this.openFile.setMode(fmode_p[0]);
        this.openFile.encs = convconfig;
        this.openFile.clearCodeConversion();
        this.openFile.checkTTY();
        switch (fd.bestFileno()) {
            case 0: {
                this.openFile.stdio_file = System.in;
                break;
            }
            case 1: {
                this.openFile.stdio_file = System.out;
                break;
            }
            case 2: {
                this.openFile.stdio_file = System.err;
            }
        }
        if (this.openFile.isBOM()) {
            EncodingUtils.ioSetEncodingByBOM(context, this);
        }
        return this;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject fileNumber, Block unused2) {
        return this.initializeCommon(context, RubyNumeric.fix2int(fileNumber), null, context.nil);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject fileNumber, IRubyObject second, Block unused2) {
        IRubyObject options2;
        int fileno2 = RubyNumeric.fix2int(fileNumber);
        IRubyObject vmode = null;
        IRubyObject hashTest = TypeConverter.checkHashType(context.runtime, second);
        if (hashTest instanceof RubyHash) {
            options2 = hashTest;
        } else {
            options2 = context.nil;
            vmode = second;
        }
        return this.initializeCommon(context, fileno2, vmode, options2);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject fileNumber, IRubyObject modeValue, IRubyObject options2, Block unused2) {
        int fileno2 = RubyNumeric.fix2int(fileNumber);
        return this.initializeCommon(context, fileno2, modeValue, options2);
    }

    protected IOOptions parseIOOptions(IRubyObject arg2) {
        Ruby runtime = this.getRuntime();
        if (arg2 instanceof RubyFixnum) {
            return RubyIO.newIOOptions(runtime, (int)RubyFixnum.fix2long(arg2));
        }
        String modeString = arg2.convertToString().toString();
        try {
            return new IOOptions(runtime, modeString);
        }
        catch (InvalidValueException ive) {
            throw runtime.newArgumentError("invalid access mode " + modeString);
        }
    }

    @JRubyMethod
    public IRubyObject external_encoding(ThreadContext context) {
        EncodingService encodingService = context.runtime.getEncodingService();
        if (this.openFile.encs.enc2 != null) {
            return encodingService.getEncoding(this.openFile.encs.enc2);
        }
        if (this.openFile.isWritable()) {
            return this.openFile.encs.enc == null ? context.runtime.getNil() : encodingService.getEncoding(this.openFile.encs.enc);
        }
        return encodingService.getEncoding(this.getReadEncoding());
    }

    @JRubyMethod
    public IRubyObject internal_encoding(ThreadContext context) {
        if (this.openFile.encs.enc2 == null) {
            return context.nil;
        }
        return context.runtime.getEncodingService().getEncoding(this.getReadEncoding());
    }

    @JRubyMethod
    public IRubyObject set_encoding(ThreadContext context, IRubyObject encodingObj) {
        this.setEncoding(context, encodingObj, context.nil, context.nil);
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject set_encoding(ThreadContext context, IRubyObject encodingString, IRubyObject internalEncoding) {
        IRubyObject opt = TypeConverter.checkHashType(context.runtime, internalEncoding);
        if (!opt.isNil()) {
            this.setEncoding(context, encodingString, context.nil, opt);
        } else {
            this.setEncoding(context, encodingString, internalEncoding, context.nil);
        }
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject set_encoding(ThreadContext context, IRubyObject encodingString, IRubyObject internalEncoding, IRubyObject options2) {
        this.setEncoding(context, encodingString, internalEncoding, options2);
        return context.nil;
    }

    public void setEncoding(ThreadContext context, IRubyObject v1, IRubyObject v2, IRubyObject opt) {
        IOEncodable.ConvConfig holder = new IOEncodable.ConvConfig();
        int ecflags = this.openFile.encs.ecflags;
        IRubyObject[] ecopts_p = new IRubyObject[]{context.nil};
        if (!v2.isNil()) {
            holder.enc2 = EncodingUtils.rbToEncoding(context, v1);
            IRubyObject tmp = v2.checkStringType19();
            if (!tmp.isNil()) {
                RubyString internalAsString = (RubyString)tmp;
                if (internalAsString.size() == 1 && internalAsString.asJavaString().equals("-")) {
                    holder.enc = holder.enc2;
                    holder.enc2 = null;
                } else {
                    holder.enc = EncodingUtils.rbToEncoding(context, internalAsString);
                }
                if (holder.enc == holder.enc2) {
                    holder.enc2 = null;
                }
            } else {
                holder.enc = EncodingUtils.rbToEncoding(context, v2);
                if (holder.enc == holder.enc2) {
                    holder.enc2 = null;
                }
            }
            EncodingUtils.SET_UNIVERSAL_NEWLINE_DECORATOR_IF_ENC2(holder.getEnc2(), ecflags);
            ecflags = EncodingUtils.econvPrepareOptions(context, opt, ecopts_p, ecflags);
        } else if (v1.isNil()) {
            EncodingUtils.ioExtIntToEncs(context, holder, null, null, 0);
            EncodingUtils.SET_UNIVERSAL_NEWLINE_DECORATOR_IF_ENC2(holder.getEnc2(), ecflags);
            ecopts_p[0] = context.nil;
        } else {
            IRubyObject tmp = v1.checkStringType19();
            if (!tmp.isNil() && EncodingUtils.encAsciicompat(EncodingUtils.encGet(context, tmp))) {
                EncodingUtils.parseModeEncoding(context, holder, tmp.asJavaString(), null);
                EncodingUtils.SET_UNIVERSAL_NEWLINE_DECORATOR_IF_ENC2(holder.getEnc2(), ecflags);
                ecflags = EncodingUtils.econvPrepareOptions(context, opt, ecopts_p, ecflags);
            } else {
                EncodingUtils.ioExtIntToEncs(context, holder, EncodingUtils.rbToEncoding(context, v1), null, 0);
                EncodingUtils.SET_UNIVERSAL_NEWLINE_DECORATOR_IF_ENC2(holder.getEnc2(), ecflags);
            }
        }
        int[] fmode_p = new int[]{this.openFile.getMode()};
        EncodingUtils.validateEncodingBinmode(context, fmode_p, ecflags, holder);
        this.openFile.setMode(fmode_p[0]);
        this.openFile.encs.enc = holder.enc;
        this.openFile.encs.enc2 = holder.enc2;
        this.openFile.encs.ecflags = ecflags;
        this.openFile.encs.ecopts = ecopts_p[0];
        this.openFile.clearCodeConversion();
    }

    @JRubyMethod(required=1, rest=true, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject io2 = ((RubyClass)recv2).newInstance(context, args2, Block.NULL_BLOCK);
        return RubyIO.ensureYieldClose(context, io2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject ensureYieldClose(ThreadContext context, IRubyObject port, Block block) {
        if (block.isGiven()) {
            Ruby runtime = context.runtime;
            try {
                IRubyObject iRubyObject = block.yield(context, port);
                return iRubyObject;
            }
            finally {
                RubyIO.ioClose(runtime, port);
            }
        }
        return port;
    }

    public static IRubyObject sysopen(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyIO.sysopen19(recv2.getRuntime().getCurrentContext(), recv2, args2, block);
    }

    @JRubyMethod(name={"sysopen"}, required=1, optional=2, meta=true)
    public static IRubyObject sysopen19(ThreadContext context, IRubyObject recv2, IRubyObject[] argv, Block block) {
        int oflags;
        IRubyObject vperm;
        Ruby runtime = context.runtime;
        IRubyObject vmode = vperm = context.nil;
        IRubyObject fname = vperm;
        switch (argv.length) {
            case 3: {
                vperm = argv[2];
            }
            case 2: {
                vmode = argv[1];
            }
            case 1: {
                fname = argv[0];
            }
        }
        fname = StringSupport.checkEmbeddedNulls(runtime, RubyFile.get_path(context, fname));
        if (vmode.isNil()) {
            oflags = OpenFlags.O_RDONLY.intValue();
        } else {
            IRubyObject intmode = TypeConverter.checkIntegerType(runtime, vmode, "to_int");
            if (!intmode.isNil()) {
                oflags = RubyNumeric.num2int(intmode);
            } else {
                vmode = vmode.convertToString();
                oflags = OpenFile.ioModestrOflags(runtime, vmode.toString());
            }
        }
        int perm = vperm.isNil() ? 438 : RubyNumeric.num2int(vperm);
        StringSupport.checkStringSafety(context.runtime, fname);
        fname = ((RubyString)fname).dupFrozen();
        ChannelFD fd = RubyIO.sysopen(runtime, fname.toString(), oflags, perm);
        return runtime.newFixnum(fd.bestFileno());
    }

    protected static ChannelFD sysopen(Ruby runtime, String fname, int oflags, int perm) {
        Sysopen data2 = new Sysopen();
        data2.fname = fname;
        data2.oflags = oflags;
        data2.perm = perm;
        ChannelFD fd = RubyIO.sysopenInternal(runtime, data2);
        if (fd == null) {
            if (data2.errno == Errno.EMFILE || data2.errno == Errno.ENFILE) {
                System.gc();
                data2.errno = null;
                fd = RubyIO.sysopenInternal(runtime, data2);
            }
            if (fd == null) {
                if (data2.errno != null) {
                    throw runtime.newErrnoFromErrno(data2.errno, fname.toString());
                }
                throw runtime.newSystemCallError(fname.toString());
            }
        }
        return fd;
    }

    private static ChannelFD sysopenInternal(Ruby runtime, Sysopen data2) {
        ChannelFD fd = RubyIO.sysopenFunc(runtime, data2);
        return fd;
    }

    private static ChannelFD sysopenFunc(Ruby runtime, Sysopen data2) {
        return RubyIO.cloexecOpen(runtime, data2);
    }

    private static ChannelFD cloexecOpen(Ruby runtime, Sysopen data2) {
        Channel ret = null;
        PosixShim shim = new PosixShim(runtime);
        ret = shim.open(runtime.getCurrentDirectory(), data2.fname, ModeFlags.createModeFlags(data2.oflags), data2.perm);
        if (ret == null) {
            data2.errno = shim.errno;
            return null;
        }
        return new ChannelFD(ret, runtime.getPosix(), runtime.getFilenoUtil());
    }

    public boolean isAutoclose() {
        OpenFile fptr = this.getOpenFileChecked();
        return fptr.isAutoclose();
    }

    public void setAutoclose(boolean autoclose2) {
        OpenFile fptr = this.getOpenFileChecked();
        fptr.setAutoclose(autoclose2);
    }

    @JRubyMethod(name={"autoclose?"})
    public IRubyObject autoclose(ThreadContext context) {
        return context.runtime.newBoolean(this.isAutoclose());
    }

    @JRubyMethod(name={"autoclose="})
    public IRubyObject autoclose_set(ThreadContext context, IRubyObject autoclose2) {
        this.setAutoclose(autoclose2.isTrue());
        return context.nil;
    }

    @JRubyMethod(name={"binmode"})
    public IRubyObject binmode() {
        this.setAscii8bitBinmode();
        RubyIO write_io = this.GetWriteIO();
        if (write_io != this) {
            write_io.setAscii8bitBinmode();
        }
        return this;
    }

    @JRubyMethod(name={"binmode?"})
    public IRubyObject op_binmode(ThreadContext context) {
        return RubyBoolean.newBoolean(context.runtime, this.getOpenFileChecked().isBinmode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"syswrite"}, required=1)
    public IRubyObject syswrite(ThreadContext context, IRubyObject str) {
        long n;
        Ruby runtime = context.runtime;
        if (!(str instanceof RubyString)) {
            str = str.asString();
        }
        RubyIO io2 = this.GetWriteIO();
        OpenFile fptr = io2.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            fptr.checkWritable(context);
            str.setFrozen(true);
            if (fptr.wbuf.len != 0) {
                runtime.getWarnings().warn("syswrite for buffered IO");
            }
            ByteList strByteList = ((RubyString)str).getByteList();
            n = OpenFile.writeInternal(context, fptr, fptr.fd(), strByteList.unsafeBytes(), strByteList.begin(), strByteList.getRealSize());
            if (n == -1L) {
                throw runtime.newErrnoFromErrno(fptr.errno(), fptr.getPath());
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        return runtime.newFixnum(n);
    }

    @JRubyMethod(name={"write_nonblock"}, required=1, optional=1)
    public IRubyObject write_nonblock(ThreadContext context, IRubyObject[] argv) {
        Ruby runtime = context.runtime;
        IRubyObject opts = context.nil;
        boolean no_exceptions = false;
        int argc = Arity.checkArgumentCount(context, argv, 1, 2);
        if (argc == 2) {
            opts = argv[1].convertToHash();
        }
        IRubyObject str = argv[0];
        if (!opts.isNil() && runtime.getFalse() == ((RubyHash)opts).op_aref(context, runtime.newSymbol("exception"))) {
            no_exceptions = true;
        }
        return this.ioWriteNonblock(context, runtime, str, no_exceptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject ioWriteNonblock(ThreadContext context, Ruby runtime, IRubyObject str, boolean no_exception) {
        long n;
        if (!(str instanceof RubyString)) {
            str = str.asString();
        }
        RubyIO io2 = this.GetWriteIO();
        OpenFile fptr = io2.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            fptr.checkWritable(context);
            if (fptr.io_fflush(context) < 0) {
                throw runtime.newErrnoFromErrno(fptr.errno(), fptr.getPath());
            }
            fptr.setNonblock(runtime);
            ByteList strByteList = ((RubyString)str).getByteList();
            n = fptr.posix.write(fptr.fd(), strByteList.unsafeBytes(), strByteList.begin(), strByteList.getRealSize(), true);
            if (n == -1L) {
                if (fptr.posix.errno == Errno.EWOULDBLOCK || fptr.posix.errno == Errno.EAGAIN) {
                    if (no_exception) {
                        RubySymbol rubySymbol = runtime.newSymbol("wait_writable");
                        return rubySymbol;
                    }
                    throw runtime.newErrnoEAGAINWritableError("write would block");
                }
                throw runtime.newErrnoFromErrno(fptr.posix.errno, fptr.getPath());
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        return runtime.newFixnum(n);
    }

    public RubyIO GetWriteIO() {
        this.checkInitialized();
        RubyIO writeIO = this.openFile.tiedIOForWriting;
        if (writeIO != null) {
            return writeIO;
        }
        return this;
    }

    private void checkInitialized() {
        if (this.openFile == null) {
            throw this.getRuntime().newIOError("uninitialized stream");
        }
    }

    @JRubyMethod(name={"write"}, required=1)
    public IRubyObject write(ThreadContext context, IRubyObject str) {
        return this.write(context, str, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject write(ThreadContext context, IRubyObject str, boolean nosync) {
        long n;
        Ruby runtime = context.runtime;
        RubyIO io2 = this.GetWriteIO();
        str = str.asString();
        IRubyObject tmp = TypeConverter.ioCheckIO(runtime, io2);
        if (tmp.isNil()) {
            return io2.callMethod(context, "write", str);
        }
        io2 = (RubyIO)tmp;
        if (((RubyString)str).size() == 0) {
            return RubyFixnum.zero(runtime);
        }
        OpenFile fptr = io2.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            fptr = io2.getOpenFileChecked();
            fptr.checkWritable(context);
            n = fptr.fwrite(context, str, nosync);
            if (n == -1L) {
                throw runtime.newErrnoFromErrno(fptr.errno(), fptr.getPath());
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        return RubyFixnum.newFixnum(runtime, n);
    }

    @JRubyMethod(name={"<<"}, required=1)
    public IRubyObject op_append(ThreadContext context, IRubyObject anObject) {
        this.callMethod(context, "write", anObject);
        return this;
    }

    @JRubyMethod(name={"fileno"}, alias={"to_i"})
    public RubyFixnum fileno(ThreadContext context) {
        return context.runtime.newFixnum(this.getOpenFileChecked().getFileno());
    }

    @JRubyMethod(name={"lineno"})
    public RubyFixnum lineno(ThreadContext context) {
        return context.runtime.newFixnum(this.getOpenFileChecked().getLineNumber());
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public RubyFixnum lineno_set(ThreadContext context, IRubyObject newLineNumber) {
        this.getOpenFileChecked().setLineNumber(RubyNumeric.fix2int(newLineNumber));
        return context.runtime.newFixnum(this.getOpenFileChecked().getLineNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public RubyBoolean sync(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyIO io2 = this.GetWriteIO();
        OpenFile fptr = io2.getOpenFileChecked();
        fptr.lock();
        try {
            RubyBoolean rubyBoolean = (fptr.getMode() & 8) != 0 ? runtime.getTrue() : runtime.getFalse();
            return rubyBoolean;
        }
        finally {
            fptr.unlock();
        }
    }

    @JRubyMethod
    public IRubyObject pid(ThreadContext context) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (myOpenFile.getProcess() == null) {
            return context.runtime.getNil();
        }
        long pid2 = myOpenFile.getPid();
        return context.runtime.newFixnum(pid2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"pos", "tell"})
    public RubyFixnum pos(ThreadContext context) {
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            long pos2 = fptr.tell(context);
            if (pos2 < 0L && fptr.errno() != null) {
                throw context.runtime.newErrnoFromErrno(fptr.errno(), fptr.getPath());
            }
            RubyFixnum rubyFixnum = context.runtime.newFixnum(pos2 -= (long)fptr.rbuf.len);
            return rubyFixnum;
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"pos="}, required=1)
    public RubyFixnum pos_set(ThreadContext context, IRubyObject offset2) {
        long pos2 = offset2.convertToInteger().getLongValue();
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            pos2 = fptr.seek(context, pos2, 0);
            if (pos2 < 0L && fptr.errno() != null) {
                throw context.runtime.newErrnoFromErrno(fptr.errno(), fptr.getPath());
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        return context.runtime.newFixnum(pos2);
    }

    @JRubyMethod(rest=true, reads={FrameField.LASTLINE})
    public IRubyObject print(ThreadContext context, IRubyObject[] args2) {
        return RubyIO.print(context, this, args2);
    }

    public static IRubyObject print(ThreadContext context, IRubyObject out, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        int argc = args2.length;
        if (argc == 0) {
            argc = 1;
            IRubyObject line = context.getLastLine();
            args2 = new IRubyObject[]{line};
        }
        for (int i2 = 0; i2 < argc; ++i2) {
            IRubyObject outputFS = runtime.getGlobalVariables().get("$,");
            if (!outputFS.isNil() && i2 > 0) {
                RubyIO.write(context, out, outputFS);
            }
            RubyIO.write(context, out, args2[i2]);
        }
        IRubyObject outputRS = runtime.getGlobalVariables().get("$\\");
        if (argc > 0 && !outputRS.isNil()) {
            RubyIO.write(context, out, outputRS);
        }
        return context.nil;
    }

    @JRubyMethod(required=1, rest=true)
    public IRubyObject printf(ThreadContext context, IRubyObject[] args2) {
        RubyIO.write(context, (IRubyObject)this, RubyKernel.sprintf(context, this, args2));
        return context.nil;
    }

    @JRubyMethod(required=1)
    public IRubyObject putc(ThreadContext context, IRubyObject ch) {
        Ruby runtime = context.runtime;
        IRubyObject str = ch instanceof RubyString ? ((RubyString)ch).substr(runtime, 0, 1) : RubyString.newStringShared(runtime, RubyFixnum.SINGLE_CHAR_BYTELISTS19[RubyNumeric.num2chr(ch) & 0xFF]);
        this.write(context, str);
        return ch;
    }

    public static IRubyObject putc(ThreadContext context, IRubyObject maybeIO, IRubyObject object) {
        if (maybeIO instanceof RubyIO) {
            ((RubyIO)maybeIO).putc(context, object);
        } else {
            byte c = RubyNumeric.num2chr(object);
            RubyString str = RubyString.newStringShared(context.runtime, RubyFixnum.SINGLE_CHAR_BYTELISTS19[c & 0xFF]);
            maybeIO.callMethod(context, "write", str);
        }
        return object;
    }

    public RubyFixnum seek(ThreadContext context, IRubyObject[] args2) {
        int whence = 0;
        if (args2.length > 1) {
            whence = RubyIO.interpretSeekWhence(args2[1]);
        }
        return this.doSeek(context, args2[0], whence);
    }

    @JRubyMethod
    public RubyFixnum seek(ThreadContext context, IRubyObject arg0) {
        int whence = 0;
        return this.doSeek(context, arg0, whence);
    }

    @JRubyMethod
    public RubyFixnum seek(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int whence = RubyIO.interpretSeekWhence(arg1);
        return this.doSeek(context, arg0, whence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyFixnum doSeek(ThreadContext context, IRubyObject offset2, int whence) {
        long pos2 = RubyNumeric.num2long(offset2);
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            pos2 = fptr.seek(context, pos2, whence);
            if (pos2 < 0L && fptr.errno() != null) {
                throw this.getRuntime().newErrnoFromErrno(fptr.errno(), fptr.getPath());
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        return RubyFixnum.zero(context.runtime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(required=1, optional=1)
    public RubyFixnum sysseek(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        IRubyObject offset2 = context.nil;
        IRubyObject ptrname = context.nil;
        int whence = 0;
        switch (args2.length) {
            case 2: {
                ptrname = args2[1];
                whence = RubyIO.interpretSeekWhence(ptrname);
            }
            case 1: {
                offset2 = args2[0];
            }
        }
        long pos2 = offset2.convertToInteger().getLongValue();
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            if (fptr.isReadable() && (fptr.READ_DATA_BUFFERED() || fptr.READ_CHAR_PENDING())) {
                throw runtime.newIOError("sysseek for buffered IO");
            }
            if (fptr.isWritable() && fptr.wbuf.len != 0) {
                runtime.getWarnings().warn("sysseek for buffered IO");
            }
            fptr.errno(null);
            pos2 = fptr.posix.lseek(fptr.fd(), pos2, whence);
            if (pos2 == -1L && fptr.errno() != null) {
                throw runtime.newErrnoFromErrno(fptr.errno(), fptr.getPath());
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        return RubyFixnum.newFixnum(runtime, pos2);
    }

    private static int interpretSeekWhence(IRubyObject vwhence) {
        if (vwhence instanceof RubySymbol) {
            if (vwhence.toString() == "SET") {
                return 0;
            }
            if (vwhence.toString() == "CUR") {
                return 1;
            }
            if (vwhence.toString() == "END") {
                return 2;
            }
        }
        return (int)vwhence.convertToInteger().getLongValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public RubyFixnum rewind(ThreadContext context) {
        Ruby runtime = context.runtime;
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            if (fptr.seek(context, 0L, 0) < 0L && fptr.errno() != null) {
                throw context.runtime.newErrnoFromErrno(fptr.errno(), fptr.getPath());
            }
            RubyArgsFile.ArgsFileData data2 = RubyArgsFile.ArgsFileData.getDataFrom(runtime.getArgsFile());
            if (this == data2.currentFile) {
                data2.currentLineNumber -= fptr.getLineNumber();
            }
            fptr.setLineNumber(0);
            if (fptr.readconv != null) {
                fptr.clearReadConversion();
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        return RubyFixnum.zero(runtime);
    }

    @JRubyMethod
    public RubyFixnum fsync(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyIO io2 = this.GetWriteIO();
        OpenFile fptr = io2.getOpenFileChecked();
        if (fptr.io_fflush(context) < 0) {
            throw runtime.newSystemCallError("");
        }
        return RubyFixnum.zero(runtime);
    }

    @JRubyMethod(name={"sync="}, required=1)
    public IRubyObject sync_set(IRubyObject sync2) {
        this.setSync(sync2.isTrue());
        return sync2;
    }

    public void setSync(boolean sync2) {
        RubyIO io2 = this.GetWriteIO();
        OpenFile fptr = io2.getOpenFileChecked();
        fptr.setSync(sync2);
    }

    public boolean getSync() {
        RubyIO io2 = this.GetWriteIO();
        OpenFile fptr = io2.getOpenFileChecked();
        return fptr.isSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"eof?", "eof"})
    public RubyBoolean eof_p(ThreadContext context) {
        Ruby runtime = context.runtime;
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            fptr.checkCharReadable(context);
            if (fptr.READ_CHAR_PENDING()) {
                RubyBoolean rubyBoolean = runtime.getFalse();
                return rubyBoolean;
            }
            if (fptr.READ_DATA_PENDING()) {
                RubyBoolean rubyBoolean = runtime.getFalse();
                return rubyBoolean;
            }
            fptr.READ_CHECK(context);
            if (fptr.fillbuf(context) < 0) {
                RubyBoolean rubyBoolean = runtime.getTrue();
                return rubyBoolean;
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        return runtime.getFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"tty?", "isatty"})
    public RubyBoolean tty_p(ThreadContext context) {
        Ruby runtime = context.runtime;
        POSIX posix = runtime.getPosix();
        OpenFile fptr = this.getOpenFileChecked();
        fptr.lock();
        try {
            if (posix.isNative() && fptr.fd().realFileno != -1) {
                RubyBoolean rubyBoolean = posix.libc().isatty(fptr.getFileno()) == 0 ? runtime.getFalse() : runtime.getTrue();
                return rubyBoolean;
            }
            if (fptr.isStdio()) {
                RubyBoolean rubyBoolean = runtime.getTrue();
                return rubyBoolean;
            }
        }
        finally {
            fptr.unlock();
        }
        return runtime.getFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject _io) {
        RubyIO write_io;
        RubyIO dest = this;
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        RubyIO io2 = TypeConverter.ioGetIO(runtime, _io);
        if (!RubyIO.OBJ_INIT_COPY(dest, io2)) {
            return dest;
        }
        OpenFile orig = io2.getOpenFileChecked();
        OpenFile fptr = dest.MakeOpenFile();
        boolean locked1 = orig.lock();
        boolean locked2 = fptr.lock();
        try {
            io2.flush(context);
            fptr.setMode(orig.getMode() & 0xFFFEFFFF);
            fptr.encs = orig.encs;
            fptr.setProcess(orig.getProcess());
            fptr.setLineNumber(orig.getLineNumber());
            if (orig.getPath() != null) {
                fptr.setPath(orig.getPath());
            }
            fptr.setFinalizer(orig.getFinalizer());
            ChannelFD fd = orig.fd().dup();
            fptr.setFD(fd);
            long pos2 = orig.tell(context);
            if (0L <= pos2) {
                fptr.seek(context, pos2, 0);
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
            if (locked1) {
                orig.unlock();
            }
        }
        if (fptr.isBinmode()) {
            dest.setBinmode();
        }
        if (io2 != (write_io = io2.GetWriteIO())) {
            fptr.tiedIOForWriting = write_io = (RubyIO)write_io.dup();
            dest.getInstanceVariables().setInstanceVariable("@tied_io_for_writing", write_io);
        }
        return dest;
    }

    @JRubyMethod(name={"closed?"})
    public RubyBoolean closed_p(ThreadContext context) {
        return context.runtime.newBoolean(this.isClosed());
    }

    public boolean isClosed() {
        OpenFile write_fptr;
        RubyIO write_io = this.GetWriteIO();
        if (this != write_io && (write_fptr = write_io.openFile) != null && write_fptr.fd() != null) {
            return false;
        }
        OpenFile fptr = this.openFile;
        this.checkInitialized();
        return fptr.fd() == null;
    }

    @JRubyMethod
    public IRubyObject close() {
        Ruby runtime = this.getRuntime();
        this.openFile.checkClosed();
        return this.rbIoClose(runtime);
    }

    protected static IRubyObject ioClose(Ruby runtime, IRubyObject io2) {
        ThreadContext context = runtime.getCurrentContext();
        IRubyObject closed = io2.checkCallMethod(context, "closed?");
        if (closed != null && closed.isTrue()) {
            return io2;
        }
        IRubyObject oldExc = runtime.getGlobalVariables().get("$!");
        try {
            return io2.checkCallMethod(context, "close");
        }
        catch (RaiseException re) {
            if (re.getMessage().contains(CLOSED_STREAM_MSG)) {
                runtime.getGlobalVariables().set("$!", oldExc);
                return context.nil;
            }
            throw re;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject rbIoClose(Ruby runtime) {
        boolean locked;
        ThreadContext context = runtime.getCurrentContext();
        RubyIO write_io = this.GetWriteIO();
        if (this != write_io) {
            OpenFile write_fptr = write_io.openFile;
            locked = write_fptr.lock();
            try {
                if (write_fptr != null && write_fptr.fd() != null) {
                    write_fptr.cleanup(runtime, true);
                }
            }
            finally {
                if (locked) {
                    write_fptr.unlock();
                }
            }
        }
        OpenFile fptr = this.openFile;
        locked = fptr.lock();
        try {
            if (fptr == null) {
                IRubyObject iRubyObject = runtime.getNil();
                return iRubyObject;
            }
            if (fptr.fd() == null) {
                IRubyObject iRubyObject = runtime.getNil();
                return iRubyObject;
            }
            fptr.interruptBlockingThreads();
            fptr.cleanup(runtime, false);
            if (fptr.getProcess() != null) {
                context.setLastExitStatus(context.nil);
                if (runtime.getPosix().isNative() && fptr.getProcess() instanceof POSIXProcess) {
                    RubyProcess.RubyStatus processResult = RubyProcess.RubyStatus.newProcessStatus(runtime, ((POSIXProcess)fptr.getProcess()).status(), fptr.getPid());
                    context.setLastExitStatus(processResult);
                } else if (!this.popenSpecial) {
                    RubyIO.obliterateProcess(fptr.getProcess());
                    RubyProcess.RubyStatus processResult = RubyProcess.RubyStatus.newProcessStatus(runtime, fptr.getProcess().exitValue() << 8, fptr.getPid());
                    context.setLastExitStatus(processResult);
                }
                fptr.setProcess(null);
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        return runtime.getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject close_write(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyIO write_io = this.GetWriteIO();
        OpenFile fptr = write_io.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            if (fptr.socketChannel() != null) {
                try {
                    fptr.socketChannel().shutdownOutput();
                }
                catch (IOException ioe) {
                    throw runtime.newErrnoFromErrno(Helpers.errnoFromException(ioe), fptr.getPath());
                }
                fptr.setMode(fptr.getMode() & 0xFFFFFFFD);
                if (!fptr.isReadable()) {
                    IRubyObject iRubyObject = write_io.rbIoClose(runtime);
                    return iRubyObject;
                }
                IRubyObject iRubyObject = context.nil;
                return iRubyObject;
            }
            if (fptr.isReadable()) {
                throw runtime.newIOError("closing non-duplex IO for writing");
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        if (this != write_io) {
            fptr = this.getOpenFileChecked();
            locked = fptr.lock();
            try {
                fptr.tiedIOForWriting = null;
                fptr.setMode(fptr.getMode() & 0xFFFFFFDF);
            }
            finally {
                if (locked) {
                    fptr.unlock();
                }
            }
        }
        write_io.rbIoClose(runtime);
        return context.nil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod
    public IRubyObject close_read(ThreadContext context) {
        Ruby runtime = context.runtime;
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked = fptr.lock();
        if (fptr.socketChannel() != null) {
            try {
                fptr.socketChannel().socket().shutdownInput();
            }
            catch (IOException ioe) {
                throw runtime.newErrnoFromErrno(Helpers.errnoFromException(ioe), fptr.getPath());
            }
            fptr.setMode(fptr.getMode() & 0xFFFFFFFE);
            if (!fptr.isWritable()) {
                IRubyObject ioe = this.rbIoClose(runtime);
                return ioe;
            }
            IRubyObject ioe = context.nil;
            return ioe;
        }
        RubyIO write_io = this.GetWriteIO();
        if (this != write_io) {
            OpenFile wfptr = write_io.getOpenFileChecked();
            boolean locked2 = wfptr.lock();
            try {
                wfptr.setProcess(fptr.getProcess());
                wfptr.setPid(fptr.getPid());
                fptr.setProcess(null);
                fptr.setPid(-1L);
                this.openFile = wfptr;
                fptr.tiedIOForWriting = null;
                fptr.setMode(fptr.getMode() & 0xFFFFFFDF);
                write_io.openFile = fptr;
                fptr.cleanup(runtime, false);
                IRubyObject iRubyObject = context.nil;
                return iRubyObject;
            }
            finally {
                if (locked2) {
                    wfptr.unlock();
                }
            }
        }
        if (!fptr.isWritable()) return this.rbIoClose(runtime);
        throw runtime.newIOError("closing non-duplex IO for reading");
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
    }

    @JRubyMethod(name={"close_on_exec="}, notImplemented=true)
    public IRubyObject close_on_exec_set(ThreadContext context, IRubyObject arg2) {
        throw context.runtime.newNotImplementedError("close_on_exec=");
    }

    @JRubyMethod(name={"close_on_exec?"}, notImplemented=true)
    public IRubyObject close_on_exec_p(ThreadContext context) {
        throw context.runtime.newNotImplementedError("close_on_exec=");
    }

    @JRubyMethod
    public RubyIO flush(ThreadContext context) {
        return this.flushRaw(context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RubyIO flushRaw(ThreadContext context, boolean sync2) {
        RubyIO io2 = this.GetWriteIO();
        OpenFile fptr = io2.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            if ((fptr.getMode() & 2) != 0 && fptr.io_fflush(context) < 0) {
                throw context.runtime.newErrnoFromErrno(fptr.errno(), "");
            }
            if ((fptr.getMode() & 1) != 0) {
                fptr.unread(context);
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        return io2;
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE})
    public IRubyObject gets(ThreadContext context) {
        IRubyObject separator = this.prepareGetsSeparator(context, null, null);
        IRubyObject result2 = this.getline(context, separator);
        if (!result2.isNil()) {
            context.setLastLine(result2);
        }
        return result2;
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE})
    public IRubyObject gets(ThreadContext context, IRubyObject arg2) {
        long limit2;
        IRubyObject separator = this.prepareGetsSeparator(context, arg2, null);
        IRubyObject result2 = this.getline(context, separator, limit2 = this.prepareGetsLimit(context, arg2, null));
        if (!result2.isNil()) {
            context.setLastLine(result2);
        }
        return result2;
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE})
    public IRubyObject gets(ThreadContext context, IRubyObject rs, IRubyObject limit_arg) {
        long limit2;
        IRubyObject result2 = this.getline(context, rs = this.prepareGetsSeparator(context, rs, limit_arg), limit2 = this.prepareGetsLimit(context, rs, limit_arg));
        if (!result2.isNil()) {
            context.setLastLine(result2);
        }
        return result2;
    }

    private IRubyObject prepareGetsSeparator(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.prepareGetsSeparator(context, null, null);
            }
            case 1: {
                return this.prepareGetsSeparator(context, args2[0], null);
            }
            case 2: {
                return this.prepareGetsSeparator(context, args2[0], args2[1]);
            }
        }
        throw new RuntimeException("invalid size for gets args: " + args2.length);
    }

    private IRubyObject prepareGetsSeparator(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        Ruby runtime = context.runtime;
        IRubyObject rs = runtime.getRecordSeparatorVar().get();
        if (arg0 != null && arg1 == null) {
            IRubyObject tmp = context.nil;
            if (arg0.isNil() || !(tmp = TypeConverter.checkStringType(runtime, arg0)).isNil()) {
                rs = tmp;
            }
        } else if (arg0 != null && arg1 != null && !(rs = arg0).isNil()) {
            rs = rs.convertToString();
        }
        if (!rs.isNil()) {
            OpenFile fptr = this.getOpenFileChecked();
            Encoding enc_rs = ((RubyString)rs).getEncoding();
            Encoding enc_io = fptr.readEncoding(runtime);
            if (enc_io != enc_rs && (((RubyString)rs).scanForCodeRange() != 16 || ((RubyString)rs).size() > 0 && !enc_io.isAsciiCompatible())) {
                if (rs == runtime.getGlobalVariables().getDefaultSeparator()) {
                    rs = RubyString.newStringLight(runtime, 0, enc_io);
                    ((RubyString)rs).catAscii(NEWLINE_BYTES, 0, 1);
                } else {
                    throw runtime.newArgumentError("encoding mismatch: " + enc_io + " IO with " + enc_rs + " RS");
                }
            }
        }
        return rs;
    }

    private long prepareGetsLimit(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.prepareGetsLimit(context, null, null);
            }
            case 1: {
                return this.prepareGetsLimit(context, args2[0], null);
            }
            case 2: {
                return this.prepareGetsLimit(context, args2[0], args2[1]);
            }
        }
        throw new RuntimeException("invalid size for gets args: " + args2.length);
    }

    private long prepareGetsLimit(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        Ruby runtime = context.runtime;
        IRubyObject lim = context.nil;
        if (arg0 != null && arg1 == null) {
            IRubyObject tmp = context.nil;
            if (!arg0.isNil() && (tmp = TypeConverter.checkStringType(runtime, arg0)).isNil()) {
                lim = arg0;
            }
        } else if (arg0 != null && arg1 != null) {
            lim = arg1;
        }
        return lim.isNil() ? -1L : lim.convertToInteger().getLongValue();
    }

    private IRubyObject gets(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.gets(context);
            }
            case 1: {
                return this.gets(context, args2[0]);
            }
            case 2: {
                return this.gets(context, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context, args2.length, 0, 2);
        return null;
    }

    public boolean getBlocking() {
        return this.openFile.isBlocking();
    }

    public void setBlocking(boolean blocking) {
        this.openFile.setBlocking(this.getRuntime(), blocking);
    }

    @JRubyMethod(name={"fcntl"})
    public IRubyObject fcntl(ThreadContext context, IRubyObject cmd) {
        return this.ctl(context.runtime, cmd, null);
    }

    @JRubyMethod(name={"fcntl"})
    public IRubyObject fcntl(ThreadContext context, IRubyObject cmd, IRubyObject arg2) {
        return this.ctl(context.runtime, cmd, arg2);
    }

    @JRubyMethod(name={"ioctl"}, required=1, optional=1)
    public IRubyObject ioctl(ThreadContext context, IRubyObject[] args2) {
        IRubyObject cmd = args2[0];
        IRubyObject arg2 = args2.length == 2 ? args2[1] : context.runtime.getNil();
        return this.ctl(context.runtime, cmd, arg2);
    }

    public IRubyObject ctl(Ruby runtime, IRubyObject cmd, IRubyObject arg2) {
        long realCmd = cmd.convertToInteger().getLongValue();
        long nArg = 0L;
        if (realCmd == (long)Fcntl.F_GETFL.intValue()) {
            OpenFile myOpenFile = this.getOpenFileChecked();
            return runtime.newFixnum(OpenFile.ioFmodeOflags(myOpenFile.getMode()));
        }
        if (arg2 == null || arg2.isNil() || arg2 == runtime.getFalse()) {
            nArg = 0L;
        } else if (arg2 instanceof RubyFixnum) {
            nArg = RubyFixnum.fix2long(arg2);
        } else if (arg2 == runtime.getTrue()) {
            nArg = 1L;
        } else {
            throw runtime.newNotImplementedError("JRuby does not support string for second fcntl/ioctl argument yet");
        }
        OpenFile fptr = this.getOpenFileChecked();
        if (realCmd != 1L) {
            if (realCmd == (long)Fcntl.F_SETFL.intValue() || realCmd == (long)Fcntl.F_SETFD.intValue()) {
                if ((nArg & 1L) != 1L) {
                    boolean block = (nArg & (long)ModeFlags.NONBLOCK) != (long)ModeFlags.NONBLOCK;
                    fptr.setBlocking(runtime, block);
                }
            } else {
                if (realCmd == (long)Fcntl.F_GETFL.intValue()) {
                    return fptr.isBlocking() ? RubyFixnum.zero(runtime) : RubyFixnum.newFixnum(runtime, ModeFlags.NONBLOCK);
                }
                throw runtime.newNotImplementedError("JRuby only supports F_SETFL and F_GETFL with NONBLOCK for fcntl/ioctl");
            }
        }
        return runtime.newFixnum(0);
    }

    @JRubyMethod(name={"puts"})
    public IRubyObject puts(ThreadContext context) {
        return RubyIO.puts0(context, this);
    }

    @JRubyMethod(name={"puts"})
    public IRubyObject puts(ThreadContext context, IRubyObject arg0) {
        return RubyIO.puts1(context, this, arg0);
    }

    @JRubyMethod(name={"puts"})
    public IRubyObject puts(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return RubyIO.puts2(context, this, arg0, arg1);
    }

    @JRubyMethod(name={"puts"})
    public IRubyObject puts(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return RubyIO.puts3(context, this, arg0, arg1, arg2);
    }

    @JRubyMethod(name={"puts"}, rest=true)
    public IRubyObject puts(ThreadContext context, IRubyObject[] args2) {
        return RubyIO.puts(context, this, args2);
    }

    public static IRubyObject puts0(ThreadContext context, IRubyObject maybeIO) {
        return RubyIO.writeSeparator(context, maybeIO);
    }

    public static IRubyObject puts1(ThreadContext context, IRubyObject maybeIO, IRubyObject arg0) {
        Ruby runtime = context.runtime;
        assert (runtime.getGlobalVariables().getDefaultSeparator() instanceof RubyString);
        RubyString separator = (RubyString)runtime.getGlobalVariables().getDefaultSeparator();
        RubyIO.putsSingle(context, runtime, maybeIO, arg0, separator);
        return context.nil;
    }

    public static IRubyObject puts2(ThreadContext context, IRubyObject maybeIO, IRubyObject arg0, IRubyObject arg1) {
        Ruby runtime = context.runtime;
        assert (runtime.getGlobalVariables().getDefaultSeparator() instanceof RubyString);
        RubyString separator = (RubyString)runtime.getGlobalVariables().getDefaultSeparator();
        RubyIO.putsSingle(context, runtime, maybeIO, arg0, separator);
        RubyIO.putsSingle(context, runtime, maybeIO, arg1, separator);
        return context.nil;
    }

    public static IRubyObject puts3(ThreadContext context, IRubyObject maybeIO, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        assert (runtime.getGlobalVariables().getDefaultSeparator() instanceof RubyString);
        RubyString separator = (RubyString)runtime.getGlobalVariables().getDefaultSeparator();
        RubyIO.putsSingle(context, runtime, maybeIO, arg0, separator);
        RubyIO.putsSingle(context, runtime, maybeIO, arg1, separator);
        RubyIO.putsSingle(context, runtime, maybeIO, arg2, separator);
        return context.nil;
    }

    public static IRubyObject puts(ThreadContext context, IRubyObject maybeIO, IRubyObject ... args2) {
        if (args2.length == 0) {
            return RubyIO.writeSeparator(context, maybeIO);
        }
        return RubyIO.putsArray(context, maybeIO, args2);
    }

    private static IRubyObject writeSeparator(ThreadContext context, IRubyObject maybeIO) {
        Ruby runtime = context.runtime;
        assert (runtime.getGlobalVariables().getDefaultSeparator() instanceof RubyString);
        RubyString separator = (RubyString)runtime.getGlobalVariables().getDefaultSeparator();
        RubyIO.write(context, maybeIO, separator);
        return runtime.getNil();
    }

    private static IRubyObject putsArray(ThreadContext context, IRubyObject maybeIO, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        assert (runtime.getGlobalVariables().getDefaultSeparator() instanceof RubyString);
        RubyString separator = (RubyString)runtime.getGlobalVariables().getDefaultSeparator();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            RubyIO.putsSingle(context, runtime, maybeIO, args2[i2], separator);
        }
        return runtime.getNil();
    }

    private static void putsSingle(ThreadContext context, Ruby runtime, IRubyObject maybeIO, IRubyObject arg2, RubyString separator) {
        ByteList line;
        if (arg2.isNil()) {
            line = RubyIO.getNilByteList(runtime);
        } else if (runtime.isInspecting(arg2)) {
            line = RECURSIVE_BYTELIST;
        } else {
            if (arg2 instanceof RubyArray) {
                RubyIO.inspectPuts(context, maybeIO, (RubyArray)arg2);
                return;
            }
            line = arg2.asString().getByteList();
        }
        RubyIO.write(context, maybeIO, line);
        if (line.length() == 0 || !line.endsWith(separator.getByteList())) {
            RubyIO.write(context, maybeIO, separator.getByteList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject inspectPuts(ThreadContext context, IRubyObject maybeIO, RubyArray array) {
        try {
            context.runtime.registerInspecting(array);
            IRubyObject iRubyObject = RubyIO.putsArray(context, maybeIO, array.toJavaArray());
            return iRubyObject;
        }
        finally {
            context.runtime.unregisterInspecting(array);
        }
    }

    protected IRubyObject write(ThreadContext context, ByteList byteList) {
        return this.callMethod(context, "write", (IRubyObject)RubyString.newStringShared(context.runtime, byteList));
    }

    protected static IRubyObject write(ThreadContext context, IRubyObject maybeIO, ByteList byteList) {
        return maybeIO.callMethod(context, "write", RubyString.newStringShared(context.runtime, byteList));
    }

    public static IRubyObject write(ThreadContext context, IRubyObject maybeIO, IRubyObject str) {
        return maybeIO.callMethod(context, "write", str);
    }

    @Override
    public IRubyObject inspect() {
        Ruby runtime = this.getRuntime();
        if (this.openFile == null) {
            return super.inspect();
        }
        String className = this.getMetaClass().getRealClass().getName();
        String path2 = this.openFile.getPath();
        String status2 = "";
        if (path2 == null) {
            if (this.openFile.fd() == null) {
                path2 = "";
                status2 = "(closed)";
            } else {
                path2 = "fd " + this.openFile.fd().bestFileno();
            }
        } else if (!this.openFile.isOpen()) {
            status2 = " (closed)";
        }
        String inspectStr = "#<" + className + ":" + path2 + status2 + ">";
        return runtime.newString(inspectStr);
    }

    @JRubyMethod(name={"readline"}, writes={FrameField.LASTLINE})
    public IRubyObject readline(ThreadContext context) {
        IRubyObject line = this.gets(context);
        if (line.isNil()) {
            throw context.runtime.newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"readline"}, writes={FrameField.LASTLINE})
    public IRubyObject readline(ThreadContext context, IRubyObject separator) {
        IRubyObject line = this.gets(context, separator);
        if (line.isNil()) {
            throw context.runtime.newEOFError();
        }
        return line;
    }

    public IRubyObject getc() {
        return this.getbyte(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject readchar(ThreadContext context) {
        IRubyObject c = this.getc19(context);
        if (c.isNil()) {
            throw context.runtime.newEOFError();
        }
        return c;
    }

    @JRubyMethod
    public IRubyObject getbyte(ThreadContext context) {
        int c = this.getByte(context);
        if (c == -1) {
            return context.nil;
        }
        return RubyNumeric.int2fix(context.runtime, c & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getByte(ThreadContext context) {
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            fptr.checkByteReadable(context);
            fptr.READ_CHECK(context);
            if (fptr.fillbuf(context) < 0) {
                int n = -1;
                return n;
            }
            ++fptr.rbuf.off;
            --fptr.rbuf.len;
            int n = fptr.rbuf.ptr[fptr.rbuf.off - 1] & 0xFF;
            return n;
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
    }

    @JRubyMethod
    public IRubyObject readbyte(ThreadContext context) {
        IRubyObject c = this.getbyte(context);
        if (c.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"getc"})
    public IRubyObject getc19(ThreadContext context) {
        Ruby runtime = context.runtime;
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            fptr.checkCharReadable(context);
            Encoding enc = fptr.inputEncoding(runtime);
            fptr.READ_CHECK(context);
            IRubyObject iRubyObject = fptr.getc(context, enc);
            return iRubyObject;
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject ungetbyte(ThreadContext context, IRubyObject b2) {
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            fptr.checkByteReadable(context);
            if (b2.isNil()) {
                IRubyObject iRubyObject = context.nil;
                return iRubyObject;
            }
            if (b2 instanceof RubyFixnum) {
                byte cc = (byte)RubyNumeric.fix2int(b2);
                b2 = RubyString.newStringNoCopy(context.runtime, new byte[]{cc});
            } else {
                b2 = b2.convertToString();
            }
            fptr.ungetbyte(context, b2);
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        return context.nil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject ungetc(ThreadContext context, IRubyObject c) {
        Ruby runtime = context.runtime;
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            fptr.checkCharReadable(context);
            if (c.isNil()) {
                IRubyObject iRubyObject = c;
                return iRubyObject;
            }
            c = c instanceof RubyFixnum ? EncodingUtils.encUintChr(context, (int)((RubyFixnum)c).getLongValue(), fptr.readEncoding(runtime)) : (c instanceof RubyBignum ? EncodingUtils.encUintChr(context, (int)((RubyBignum)c).getLongValue(), fptr.readEncoding(runtime)) : c.convertToString());
            if (fptr.needsReadConversion()) {
                fptr.SET_BINARY_MODE();
                int len = ((RubyString)c).size();
                fptr.makeReadConversion(context, len);
                if (fptr.cbuf.capa - fptr.cbuf.len < len) {
                    throw runtime.newIOError("ungetc failed");
                }
                if (fptr.cbuf.off < len) {
                    System.arraycopy(fptr.cbuf.ptr, fptr.cbuf.off, fptr.cbuf.ptr, fptr.cbuf.capa - fptr.cbuf.len, fptr.cbuf.len);
                    fptr.cbuf.off = fptr.cbuf.capa - fptr.cbuf.len;
                }
                fptr.cbuf.off -= len;
                fptr.cbuf.len += len;
                ByteList cByteList = ((RubyString)c).getByteList();
                System.arraycopy(cByteList.unsafeBytes(), cByteList.begin(), fptr.cbuf.ptr, fptr.cbuf.off, len);
            } else {
                fptr.NEED_NEWLINE_DECORATOR_ON_READ_CHECK();
                fptr.ungetbyte(context, c);
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        return context.nil;
    }

    @JRubyMethod(name={"read_nonblock"}, required=1, optional=2)
    public IRubyObject read_nonblock(ThreadContext context, IRubyObject[] args2) {
        return this.doReadNonblock(context, args2, true);
    }

    public IRubyObject doReadNonblock(ThreadContext context, IRubyObject[] args2, boolean useException) {
        IRubyObject ret;
        Ruby runtime = context.runtime;
        boolean no_exception = !useException;
        IRubyObject opts = ArgsUtil.getOptionsArg(runtime, args2);
        if (!opts.isNil() && runtime.getFalse() == ((RubyHash)opts).op_aref(context, runtime.newSymbol("exception"))) {
            no_exception = true;
        }
        if ((ret = this.getPartial(context, args2, true, no_exception)).isNil()) {
            if (no_exception) {
                return ret;
            }
            throw runtime.newEOFError();
        }
        return ret;
    }

    @JRubyMethod(name={"readpartial"}, required=1, optional=1)
    public IRubyObject readpartial(ThreadContext context, IRubyObject[] args2) {
        IRubyObject value2 = this.getPartial(context, args2, false, false);
        if (value2.isNil()) {
            throw context.runtime.newEOFError();
        }
        return value2;
    }

    /*
     * Exception decompiling
     */
    private IRubyObject getPartial(ThreadContext context, IRubyObject[] args, boolean nonblock, boolean noException) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 19[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"sysread"}, required=1, optional=1)
    public IRubyObject sysread(ThreadContext context, IRubyObject[] args2) {
        int n;
        Ruby runtime = context.runtime;
        IRubyObject len = args2.length >= 1 ? args2[0] : context.nil;
        IRubyObject str = args2.length >= 2 ? args2[1] : context.nil;
        int ilen = RubyNumeric.num2int(len);
        str = EncodingUtils.setStrBuf(runtime, str, ilen);
        if (ilen == 0) {
            return str;
        }
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            fptr.checkByteReadable(context);
            if (fptr.READ_DATA_BUFFERED()) {
                throw runtime.newIOError("sysread for buffered IO");
            }
            context.getThread().select(fptr.channel(), fptr, 1);
            fptr.checkClosed();
            str = EncodingUtils.setStrBuf(runtime, str, ilen);
            ByteList strByteList = ((RubyString)str).getByteList();
            n = OpenFile.readInternal(context, fptr, fptr.fd(), strByteList.unsafeBytes(), strByteList.begin(), ilen);
            if (n == -1) {
                throw runtime.newErrnoFromErrno(fptr.errno(), fptr.getPath());
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        ((RubyString)str).setReadLength(n);
        if (n == 0 && ilen > 0) {
            throw runtime.newEOFError();
        }
        str.setTaint(true);
        return str;
    }

    public IRubyObject read(IRubyObject[] args2) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        switch (args2.length) {
            case 0: {
                return this.read(context);
            }
            case 1: {
                return this.read(context, args2[0]);
            }
            case 2: {
                return this.read(context, args2[0], args2[1]);
            }
        }
        throw this.getRuntime().newArgumentError(args2.length, 2);
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context) {
        return this.read(context, context.nil, context.nil);
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context, IRubyObject arg0) {
        return this.read(context, arg0, context.nil);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context, IRubyObject length2, IRubyObject str) {
        int n;
        Ruby runtime = context.runtime;
        if (length2.isNil()) {
            OpenFile fptr = this.getOpenFileChecked();
            boolean locked = fptr.lock();
            try {
                fptr.checkCharReadable(context);
                IRubyObject iRubyObject = fptr.readAll(context, 0, str);
                return iRubyObject;
            }
            finally {
                if (locked) {
                    fptr.unlock();
                }
            }
        }
        int len = RubyNumeric.num2int(length2);
        if (len < 0) {
            throw runtime.newArgumentError("negative length " + len + " given");
        }
        str = EncodingUtils.setStrBuf(runtime, str, len);
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            fptr.checkByteReadable(context);
            if (len == 0) {
                ((RubyString)str).setReadLength(0);
                IRubyObject iRubyObject = str;
                return iRubyObject;
            }
            fptr.READ_CHECK(context);
            n = fptr.fread(context, str, 0, len);
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        ((RubyString)str).setReadLength(n);
        if (n == 0) {
            return context.nil;
        }
        str.setTaint(true);
        return str;
    }

    public IRubyObject readchar() {
        return this.readchar(this.getRuntime().getCurrentContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject stat(ThreadContext context) {
        Ruby runtime = context.runtime;
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            int realFileno;
            fptr.checkClosed();
            if (runtime.getPosix().isNative() && (realFileno = fptr.fd().realFileno) != -1) {
                RubyFileStat rubyFileStat = RubyFileStat.newFileStat(runtime, realFileno);
                return rubyFileStat;
            }
            RubyFileStat rubyFileStat = context.runtime.newFileStat(fptr.getPath(), false);
            return rubyFileStat;
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject each_byteInternal(ThreadContext context, Block block) {
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "each_byte");
        }
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            while (true) {
                if (fptr.rbuf.len > 0) {
                    int p2;
                    byte[] pBytes = fptr.rbuf.ptr;
                    ++fptr.rbuf.off;
                    --fptr.rbuf.len;
                    block.yield(context, runtime.newFixnum(pBytes[p2] & 0xFF));
                    fptr.errno(null);
                    continue;
                }
                fptr.checkByteReadable(context);
                fptr.READ_CHECK(context);
                if (fptr.fillbuf(context) < 0) break;
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each_byte(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_byteInternal(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "each_byte");
    }

    @JRubyMethod(name={"bytes"})
    public IRubyObject bytes(ThreadContext context, Block block) {
        context.runtime.getWarnings().warn("IO#bytes is deprecated; use #each_byte instead");
        return this.each_byte(context, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject each_charInternal(ThreadContext context, Block block) {
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "each_char");
        }
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            IRubyObject c;
            fptr.checkCharReadable(context);
            Encoding enc = fptr.inputEncoding(runtime);
            fptr.READ_CHECK(context);
            while (!(c = fptr.getc(context, enc)).isNil()) {
                block.yield(context, c);
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        return this;
    }

    @JRubyMethod(name={"each_char"})
    public IRubyObject each_char(ThreadContext context, Block block) {
        return this.each_charInternal(context, block);
    }

    @JRubyMethod(name={"chars"})
    public IRubyObject chars(ThreadContext context, Block block) {
        context.runtime.getWarnings().warn("IO#chars is deprecated; use #each_char instead");
        return this.each_charInternal(context, block);
    }

    @JRubyMethod
    public IRubyObject codepoints(ThreadContext context, Block block) {
        context.runtime.getWarnings().warn("IO#codepoints is deprecated; use #each_codepoint instead");
        return this.eachCodePointCommon(context, block, "each_codepoint");
    }

    @JRubyMethod
    public IRubyObject each_codepoint(ThreadContext context, Block block) {
        return this.eachCodePointCommon(context, block, "each_codepoint");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject eachCodePointCommon(ThreadContext context, Block block, String methodName) {
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, methodName);
        }
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            fptr.checkCharReadable(context);
            fptr.READ_CHECK(context);
            if (fptr.needsReadConversion()) {
                fptr.SET_BINARY_MODE();
                while (true) {
                    int r;
                    block13: {
                        fptr.makeReadConversion(context);
                        do {
                            if (fptr.cbuf.len == 0) continue;
                            r = fptr.encs.enc != null ? StringSupport.preciseLength(fptr.encs.enc, fptr.cbuf.ptr, fptr.cbuf.off, fptr.cbuf.off + fptr.cbuf.len) : StringSupport.CONSTRUCT_MBCLEN_CHARFOUND(1);
                            if (StringSupport.MBCLEN_NEEDMORE_P(r)) {
                                if (fptr.cbuf.len != fptr.cbuf.capa) continue;
                                throw runtime.newIOError("too long character");
                            }
                            break block13;
                        } while (fptr.moreChar(context) != 1);
                        fptr.clearReadConversion();
                        RubyIO rubyIO = this;
                        return rubyIO;
                    }
                    if (StringSupport.MBCLEN_INVALID_P(r)) {
                        throw runtime.newArgumentError("invalid byte sequence in " + fptr.encs.enc.toString());
                    }
                    int n = StringSupport.MBCLEN_CHARFOUND_LEN(r);
                    int c = fptr.encs.enc != null ? StringSupport.codePoint(runtime, fptr.encs.enc, fptr.cbuf.ptr, fptr.cbuf.off, fptr.cbuf.off + fptr.cbuf.len) : fptr.cbuf.ptr[fptr.cbuf.off] & 0xFF;
                    fptr.cbuf.off += n;
                    fptr.cbuf.len -= n;
                    block.yield(context, runtime.newFixnum(c & 0xFFFFFFFF));
                }
            }
            fptr.NEED_NEWLINE_DECORATOR_ON_READ_CHECK();
            Encoding enc = fptr.inputEncoding(runtime);
            while (fptr.fillbuf(context) >= 0) {
                int n;
                int r = StringSupport.preciseLength(enc, fptr.rbuf.ptr, fptr.rbuf.off, fptr.rbuf.off + fptr.rbuf.len);
                if (StringSupport.MBCLEN_CHARFOUND_P(r) && (n = StringSupport.MBCLEN_CHARFOUND_LEN(r)) <= fptr.rbuf.len) {
                    int c = StringSupport.codePoint(runtime, fptr.encs.enc, fptr.rbuf.ptr, fptr.rbuf.off, fptr.rbuf.off + fptr.rbuf.len);
                    fptr.rbuf.off += n;
                    fptr.rbuf.len -= n;
                    block.yield(context, runtime.newFixnum(c & 0xFFFFFFFF));
                    continue;
                }
                if (!StringSupport.MBCLEN_INVALID_P(r)) continue;
                throw runtime.newArgumentError("invalid byte sequence in " + enc.toString());
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        return this;
    }

    private IRubyObject each_lineInternal(ThreadContext context, IRubyObject[] args2, Block block, String name2) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, name2, args2);
        }
        Ruby runtime = context.runtime;
        IRubyObject separator = this.prepareGetsSeparator(context, args2);
        ByteListCache cache = new ByteListCache();
        IRubyObject line = this.getline(context, separator);
        while (!line.isNil()) {
            block.yield(context, line);
            line = this.getline(context, separator, -1L, cache);
        }
        return this;
    }

    @JRubyMethod(optional=1)
    public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.each_lineInternal(context, args2, block, "each");
    }

    @JRubyMethod(optional=1)
    public IRubyObject each_line(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.each_lineInternal(context, args2, block, "each_line");
    }

    @JRubyMethod(name={"lines"})
    public IRubyObject lines(ThreadContext context, Block block) {
        context.runtime.getWarnings().warn("IO#lines is deprecated; use #each_line instead");
        return this.each_lineInternal(context, NULL_ARRAY, block, "each_line");
    }

    @JRubyMethod(name={"readlines"}, optional=2)
    public RubyArray readlines(ThreadContext context, IRubyObject[] args2) {
        return this.readlinesCommon(context, args2);
    }

    private RubyArray readlinesCommon(ThreadContext context, IRubyObject[] args2) {
        IRubyObject line;
        Ruby runtime = context.runtime;
        long limit2 = this.prepareGetsLimit(context, args2);
        IRubyObject separator = this.prepareGetsSeparator(context, args2);
        RubyArray result2 = runtime.newArray();
        while (!(line = this.getline(context, separator, limit2, null)).isNil()) {
            result2.append(line);
        }
        return result2;
    }

    @JRubyMethod(name={"to_io"})
    public RubyIO to_io() {
        return this;
    }

    @Override
    public String toString() {
        return this.inspect().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject foreachInternal19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = context.runtime;
        IRubyObject opt = ArgsUtil.getOptionsArg(context.runtime, args2);
        IRubyObject io2 = RubyIO.openKeyArgs(context, recv2, args2, opt);
        if (io2.isNil()) {
            return io2;
        }
        IRubyObject[] methodArguments = RubyIO.processReadlinesMethodArguments(args2);
        try {
            IRubyObject str;
            while (!(str = ((RubyIO)io2).gets(context, methodArguments)).isNil()) {
                block.yield(context, str);
            }
        }
        finally {
            ((RubyIO)io2).close();
            runtime.getGlobalVariables().clear("$_");
        }
        return context.nil;
    }

    @JRubyMethod(name={"foreach"}, required=1, optional=3, meta=true)
    public static IRubyObject foreach(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, recv2, "foreach", args2);
        }
        return RubyIO.foreachInternal19(context, recv2, args2, block);
    }

    public static RubyIO convertToIO(ThreadContext context, IRubyObject obj) {
        return TypeConverter.ioGetIO(context.runtime, obj);
    }

    @JRubyMethod(name={"select"}, required=1, optional=3, meta=true)
    public static IRubyObject select(ThreadContext context, IRubyObject recv2, IRubyObject[] argv) {
        Long timeout2;
        IRubyObject _timeout;
        IRubyObject except = _timeout = context.nil;
        IRubyObject write2 = _timeout;
        IRubyObject read2 = _timeout;
        switch (argv.length) {
            case 4: {
                _timeout = argv[3];
            }
            case 3: {
                except = argv[2];
            }
            case 2: {
                write2 = argv[1];
            }
            case 1: {
                read2 = argv[0];
            }
        }
        if (_timeout.isNil()) {
            timeout2 = null;
        } else {
            double tmp = _timeout.convertToFloat().getDoubleValue();
            if (tmp < 0.0) {
                throw context.runtime.newArgumentError("negative timeout");
            }
            timeout2 = (long)(tmp * 1000.0);
        }
        SelectExecutor args2 = new SelectExecutor(read2, write2, except, timeout2);
        return args2.go(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(required=1, optional=2)
    public IRubyObject advise(ThreadContext context, IRubyObject[] argv) {
        IRubyObject len;
        IRubyObject offset2 = len = context.nil;
        IRubyObject advice = len;
        switch (argv.length) {
            case 3: {
                len = argv[2];
            }
            case 2: {
                offset2 = argv[1];
            }
            case 1: {
                advice = argv[0];
            }
        }
        RubyIO.adviceArgCheck(context, advice);
        RubyIO io2 = this.GetWriteIO();
        OpenFile fptr = io2.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            int off = offset2.isNil() ? 0 : offset2.convertToInteger().getIntValue();
            int l = len.isNil() ? 0 : len.convertToInteger().getIntValue();
            IRubyObject iRubyObject = context.nil;
            return iRubyObject;
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
    }

    static void adviceArgCheck(ThreadContext context, IRubyObject advice) {
        String adviceStr;
        if (!(advice instanceof RubySymbol)) {
            throw context.runtime.newTypeError("advise must be a symbol");
        }
        switch (adviceStr = advice.asJavaString()) {
            default: {
                throw context.runtime.newNotImplementedError(RubyIO.rbInspect(context, advice).toString());
            }
            case "normal": 
            case "sequential": 
            case "random": 
            case "willneed": 
            case "dontneed": 
            case "noreuse": 
        }
    }

    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyIO.read19(context, recv2, args2, Block.NULL_BLOCK);
    }

    public static void failIfDirectory(Ruby runtime, RubyString pathStr) {
        if (RubyFileTest.directory_p(runtime, (IRubyObject)pathStr).isTrue()) {
            if (Platform.IS_WINDOWS) {
                throw runtime.newErrnoEACCESError(pathStr.asJavaString());
            }
            throw runtime.newErrnoEISDirError(pathStr.asJavaString());
        }
    }

    private static IRubyObject openKeyArgs(ThreadContext context, IRubyObject recv2, IRubyObject[] argv, IRubyObject opt) {
        Ruby runtime = context.runtime;
        RubyString path2 = StringSupport.checkEmbeddedNulls(runtime, RubyFile.get_path(context, argv[0]));
        RubyIO.failIfDirectory(runtime, path2);
        if (opt.isNil()) {
            return RubyIO.ioOpen(context, path2, runtime.newFixnum(ModeFlags.RDONLY), runtime.newFixnum(438), opt);
        }
        IRubyObject v = ((RubyHash)opt).op_aref(context, runtime.newSymbol("open_args"));
        if (!v.isNil()) {
            v = v.convertToArray();
            int n = ((RubyArray)v).size() + 1;
            RubyArray args2 = runtime.newArray(n);
            args2.push_m19(new IRubyObject[]{path2});
            args2.concat19(v);
            return RubyKernel.open19(context, recv2, args2.toJavaArray(), Block.NULL_BLOCK);
        }
        return RubyIO.ioOpen(context, path2, context.nil, context.nil, opt);
    }

    public static IRubyObject ioOpen(ThreadContext context, IRubyObject filename2, IRubyObject vmode, IRubyObject vperm, IRubyObject opt) {
        Ruby runtime = context.runtime;
        int[] oflags_p = new int[]{0};
        int[] fmode_p = new int[]{0};
        if (filename2 instanceof RubyString && ((RubyString)filename2).isEmpty()) {
            throw context.getRuntime().newErrnoENOENTError();
        }
        Object pm = EncodingUtils.vmodeVperm(vmode, vperm);
        IOEncodable.ConvConfig convconfig = new IOEncodable.ConvConfig();
        EncodingUtils.extractModeEncoding(context, convconfig, pm, opt, oflags_p, fmode_p);
        int perm = EncodingUtils.vperm(pm) == null || EncodingUtils.vperm(pm).isNil() ? 438 : RubyNumeric.num2int(EncodingUtils.vperm(pm));
        IRubyObject cmd = PopenExecutor.checkPipeCommand(context, filename2);
        if (!cmd.isNil()) {
            return PopenExecutor.pipeOpen(context, cmd, OpenFile.ioOflagsModestr(runtime, oflags_p[0]), fmode_p[0], convconfig);
        }
        return ((RubyFile)context.runtime.getFile().allocate()).fileOpenGeneric(context, filename2, oflags_p[0], fmode_p[0], convconfig, perm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject write19(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject str, IRubyObject offset2, RubyHash options2) {
        Ruby runtime = context.runtime;
        RubyString pathStr = StringSupport.checkEmbeddedNulls(runtime, RubyFile.get_path(context, path2));
        RubyIO.failIfDirectory(runtime, pathStr);
        RubyIO file2 = null;
        long mode2 = ModeFlags.CREAT;
        if (options2 == null || options2 != null && options2.isEmpty()) {
            mode2 = offset2.isNil() ? (mode2 |= (long)ModeFlags.WRONLY) : (mode2 |= (long)ModeFlags.RDWR);
            file2 = (RubyIO)Helpers.invoke(context, (IRubyObject)runtime.getFile(), "new", path2, (IRubyObject)RubyFixnum.newFixnum(runtime, mode2));
        } else {
            file2 = !options2.containsKey(runtime.newSymbol("mode")) ? (RubyIO)Helpers.invoke(context, (IRubyObject)runtime.getFile(), "new", path2, (IRubyObject)RubyFixnum.newFixnum(runtime, mode2 |= (long)ModeFlags.WRONLY), (IRubyObject)options2) : (RubyIO)Helpers.invoke(context, (IRubyObject)runtime.getFile(), "new", path2, (IRubyObject)options2);
        }
        try {
            if (!offset2.isNil()) {
                file2.seek(context, offset2);
            }
            IRubyObject iRubyObject = file2.write(context, str);
            return iRubyObject;
        }
        finally {
            file2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true, required=1, optional=2)
    public static IRubyObject binread(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        IRubyObject nil = runtime.getNil();
        RubyString path2 = StringSupport.checkEmbeddedNulls(runtime, RubyFile.get_path(context, args2[0]));
        IRubyObject length2 = nil;
        IRubyObject offset2 = nil;
        if (args2.length > 2) {
            offset2 = args2[2];
            length2 = args2[1];
        } else if (args2.length > 1) {
            length2 = args2[1];
        }
        try (RubyIO file2 = (RubyIO)Helpers.invoke(context, (IRubyObject)runtime.getFile(), "new", (IRubyObject)path2, (IRubyObject)runtime.newString("rb:ASCII-8BIT"));){
            if (!offset2.isNil()) {
                file2.seek(context, offset2);
            }
            IRubyObject iRubyObject = file2.read(context, length2);
            return iRubyObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"}, meta=true, required=1, optional=3)
    public static IRubyObject read19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        Ruby runtime = context.runtime;
        IRubyObject nil = runtime.getNil();
        IRubyObject path2 = args2[0];
        IRubyObject length2 = nil;
        IRubyObject offset2 = nil;
        IRubyObject options2 = nil;
        if (args2.length > 3) {
            if (!(args2[3] instanceof RubyHash)) {
                throw runtime.newTypeError("Must be a hash");
            }
            options2 = (RubyHash)args2[3];
            offset2 = args2[2];
            length2 = args2[1];
        } else if (args2.length > 2) {
            if (args2[2] instanceof RubyHash) {
                options2 = (RubyHash)args2[2];
            } else {
                offset2 = args2[2];
            }
            length2 = args2[1];
        } else if (args2.length > 1) {
            if (args2[1] instanceof RubyHash) {
                options2 = (RubyHash)args2[1];
            } else {
                length2 = args2[1];
            }
        }
        if (options2 == null) {
            options2 = RubyHash.newHash(runtime);
        }
        try (RubyIO file2 = (RubyIO)RubyIO.openKeyArgs(context, recv2, new IRubyObject[]{path2, length2, offset2}, options2);){
            if (!offset2.isNil()) {
                file2.seek(context, offset2);
            }
            IRubyObject iRubyObject = file2.read(context, length2);
            return iRubyObject;
        }
    }

    @JRubyMethod(meta=true, required=2, optional=2)
    public static IRubyObject binwrite(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyIO.ioStaticWrite(context, recv2, args2, true);
    }

    @JRubyMethod(name={"write"}, meta=true, required=2, optional=2)
    public static IRubyObject write(ThreadContext context, IRubyObject recv2, IRubyObject[] argv) {
        return RubyIO.ioStaticWrite(context, recv2, argv, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject ioStaticWrite(ThreadContext context, IRubyObject recv2, IRubyObject[] argv, boolean binary) {
        IRubyObject _io;
        IRubyObject opt;
        Ruby runtime = context.runtime;
        IRubyObject offset2 = opt = context.nil;
        IRubyObject string2 = opt;
        switch (argv.length) {
            case 4: {
                opt = argv[3].convertToHash();
                offset2 = argv[2];
                string2 = argv[1];
                break;
            }
            case 3: {
                opt = TypeConverter.checkHashType(runtime, argv[2]);
                if (opt.isNil()) {
                    offset2 = argv[2];
                }
                string2 = argv[1];
                break;
            }
            case 2: {
                string2 = argv[1];
                break;
            }
            default: {
                Arity.raiseArgumentError(runtime, argv.length, 2, 4);
            }
        }
        opt = opt.isNil() ? RubyHash.newHash(runtime) : ((RubyHash)opt).dupFast(context);
        if (((RubyHash)opt).op_aref(context, runtime.newSymbol("mode")).isNil()) {
            int mode2 = OpenFlags.O_WRONLY.intValue() | OpenFlags.O_CREAT.intValue();
            if (OpenFlags.O_BINARY.defined() && binary) {
                mode2 |= OpenFlags.O_BINARY.intValue();
            }
            if (offset2.isNil()) {
                mode2 |= OpenFlags.O_TRUNC.intValue();
            }
            ((RubyHash)opt).op_aset(runtime.newSymbol("mode"), runtime.newFixnum(mode2));
        }
        if ((_io = RubyIO.openKeyArgs(context, recv2, argv, opt)).isNil()) {
            return context.nil;
        }
        RubyIO io2 = (RubyIO)_io;
        if (!OpenFlags.O_BINARY.defined() && binary) {
            io2.binmode();
        }
        if (!offset2.isNil()) {
            RubyIO.seekBeforeAccess(context, io2, offset2, 0);
        }
        try {
            IRubyObject iRubyObject = io2.write(context, string2, false);
            return iRubyObject;
        }
        finally {
            RubyIO.ioClose(runtime, io2);
        }
    }

    static IRubyObject seekBeforeAccess(ThreadContext context, RubyIO io2, IRubyObject offset2, int mode2) {
        io2.setBinmode();
        return io2.doSeek(context, offset2, mode2);
    }

    public static IRubyObject readlines(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        return RubyIO.readlines19(context, recv2, args2, unusedBlock);
    }

    @JRubyMethod(name={"readlines"}, required=1, optional=3, meta=true)
    public static IRubyObject readlines19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        int argc = args2.length;
        IRubyObject opt = ArgsUtil.getOptionsArg(context.runtime, args2);
        IRubyObject io2 = RubyIO.openKeyArgs(context, recv2, args2, opt);
        if (io2.isNil()) {
            return io2;
        }
        IRubyObject[] methodArguments = RubyIO.processReadlinesMethodArguments(args2);
        return RubyIO.readlinesCommon19(context, (RubyIO)io2, methodArguments);
    }

    private static IRubyObject[] processReadlinesMethodArguments(IRubyObject[] args2) {
        int count2 = args2.length;
        IRubyObject[] methodArguments = IRubyObject.NULL_ARRAY;
        if (count2 >= 3 && (args2[2] instanceof RubyFixnum || args2[2].respondsTo("to_int"))) {
            methodArguments = new IRubyObject[]{args2[1], args2[2]};
        } else if (count2 >= 2 && (args2[1] instanceof RubyFixnum || args2[1].respondsTo("to_int"))) {
            methodArguments = new IRubyObject[]{args2[1]};
        } else if (count2 >= 2 && !(args2[1] instanceof RubyHash)) {
            methodArguments = new IRubyObject[]{args2[1]};
        }
        return methodArguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RubyArray readlinesCommon19(ThreadContext context, RubyIO file2, IRubyObject[] newArguments) {
        try {
            RubyArray rubyArray = file2.readlines(context, newArguments);
            return rubyArray;
        }
        finally {
            file2.close();
        }
    }

    private void setupPopen(ModeFlags modes, ShellLauncher.POpenProcess process) throws RaiseException {
        Ruby runtime = this.getRuntime();
        this.openFile.setMode(modes.getOpenFileFlags() | 8);
        this.openFile.setProcess(process);
        if (this.openFile.isReadable()) {
            ReadableByteChannel inChannel = process.getInput() != null ? process.getInput() : Channels.newChannel(process.getInputStream());
            ChannelFD main2 = new ChannelFD(inChannel, runtime.getPosix(), runtime.getFilenoUtil());
            this.openFile.setFD(main2);
            this.openFile.setMode(1);
        }
        if (this.openFile.isWritable() && process.hasOutput()) {
            WritableByteChannel outChannel = process.getOutput() != null ? process.getOutput() : Channels.newChannel(process.getOutputStream());
            ChannelFD pipe = new ChannelFD(outChannel, runtime.getPosix(), runtime.getFilenoUtil());
            RubyIO writeIO = new RubyIO(runtime, runtime.getIO());
            writeIO.initializeCommon(runtime.getCurrentContext(), pipe, (IRubyObject)runtime.newFixnum(OpenFlags.O_WRONLY), runtime.getNil());
            this.openFile.tiedIOForWriting = writeIO;
            this.setInstanceVariable("@tied_io_for_writing", writeIO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(name={"popen"}, required=1, optional=2, meta=true)
    public static IRubyObject popen(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Object object;
        ShellLauncher.POpenProcess process;
        Ruby runtime;
        block19: {
            IRubyObject tmp;
            runtime = context.runtime;
            if (runtime.getPosix().isNative() && !Platform.IS_WINDOWS) {
                return PopenExecutor.popen(context, args2, (RubyClass)recv2, block);
            }
            IRubyObject pmode = null;
            RubyHash options2 = null;
            int firstArg = 0;
            int argc = args2.length;
            if (argc > 0 && !TypeConverter.checkHashType(runtime, args2[0]).isNil()) {
                ++firstArg;
                --argc;
            }
            if (argc > 0 && !(tmp = TypeConverter.checkHashType(runtime, args2[args2.length - 1])).isNil()) {
                options2 = (RubyHash)tmp;
                --argc;
            }
            if (argc > 1) {
                pmode = args2[firstArg + 1];
            }
            RubyIO io2 = new RubyIO(runtime, (RubyClass)recv2);
            io2.MakeOpenFile();
            Object pm = EncodingUtils.vmodeVperm(pmode, runtime.newFixnum(0));
            int[] oflags_p = new int[]{0};
            int[] fmode_p = new int[]{0};
            EncodingUtils.extractModeEncoding(context, io2, pm, options2, oflags_p, fmode_p);
            ModeFlags modes = ModeFlags.createModeFlags(oflags_p[0]);
            if (args2.length > 1 && args2[args2.length - 1] instanceof RubyHash) {
                options2 = (RubyHash)args2[args2.length - 1];
                IRubyObject[] newArgs = new IRubyObject[args2.length - 1];
                System.arraycopy(args2, 0, newArgs, 0, args2.length - 1);
                args2 = newArgs;
            }
            Ruby19POpen r19Popen = new Ruby19POpen(runtime, args2);
            if ("-".equals(r19Popen.cmd.toString())) {
                throw runtime.newNotImplementedError("popen(\"-\") is unimplemented");
            }
            process = r19Popen.cmdPlusArgs == null ? ShellLauncher.popen(runtime, (IRubyObject)r19Popen.cmd, modes) : ShellLauncher.popen(runtime, r19Popen.cmdPlusArgs, (Map)r19Popen.env, modes);
            if (System.getProperty("java.specification.version", "").equals("1.5")) {
                object = process;
                synchronized (object) {
                    try {
                        process.wait(100L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
            RubyIO.checkPopenOptions(options2);
            io2.setupPopen(modes, process);
            if (!block.isGiven()) return io2;
            try {
                object = block.yield(context, io2);
                if (!io2.openFile.isOpen()) break block19;
                io2.close();
            }
            catch (Throwable throwable) {
                try {
                    if (io2.openFile.isOpen()) {
                        io2.close();
                    }
                    context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime, process.waitFor() << 8, ShellLauncher.getPidFromProcess(process)));
                    throw throwable;
                }
                catch (IOException e) {
                    throw runtime.newIOErrorFromException(e);
                }
                catch (InterruptedException e) {
                    throw runtime.newThreadError("unexpected interrupt");
                }
            }
        }
        context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime, process.waitFor() << 8, ShellLauncher.getPidFromProcess(process)));
        return object;
    }

    public static IRubyObject pipe(ThreadContext context, IRubyObject recv2) {
        return RubyIO.pipe19(context, recv2);
    }

    public static IRubyObject pipe19(ThreadContext context, IRubyObject recv2) {
        return RubyIO.pipe19(context, recv2, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
    }

    public static IRubyObject pipe19(ThreadContext context, IRubyObject recv2, IRubyObject modes) {
        return RubyIO.pipe19(context, recv2, new IRubyObject[]{modes}, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"pipe"}, optional=3, meta=true)
    public static IRubyObject pipe19(ThreadContext context, IRubyObject klass, IRubyObject[] argv, Block block) {
        IRubyObject opt;
        Ruby runtime = context.runtime;
        IRubyObject v2 = opt = context.nil;
        IRubyObject v1 = opt;
        int[] fmode_p = new int[]{0};
        int argc = argv.length;
        switch (argc) {
            case 3: {
                opt = argv[2].convertToHash();
                --argc;
                v2 = argv[1];
                v1 = argv[0];
                break;
            }
            case 2: {
                opt = TypeConverter.checkHashType(runtime, argv[1]);
                if (!opt.isNil()) {
                    --argc;
                } else {
                    v2 = argv[1];
                }
                v1 = argv[0];
                break;
            }
            case 1: {
                opt = TypeConverter.checkHashType(runtime, argv[0]);
                if (!opt.isNil()) {
                    --argc;
                    break;
                }
                v1 = argv[0];
            }
        }
        PosixShim posix = new PosixShim(runtime);
        Channel[] fds = posix.pipe();
        if (fds == null) {
            throw runtime.newErrnoFromErrno(posix.errno, "opening pipe");
        }
        RubyIO r = new RubyIO(runtime, (RubyClass)klass);
        r.initializeCommon(context, new ChannelFD(fds[0], runtime.getPosix(), runtime.getFilenoUtil()), (IRubyObject)runtime.newFixnum(OpenFlags.O_RDONLY), context.nil);
        OpenFile fptr = r.getOpenFileChecked();
        r.setEncoding(context, v1, v2, opt);
        RubyIO w = new RubyIO(runtime, (RubyClass)klass);
        w.initializeCommon(context, new ChannelFD(fds[1], runtime.getPosix(), runtime.getFilenoUtil()), (IRubyObject)runtime.newFixnum(OpenFlags.O_WRONLY), context.nil);
        OpenFile fptr2 = w.getOpenFileChecked();
        fptr2.setSync(true);
        EncodingUtils.extractBinmode(runtime, opt, fmode_p);
        if (EncodingUtils.DEFAULT_TEXTMODE != 0) {
            if ((fptr.getMode() & 0x1000) != 0 && (fmode_p[0] & 4) != 0) {
                fptr.setMode(fptr.getMode() & 0xFFFFEFFF);
            }
            if (Platform.IS_WINDOWS && (fptr.encs.ecflags & EncodingUtils.ECONV_DEFAULT_NEWLINE_DECORATOR) != 0) {
                fptr.encs.ecflags |= 0x100;
            }
        }
        fptr.setMode(fptr.getMode() | fmode_p[0]);
        if (EncodingUtils.DEFAULT_TEXTMODE != 0 && (fptr2.getMode() & 0x1000) != 0 && (fmode_p[0] & 4) != 0) {
            fptr2.setMode(fptr2.getMode() & 0xFFFFEFFF);
        }
        fptr2.setMode(fptr2.getMode() | fmode_p[0]);
        RubyArray ret = runtime.newArray((IRubyObject)r, (IRubyObject)w);
        if (block.isGiven()) {
            return RubyIO.ensureYieldClosePipes(context, ret, r, w, block);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject ensureYieldClosePipes(ThreadContext context, IRubyObject obj, RubyIO r, RubyIO w, Block block) {
        try {
            IRubyObject iRubyObject = block.yield(context, obj);
            return iRubyObject;
        }
        finally {
            RubyIO.pipePairClose(context.runtime, r, w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pipePairClose(Ruby runtime, RubyIO r, RubyIO w) {
        try {
            RubyIO.ioClose(runtime, r);
        }
        finally {
            RubyIO.ioClose(runtime, w);
        }
    }

    /*
     * Loose catch block
     */
    @JRubyMethod(name={"copy_stream"}, required=2, optional=2, meta=true)
    public static IRubyObject copy_stream(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        RubyString path2;
        Ruby runtime = context.runtime;
        IRubyObject arg1 = args2[0];
        IRubyObject arg2 = args2[1];
        RubyInteger length2 = null;
        RubyInteger offset2 = null;
        RubyIO io1 = null;
        RubyIO io2 = null;
        RubyString read2 = null;
        if (args2.length >= 3) {
            length2 = args2[2].convertToInteger();
            if (args2.length == 4) {
                offset2 = args2[3].convertToInteger();
            }
        }
        if (arg1 instanceof RubyString) {
            io1 = (RubyIO)RubyFile.open(context, runtime.getFile(), new IRubyObject[]{arg1}, Block.NULL_BLOCK);
        } else if (arg1 instanceof RubyIO) {
            io1 = (RubyIO)arg1;
        } else if (arg1.respondsTo("to_path")) {
            path2 = (RubyString)TypeConverter.convertToType19(arg1, runtime.getString(), "to_path");
            io1 = (RubyIO)RubyFile.open(context, runtime.getFile(), new IRubyObject[]{path2}, Block.NULL_BLOCK);
        } else if (arg1.respondsTo("read")) {
            read2 = length2 == null ? arg1.callMethod(context, "read", runtime.getNil()).convertToString() : arg1.callMethod(context, "read", length2).convertToString();
        } else {
            throw runtime.newArgumentError("Should be String or IO");
        }
        if (arg2 instanceof RubyString) {
            io2 = (RubyIO)RubyFile.open(context, runtime.getFile(), new IRubyObject[]{arg2, runtime.newString("w")}, Block.NULL_BLOCK);
        } else if (arg2 instanceof RubyIO) {
            io2 = (RubyIO)arg2;
        } else if (arg2.respondsTo("to_path")) {
            path2 = (RubyString)TypeConverter.convertToType19(arg2, runtime.getString(), "to_path");
            io2 = (RubyIO)RubyFile.open(context, runtime.getFile(), new IRubyObject[]{path2, runtime.newString("w")}, Block.NULL_BLOCK);
        } else {
            if (arg2.respondsTo("write")) {
                if (read2 == null) {
                    read2 = length2 == null ? io1.read(context, runtime.getNil()).convertToString() : io1.read(context, length2).convertToString();
                }
                return arg2.callMethod(context, "write", read2);
            }
            throw runtime.newArgumentError("Should be String or IO");
        }
        if (io1 == null) {
            IRubyObject size2 = io2.write(context, read2);
            io2.flush(context);
            return size2;
        }
        io2 = io2.GetWriteIO();
        if (!io1.openFile.isReadable()) {
            throw runtime.newIOError("from IO is not readable");
        }
        if (!io2.openFile.isWritable()) {
            throw runtime.newIOError("to IO is not writable");
        }
        OpenFile fptr = io1.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            long pos2 = fptr.tell(context);
            long size3 = 0L;
            try {
                Object from;
                if (io1.openFile.fileChannel() == null) {
                    long position;
                    long remaining = length2 == null ? -1L : length2.getLongValue();
                    long l = position = offset2 == null ? -1L : offset2.getLongValue();
                    if (io2.openFile.fileChannel() == null) {
                        ReadableByteChannel from2 = io1.openFile.readChannel();
                        WritableByteChannel to = io2.openFile.writeChannel();
                        size3 = RubyIO.transfer(context, from2, to, remaining, position);
                    } else {
                        ReadableByteChannel from3 = io1.openFile.readChannel();
                        FileChannel to = io2.openFile.fileChannel();
                        size3 = RubyIO.transfer(context, from3, to, remaining, position);
                    }
                } else {
                    from = io1.openFile.fileChannel();
                    WritableByteChannel to = io2.openFile.writeChannel();
                    long remaining = length2 == null ? ((FileChannel)from).size() : length2.getLongValue();
                    long position = offset2 == null ? ((FileChannel)from).position() : offset2.getLongValue();
                    size3 = RubyIO.transfer((FileChannel)from, to, remaining, position);
                }
                from = context.runtime.newFixnum(size3);
                return from;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw runtime.newIOErrorFromException(ioe);
            }
            finally {
                if (offset2 != null) {
                    fptr.seek(context, pos2, 0);
                } else {
                    fptr.seek(context, pos2 + size3, 0);
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
    }

    private static long transfer(ThreadContext context, ReadableByteChannel from, FileChannel to, long length2, long position) throws IOException {
        int ret;
        long chunkSize = 0x8000000L;
        long transferred = 0L;
        long startPosition = to.position();
        if (position != -1L && from instanceof NativeSelectableChannel && (ret = context.runtime.getPosix().lseek(((NativeSelectableChannel)((Object)from)).getFD(), position, 0)) == -1) {
            throw context.runtime.newErrnoFromErrno(Errno.valueOf(context.runtime.getPosix().errno()), from.toString());
        }
        if (length2 > 0L) {
            long bytes2;
            while ((bytes2 = to.transferFrom(from, startPosition + transferred, Math.min(chunkSize, length2))) > 0L) {
                transferred += bytes2;
                length2 -= bytes2;
            }
        } else {
            long bytes3;
            while ((bytes3 = to.transferFrom(from, startPosition + transferred, chunkSize)) > 0L) {
                transferred += bytes3;
            }
        }
        to.position(startPosition + transferred);
        return transferred;
    }

    private static long transfer(FileChannel from, WritableByteChannel to, long remaining, long position) throws IOException {
        long count2;
        long n;
        long chunkSize = 0x8000000L;
        long transferred = 0L;
        if (remaining < 0L) {
            remaining = from.size();
        }
        while (remaining > 0L && (n = from.transferTo(position, count2 = Math.min(remaining, chunkSize), to)) != 0L) {
            position += n;
            remaining -= n;
            transferred += n;
        }
        return transferred;
    }

    private static long transfer(ThreadContext context, ReadableByteChannel from, WritableByteChannel to, long length2, long position) throws IOException {
        long n;
        int ret;
        int chunkSize = 8192;
        ByteBuffer buffer = ByteBuffer.allocateDirect(chunkSize);
        long transferred = 0L;
        if (position != -1L && from instanceof NativeSelectableChannel && (ret = context.runtime.getPosix().lseek(((NativeSelectableChannel)((Object)from)).getFD(), position, 0)) == -1) {
            throw context.runtime.newErrnoFromErrno(Errno.valueOf(context.runtime.getPosix().errno()), from.toString());
        }
        do {
            context.pollThreadEvents();
            if (length2 > 0L && length2 < (long)chunkSize) {
                buffer.limit((int)length2);
            }
            if ((n = (long)from.read(buffer)) == -1L) break;
            buffer.flip();
            to.write(buffer);
            buffer.clear();
            transferred += n;
        } while ((length2 <= 0L || (length2 -= n) > 0L) && from.isOpen());
        return transferred;
    }

    @JRubyMethod(name={"try_convert"}, meta=true)
    public static IRubyObject tryConvert(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return arg2.respondsTo("to_io") ? RubyIO.convertToIO(context, arg2) : context.runtime.getNil();
    }

    private static ByteList getNilByteList(Ruby runtime) {
        return ByteList.EMPTY_BYTELIST;
    }

    public void addBlockingThread(RubyThread thread2) {
        OpenFile fptr = this.openFile;
        if (this.openFile != null) {
            this.openFile.addBlockingThread(thread2);
        }
    }

    public void removeBlockingThread(RubyThread thread2) {
        if (this.openFile != null) {
            this.openFile.removeBlockingThread(thread2);
        }
    }

    protected void interruptBlockingThreads() {
        if (this.openFile != null) {
            this.openFile.interruptBlockingThreads();
        }
    }

    protected IOOptions updateIOOptionsFromOptions(ThreadContext context, RubyHash options2, IOOptions ioOptions) {
        if (options2 == null || options2.isNil()) {
            return ioOptions;
        }
        Ruby runtime = context.runtime;
        if (options2.containsKey(runtime.newSymbol("mode"))) {
            ioOptions = this.parseIOOptions(options2.fastARef(runtime.newSymbol("mode")));
        }
        if (options2.containsKey(runtime.newSymbol("binmode")) && options2.fastARef(runtime.newSymbol("binmode")).isTrue()) {
            ioOptions = RubyIO.newIOOptions(runtime, ioOptions, ModeFlags.BINARY);
        }
        if (options2.containsKey(runtime.newSymbol("binmode")) && options2.fastARef(runtime.newSymbol("binmode")).isTrue()) {
            ioOptions = RubyIO.newIOOptions(runtime, ioOptions, ModeFlags.BINARY);
        }
        if (options2.containsKey(runtime.newSymbol("textmode")) && options2.fastARef(runtime.newSymbol("textmode")).isTrue()) {
            ioOptions = RubyIO.newIOOptions(runtime, ioOptions, 0x10000000);
        }
        if (options2.containsKey(runtime.newSymbol("open_args"))) {
            IRubyObject args2 = options2.fastARef(runtime.newSymbol("open_args"));
            RubyArray openArgs = args2.convertToArray();
            for (int i2 = 0; i2 < openArgs.size(); ++i2) {
                IRubyObject arg2 = openArgs.eltInternal(i2);
                if (arg2 instanceof RubyString) {
                    ioOptions = RubyIO.newIOOptions(runtime, arg2.asJavaString());
                    continue;
                }
                if (arg2 instanceof RubyFixnum) {
                    ioOptions = RubyIO.newIOOptions(runtime, ((RubyFixnum)arg2).getLongValue());
                    continue;
                }
                if (!(arg2 instanceof RubyHash)) continue;
                ioOptions = this.updateIOOptionsFromOptions(context, (RubyHash)arg2, ioOptions);
            }
        }
        EncodingUtils.ioExtractEncodingOption(context, this, options2, null);
        return ioOptions;
    }

    public static void checkExecOptions(IRubyObject options2) {
        RubyIO.checkUnsupportedOptions(options2, UNSUPPORTED_SPAWN_OPTIONS, "unsupported exec option");
        RubyIO.checkValidOptions(options2, ALL_SPAWN_OPTIONS);
    }

    public static void checkSpawnOptions(IRubyObject options2) {
        RubyIO.checkUnsupportedOptions(options2, UNSUPPORTED_SPAWN_OPTIONS, "unsupported spawn option");
        RubyIO.checkValidOptions(options2, ALL_SPAWN_OPTIONS);
    }

    public static void checkPopenOptions(IRubyObject options2) {
        RubyIO.checkUnsupportedOptions(options2, UNSUPPORTED_SPAWN_OPTIONS, "unsupported popen option");
    }

    private static void checkUnsupportedOptions(IRubyObject options2, Set<String> unsupported, String error2) {
        if (options2 == null || options2.isNil() || !(options2 instanceof RubyHash)) {
            return;
        }
        RubyHash optsHash = (RubyHash)options2;
        Ruby runtime = optsHash.getRuntime();
        for (String key2 : unsupported) {
            if (!optsHash.containsKey(runtime.newSymbol(key2))) continue;
            runtime.getWarnings().warn(error2 + ": " + key2);
        }
    }

    private static void checkValidOptions(IRubyObject options2, Set<String> valid) {
        if (options2 == null || options2.isNil() || !(options2 instanceof RubyHash)) {
            return;
        }
        RubyHash optsHash = (RubyHash)options2;
        Ruby runtime = optsHash.getRuntime();
        for (Object opt : optsHash.keySet()) {
            if (opt instanceof RubySymbol || opt instanceof RubyFixnum || opt instanceof RubyArray || valid.contains(opt.toString())) continue;
            throw runtime.newTypeError("wrong exec option: " + opt);
        }
    }

    public static RubyArray checkExecEnv(ThreadContext context, RubyHash hash2) {
        return PopenExecutor.checkExecEnv(context, hash2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void obliterateProcess(Process process) {
        int i2 = 0;
        Object waitLock = new Object();
        while (true) {
            if (i2 >= 1000) {
                return;
            }
            process.destroy();
            try {
                process.exitValue();
                break;
            }
            catch (IllegalThreadStateException itse) {
                ++i2;
                Object object = waitLock;
                synchronized (object) {
                    try {
                        waitLock.wait(1L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static ModeFlags newModeFlags(Ruby runtime, long mode2) {
        return RubyIO.newModeFlags(runtime, (int)mode2);
    }

    public static ModeFlags newModeFlags(Ruby runtime, int mode2) {
        try {
            return new ModeFlags(mode2);
        }
        catch (InvalidValueException ive) {
            throw runtime.newErrnoEINVALError();
        }
    }

    public static ModeFlags newModeFlags(Ruby runtime, String mode2) {
        try {
            return new ModeFlags(mode2);
        }
        catch (InvalidValueException ive) {
            throw runtime.newArgumentError("illegal access mode " + mode2);
        }
    }

    public static IOOptions newIOOptions(Ruby runtime, ModeFlags modeFlags) {
        return new IOOptions(modeFlags);
    }

    public static IOOptions newIOOptions(Ruby runtime, long mode2) {
        return RubyIO.newIOOptions(runtime, (int)mode2);
    }

    public static IOOptions newIOOptions(Ruby runtime, int mode2) {
        try {
            ModeFlags modeFlags = new ModeFlags(mode2);
            return new IOOptions(modeFlags);
        }
        catch (InvalidValueException ive) {
            throw runtime.newErrnoEINVALError();
        }
    }

    public static IOOptions newIOOptions(Ruby runtime, String mode2) {
        try {
            return new IOOptions(runtime, mode2);
        }
        catch (InvalidValueException ive) {
            throw runtime.newArgumentError("illegal access mode " + mode2);
        }
    }

    public static IOOptions newIOOptions(Ruby runtime, IOOptions oldFlags, int orOflags) {
        try {
            return new IOOptions(new ModeFlags(oldFlags.getModeFlags().getFlags() | orOflags));
        }
        catch (InvalidValueException ive) {
            throw runtime.newErrnoEINVALError();
        }
    }

    @Deprecated
    public IRubyObject readline(ThreadContext context, IRubyObject[] args2) {
        return args2.length == 0 ? this.readline(context) : this.readline(context, args2[0]);
    }

    @Override
    public void setEnc2(Encoding enc2) {
        this.openFile.encs.enc2 = enc2;
    }

    @Override
    public void setEnc(Encoding enc) {
        this.openFile.encs.enc = enc;
    }

    @Override
    public void setEcflags(int ecflags) {
        this.openFile.encs.ecflags = ecflags;
    }

    @Override
    public int getEcflags() {
        return this.openFile.encs.ecflags;
    }

    @Override
    public void setEcopts(IRubyObject ecopts) {
        this.openFile.encs.ecopts = ecopts;
    }

    @Override
    public IRubyObject getEcopts() {
        return this.openFile.encs.ecopts;
    }

    @Override
    public void setBOM(boolean bom) {
        this.openFile.setBOM(bom);
    }

    @Override
    public boolean getBOM() {
        return this.openFile.isBOM();
    }

    protected RubyIO setAscii8bitBinmode() {
        OpenFile fptr = this.getOpenFileChecked();
        fptr.ascii8bitBinmode(this.getRuntime());
        return this;
    }

    public OpenFile MakeOpenFile() {
        Ruby runtime = this.getRuntime();
        if (this.openFile != null) {
            this.rbIoClose(runtime);
            RubyIO.rb_io_fptr_finalize(runtime, this.openFile);
            this.openFile = null;
        }
        this.openFile = new OpenFile(runtime.getNil());
        runtime.addInternalFinalizer(this.openFile);
        return this.openFile;
    }

    private static int rb_io_fptr_finalize(Ruby runtime, OpenFile fptr) {
        if (fptr == null) {
            return 0;
        }
        fptr.setPath(null);
        if (fptr.fd() != null) {
            fptr.cleanup(runtime, true);
        }
        fptr.write_lock = null;
        if (fptr.rbuf.ptr != null) {
            fptr.rbuf.ptr = null;
        }
        if (fptr.wbuf.ptr != null) {
            fptr.wbuf.ptr = null;
        }
        fptr.clearCodeConversion();
        return 1;
    }

    @Deprecated
    public IRubyObject getline(Ruby runtime, ByteList separator) {
        return this.getline(runtime.getCurrentContext(), runtime.newString(separator), -1L, null);
    }

    @Deprecated
    public IRubyObject getline(Ruby runtime, ByteList separator, long limit2) {
        return this.getline(runtime.getCurrentContext(), runtime.newString(separator), limit2, null);
    }

    @Deprecated
    private IRubyObject getline(ThreadContext context, IRubyObject separator, ByteListCache cache) {
        return this.getline(context, separator, -1L, cache);
    }

    @Deprecated
    public IRubyObject getline(ThreadContext context, ByteList separator) {
        return this.getline(context, RubyString.newString(context.runtime, separator), -1L, null);
    }

    @Deprecated
    public IRubyObject getline(ThreadContext context, ByteList separator, long limit2) {
        return this.getline(context, RubyString.newString(context.runtime, separator), limit2, null);
    }

    @Deprecated
    public IRubyObject lines19(ThreadContext context, Block block) {
        return this.lines(context, block);
    }

    @Deprecated
    public IRubyObject each_char19(ThreadContext context, Block block) {
        return this.each_char(context, block);
    }

    @Deprecated
    public IRubyObject chars19(ThreadContext context, Block block) {
        return this.chars(context, block);
    }

    @Deprecated
    public RubyArray readlines19(ThreadContext context, IRubyObject[] args2) {
        return this.readlines(context, args2);
    }

    @Deprecated
    public RubyIO(Ruby runtime, STDIO stdio) {
        super(runtime, runtime.getIO());
        RubyIO tmp = null;
        switch (stdio) {
            case IN: {
                tmp = RubyIO.prepStdio(runtime, runtime.getIn(), (Channel)Channels.newChannel(runtime.getIn()), 1, runtime.getIO(), "<STDIN>");
                break;
            }
            case OUT: {
                tmp = RubyIO.prepStdio(runtime, runtime.getOut(), (Channel)Channels.newChannel(runtime.getOut()), 2, runtime.getIO(), "<STDOUT>");
                break;
            }
            case ERR: {
                tmp = RubyIO.prepStdio(runtime, runtime.getIn(), (Channel)Channels.newChannel(runtime.getErr()), 10, runtime.getIO(), "<STDERR>");
            }
        }
        this.openFile = tmp.openFile;
        tmp.openFile = null;
    }

    @Deprecated
    public RubyIO(Ruby runtime, RubyClass cls, ShellLauncher.POpenProcess process, RubyHash options2, IOOptions ioOptions) {
        super(runtime, cls);
        ioOptions = this.updateIOOptionsFromOptions(runtime.getCurrentContext(), options2, ioOptions);
        this.openFile = this.MakeOpenFile();
        this.setupPopen(ioOptions.getModeFlags(), process);
    }

    @Deprecated
    public static ModeFlags getIOModes(Ruby runtime, String modesString) {
        return RubyIO.newModeFlags(runtime, modesString);
    }

    @Deprecated
    public static int getIOModesIntFromString(Ruby runtime, String modesString) {
        try {
            return ModeFlags.getOFlagsFromString(modesString);
        }
        catch (InvalidValueException ive) {
            throw runtime.newArgumentError("illegal access mode");
        }
    }

    @Deprecated
    public static IRubyObject writeStatic(ThreadContext context, IRubyObject recv2, IRubyObject[] argv, Block unusedBlock) {
        return RubyIO.write(context, recv2, argv);
    }

    @Deprecated
    public static IRubyObject popen3(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyIO.popen3_19(context, recv2, args2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static IRubyObject popen3_19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyThread[] waitThread;
        final Ruby runtime = context.runtime;
        if (args2.length > 0 && args2[args2.length - 1] instanceof RubyHash) {
            args2 = Arrays.copyOf(args2, args2.length - 1);
        }
        final POpenTuple tuple = RubyIO.popenSpecial(context, args2);
        final long pid2 = ShellLauncher.getPidFromProcess(tuple.process);
        waitThread = new RubyThread[]{new RubyThread(runtime, (RubyClass)runtime.getClassFromPath("Process::WaitThread"), new ThreadedRunnable(){
            volatile Thread javaThread;

            @Override
            public Thread getJavaThread() {
                return this.javaThread;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RubyThread rubyThread;
                this.javaThread = Thread.currentThread();
                while ((rubyThread = waitThread[0]) == null) {
                    Thread.yield();
                }
                ThreadContext context = runtime.getThreadService().registerNewThread(rubyThread);
                rubyThread.op_aset(runtime.newSymbol("pid"), runtime.newFixnum(pid2));
                try {
                    int exitValue = tuple.process.waitFor();
                    RubyProcess.RubyStatus status2 = RubyProcess.RubyStatus.newProcessStatus(runtime, exitValue << 8, pid2);
                    rubyThread.cleanTerminate(status2);
                }
                catch (Throwable t) {
                    rubyThread.exceptionRaised(t);
                }
                finally {
                    rubyThread.dispose();
                }
            }
        })};
        RubyArray yieldArgs = RubyArray.newArrayLight(runtime, tuple.output, tuple.input, tuple.error, waitThread[0]);
        if (block.isGiven()) {
            try {
                IRubyObject iRubyObject = block.yield(context, yieldArgs);
                return iRubyObject;
            }
            finally {
                RubyIO.cleanupPOpen(tuple);
                IRubyObject status2 = waitThread[0].join(IRubyObject.NULL_ARRAY);
                context.setLastExitStatus(status2);
            }
        }
        return yieldArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static IRubyObject popen4(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject iRubyObject;
        Ruby runtime = context.runtime;
        POpenTuple tuple = RubyIO.popenSpecial(context, args2);
        RubyArray yieldArgs = RubyArray.newArrayLight(runtime, runtime.newFixnum(ShellLauncher.getPidFromProcess(tuple.process)), tuple.output, tuple.input, tuple.error);
        if (!block.isGiven()) return yieldArgs;
        try {
            iRubyObject = block.yield(context, yieldArgs);
        }
        catch (Throwable throwable) {
            try {
                RubyIO.cleanupPOpen(tuple);
                context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime, tuple.process.waitFor() << 8, ShellLauncher.getPidFromProcess(tuple.process)));
                throw throwable;
            }
            catch (InterruptedException e) {
                throw runtime.newThreadError("unexpected interrupt");
            }
        }
        RubyIO.cleanupPOpen(tuple);
        context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime, tuple.process.waitFor() << 8, ShellLauncher.getPidFromProcess(tuple.process)));
        return iRubyObject;
    }

    @Deprecated
    private static void cleanupPOpen(POpenTuple tuple) {
        if (tuple.input.openFile.isOpen()) {
            tuple.input.close();
        }
        if (tuple.output.openFile.isOpen()) {
            tuple.output.close();
        }
        if (tuple.error.openFile.isOpen()) {
            tuple.error.close();
        }
    }

    @Deprecated
    public static POpenTuple popenSpecial(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        try {
            ShellLauncher.POpenProcess process = ShellLauncher.popen3(runtime, args2, false);
            RubyIO input = process.getInput() != null ? new RubyIO(runtime, process.getInput()) : new RubyIO(runtime, process.getInputStream());
            RubyIO output = process.getOutput() != null ? new RubyIO(runtime, process.getOutput()) : new RubyIO(runtime, process.getOutputStream());
            RubyIO error2 = process.getError() != null ? new RubyIO(runtime, process.getError()) : new RubyIO(runtime, process.getErrorStream());
            input.getOpenFile().setProcess(process);
            output.getOpenFile().setProcess(process);
            error2.getOpenFile().setProcess(process);
            input.popenSpecial = true;
            output.popenSpecial = true;
            error2.popenSpecial = true;
            return new POpenTuple(input, output, error2, process);
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
    }

    @Deprecated
    public IRubyObject doWriteNonblock(ThreadContext context, IRubyObject[] argv, boolean useException) {
        return this.write_nonblock(context, argv);
    }

    @Deprecated
    public static IRubyObject select_static(ThreadContext context, Ruby runtime, IRubyObject[] args2) {
        return RubyIO.select(context, runtime.getIO(), args2);
    }

    static /* synthetic */ byte[] access$200() {
        return EMPTY_BYTE_ARRAY;
    }

    static {
        String v = SafePropertyAccessor.getProperty("java.VENDOR");
        VENDOR = v == null ? "" : v;
        EMPTY_BYTE_ARRAY = new byte[0];
        RECURSIVE_BYTELIST = ByteList.create("[...]");
        UNSUPPORTED_SPAWN_OPTIONS = new HashSet<String>(Arrays.asList("unsetenv_others", "prgroup", "new_pgroup", "rlimit_resourcename", "chdir", "umask", "in", "out", "err", "close_others"));
        ALL_SPAWN_OPTIONS = new HashSet<String>(Arrays.asList("unsetenv_others", "prgroup", "new_pgroup", "rlimit_resourcename", "chdir", "umask", "in", "out", "err", "close_others"));
        NEWLINE_BYTES = new byte[]{10};
    }

    @Deprecated
    private static class POpenTuple {
        public final RubyIO input;
        public final RubyIO output;
        public final RubyIO error;
        public final Process process;

        public POpenTuple(RubyIO i2, RubyIO o, RubyIO e, Process p2) {
            this.input = i2;
            this.output = o;
            this.error = e;
            this.process = p2;
        }
    }

    private static class ByteListCache {
        private byte[] buffer = RubyIO.access$200();

        private ByteListCache() {
        }

        public void release(ByteList l) {
            this.buffer = l.getUnsafeBytes();
        }

        public ByteList allocate(int size2) {
            ByteList l = new ByteList(this.buffer, 0, size2, false);
            return l;
        }
    }

    private static class Ruby19POpen {
        public final RubyString cmd;
        public final IRubyObject[] cmdPlusArgs;
        public final RubyHash env;

        public Ruby19POpen(Ruby runtime, IRubyObject[] args2) {
            IRubyObject _cmd;
            IRubyObject[] _cmdPlusArgs = null;
            IRubyObject _env = null;
            int firstArg = 0;
            int argc = args2.length;
            if (argc > 0 && !(_env = TypeConverter.checkHashType(runtime, args2[0])).isNil()) {
                if (argc < 2) {
                    throw runtime.newArgumentError(1, 2);
                }
                ++firstArg;
                --argc;
            } else {
                _env = null;
            }
            IRubyObject arg0 = args2[firstArg].checkArrayType();
            if (arg0.isNil()) {
                arg0 = TypeConverter.checkStringType(runtime, args2[firstArg]);
                if (arg0.isNil()) {
                    throw runtime.newTypeError(args2[firstArg], runtime.getString());
                }
                _cmdPlusArgs = null;
                _cmd = arg0;
            } else {
                RubyArray arg0Ary = (RubyArray)arg0;
                if (arg0Ary.isEmpty()) {
                    throw runtime.newArgumentError("wrong number of arguments");
                }
                if (arg0Ary.eltOk(0L) instanceof RubyHash) {
                    _env = arg0Ary.delete_at(0);
                }
                if (arg0Ary.isEmpty()) {
                    throw runtime.newArgumentError("wrong number of arguments");
                }
                if (arg0Ary.size() > 1 && arg0Ary.eltOk(arg0Ary.size() - 1) instanceof RubyHash) {
                    _env = arg0Ary.eltOk(arg0Ary.size() - 1);
                }
                _cmdPlusArgs = arg0Ary.toJavaArray();
                _cmd = _cmdPlusArgs[0];
            }
            if (Platform.IS_WINDOWS) {
                String commandString = _cmd.convertToString().toString().replace('/', '\\');
                _cmd = runtime.newString(commandString);
                if (_cmdPlusArgs != null) {
                    _cmdPlusArgs[0] = _cmd;
                }
            } else {
                _cmd = _cmd.convertToString();
                if (_cmdPlusArgs != null) {
                    _cmdPlusArgs[0] = _cmd;
                }
            }
            this.cmd = (RubyString)_cmd;
            this.cmdPlusArgs = _cmdPlusArgs;
            this.env = (RubyHash)_env;
        }
    }

    private static class Sysopen {
        String fname;
        int oflags;
        int perm;
        Errno errno;

        private Sysopen() {
        }
    }
}

