/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import java.util.Map;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class AsString
extends Operand {
    private final Operand source;

    public AsString(Operand source2) {
        super(OperandType.AS_STRING);
        this.source = source2 == null ? StringLiteral.EMPTY_STRING : source2;
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        return ((IRubyObject)this.source.retrieve(context, self2, currScope, currDynScope, temp)).asString();
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap, boolean force) {
        Operand newSource = this.source.getSimplifiedOperand(valueMap, force);
        return newSource == this.source ? this : new AsString(newSource);
    }

    @Override
    public Operand cloneForInlining(CloneInfo ii) {
        return new AsString(this.source.cloneForInlining(ii));
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        this.source.addUsedVariables(l);
    }

    public Operand getSource() {
        return this.source;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.AsString(this);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getSource());
    }

    public static AsString decode(IRReaderDecoder d) {
        return new AsString(d.decodeOperand());
    }

    public String toString() {
        return "#{" + this.source + "}";
    }
}

