/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.interpreter;

import org.jruby.RubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.ir.IRScope;
import org.jruby.ir.OpClass;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.GetFieldInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LineNumberInstr;
import org.jruby.ir.instructions.NonlocalReturnInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.ReturnBase;
import org.jruby.ir.instructions.RuntimeHelperCall;
import org.jruby.ir.instructions.SearchConstInstr;
import org.jruby.ir.instructions.specialized.OneOperandArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.OneOperandArgNoBlockNoResultCallInstr;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.interpreter.InterpreterEngine;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.runtime.opto.ConstantCache;

public class BodyInterpreterEngine
extends InterpreterEngine {
    @Override
    public IRubyObject interpret(ThreadContext context, IRubyObject self2, InterpreterContext interpreterContext, RubyModule implClass, String name2, Block block, Block.Type blockType) {
        Instr[] instrs = interpreterContext.getInstructions();
        Object[] temp = interpreterContext.allocateTemporaryVariables();
        int n = instrs.length;
        int ipc = 0;
        Throwable exception2 = null;
        StaticScope currScope = interpreterContext.getStaticScope();
        DynamicScope currDynScope = context.getCurrentScope();
        IRScope scope = currScope.getIRScope();
        boolean debug = IRRuntimeHelpers.isDebug();
        while (ipc < n) {
            Instr instr = instrs[ipc];
            ++ipc;
            Operation operation = instr.getOperation();
            if (debug) {
                Interpreter.LOG.info("I: {}", instr);
                ++Interpreter.interpInstrsCount;
            }
            try {
                switch (operation) {
                    case RETURN: {
                        return (IRubyObject)BodyInterpreterEngine.retrieveOp(((ReturnBase)instr).getReturnValue(), context, self2, currDynScope, currScope, temp);
                    }
                    case NONLOCAL_RETURN: {
                        NonlocalReturnInstr ri = (NonlocalReturnInstr)instr;
                        IRubyObject rv = (IRubyObject)BodyInterpreterEngine.retrieveOp(ri.getReturnValue(), context, self2, currDynScope, currScope, temp);
                        return IRRuntimeHelpers.initiateNonLocalReturn(context, currDynScope, blockType, rv);
                    }
                    case LINE_NUM: {
                        context.setLine(((LineNumberInstr)instr).lineNumber);
                        break;
                    }
                    case RECV_SELF: {
                        break;
                    }
                    case RECV_JRUBY_EXC: {
                        BodyInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), exception2);
                        break;
                    }
                    case THROW: {
                        instr.interpret(context, currScope, currDynScope, self2, temp);
                        break;
                    }
                    case PUSH_FRAME: {
                        context.preMethodFrameOnly(implClass, name2, self2, block);
                        context.setCurrentVisibility(Visibility.PUBLIC);
                        break;
                    }
                    case POP_FRAME: {
                        context.popFrame();
                        break;
                    }
                    case PUSH_BINDING: {
                        currDynScope = interpreterContext.newDynamicScope(context);
                        context.pushScope(currDynScope);
                        break;
                    }
                    case POP_BINDING: {
                        context.popScope();
                        break;
                    }
                    case LOAD_FRAME_CLOSURE: {
                        BodyInterpreterEngine.setResult(temp, currDynScope, instr, (Object)context.getFrameBlock());
                        break;
                    }
                    case DEF_INST_METH: {
                        instr.interpret(context, currScope, currDynScope, self2, temp);
                        break;
                    }
                    case PUT_CONST: {
                        instr.interpret(context, currScope, currDynScope, self2, temp);
                        break;
                    }
                    case NORESULT_CALL_1O: {
                        CallBase call2 = (OneOperandArgNoBlockNoResultCallInstr)instr;
                        IRubyObject r = (IRubyObject)BodyInterpreterEngine.retrieveOp(call2.getReceiver(), context, self2, currDynScope, currScope, temp);
                        IRubyObject o = (IRubyObject)call2.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
                        call2.getCallSite().call(context, self2, r, o);
                        break;
                    }
                    case SEARCH_CONST: {
                        SearchConstInstr sci = (SearchConstInstr)instr;
                        ConstantCache cache = sci.getConstantCache();
                        Object result2 = !ConstantCache.isCached(cache) ? sci.cache(context, currScope, currDynScope, self2, temp) : cache.value;
                        BodyInterpreterEngine.setResult(temp, currDynScope, sci.getResult(), result2);
                        break;
                    }
                    case PROCESS_MODULE_BODY: {
                        BodyInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), instr.interpret(context, currScope, currDynScope, self2, temp));
                        break;
                    }
                    case DEF_CLASS: {
                        BodyInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), instr.interpret(context, currScope, currDynScope, self2, temp));
                        break;
                    }
                    case INHERITANCE_SEARCH_CONST: {
                        BodyInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), instr.interpret(context, currScope, currDynScope, self2, temp));
                        break;
                    }
                    case DEF_MODULE: {
                        BodyInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), instr.interpret(context, currScope, currDynScope, self2, temp));
                        break;
                    }
                    case CALL_1O: {
                        CallBase call2 = (OneOperandArgNoBlockCallInstr)instr;
                        IRubyObject r = (IRubyObject)BodyInterpreterEngine.retrieveOp(call2.getReceiver(), context, self2, currDynScope, currScope, temp);
                        IRubyObject o = (IRubyObject)call2.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
                        BodyInterpreterEngine.setResult(temp, currDynScope, ((CallInstr)call2).getResult(), (Object)call2.getCallSite().call(context, self2, r, o));
                        break;
                    }
                    case BNE: {
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case DEF_CLASS_METH: {
                        instr.interpret(context, currScope, currDynScope, self2, temp);
                        break;
                    }
                    case LOAD_IMPLICIT_CLOSURE: {
                        BodyInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), (Object)block);
                        break;
                    }
                    case RECV_RUBY_EXC: {
                        BodyInterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), IRRuntimeHelpers.unwrapRubyException(exception2));
                        break;
                    }
                    case COPY: {
                        BodyInterpreterEngine.setResult(temp, currDynScope, ((CopyInstr)instr).getResult(), BodyInterpreterEngine.retrieveOp(((CopyInstr)instr).getSource(), context, self2, currDynScope, currScope, temp));
                        break;
                    }
                    case JUMP: {
                        ipc = ((JumpInstr)instr).getJumpTarget().getTargetPC();
                        break;
                    }
                    case RUNTIME_HELPER: {
                        RuntimeHelperCall rhc = (RuntimeHelperCall)instr;
                        BodyInterpreterEngine.setResult(temp, currDynScope, rhc.getResult(), (Object)rhc.callHelper(context, currScope, currDynScope, self2, temp, blockType));
                        break;
                    }
                    case GET_FIELD: {
                        IRubyObject result3;
                        GetFieldInstr gfi = (GetFieldInstr)instr;
                        IRubyObject object = (IRubyObject)gfi.getSource().retrieve(context, self2, currScope, currDynScope, temp);
                        VariableAccessor a = gfi.getAccessor(object);
                        IRubyObject iRubyObject = result3 = a == null ? null : (IRubyObject)a.get(object);
                        if (result3 == null) {
                            if (context.runtime.isVerbose()) {
                                context.runtime.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, "instance variable " + gfi.getRef() + " not initialized");
                            }
                            result3 = context.nil;
                        }
                        BodyInterpreterEngine.setResult(temp, currDynScope, gfi.getResult(), (Object)result3);
                        break;
                    }
                    default: {
                        if (instr.getOperation().opClass == OpClass.BRANCH_OP) {
                            ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                            break;
                        }
                        Object result4 = instr.interpret(context, currScope, currDynScope, self2, temp);
                        BodyInterpreterEngine.setResult(temp, currDynScope, instr, result4);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                ipc = instr.getRPC();
                if (debug) {
                    Interpreter.LOG.info("in : " + interpreterContext.getStaticScope().getIRScope() + ", caught Java throwable: " + t + "; excepting instr: " + instr, new Object[0]);
                    Interpreter.LOG.info("ipc for rescuer: " + ipc, new Object[0]);
                }
                if (ipc == -1) {
                    Helpers.throwException(t);
                    continue;
                }
                exception2 = t;
            }
        }
        throw context.runtime.newRuntimeError("BUG: interpreter fell through to end unexpectedly");
    }

    @Override
    public IRubyObject interpret(ThreadContext context, IRubyObject self2, InterpreterContext interpreterContext, RubyModule implClass, String name2, IRubyObject[] args2, Block block, Block.Type blockType) {
        return this.interpret(context, self2, interpreterContext, implClass, name2, block, blockType);
    }
}

