/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.util.ArrayList;
import java.util.List;
import org.jruby.ir.IRFor;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.interpreter.ClosureInterpreterContext;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.ClosureLocalVariable;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.TemporaryClosureVariable;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.TemporaryVariableType;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.InterpretedIRBlockBody;
import org.jruby.runtime.Signature;

public class IRClosure
extends IRScope {
    public final Label startLabel;
    public final Label endLabel;
    public final int closureId;
    private boolean isBeginEndBlock;
    private String[] parameterList;
    private Signature signature;
    private IRBlockBody body;
    private Handle handle;

    protected IRClosure(IRManager manager, IRScope lexicalParent, String fileName, int lineNumber, StaticScope staticScope, String prefix) {
        super(manager, lexicalParent, null, fileName, lineNumber, staticScope);
        this.startLabel = this.getNewLabel(prefix + "START");
        this.endLabel = this.getNewLabel(prefix + "END");
        this.closureId = lexicalParent.getNextClosureId();
        this.setName(prefix + this.closureId);
        this.body = null;
        this.parameterList = new String[0];
    }

    protected IRClosure(IRClosure c, IRScope lexicalParent, int closureId, String fullName) {
        super(c, lexicalParent);
        this.closureId = closureId;
        super.setName(fullName);
        this.startLabel = this.getNewLabel(this.getName() + "_START");
        this.endLabel = this.getNewLabel(this.getName() + "_END");
        this.body = this.getManager().isDryRun() ? null : new InterpretedIRBlockBody(this, c.body.getSignature());
        this.signature = c.signature;
    }

    public IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, Signature signature) {
        this(manager, lexicalParent, lineNumber, staticScope, signature, "_CLOSURE_");
    }

    public IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, Signature signature, String prefix) {
        this(manager, lexicalParent, lineNumber, staticScope, signature, prefix, false);
    }

    public IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, Signature signature, String prefix, boolean isBeginEndBlock) {
        this(manager, lexicalParent, lexicalParent.getFileName(), lineNumber, staticScope, prefix);
        this.signature = signature;
        lexicalParent.addClosure(this);
        if (this.getManager().isDryRun()) {
            this.body = null;
        } else {
            this.body = new InterpretedIRBlockBody(this, signature);
            if (staticScope != null && !isBeginEndBlock) {
                staticScope.setIRScope(this);
                staticScope.setScopeType(this.getScopeType());
            }
        }
    }

    @Override
    public InterpreterContext allocateInterpreterContext(List<Instr> instructions) {
        this.interpreterContext = new ClosureInterpreterContext(this, instructions);
        return this.interpreterContext;
    }

    public void setBeginEndBlock() {
        this.isBeginEndBlock = true;
    }

    @Override
    public boolean isBeginEndBlock() {
        return this.isBeginEndBlock;
    }

    public void setParameterList(String[] parameterList) {
        this.parameterList = parameterList;
        if (!this.getManager().isDryRun()) {
            this.body.setParameterList(parameterList);
        }
    }

    public String[] getParameterList() {
        return this.parameterList;
    }

    @Override
    public int getNextClosureId() {
        return this.getLexicalParent().getNextClosureId();
    }

    @Override
    public LocalVariable getNewFlipStateVariable() {
        throw new RuntimeException("Cannot get flip variables from closures.");
    }

    @Override
    public TemporaryLocalVariable createTemporaryVariable() {
        return this.getNewTemporaryVariable(TemporaryVariableType.CLOSURE);
    }

    @Override
    public TemporaryLocalVariable getNewTemporaryVariable(TemporaryVariableType type2) {
        if (type2 == TemporaryVariableType.CLOSURE) {
            ++this.temporaryVariableIndex;
            return new TemporaryClosureVariable(this.closureId, this.temporaryVariableIndex);
        }
        return super.getNewTemporaryVariable(type2);
    }

    @Override
    public Label getNewLabel() {
        return this.getNewLabel("CL" + this.closureId + "_LBL");
    }

    @Override
    public IRScopeType getScopeType() {
        return IRScopeType.CLOSURE;
    }

    @Override
    public boolean isTopLocalVariableScope() {
        return false;
    }

    @Override
    public boolean isFlipScope() {
        return false;
    }

    public String toStringBody() {
        return this.getName() + " = {\n" + this.toStringInstrs() + "\n}\n\n";
    }

    public BlockBody getBlockBody() {
        return this.body;
    }

    @Override
    protected LocalVariable findExistingLocalVariable(String name2, int scopeDepth) {
        LocalVariable lvar = this.lookupExistingLVar(name2);
        if (lvar != null) {
            return lvar;
        }
        int newDepth = scopeDepth - 1;
        return newDepth >= 0 ? this.getLexicalParent().findExistingLocalVariable(name2, newDepth) : null;
    }

    @Override
    public LocalVariable getNewLocalVariable(String name2, int depth) {
        if (depth == 0 && !(this instanceof IRFor)) {
            ClosureLocalVariable lvar = new ClosureLocalVariable(name2, 0, this.getStaticScope().addVariableThisScope(name2));
            this.localVars.put(name2, lvar);
            return lvar;
        }
        IRScope s2 = this;
        int d = depth;
        while (true) {
            if (s2 instanceof IRFor) {
                ++depth;
                s2 = s2.getLexicalParent();
                continue;
            }
            if (--d >= 0) {
                s2 = s2.getLexicalParent();
            }
            if (d < 0) break;
        }
        return s2.getNewLocalVariable(name2, 0).cloneForDepth(depth);
    }

    @Override
    public LocalVariable getLocalVariable(String name2, int depth) {
        LocalVariable lvar;
        IRScope s2 = this;
        int d = depth;
        while (true) {
            if (s2 instanceof IRFor) {
                ++depth;
                s2 = s2.getLexicalParent();
                continue;
            }
            lvar = s2.lookupExistingLVar(name2);
            if (--d >= 0) {
                s2 = s2.getLexicalParent();
            }
            if (lvar != null || d < 0) break;
        }
        if (lvar == null) {
            lvar = s2.getNewLocalVariable(name2, 0).cloneForDepth(depth);
        } else {
            int lvarDepth = depth - (d + 1);
            if (lvar.getScopeDepth() != lvarDepth) {
                lvar = lvar.cloneForDepth(lvarDepth);
            }
        }
        return lvar;
    }

    protected IRClosure cloneForInlining(CloneInfo ii, IRClosure clone) {
        clone.setParameterList(this.parameterList);
        clone.isBeginEndBlock = this.isBeginEndBlock;
        SimpleCloneInfo clonedII = ii.cloneForCloningClosure(clone);
        ArrayList<Instr> newInstrs = new ArrayList<Instr>(this.interpreterContext.getInstructions().length);
        for (Instr i2 : this.interpreterContext.getInstructions()) {
            newInstrs.add(i2.clone(clonedII));
        }
        clone.allocateInterpreterContext(newInstrs);
        return clone;
    }

    public IRClosure cloneForInlining(CloneInfo ii) {
        IRClosure clonedClosure;
        IRScope lexicalParent = ii.getScope();
        if (ii instanceof SimpleCloneInfo && !((SimpleCloneInfo)ii).isEnsureBlockCloneMode()) {
            clonedClosure = new IRClosure(this, lexicalParent, this.closureId, this.getName());
        } else {
            int id2 = lexicalParent.getNextClosureId();
            String fullName = lexicalParent.getName() + "_CLOSURE_CLONE_" + id2;
            clonedClosure = new IRClosure(this, lexicalParent, id2, fullName);
        }
        lexicalParent.addClosure(clonedClosure);
        return this.cloneForInlining(ii, clonedClosure);
    }

    @Override
    public void setName(String name2) {
        super.setName(this.getLexicalParent().getName() + name2);
    }

    public Arity getArity() {
        return this.signature.arity();
    }

    public Signature getSignature() {
        return this.signature;
    }

    public void setHandle(Handle handle) {
        this.handle = handle;
    }

    public Handle getHandle() {
        return this.handle;
    }
}

