/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.bsf;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.BSFEngineImpl;
import org.apache.bsf.util.BSFFunctions;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EmbedRubyObjectAdapter;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.PathType;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.util.SystemPropertyCatcher;
import org.jruby.embed.variable.BiVariable;
import org.jruby.embed.variable.VariableInterceptor;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyEngine
extends BSFEngineImpl {
    private ScriptingContainer container;

    public Object apply(String file2, int line, int col, Object funcBody, Vector paramNames, Vector args2) {
        ThreadContext context = this.container.getProvider().getRuntime().getCurrentContext();
        try {
            if (paramNames != null && args2 != null) {
                for (int i2 = 0; i2 < paramNames.size(); ++i2) {
                    Object o = paramNames.get(i2);
                    if (!(o instanceof String)) continue;
                    String name2 = (String)o;
                    this.container.put(name2, args2.get(i2));
                }
            }
            return this.run(file2, line, funcBody);
        }
        catch (StackOverflowError soe) {
            throw context.runtime.newSystemStackError("stack level too deep", soe);
        }
    }

    private Object run(String fileinfo, int line, Object scriptUnit) {
        EmbedEvalUnit unit = null;
        if (scriptUnit instanceof String) {
            unit = this.container.parse(scriptUnit.toString(), line);
        } else if (scriptUnit instanceof Reader) {
            unit = this.container.parse((Reader)scriptUnit, fileinfo, line);
        } else if (scriptUnit instanceof InputStream) {
            unit = this.container.parse((InputStream)scriptUnit, fileinfo, line);
        } else if (scriptUnit instanceof PathType) {
            unit = this.container.parse((PathType)((Object)scriptUnit), fileinfo, line);
        }
        if (unit == null) {
            return null;
        }
        IRubyObject ret = unit.run();
        return JavaEmbedUtils.rubyToJava(ret);
    }

    public Object eval(String file2, int line, int col, Object expr) throws BSFException {
        try {
            return this.run(file2, line, expr);
        }
        catch (Exception excptn) {
            throw new BSFException(100, "Exception", (Throwable)excptn);
        }
    }

    public void exec(String file2, int line, int col, Object expr) throws BSFException {
        try {
            this.run(file2, line, expr);
        }
        catch (Exception excptn) {
            throw new BSFException(100, "Exception", (Throwable)excptn);
        }
    }

    public Object call(Object recv2, String method, Object[] args2) throws BSFException {
        try {
            EmbedRubyObjectAdapter adapter = this.container.newObjectAdapter();
            if (args2 == null) {
                return adapter.callMethod(recv2, method, Object.class);
            }
            return adapter.callMethod(recv2, method, args2, Object.class);
        }
        catch (Exception excptn) {
            throw new BSFException(100, excptn.getMessage(), (Throwable)excptn);
        }
    }

    public void initialize(BSFManager manager, String language, Vector someDeclaredBeans) throws BSFException {
        super.initialize(manager, language, someDeclaredBeans);
        LocalContextScope scope = SystemPropertyCatcher.getScope(LocalContextScope.SINGLETON);
        LocalVariableBehavior behavior = LocalVariableBehavior.BSF;
        this.container = new ScriptingContainer(scope, behavior);
        SystemPropertyCatcher.setConfiguration(this.container);
        Ruby runtime = this.container.getProvider().getRuntime();
        if (someDeclaredBeans != null && someDeclaredBeans.size() > 0) {
            for (int i2 = 0; i2 < someDeclaredBeans.size(); ++i2) {
                BSFDeclaredBean bean = (BSFDeclaredBean)someDeclaredBeans.get(i2);
                this.setVariable(bean);
            }
        }
        runtime.getGlobalVariables().defineReadonly("$bsf", new FunctionsGlobalVariable(runtime, new BSFFunctions(manager, (BSFEngine)this)), GlobalVariable.Scope.GLOBAL);
    }

    private void setVariable(BSFDeclaredBean bean) {
        String name2 = bean.name;
        if ("$bsf".equals(name2)) {
            return;
        }
        if (!name2.startsWith("$")) {
            name2 = "$".concat(name2);
        }
        RubyObject receiver2 = (RubyObject)this.container.getProvider().getRuntime().getTopSelf();
        BiVariable v = VariableInterceptor.getVariableInstance(LocalVariableBehavior.BSF, receiver2, name2, bean.bean, bean.type);
        this.container.getVarMap().setVariable(receiver2, v);
    }

    private List<String> getClassPath(BSFManager manager) {
        String classpath = manager.getClassPath();
        String s2 = System.getProperty("org.jruby.embed.class.path");
        if (s2 != null) {
            classpath = classpath + File.pathSeparator + s2;
        }
        return Arrays.asList(classpath.split(System.getProperty("path.separator")));
    }

    public void declareBean(BSFDeclaredBean bean) throws BSFException {
        assert (bean != null);
        this.setVariable(bean);
    }

    public void undeclareBean(BSFDeclaredBean bean) throws BSFException {
        assert (bean != null);
        String name2 = bean.name;
        if (!name2.startsWith("$")) {
            name2 = "$".concat(name2);
        }
        this.container.getVarMap().remove(name2);
    }

    public void handleException(BSFException bsfExcptn) {
        JRubyEngine.printException(this.container.getProvider().getRuntime(), (Exception)bsfExcptn.getTargetException());
    }

    private static void printException(Ruby runtime, Exception exception2) {
        assert (exception2 != null);
        if (exception2 instanceof RaiseException) {
            JumpException je = (JumpException)exception2;
            if (je instanceof RaiseException) {
                runtime.printError(((RaiseException)je).getException());
            } else if (je instanceof JumpException.BreakJump) {
                runtime.getErrorStream().println("break without block.");
            } else if (je instanceof JumpException.ReturnJump) {
                runtime.getErrorStream().println("return without block.");
            }
        }
    }

    public void terminate() {
        this.container.getVarMap().clear();
        this.container.terminate();
        super.terminate();
    }

    private static class FunctionsGlobalVariable
    implements IAccessor {
        private final Ruby runtime;
        private final BSFFunctions functions;

        public FunctionsGlobalVariable(Ruby runtime, BSFFunctions functions) {
            this.runtime = runtime;
            this.functions = functions;
        }

        @Override
        public IRubyObject getValue() {
            IRubyObject result2 = JavaUtil.convertJavaToRuby(this.runtime, this.functions, BSFFunctions.class);
            return result2 instanceof JavaObject ? Java.wrap(this.runtime, result2) : result2;
        }

        @Override
        public IRubyObject setValue(IRubyObject value2) {
            return value2;
        }
    }
}

