/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.subsystems.ObjectSpaceManager;

public abstract class RubyRange
extends RubyBasicObject {
    protected final boolean excludeEnd;

    public RubyRange(RubyClass rangeClass, boolean excludeEnd) {
        super(rangeClass);
        this.excludeEnd = excludeEnd;
    }

    public boolean doesExcludeEnd() {
        return this.excludeEnd;
    }

    public static class ObjectRange
    extends RubyRange {
        private final Object begin;
        private final Object end;

        public ObjectRange(RubyClass rangeClass, Object begin2, Object end2, boolean excludeEnd) {
            super(rangeClass, excludeEnd);
            this.begin = begin2;
            this.end = end2;
        }

        public Object getBegin() {
            return this.begin;
        }

        public Object getEnd() {
            return this.end;
        }

        @Override
        public void visitObjectGraphChildren(ObjectSpaceManager.ObjectGraphVisitor visitor) {
            if (this.begin instanceof RubyBasicObject) {
                ((RubyBasicObject)this.begin).visitObjectGraph(visitor);
            }
            if (this.end instanceof RubyBasicObject) {
                ((RubyBasicObject)this.end).visitObjectGraph(visitor);
            }
        }
    }

    public static class LongFixnumRange
    extends RubyRange {
        private final long begin;
        private final long end;

        public LongFixnumRange(RubyClass rangeClass, long begin2, long end2, boolean excludeEnd) {
            super(rangeClass, excludeEnd);
            this.begin = begin2;
            this.end = end2;
        }

        public final long getBegin() {
            return this.begin;
        }

        public final long getEnd() {
            return this.end;
        }

        public final long getExclusiveEnd() {
            if (this.excludeEnd) {
                return this.end;
            }
            return this.end + 1L;
        }
    }

    public static class IntegerFixnumRange
    extends RubyRange {
        private final int begin;
        private final int end;

        public IntegerFixnumRange(RubyClass rangeClass, int begin2, int end2, boolean excludeEnd) {
            super(rangeClass, excludeEnd);
            this.begin = begin2;
            this.end = end2;
        }

        public final int getBegin() {
            return this.begin;
        }

        public final int getEnd() {
            return this.end;
        }

        public final int getExclusiveEnd() {
            if (this.excludeEnd) {
                return this.end;
            }
            return this.end + 1;
        }
    }
}

