/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.backtrace;

import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.List;
import org.jruby.truffle.nodes.CoreSourceSection;
import org.jruby.truffle.runtime.DebugOperations;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Activation;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.backtrace.BacktraceFormatter;
import org.jruby.truffle.runtime.control.TruffleFatalException;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.util.cli.Options;

public class DebugBacktraceFormatter
implements BacktraceFormatter {
    @Override
    public String[] format(RubyContext context, RubyException exception2, Backtrace backtrace2) {
        try {
            List<Activation> activations = backtrace2.getActivations();
            ArrayList<String> lines2 = new ArrayList<String>();
            if (exception2 != null) {
                lines2.add(String.format("%s (%s)", exception2.getMessage(), exception2.getLogicalClass().getName()));
            }
            for (Activation activation : activations) {
                lines2.add(DebugBacktraceFormatter.formatLine(context, activation));
            }
            return lines2.toArray(new String[lines2.size()]);
        }
        catch (Exception e) {
            throw new TruffleFatalException("Exception while trying to format a Ruby call stack", e);
        }
    }

    private static String formatLine(RubyContext context, Activation activation) {
        StringBuilder builder = new StringBuilder();
        builder.append(DebugBacktraceFormatter.formatBasicLine(activation));
        MaterializedFrame frame = activation.getMaterializedFrame();
        FrameDescriptor frameDescriptor = frame.getFrameDescriptor();
        builder.append(" self=");
        builder.append(DebugBacktraceFormatter.debugString(context, RubyArguments.getSelf(frame.getArguments())));
        for (Object identifier : frameDescriptor.getIdentifiers()) {
            if (!(identifier instanceof String)) continue;
            builder.append(" ");
            builder.append(identifier);
            builder.append("=");
            builder.append(DebugBacktraceFormatter.debugString(context, frame.getValue(frameDescriptor.findFrameSlot(identifier))));
        }
        return builder.toString();
    }

    public static String formatBasicLine(Activation activation) {
        StringBuilder builder = new StringBuilder();
        builder.append("    at ");
        SourceSection sourceSection = activation.getCallNode().getEncapsulatingSourceSection();
        if (sourceSection instanceof CoreSourceSection) {
            CoreSourceSection coreSourceSection = (CoreSourceSection)sourceSection;
            builder.append(coreSourceSection.getClassName());
            builder.append("#");
            builder.append(coreSourceSection.getMethodName());
        } else {
            builder.append(sourceSection.getSource().getName());
            builder.append(":");
            builder.append(sourceSection.getStartLine());
            builder.append(":in '");
            builder.append(sourceSection.getIdentifier());
            builder.append("'");
        }
        return builder.toString();
    }

    public static String debugString(RubyContext context, Object value2) {
        if (value2 == null) {
            return "*null*";
        }
        try {
            String string2 = DebugOperations.inspect(context, value2);
            if (string2.length() <= Options.TRUFFLE_BACKTRACE_MAX_VALUE_LENGTH.load()) {
                return string2;
            }
            return string2.substring(0, Options.TRUFFLE_BACKTRACE_MAX_VALUE_LENGTH.load()) + "\u2026";
        }
        catch (Throwable t) {
            return "*error*";
        }
    }
}

