/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objectstorage;

import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.object.BooleanLocation;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.nodes.objectstorage.WriteObjectFieldChainNode;
import org.jruby.truffle.nodes.objectstorage.WriteObjectFieldNode;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@NodeInfo(cost=NodeCost.POLYMORPHIC)
public class WriteBooleanObjectFieldNode
extends WriteObjectFieldChainNode {
    private final Shape expectedLayout;
    private final Shape newLayout;
    private final BooleanLocation storageLocation;

    public WriteBooleanObjectFieldNode(Shape expectedLayout, Shape newLayout, BooleanLocation storageLocation, WriteObjectFieldNode next2) {
        super(next2);
        this.expectedLayout = expectedLayout;
        this.newLayout = newLayout;
        this.storageLocation = storageLocation;
    }

    @Override
    public void execute(RubyBasicObject object, boolean value2) {
        block7: {
            try {
                this.expectedLayout.getValidAssumption().check();
                this.newLayout.getValidAssumption().check();
            }
            catch (InvalidAssumptionException e) {
                this.replace(this.next);
                this.next.execute(object, value2);
                return;
            }
            if (object.getObjectLayout() == this.expectedLayout) {
                try {
                    if (this.newLayout == this.expectedLayout) {
                        this.storageLocation.setBoolean(object.getDynamicObject(), value2, this.expectedLayout);
                        break block7;
                    }
                    this.storageLocation.setBoolean(object.getDynamicObject(), value2, this.expectedLayout, this.newLayout);
                }
                catch (FinalLocationException e) {
                    this.replace(this.next, "!final").execute(object, value2);
                }
            } else {
                this.next.execute(object, value2);
            }
        }
    }

    @Override
    public void execute(RubyBasicObject object, Object value2) {
        if (value2 instanceof Boolean) {
            this.execute(object, (Boolean)value2);
        } else {
            this.next.execute(object, value2);
        }
    }
}

