/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods.locals;

import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.methods.locals.FlipFlopStateNode;
import org.jruby.truffle.runtime.RubyArguments;

public class LevelFlipFlopStateNode
extends FlipFlopStateNode {
    private final int level;
    private final FrameSlot frameSlot;

    public LevelFlipFlopStateNode(SourceSection sourceSection, int level2, FrameSlot frameSlot) {
        super(sourceSection);
        this.level = level2;
        this.frameSlot = frameSlot;
    }

    @Override
    public boolean getState(VirtualFrame frame) {
        MaterializedFrame levelFrame = RubyArguments.getDeclarationFrame(frame, this.level);
        try {
            return levelFrame.getBoolean(this.frameSlot);
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void setState(VirtualFrame frame, boolean state2) {
        MaterializedFrame levelFrame = RubyArguments.getDeclarationFrame(frame, this.level);
        levelFrame.setBoolean(this.frameSlot, state2);
    }
}

