/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.methods.UnsupportedOperationBehavior;
import org.jruby.truffle.runtime.DebugOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.control.ThreadExitException;
import org.jruby.truffle.runtime.control.TruffleFatalException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.util.cli.Options;

public class ExceptionTranslatingNode
extends RubyNode {
    private final UnsupportedOperationBehavior unsupportedOperationBehavior;
    @Node.Child
    private RubyNode child;
    private final BranchProfile controlProfile = BranchProfile.create();
    private final BranchProfile rethrowProfile = BranchProfile.create();

    public ExceptionTranslatingNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
        this(context, sourceSection, child, UnsupportedOperationBehavior.TYPE_ERROR);
    }

    public ExceptionTranslatingNode(RubyContext context, SourceSection sourceSection, RubyNode child, UnsupportedOperationBehavior unsupportedOperationBehavior) {
        super(context, sourceSection);
        this.child = child;
        this.unsupportedOperationBehavior = unsupportedOperationBehavior;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        try {
            return this.child.execute(frame);
        }
        catch (ThreadExitException | TruffleFatalException exception2) {
            throw exception2;
        }
        catch (ControlFlowException exception3) {
            this.controlProfile.enter();
            throw exception3;
        }
        catch (RaiseException exception4) {
            this.rethrowProfile.enter();
            throw exception4;
        }
        catch (ArithmeticException exception5) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.translate(exception5));
        }
        catch (UnsupportedSpecializationException exception6) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.translate(exception6));
        }
        catch (Throwable exception7) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.translate(exception7));
        }
    }

    private RubyException translate(ArithmeticException exception2) {
        if (Options.TRUFFLE_EXCEPTIONS_PRINT_JAVA.load().booleanValue()) {
            exception2.printStackTrace();
        }
        return this.getContext().getCoreLibrary().zeroDivisionError(this);
    }

    private RubyException translate(UnsupportedSpecializationException exception2) {
        if (Options.TRUFFLE_EXCEPTIONS_PRINT_JAVA.load().booleanValue()) {
            exception2.printStackTrace();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Truffle doesn't have a case for the ");
        builder.append(exception2.getNode().getClass().getName());
        builder.append(" node with values of type ");
        for (Object value2 : exception2.getSuppliedValues()) {
            builder.append(" ");
            if (value2 instanceof RubyBasicObject) {
                Object store;
                builder.append(((RubyBasicObject)value2).getLogicalClass().getName());
                builder.append("(");
                builder.append(value2.getClass().getName());
                builder.append(")");
                if (value2 instanceof RubyArray) {
                    store = ((RubyArray)value2).getStore();
                    if (store == null) {
                        builder.append("[null]");
                        continue;
                    }
                    builder.append("[");
                    builder.append(store.getClass().getName());
                    builder.append("]");
                    continue;
                }
                if (!(value2 instanceof RubyHash)) continue;
                store = ((RubyHash)value2).getStore();
                if (store == null) {
                    builder.append("[null]");
                    continue;
                }
                builder.append("[");
                builder.append(store.getClass().getName());
                builder.append("]");
                continue;
            }
            builder.append(value2.getClass().getName());
        }
        switch (this.unsupportedOperationBehavior) {
            case TYPE_ERROR: {
                return this.getContext().getCoreLibrary().typeError(builder.toString(), this);
            }
            case ARGUMENT_ERROR: {
                return this.getContext().getCoreLibrary().argumentError(builder.toString(), this);
            }
        }
        throw new UnsupportedOperationException();
    }

    public RubyException translate(Throwable throwable) {
        if (Options.TRUFFLE_EXCEPTIONS_PRINT_JAVA.load().booleanValue()) {
            throwable.printStackTrace();
        }
        if (Options.TRUFFLE_PANIC_ON_JAVA_ASSERT.load().booleanValue() && throwable instanceof AssertionError) {
            DebugOperations.panic(this.getContext(), this, throwable.toString());
        }
        return this.getContext().getCoreLibrary().internalError(String.format("%s %s", throwable.getClass().getSimpleName(), throwable.getMessage()), this);
    }
}

