/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.RubyThread;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.control.ThreadExitException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubyThread;
import org.jruby.truffle.runtime.util.Consumer;

@CoreClass(name="Thread")
public abstract class ThreadNodes {

    @CoreMethod(names={"value"})
    public static abstract class ValueNode
    extends CoreMethodNode {
        public ValueNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ValueNode(ValueNode prev) {
            super(prev);
        }

        @Specialization
        public Object value(RubyThread self2) {
            ValueNode.notDesignedForCompilation();
            self2.join();
            if (self2.getException() != null) {
                throw new RaiseException(self2.getException());
            }
            if (self2.getValue() == null) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            return self2.getValue();
        }
    }

    @CoreMethod(names={"stop?"})
    public static abstract class StopNode
    extends CoreMethodNode {
        public StopNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StopNode(StopNode prev) {
            super(prev);
        }

        @Specialization
        public boolean stop(RubyThread self2) {
            StopNode.notDesignedForCompilation();
            return self2.getStatus() == RubyThread.Status.DEAD || self2.getStatus() == RubyThread.Status.SLEEP;
        }
    }

    @CoreMethod(names={"status"})
    public static abstract class StatusNode
    extends CoreMethodNode {
        public StatusNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StatusNode(StatusNode prev) {
            super(prev);
        }

        @Specialization
        public Object status(RubyThread self2) {
            StatusNode.notDesignedForCompilation();
            return new RubyString(this.getContext().getCoreLibrary().getStringClass(), self2.getStatus().bytes);
        }
    }

    @CoreMethod(names={"raise"}, required=1, optional=1)
    public static abstract class RaiseNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode initialize;

        public RaiseNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.initialize = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public RaiseNode(RaiseNode prev) {
            super(prev);
            this.initialize = prev.initialize;
        }

        @Specialization
        public RubyNilClass raise(VirtualFrame frame, RubyThread thread2, RubyString message2, UndefinedPlaceholder undefined) {
            return this.raise(frame, thread2, this.getContext().getCoreLibrary().getRuntimeErrorClass(), message2);
        }

        @Specialization
        public RubyNilClass raise(VirtualFrame frame, final RubyThread thread2, RubyClass exceptionClass, RubyString message2) {
            RubyBasicObject exception2 = exceptionClass.allocate(this);
            this.initialize.call(frame, exception2, "initialize", null, message2);
            if (!(exception2 instanceof RubyException)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("exception class/object expected", this));
            }
            final RaiseException exceptionWrapper = new RaiseException((RubyException)exception2);
            this.getContext().getSafepointManager().pauseAllThreadsAndExecute(new Consumer<RubyThread>(){

                @Override
                public void accept(RubyThread currentThread) {
                    if (currentThread == thread2) {
                        throw exceptionWrapper;
                    }
                }
            });
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"pass"}, onSingleton=true)
    public static abstract class PassNode
    extends CoreMethodNode {
        public PassNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PassNode(PassNode prev) {
            super(prev);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public RubyNilClass pass() {
            RubyThread runningThread = this.getContext().getThreadManager().leaveGlobalLock();
            try {
                Thread.yield();
            }
            finally {
                this.getContext().getThreadManager().enterGlobalLock(runningThread);
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"join"})
    public static abstract class JoinNode
    extends CoreMethodNode {
        public JoinNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public JoinNode(JoinNode prev) {
            super(prev);
        }

        @Specialization
        public RubyThread join(RubyThread self2) {
            JoinNode.notDesignedForCompilation();
            self2.join();
            return self2;
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true)
    public static abstract class InitializeNode
    extends CoreMethodNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeNode(InitializeNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass initialize(RubyThread thread2, RubyProc block) {
            InitializeNode.notDesignedForCompilation();
            thread2.initialize(this.getContext(), (RubyNode)this, block);
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"kill"})
    public static abstract class KillNode
    extends CoreMethodNode {
        public KillNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public KillNode(KillNode prev) {
            super(prev);
        }

        @Specialization
        public RubyThread kill(final RubyThread thread2) {
            this.getContext().getSafepointManager().pauseAllThreadsAndExecute(new Consumer<RubyThread>(){

                @Override
                public void accept(RubyThread currentThread) {
                    if (currentThread == thread2) {
                        throw new ThreadExitException();
                    }
                }
            });
            return thread2;
        }
    }

    @CoreMethod(names={"exit"}, needsSelf=false)
    public static abstract class ExitInstanceNode
    extends CoreMethodNode {
        public ExitInstanceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ExitInstanceNode(ExitInstanceNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass exit() {
            throw new ThreadExitException();
        }
    }

    @CoreMethod(names={"exit"}, onSingleton=true)
    public static abstract class ExitModuleNode
    extends CoreMethodNode {
        public ExitModuleNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ExitModuleNode(ExitModuleNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass exit() {
            throw new ThreadExitException();
        }
    }

    @CoreMethod(names={"current"}, onSingleton=true)
    public static abstract class CurrentNode
    extends CoreMethodNode {
        public CurrentNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CurrentNode(CurrentNode prev) {
            super(prev);
        }

        @Specialization
        public RubyThread current() {
            CurrentNode.notDesignedForCompilation();
            return this.getContext().getThreadManager().getCurrentThread();
        }
    }

    @CoreMethod(names={"alive?"})
    public static abstract class AliveNode
    extends CoreMethodNode {
        public AliveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AliveNode(AliveNode prev) {
            super(prev);
        }

        @Specialization
        public boolean alive(RubyThread thread2) {
            return thread2.getStatus() != RubyThread.Status.ABORTING && thread2.getStatus() != RubyThread.Status.DEAD;
        }
    }
}

