/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;

@CoreClass(name="Symbol")
public abstract class SymbolNodes {

    @CoreMethod(names={"inspect"})
    public static abstract class InspectNode
    extends CoreMethodNode {
        public InspectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InspectNode(InspectNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString toS(RubySymbol symbol) {
            InspectNode.notDesignedForCompilation();
            return this.getContext().makeString(symbol.getJRubySymbol().inspect(this.getContext().getRuntime().getCurrentContext()).asString().decodeString());
        }
    }

    @CoreMethod(names={"to_s"})
    public static abstract class ToSNode
    extends CoreMethodNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToSNode(ToSNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString toS(RubySymbol symbol) {
            ToSNode.notDesignedForCompilation();
            return this.getContext().makeString(symbol.getJRubySymbol().to_s().asString().decodeString());
        }
    }

    @CoreMethod(names={"to_sym"})
    public static abstract class ToSymNode
    extends CoreMethodNode {
        public ToSymNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToSymNode(ToSymNode prev) {
            super(prev);
        }

        @Specialization
        public RubySymbol toSym(RubySymbol symbol) {
            return symbol;
        }
    }

    @CoreMethod(names={"to_proc"})
    public static abstract class ToProcNode
    extends CoreMethodNode {
        public ToProcNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToProcNode(ToProcNode prev) {
            super(prev);
        }

        @Specialization
        public RubyProc toProc(RubySymbol symbol) {
            ToProcNode.notDesignedForCompilation();
            return symbol.toProc(Truffle.getRuntime().getCallerFrame().getCallNode().getEncapsulatingSourceSection(), this);
        }
    }

    @CoreMethod(names={"empty?"})
    public static abstract class EmptyNode
    extends CoreMethodNode {
        public EmptyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EmptyNode(EmptyNode prev) {
            super(prev);
        }

        @Specialization
        public boolean empty(RubySymbol symbol) {
            EmptyNode.notDesignedForCompilation();
            return symbol.toString().isEmpty();
        }
    }

    @CoreMethod(names={"all_symbols"}, onSingleton=true)
    public static abstract class AllSymbolsNode
    extends CoreMethodNode {
        public AllSymbolsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AllSymbolsNode(AllSymbolsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray allSymbols() {
            AllSymbolsNode.notDesignedForCompilation();
            RubyArray array = new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
            for (RubySymbol s2 : this.getContext().getSymbolTable().getSymbolsTable().values()) {
                array.slowPush(s2);
            }
            return array;
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodNode {
        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CompareNode(CompareNode prev) {
            super(prev);
        }

        @Specialization
        public int compare(RubySymbol a, RubySymbol b2) {
            CompareNode.notDesignedForCompilation();
            return a.toString().compareTo(b2.toString());
        }
    }

    @CoreMethod(names={"==", "==="}, required=1)
    public static abstract class EqualNode
    extends CoreMethodNode {
        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EqualNode(EqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean equal(RubySymbol a, RubySymbol b2) {
            return a == b2;
        }

        @Specialization
        public boolean equal(RubySymbol a, RubyString b2) {
            EqualNode.notDesignedForCompilation();
            return a.toString().equals(b2.toString());
        }

        @Specialization
        public boolean equal(RubySymbol a, int b2) {
            EqualNode.notDesignedForCompilation();
            return a.toString().equals(Integer.toString(b2));
        }

        @Specialization
        public boolean equal(RubySymbol a, long b2) {
            EqualNode.notDesignedForCompilation();
            return a.toString().equals(Long.toString(b2));
        }

        @Specialization(guards={"notSymbol"})
        public boolean equal(RubySymbol a, Object b2) {
            return false;
        }

        protected boolean notSymbol(RubySymbol a, Object b2) {
            return !(b2 instanceof RubySymbol);
        }
    }
}

