/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.FalseClassNodes;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=FalseClassNodes.class)
public final class FalseClassNodesFactory {
    public static List<NodeFactory<? extends UnaryCoreMethodNode>> getFactories() {
        return Arrays.asList(AndNodeFactory.getInstance(), OrXorNodeFactory.getInstance());
    }

    @GeneratedBy(value=FalseClassNodes.OrXorNode.class)
    public static final class OrXorNodeFactory
    extends NodeFactoryBase<FalseClassNodes.OrXorNode> {
        private static OrXorNodeFactory orXorNodeFactoryInstance;

        private OrXorNodeFactory() {
            super(FalseClassNodes.OrXorNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        @Override
        public FalseClassNodes.OrXorNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return OrXorNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FalseClassNodes.OrXorNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return OrXorUninitializedNode.create0(context, sourceSection, operand);
        }

        public static NodeFactory<FalseClassNodes.OrXorNode> getInstance() {
            if (orXorNodeFactoryInstance == null) {
                orXorNodeFactoryInstance = new OrXorNodeFactory();
            }
            return orXorNodeFactoryInstance;
        }

        @GeneratedBy(value=FalseClassNodes.OrXorNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class OrXorPolymorphicNode
        extends OrXorBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> operandPolymorphicType;

            OrXorPolymorphicNode(OrXorBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object operandValue = this.operand.execute(frameValue);
                return this.next0.executeChained0(frameValue, operandValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.operandPolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object operandValue) {
                return this.next0.executeChained0(frameValue, operandValue);
            }
        }

        @GeneratedBy(value=FalseClassNodes.OrXorNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class OrXorBooleanNode
        extends OrXorBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(OrXorBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE}, 0, 0);

            OrXorBooleanNode(OrXorBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean operandValue;
                try {
                    operandValue = this.operand.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected operandValue instanceof boolean");
                }
                return super.orXor(operandValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object operandValue) {
                if (RubyTypesGen.RUBYTYPES.isBoolean(operandValue)) {
                    boolean operandValueCast = RubyTypesGen.RUBYTYPES.asBoolean(operandValue);
                    return super.orXor(operandValueCast);
                }
                return this.next0.executeChained0(frameValue, operandValue);
            }

            static FalseClassNodes.OrXorNode create0(FalseClassNodes.OrXorNode current2) {
                return new OrXorBooleanNode((OrXorBaseNode)current2);
            }
        }

        @GeneratedBy(value=FalseClassNodes.OrXorNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class OrXorUninitializedNode
        extends OrXorBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(OrXorUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            OrXorUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection, operand);
            }

            OrXorUninitializedNode(OrXorBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object operandValue = this.operand.execute(frameValue);
                return this.executeUninitialized0(frameValue, operandValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object operandValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, operandValue);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object operandValue) {
                OrXorBaseNode newNode = this.specialize0(operandValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    OrXorBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.operand}, operandValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, operandValue);
            }

            static FalseClassNodes.OrXorNode create0(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                return new OrXorUninitializedNode(context, sourceSection, operand);
            }
        }

        @GeneratedBy(value=FalseClassNodes.OrXorNode.class)
        private static abstract class OrXorBaseNode
        extends FalseClassNodes.OrXorNode
        implements DSLNode {
            @Node.Child
            protected RubyNode operand;
            @Node.Child
            protected OrXorBaseNode next0;

            OrXorBaseNode(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand = super.createCast(operand);
            }

            OrXorBaseNode(OrXorBaseNode copy) {
                super(copy);
            }

            @Override
            public RubyNode getOperand() {
                return this.operand;
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object operandValue, String reason2) {
                String message2;
                OrXorBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                OrXorBaseNode newNode = this.specialize0(operandValue);
                if (newNode == null) {
                    newNode = new OrXorUninitializedNode(this);
                    ((OrXorUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = OrXorBaseNode.createInfo0(reason2, operandValue))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new OrXorUninitializedNode(this), new OrXorPolymorphicNode(this), (OrXorBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, operandValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final OrXorBaseNode specialize0(Object operandValue) {
                if (RubyTypesGen.RUBYTYPES.isBoolean(operandValue)) {
                    return (OrXorBaseNode)OrXorBooleanNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.operand = other == null ? null : ((OrXorBaseNode)other).operand;
                this.next0 = newNext == null ? null : (OrXorBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object operandValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("operandValue").append(" = ").append(operandValue);
                    if (operandValue != null) {
                        builder.append(" (").append(operandValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FalseClassNodes.AndNode.class)
    public static final class AndNodeFactory
    extends NodeFactoryBase<FalseClassNodes.AndNode> {
        private static AndNodeFactory andNodeFactoryInstance;

        private AndNodeFactory() {
            super(FalseClassNodes.AndNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        @Override
        public FalseClassNodes.AndNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return AndNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FalseClassNodes.AndNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return AndObjectNode.create0(context, sourceSection, operand);
        }

        public static NodeFactory<FalseClassNodes.AndNode> getInstance() {
            if (andNodeFactoryInstance == null) {
                andNodeFactoryInstance = new AndNodeFactory();
            }
            return andNodeFactoryInstance;
        }

        @GeneratedBy(value=FalseClassNodes.AndNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AndObjectNode
        extends AndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AndObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);

            AndObjectNode(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection, operand);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object operandValue = this.operand.execute(frameValue);
                return super.and(operandValue);
            }

            static FalseClassNodes.AndNode create0(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                return new AndObjectNode(context, sourceSection, operand);
            }
        }

        @GeneratedBy(value=FalseClassNodes.AndNode.class)
        private static abstract class AndBaseNode
        extends FalseClassNodes.AndNode
        implements DSLNode {
            @Node.Child
            protected RubyNode operand;

            AndBaseNode(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.operand = other == null ? null : ((AndBaseNode)other).operand;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return null;
            }
        }
    }
}

