/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.FixnumOrBignumNode;
import org.jruby.truffle.nodes.core.GeneralDivModNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyString;

@CoreClass(name="Bignum")
public abstract class BignumNodes {

    @CoreMethod(names={"to_s", "inspect"})
    public static abstract class ToSNode
    extends CoreMethodNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToSNode(ToSNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyString toS(RubyBignum value2) {
            return this.getContext().makeString(value2.bigIntegerValue().toString());
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends CoreMethodNode {
        public ToFNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToFNode(ToFNode prev) {
            super(prev);
        }

        @Specialization
        public double toF(RubyBignum value2) {
            return value2.doubleValue();
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodNode {
        public HashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public HashNode(HashNode prev) {
            super(prev);
        }

        @Specialization
        public int hash(RubyBignum self2) {
            return self2.bigIntegerValue().hashCode();
        }
    }

    @CoreMethod(names={"even?"})
    public static abstract class EvenNode
    extends BignumCoreMethodNode {
        public EvenNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EvenNode(EvenNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean even(RubyBignum value2) {
            return value2.bigIntegerValue().getLowestSetBit() != 0;
        }
    }

    @CoreMethod(names={"divmod"}, required=1)
    public static abstract class DivModNode
    extends CoreMethodNode {
        @Node.Child
        private GeneralDivModNode divModNode;

        public DivModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.divModNode = new GeneralDivModNode(context, sourceSection);
        }

        public DivModNode(DivModNode prev) {
            super(prev);
            this.divModNode = prev.divModNode;
        }

        @Specialization
        public RubyArray divMod(RubyBignum a, int b2) {
            return this.divModNode.execute(a, b2);
        }

        @Specialization
        public RubyArray divMod(RubyBignum a, long b2) {
            return this.divModNode.execute(a, b2);
        }

        @Specialization
        public RubyArray divMod(RubyBignum a, RubyBignum b2) {
            return this.divModNode.execute(a, b2);
        }
    }

    @CoreMethod(names={"abs"})
    public static abstract class AbsNode
    extends BignumCoreMethodNode {
        public AbsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AbsNode(AbsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyBignum abs(RubyBignum value2) {
            return value2.abs();
        }
    }

    @CoreMethod(names={">>"}, required=1)
    public static abstract class RightShiftNode
    extends BignumCoreMethodNode {
        private final BranchProfile bLessThanZero = BranchProfile.create();

        public RightShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RightShiftNode(RightShiftNode prev) {
            super(prev);
        }

        @Specialization
        public Object leftShift(RubyBignum a, int b2) {
            if (b2 >= 0) {
                return this.fixnumOrBignum(a.shiftRight(b2));
            }
            this.bLessThanZero.enter();
            return this.fixnumOrBignum(a.shiftLeft(-b2));
        }
    }

    @CoreMethod(names={"<<"}, required=1)
    public static abstract class LeftShiftNode
    extends BignumCoreMethodNode {
        private final BranchProfile bLessThanZero = BranchProfile.create();

        public LeftShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LeftShiftNode(LeftShiftNode prev) {
            super(prev);
        }

        @Specialization
        public Object leftShift(RubyBignum a, int b2) {
            if (b2 >= 0) {
                return this.fixnumOrBignum(a.shiftLeft(b2));
            }
            this.bLessThanZero.enter();
            return this.fixnumOrBignum(a.shiftRight(-b2));
        }
    }

    @CoreMethod(names={"^"}, required=1)
    public static abstract class BitXOrNode
    extends BignumCoreMethodNode {
        public BitXOrNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BitXOrNode(BitXOrNode prev) {
            super(prev);
        }

        @Specialization
        public Object bitXOr(RubyBignum a, int b2) {
            return this.fixnumOrBignum(a.xor(b2));
        }

        @Specialization
        public Object bitXOr(RubyBignum a, long b2) {
            return this.fixnumOrBignum(a.xor(b2));
        }

        @Specialization
        public Object bitXOr(RubyBignum a, RubyBignum b2) {
            return this.fixnumOrBignum(a.xor(b2));
        }
    }

    @CoreMethod(names={"|"}, required=1)
    public static abstract class BitOrNode
    extends BignumCoreMethodNode {
        public BitOrNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BitOrNode(BitOrNode prev) {
            super(prev);
        }

        @Specialization
        public Object bitOr(RubyBignum a, int b2) {
            return this.fixnumOrBignum(a.or(b2));
        }

        @Specialization
        public Object bitOr(RubyBignum a, long b2) {
            return this.fixnumOrBignum(a.or(b2));
        }

        @Specialization
        public Object bitOr(RubyBignum a, RubyBignum b2) {
            return this.fixnumOrBignum(a.or(a));
        }
    }

    @CoreMethod(names={"&"}, required=1)
    public static abstract class BitAndNode
    extends BignumCoreMethodNode {
        public BitAndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BitAndNode(BitAndNode prev) {
            super(prev);
        }

        @Specialization
        public Object bitAnd(RubyBignum a, int b2) {
            return this.fixnumOrBignum(a.and(b2));
        }

        @Specialization
        public Object bitAnd(RubyBignum a, long b2) {
            return this.fixnumOrBignum(a.and(b2));
        }

        @Specialization
        public Object bitAnd(RubyBignum a, RubyBignum b2) {
            return this.fixnumOrBignum(a.and(b2));
        }
    }

    @CoreMethod(names={">"}, required=1)
    public static abstract class GreaterNode
    extends CoreMethodNode {
        public GreaterNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GreaterNode(GreaterNode prev) {
            super(prev);
        }

        @Specialization
        public boolean greater(RubyBignum a, int b2) {
            return a.compare(b2) > 0;
        }

        @Specialization
        public boolean greater(RubyBignum a, long b2) {
            return a.compare(b2) > 0;
        }

        @Specialization
        public boolean greater(RubyBignum a, double b2) {
            return a.compare(b2) > 0;
        }

        @Specialization
        public boolean greater(RubyBignum a, RubyBignum b2) {
            return a.compare(b2) > 0;
        }
    }

    @CoreMethod(names={">="}, required=1)
    public static abstract class GreaterEqualNode
    extends CoreMethodNode {
        public GreaterEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GreaterEqualNode(GreaterEqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean greaterEqual(RubyBignum a, int b2) {
            return a.compare(b2) >= 0;
        }

        @Specialization
        public boolean greaterEqual(RubyBignum a, long b2) {
            return a.compare(b2) >= 0;
        }

        @Specialization
        public boolean greaterEqual(RubyBignum a, double b2) {
            return a.compare(b2) >= 0;
        }

        @Specialization
        public boolean greaterEqual(RubyBignum a, RubyBignum b2) {
            return a.compare(b2) >= 0;
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodNode {
        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CompareNode(CompareNode prev) {
            super(prev);
        }

        @Specialization
        public int compare(RubyBignum a, int b2) {
            return a.compare(b2);
        }

        @Specialization
        public int compare(RubyBignum a, long b2) {
            return a.compare(b2);
        }

        @Specialization
        public int compare(RubyBignum a, double b2) {
            return Double.compare(a.doubleValue(), b2);
        }

        @Specialization
        public int compare(RubyBignum a, RubyBignum b2) {
            return a.compare(b2);
        }
    }

    @CoreMethod(names={"==", "eql?"}, required=1)
    public static abstract class EqualNode
    extends CoreMethodNode {
        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EqualNode(EqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean equal(RubyBignum a, int b2) {
            return a.isEqualTo(b2);
        }

        @Specialization
        public boolean equal(RubyBignum a, long b2) {
            return a.isEqualTo(b2);
        }

        @Specialization
        public boolean equal(RubyBignum a, double b2) {
            return a.doubleValue() == b2;
        }

        @Specialization
        public boolean equal(RubyBignum a, RubyBignum b2) {
            return a.isEqualTo(b2);
        }
    }

    @CoreMethod(names={"<="}, required=1)
    public static abstract class LessEqualNode
    extends CoreMethodNode {
        public LessEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LessEqualNode(LessEqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean lessEqual(RubyBignum a, int b2) {
            return a.compare(b2) <= 0;
        }

        @Specialization
        public boolean lessEqual(RubyBignum a, long b2) {
            return a.compare(b2) <= 0;
        }

        @Specialization
        public boolean lessEqual(RubyBignum a, double b2) {
            return a.compare(b2) <= 0;
        }

        @Specialization
        public boolean lessEqual(RubyBignum a, RubyBignum b2) {
            return a.compare(b2) <= 0;
        }
    }

    @CoreMethod(names={"<"}, required=1)
    public static abstract class LessNode
    extends CoreMethodNode {
        public LessNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LessNode(LessNode prev) {
            super(prev);
        }

        @Specialization
        public boolean less(RubyBignum a, int b2) {
            return a.compare(b2) < 0;
        }

        @Specialization
        public boolean less(RubyBignum a, long b2) {
            return a.compare(b2) < 0;
        }

        @Specialization
        public boolean less(RubyBignum a, double b2) {
            return a.compare(b2) < 0;
        }

        @Specialization
        public boolean less(RubyBignum a, RubyBignum b2) {
            return a.compare(b2) < 0;
        }
    }

    @CoreMethod(names={"%"}, required=1)
    public static abstract class ModNode
    extends BignumCoreMethodNode {
        public ModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ModNode(ModNode prev) {
            super(prev);
        }

        @Specialization
        public Object mod(RubyBignum a, int b2) {
            return this.fixnumOrBignum(a.mod(b2));
        }

        @Specialization
        public Object mod(RubyBignum a, long b2) {
            return this.fixnumOrBignum(a.mod(b2));
        }

        @Specialization
        public Object mod(RubyBignum a, RubyBignum b2) {
            return this.fixnumOrBignum(a.mod(b2));
        }
    }

    @CoreMethod(names={"/", "__slash__"}, required=1)
    public static abstract class DivNode
    extends BignumCoreMethodNode {
        public DivNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DivNode(DivNode prev) {
            super(prev);
        }

        @Specialization
        public Object div(RubyBignum a, int b2) {
            return this.fixnumOrBignum(a.divide(b2));
        }

        @Specialization
        public RubyBignum div(RubyBignum a, long b2) {
            return a.divide(b2);
        }

        @Specialization
        public double div(RubyBignum a, double b2) {
            return a.doubleValue() / b2;
        }

        @Specialization
        public Object div(RubyBignum a, RubyBignum b2) {
            return a.divide(b2);
        }
    }

    @CoreMethod(names={"**"}, required=1)
    public static abstract class PowNode
    extends CoreMethodNode {
        public PowNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PowNode(PowNode prev) {
            super(prev);
        }

        @Specialization
        public RubyBignum pow(RubyBignum a, int b2) {
            return a.pow(b2);
        }

        @Specialization
        public RubyBignum pow(RubyBignum a, long b2) {
            return a.pow(b2);
        }

        @Specialization
        public double pow(RubyBignum a, double b2) {
            return Math.pow(a.doubleValue(), b2);
        }

        @Specialization
        public RubyBignum pow(RubyBignum a, RubyBignum b2) {
            return a.pow(b2);
        }
    }

    @CoreMethod(names={"*"}, required=1)
    public static abstract class MulNode
    extends CoreMethodNode {
        public MulNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MulNode(MulNode prev) {
            super(prev);
        }

        @Specialization
        public RubyBignum mul(RubyBignum a, int b2) {
            return a.multiply(b2);
        }

        @Specialization
        public RubyBignum mul(RubyBignum a, long b2) {
            return a.multiply(b2);
        }

        @Specialization
        public double mul(RubyBignum a, double b2) {
            return a.doubleValue() * b2;
        }

        @Specialization
        public RubyBignum mul(RubyBignum a, RubyBignum b2) {
            return a.multiply(b2);
        }
    }

    @CoreMethod(names={"-"}, required=1)
    public static abstract class SubNode
    extends BignumCoreMethodNode {
        public SubNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SubNode(SubNode prev) {
            super(prev);
        }

        @Specialization
        public Object sub(RubyBignum a, int b2) {
            return this.fixnumOrBignum(a.subtract(b2));
        }

        @Specialization
        public Object sub(RubyBignum a, long b2) {
            return this.fixnumOrBignum(a.subtract(b2));
        }

        @Specialization
        public double sub(RubyBignum a, double b2) {
            return a.doubleValue() - b2;
        }

        @Specialization
        public Object sub(RubyBignum a, RubyBignum b2) {
            return this.fixnumOrBignum(a.subtract(b2));
        }
    }

    @CoreMethod(names={"+"}, required=1)
    public static abstract class AddNode
    extends BignumCoreMethodNode {
        public AddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AddNode(AddNode prev) {
            super(prev);
        }

        @Specialization
        public RubyBignum add(RubyBignum a, int b2) {
            return a.add(b2);
        }

        @Specialization
        public RubyBignum add(RubyBignum a, long b2) {
            return a.add(b2);
        }

        @Specialization
        public double add(RubyBignum a, double b2) {
            return a.doubleValue() + b2;
        }

        @Specialization
        public Object add(RubyBignum a, RubyBignum b2) {
            return this.fixnumOrBignum(a.add(b2));
        }
    }

    @CoreMethod(names={"-@"})
    public static abstract class NegNode
    extends BignumCoreMethodNode {
        public NegNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public NegNode(NegNode prev) {
            super(prev);
        }

        @Specialization
        public RubyBignum neg(RubyBignum value2) {
            return value2.negate();
        }
    }

    public static abstract class BignumCoreMethodNode
    extends CoreMethodNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;

        public BignumCoreMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fixnumOrBignum = new FixnumOrBignumNode(context, sourceSection);
        }

        public BignumCoreMethodNode(BignumCoreMethodNode prev) {
            super(prev);
            this.fixnumOrBignum = prev.fixnumOrBignum;
        }

        public Object fixnumOrBignum(RubyBignum value2) {
            return this.fixnumOrBignum.fixnumOrBignum(value2);
        }
    }
}

