/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.conversion;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.conversion.ToSymbolNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;

@GeneratedBy(value=ToSymbolNode.class)
public final class ToSymbolNodeFactory
extends NodeFactoryBase<ToSymbolNode> {
    private static ToSymbolNodeFactory instance;

    private ToSymbolNodeFactory() {
        super(ToSymbolNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
    }

    @Override
    public ToSymbolNode createNode(Object ... arguments) {
        if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
            return ToSymbolNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2]);
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static ToSymbolNode create(RubyContext context, SourceSection sourceSection, RubyNode child) {
        return ToSymbolUninitializedNode.create0(context, sourceSection, child);
    }

    public static NodeFactory<ToSymbolNode> getInstance() {
        if (instance == null) {
            instance = new ToSymbolNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=ToSymbolNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class ToSymbolPolymorphicNode
    extends ToSymbolBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> childPolymorphicType;

        ToSymbolPolymorphicNode(ToSymbolBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubySymbol value2;
            try {
                value2 = this.executeRubySymbol(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
            Object childValue;
            try {
                childValue = this.childPolymorphicType == String.class ? this.child.executeString(frameValue) : (this.childPolymorphicType == RubyString.class ? this.child.executeRubyString(frameValue) : (this.childPolymorphicType == RubySymbol.class ? this.child.executeRubySymbol(frameValue) : this.child.execute(frameValue)));
            }
            catch (UnexpectedResultException ex) {
                this.childPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        @Override
        public RubySymbol executeRubySymbol(VirtualFrame frameValue, Object childValueEvaluated) {
            Object childValue;
            try {
                childValue = this.childPolymorphicType == String.class ? RubyTypesGen.RUBYTYPES.expectString(childValueEvaluated) : (this.childPolymorphicType == RubyString.class ? RubyTypesGen.RUBYTYPES.expectRubyString(childValueEvaluated) : (this.childPolymorphicType == RubySymbol.class ? RubyTypesGen.RUBYTYPES.expectRubySymbol(childValueEvaluated) : childValueEvaluated));
            }
            catch (UnexpectedResultException ex) {
                this.childPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.childPolymorphicType = types[0];
        }

        @Override
        protected RubySymbol executeChained0(VirtualFrame frameValue, Object childValue) {
            return this.next0.executeChained0(frameValue, childValue);
        }
    }

    @GeneratedBy(value=ToSymbolNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ToSymbolStringNode
    extends ToSymbolBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToSymbolStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{String.class}, 0, 0);

        ToSymbolStringNode(ToSymbolBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubySymbol value2;
            try {
                value2 = this.executeRubySymbol(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
            String childValue;
            try {
                childValue = this.child.executeString(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof String");
            }
            return super.toSymbol(childValue);
        }

        @Override
        public RubySymbol executeRubySymbol(VirtualFrame frameValue, Object childValueEvaluated) {
            String childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectString(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof String");
            }
            return super.toSymbol(childValue);
        }

        @Override
        protected RubySymbol executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isString(childValue)) {
                String childValueCast = RubyTypesGen.RUBYTYPES.asString(childValue);
                return super.toSymbol(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ToSymbolNode create0(ToSymbolNode current2) {
            return new ToSymbolStringNode((ToSymbolBaseNode)current2);
        }
    }

    @GeneratedBy(value=ToSymbolNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ToSymbolRubyStringNode
    extends ToSymbolBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToSymbolRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

        ToSymbolRubyStringNode(ToSymbolBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubySymbol value2;
            try {
                value2 = this.executeRubySymbol(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyString childValue;
            try {
                childValue = this.child.executeRubyString(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyString");
            }
            return super.toSymbol(childValue);
        }

        @Override
        public RubySymbol executeRubySymbol(VirtualFrame frameValue, Object childValueEvaluated) {
            RubyString childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectRubyString(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyString");
            }
            return super.toSymbol(childValue);
        }

        @Override
        protected RubySymbol executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyString(childValue)) {
                RubyString childValueCast = RubyTypesGen.RUBYTYPES.asRubyString(childValue);
                return super.toSymbol(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ToSymbolNode create0(ToSymbolNode current2) {
            return new ToSymbolRubyStringNode((ToSymbolBaseNode)current2);
        }
    }

    @GeneratedBy(value=ToSymbolNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ToSymbolRubySymbolNode
    extends ToSymbolBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToSymbolRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class}, 0, 0);

        ToSymbolRubySymbolNode(ToSymbolBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubySymbol value2;
            try {
                value2 = this.executeRubySymbol(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
            RubySymbol childValue;
            try {
                childValue = this.child.executeRubySymbol(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubySymbol");
            }
            return super.toSymbol(childValue);
        }

        @Override
        public RubySymbol executeRubySymbol(VirtualFrame frameValue, Object childValueEvaluated) {
            RubySymbol childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectRubySymbol(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubySymbol");
            }
            return super.toSymbol(childValue);
        }

        @Override
        protected RubySymbol executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubySymbol(childValue)) {
                RubySymbol childValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(childValue);
                return super.toSymbol(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ToSymbolNode create0(ToSymbolNode current2) {
            return new ToSymbolRubySymbolNode((ToSymbolBaseNode)current2);
        }
    }

    @GeneratedBy(value=ToSymbolNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class ToSymbolUninitializedNode
    extends ToSymbolBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToSymbolUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        ToSymbolUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection, child);
        }

        ToSymbolUninitializedNode(ToSymbolBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubySymbol value2;
            try {
                value2 = this.executeRubySymbol(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = this.child.execute(frameValue);
            return this.executeUninitialized0(frameValue, childValue);
        }

        @Override
        public RubySymbol executeRubySymbol(VirtualFrame frameValue, Object childValueEvaluated) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = childValueEvaluated;
            return this.executeUninitialized0(frameValue, childValue);
        }

        @Override
        protected RubySymbol executeChained0(VirtualFrame frameValue, Object childValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, childValue);
        }

        protected RubySymbol executeUninitialized0(VirtualFrame frameValue, Object childValue) {
            ToSymbolBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                ToSymbolBaseNode rootNode = DSLShare.findRoot(this);
                throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.child}, childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, childValue);
        }

        static ToSymbolNode create0(RubyContext context, SourceSection sourceSection, RubyNode child) {
            return new ToSymbolUninitializedNode(context, sourceSection, child);
        }
    }

    @GeneratedBy(value=ToSymbolNode.class)
    private static abstract class ToSymbolBaseNode
    extends ToSymbolNode
    implements DSLNode {
        @Node.Child
        protected RubyNode child;
        @Node.Child
        protected ToSymbolBaseNode next0;

        ToSymbolBaseNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection);
            this.child = child;
        }

        ToSymbolBaseNode(ToSymbolBaseNode copy) {
            super(copy);
        }

        protected abstract RubySymbol executeChained0(VirtualFrame var1, Object var2);

        protected final RubySymbol rewrite0(VirtualFrame frameValue, Object childValue, String reason2) {
            String message2;
            ToSymbolBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            ToSymbolBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                newNode = new ToSymbolUninitializedNode(this);
                ((ToSymbolUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ToSymbolBaseNode.createInfo0(reason2, childValue))) == null) {
                returnNode = DSLShare.rewriteToPolymorphic(this, new ToSymbolUninitializedNode(this), new ToSymbolPolymorphicNode(this), (ToSymbolBaseNode)this.copy(), newNode, message2);
            }
            return returnNode.executeChained0(frameValue, childValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final ToSymbolBaseNode specialize0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubySymbol(childValue)) {
                return (ToSymbolBaseNode)ToSymbolRubySymbolNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyString(childValue)) {
                return (ToSymbolBaseNode)ToSymbolRubyStringNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isString(childValue)) {
                return (ToSymbolBaseNode)ToSymbolStringNode.create0(this);
            }
            return null;
        }

        @Override
        public final void adoptChildren0(Node other, Node newNext) {
            this.child = other == null ? null : ((ToSymbolBaseNode)other).child;
            this.next0 = newNext == null ? null : (ToSymbolBaseNode)newNext;
        }

        @Override
        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
        }

        @Override
        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message2, Object childValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message2);
                builder.append(" (");
                builder.append("childValue").append(" = ").append(childValue);
                if (childValue != null) {
                    builder.append(" (").append(childValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message2;
        }
    }
}

