/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyString;

@NodeChild(type=RubyNode.class)
public abstract class ToSNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode callToSNode;
    @Node.Child
    private KernelNodes.ToSNode kernelToSNode;

    public ToSNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.callToSNode = DispatchHeadNodeFactory.createMethodCall(context, true);
    }

    protected RubyString kernelToS(VirtualFrame frame, Object object) {
        if (this.kernelToSNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.kernelToSNode = this.insert(KernelNodesFactory.ToSNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null}));
        }
        return this.kernelToSNode.executeToS(frame, object);
    }

    public ToSNode(ToSNode prev) {
        super(prev);
        this.callToSNode = prev.callToSNode;
    }

    @Override
    public abstract RubyString executeRubyString(VirtualFrame var1);

    @Specialization
    public RubyString toS(RubyString string2) {
        return string2;
    }

    @Specialization(guards={"!isRubyString"}, rewriteOn={UnexpectedResultException.class})
    public RubyString toS(VirtualFrame frame, Object object) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyString(this.callToSNode.call(frame, object, "to_s", null, new Object[0]));
    }

    @Specialization(guards={"!isRubyString"})
    public RubyString toSFallback(VirtualFrame frame, Object object) {
        Object value2 = this.callToSNode.call(frame, object, "to_s", null, new Object[0]);
        if (value2 instanceof RubyString) {
            return (RubyString)value2;
        }
        return this.kernelToS(frame, object);
    }

    @Override
    public final Object execute(VirtualFrame frame) {
        return this.executeRubyString(frame);
    }
}

