/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.Node;

public class MethodNodes {
    private static final Map<String, MethodNodes> cache = new ConcurrentHashMap<String, MethodNodes>();
    private final ArgsNode argsNode;
    private final Node bodyNode;

    public MethodNodes(ArgsNode argsNode, Node bodyNode) {
        assert (argsNode != null);
        assert (bodyNode != null);
        this.argsNode = argsNode;
        this.bodyNode = bodyNode;
    }

    public ArgsNode getArgsNode() {
        return this.argsNode;
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public static void cache(String methodJavaName, MethodNodes nodes) {
        cache.put(methodJavaName, nodes);
    }

    public static MethodNodes lookup(String methodJavaName) {
        return cache.get(methodJavaName);
    }
}

