/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;

public class WhenNode
extends Node {
    protected final Node expressionNodes;
    protected final Node bodyNode;
    private final Node nextCase;

    public WhenNode(ISourcePosition position, Node expressionNodes, Node bodyNode, Node nextCase) {
        super(position);
        this.expressionNodes = expressionNodes;
        this.bodyNode = bodyNode;
        this.nextCase = nextCase;
        assert (bodyNode != null) : "bodyNode is not null";
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.WHENNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitWhenNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getNextCase() {
        return this.nextCase;
    }

    public Node getExpressionNodes() {
        return this.expressionNodes;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.expressionNodes, this.bodyNode, this.nextCase);
    }
}

