/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;

public class RootNode
extends Node {
    private transient DynamicScope scope;
    private StaticScope staticScope;
    private Node bodyNode;

    public RootNode(ISourcePosition position, DynamicScope scope, Node bodyNode) {
        super(position);
        assert (bodyNode != null) : "bodyNode is not null";
        this.scope = scope;
        this.staticScope = scope.getStaticScope();
        this.bodyNode = bodyNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ROOTNODE;
    }

    public DynamicScope getScope() {
        return this.scope;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitRootNode(this);
    }

    @Override
    public List<Node> childNodes() {
        return RootNode.createList(this.bodyNode);
    }
}

