/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.utilities;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.utilities.ValueProfile;

public final class ExactClassValueProfile
extends ValueProfile {
    @CompilerDirectives.CompilationFinal
    protected Class<?> cachedClass;

    ExactClassValueProfile() {
    }

    @Override
    public <T> T profile(T value2) {
        if (this.cachedClass != null && this.cachedClass.isInstance(value2)) {
            return (T)this.cachedClass.cast(value2);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.cachedClass = this.cachedClass == null && value2 != null ? value2.getClass() : Object.class;
        return value2;
    }

    public boolean isGeneric() {
        return this.cachedClass == Object.class;
    }

    public boolean isUninitialized() {
        return this.cachedClass == null;
    }

    public Class<?> getCachedClass() {
        return this.cachedClass;
    }

    public String toString() {
        return String.format("%s(%s)@%x", this.getClass().getSimpleName(), this.isUninitialized() ? "uninitialized" : (this.isGeneric() ? "generic" : this.cachedClass.getName()), this.hashCode());
    }
}

