/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrument.impl;

import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.SyntaxTag;
import com.oracle.truffle.api.source.LineLocation;
import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LineToProbesMap
implements Probe.ProbeListener {
    private static final boolean TRACE = false;
    private static final PrintStream OUT = System.out;
    private final Map<LineLocation, Collection<Probe>> lineToProbesMap = new HashMap<LineLocation, Collection<Probe>>();

    private static void trace(String msg) {
        OUT.println("LineToProbesMap: " + msg);
    }

    @Override
    public void startASTProbing(Source source2) {
    }

    @Override
    public void newProbeInserted(Probe probe) {
        SourceSection sourceSection = probe.getProbedSourceSection();
        if (sourceSection != null && !(sourceSection instanceof NullSourceSection)) {
            LineLocation lineLocation = sourceSection.getLineLocation();
            this.addProbeToLine(lineLocation, probe);
        }
    }

    @Override
    public void probeTaggedAs(Probe probe, SyntaxTag tag2, Object tagValue) {
    }

    @Override
    public void endASTProbing(Source source2) {
    }

    public Probe findLineProbe(LineLocation lineLocation) {
        Probe probe = null;
        Collection<Probe> probes = this.getProbesAtLine(lineLocation);
        for (Probe probesOnLine : probes) {
            if (probe == null) {
                probe = probesOnLine;
                continue;
            }
            if (probesOnLine.getProbedSourceSection().getCharIndex() >= probe.getProbedSourceSection().getCharIndex()) continue;
            probe = probesOnLine;
        }
        return probe;
    }

    protected void addProbeToLine(LineLocation line, Probe probe) {
        if (!this.lineToProbesMap.containsKey(line)) {
            ArrayList<Probe> newProbeList = new ArrayList<Probe>(2);
            newProbeList.add(probe);
            this.lineToProbesMap.put(line, newProbeList);
        } else {
            Collection<Probe> existingProbeList = this.lineToProbesMap.get(line);
            assert (!existingProbeList.contains(probe));
            existingProbeList.add(probe);
        }
    }

    public Collection<Probe> getProbesAtLine(LineLocation line) {
        Collection<Probe> probesList = this.lineToProbesMap.get(line);
        if (probesList == null) {
            return Collections.emptyList();
        }
        return probesList;
    }

    public Collection<Probe> getProbesAtLineNumber(int lineNumber) {
        Set<LineLocation> keySet = this.lineToProbesMap.keySet();
        if (keySet.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Probe> probes = new ArrayList<Probe>();
        for (LineLocation line : keySet) {
            if (line.getLineNumber() != lineNumber) continue;
            probes.addAll(this.lineToProbesMap.get(line));
        }
        return probes;
    }

    public void forget(Source source2) {
        Set<LineLocation> mappedLines = this.lineToProbesMap.keySet();
        if (mappedLines.size() > 0) {
            ArrayList<LineLocation> forgetLines = new ArrayList<LineLocation>();
            for (LineLocation line : mappedLines) {
                if (!line.getSource().equals(source2)) continue;
                forgetLines.add(line);
            }
            for (LineLocation line : forgetLines) {
                this.lineToProbesMap.remove(line);
            }
        }
    }
}

