/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrument;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.instrument.ASTProber;
import com.oracle.truffle.api.instrument.Instrument;
import com.oracle.truffle.api.instrument.ProbeNode;
import com.oracle.truffle.api.instrument.SyntaxTag;
import com.oracle.truffle.api.instrument.SyntaxTagTrap;
import com.oracle.truffle.api.instrument.SyntaxTagged;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Probe
implements SyntaxTagged {
    private static final List<ASTProber> astProbers = new ArrayList<ASTProber>();
    private static final List<ProbeListener> probeListeners = new ArrayList<ProbeListener>();
    private static final List<WeakReference<Probe>> probes = new ArrayList<WeakReference<Probe>>();
    private static SyntaxTagTrap globalTagTrap = null;
    private final SourceSection sourceSection;
    private final ArrayList<SyntaxTag> tags = new ArrayList();
    private final List<WeakReference<ProbeNode>> probeNodeClones = new ArrayList<WeakReference<ProbeNode>>();
    private final CyclicAssumption probeStateUnchanged = new CyclicAssumption("Probe state unchanged");
    private boolean trapActive = false;

    private static Source findSource(Node node) {
        FindSourceVisitor visitor = new FindSourceVisitor();
        node.accept(visitor);
        return visitor.source;
    }

    public static void registerASTProber(ASTProber prober) {
        astProbers.add(prober);
    }

    public static void unregisterASTProber(ASTProber prober) {
        astProbers.remove(prober);
    }

    public static void applyASTProbers(Node node) {
        Source source2 = Probe.findSource(node);
        for (ProbeListener listener : probeListeners) {
            listener.startASTProbing(source2);
        }
        for (ASTProber prober : astProbers) {
            prober.probeAST(node);
        }
        for (ProbeListener listener : probeListeners) {
            listener.endASTProbing(source2);
        }
    }

    public static void addProbeListener(ProbeListener listener) {
        assert (listener != null);
        probeListeners.add(listener);
    }

    public static void removeProbeListener(ProbeListener listener) {
        probeListeners.remove(listener);
    }

    public static Collection<Probe> findProbesTaggedAs(SyntaxTag tag2) {
        ArrayList<Probe> taggedProbes = new ArrayList<Probe>();
        for (WeakReference<Probe> ref : probes) {
            Probe probe = (Probe)ref.get();
            if (probe == null || tag2 != null && !probe.isTaggedAs(tag2)) continue;
            taggedProbes.add((Probe)ref.get());
        }
        return taggedProbes;
    }

    public static void setTagTrap(SyntaxTagTrap newTagTrap) throws IllegalStateException {
        assert (newTagTrap != null);
        if (globalTagTrap != null) {
            throw new IllegalStateException("trap already set");
        }
        globalTagTrap = newTagTrap;
        SyntaxTag newTag = newTagTrap.getTag();
        for (WeakReference<Probe> ref : probes) {
            Probe probe = (Probe)ref.get();
            if (probe == null || !probe.tags.contains(newTag)) continue;
            probe.trapActive = true;
            probe.probeStateUnchanged.invalidate();
        }
    }

    public static void clearTagTrap() {
        if (globalTagTrap == null) {
            throw new IllegalStateException("no trap set");
        }
        globalTagTrap = null;
        for (WeakReference<Probe> ref : probes) {
            Probe probe = (Probe)ref.get();
            if (probe == null || !probe.trapActive) continue;
            probe.trapActive = false;
            probe.probeStateUnchanged.invalidate();
        }
    }

    Probe(ProbeNode probeNode, SourceSection sourceSection) {
        this.sourceSection = sourceSection;
        probes.add(new WeakReference<Probe>(this));
        this.registerProbeNodeClone(probeNode);
        for (ProbeListener listener : probeListeners) {
            listener.newProbeInserted(this);
        }
    }

    @Override
    public boolean isTaggedAs(SyntaxTag tag2) {
        assert (tag2 != null);
        return this.tags.contains(tag2);
    }

    @Override
    public Collection<SyntaxTag> getSyntaxTags() {
        return Collections.unmodifiableCollection(this.tags);
    }

    public void tagAs(SyntaxTag tag2, Object tagValue) {
        assert (tag2 != null);
        if (!this.tags.contains(tag2)) {
            this.tags.add(tag2);
            for (ProbeListener listener : probeListeners) {
                listener.probeTaggedAs(this, tag2, tagValue);
            }
            if (globalTagTrap != null && tag2 == globalTagTrap.getTag()) {
                this.trapActive = true;
            }
            this.probeStateUnchanged.invalidate();
        }
    }

    public void attach(Instrument instrument) throws IllegalStateException {
        if (instrument.isDisposed()) {
            throw new IllegalStateException("Attempt to attach disposed instrument");
        }
        if (instrument.getProbe() != null) {
            throw new IllegalStateException("Attampt to attach an already attached instrument");
        }
        instrument.setAttachedTo(this);
        for (WeakReference<ProbeNode> ref : this.probeNodeClones) {
            ProbeNode probeNode = (ProbeNode)ref.get();
            if (probeNode == null) continue;
            probeNode.addInstrument(instrument);
        }
        this.probeStateUnchanged.invalidate();
    }

    public SourceSection getProbedSourceSection() {
        return this.sourceSection;
    }

    public String getShortDescription() {
        String location = this.sourceSection == null ? "<unknown>" : this.sourceSection.getShortDescription();
        return "Probe@" + location + this.getTagsDescription();
    }

    void registerProbeNodeClone(ProbeNode probeNode) {
        this.probeNodeClones.add(new WeakReference<ProbeNode>(probeNode));
    }

    SyntaxTagTrap getTrap() {
        return this.trapActive ? globalTagTrap : null;
    }

    Assumption getUnchangedAssumption() {
        return this.probeStateUnchanged.getAssumption();
    }

    void disposeInstrument(Instrument instrument) throws IllegalStateException {
        for (WeakReference<ProbeNode> ref : this.probeNodeClones) {
            ProbeNode probeNode = (ProbeNode)ref.get();
            if (probeNode == null) continue;
            probeNode.removeInstrument(instrument);
        }
        this.probeStateUnchanged.invalidate();
    }

    private String getTagsDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        String prefix = "";
        for (SyntaxTag tag2 : this.tags) {
            sb.append(prefix);
            prefix = ",";
            sb.append(tag2.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    private static final class FindSourceVisitor
    implements NodeVisitor {
        Source source = null;

        private FindSourceVisitor() {
        }

        @Override
        public boolean visit(Node node) {
            SourceSection sourceSection = node.getSourceSection();
            if (sourceSection != null) {
                this.source = sourceSection.getSource();
                return false;
            }
            return true;
        }
    }

    public static interface ProbeListener {
        public void startASTProbing(Source var1);

        public void newProbeInserted(Probe var1);

        public void probeTaggedAs(Probe var1, SyntaxTag var2, Object var3);

        public void endASTProbing(Source var1);
    }
}

