/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile;

import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.profile.Invocation;
import org.jruby.runtime.profile.ProfilePrinter;
import org.jruby.runtime.profile.ProfiledMethod;
import org.jruby.util.collections.IntHashMap;

public class ProfileData {
    private static final int MAX_PROFILE_METHODS = 100000;
    private final IntHashMap<ProfiledMethod> profiledMethods = new IntHashMap(500);
    private Invocation currentInvocation;
    private Invocation topInvocation;
    private int[] methodRecursion;
    private final ThreadContext threadContext;

    public ProfileData(ThreadContext tc) {
        this.threadContext = tc;
        this.clear();
    }

    public IntHashMap<ProfiledMethod> getProfiledMethods() {
        return this.profiledMethods;
    }

    public void addProfiledMethod(String name2, DynamicMethod method2) {
        if (method2.isUndefined()) {
            return;
        }
        long serial = method2.getSerialNumber();
        if (serial > 100000L) {
            return;
        }
        if (this.profiledMethods.get((int)serial) == null) {
            this.profiledMethods.put((int)serial, new ProfiledMethod(name2, method2));
        }
    }

    protected ProfiledMethod getProfiledMethod(int serial) {
        ProfiledMethod[] runtimeMethods;
        ProfiledMethod profiledMethod = this.getProfiledMethods().get(serial);
        if (profiledMethod == null && serial < (runtimeMethods = this.threadContext.getRuntime().getProfiledMethods()).length) {
            profiledMethod = runtimeMethods[serial];
        }
        return profiledMethod;
    }

    public int profileEnter(int calledMethod) {
        Invocation parentInvocation = this.currentInvocation;
        Invocation childInvocation = parentInvocation.childInvocationFor(calledMethod);
        childInvocation.incrementCount();
        this.currentInvocation = childInvocation;
        return parentInvocation.getMethodSerialNumber();
    }

    public int profileExit(int callingMethod, long startTime) {
        long now = System.nanoTime();
        long duration = now - startTime;
        int oldSerial = this.currentInvocation.getMethodSerialNumber();
        this.currentInvocation.addDuration(duration);
        if (this.currentInvocation == this.topInvocation) {
            Invocation newTopInvocation = new Invocation(0);
            Invocation newCurrentInvocation = this.currentInvocation.copyWithNewSerialAndParent(callingMethod, newTopInvocation);
            newTopInvocation.addChild(newCurrentInvocation);
            newCurrentInvocation.incrementCount();
            this.topInvocation = newTopInvocation;
            this.currentInvocation = newCurrentInvocation;
            return oldSerial;
        }
        if (this.currentInvocation.getParent() == this.topInvocation && callingMethod != 0) {
            Invocation newTopInvocation = new Invocation(0);
            Invocation newCurrentInvocation = newTopInvocation.childInvocationFor(callingMethod);
            Invocation newChildInvocation = this.currentInvocation.copyWithNewSerialAndParent(this.currentInvocation.getMethodSerialNumber(), newCurrentInvocation);
            newCurrentInvocation.addChild(newChildInvocation);
            newCurrentInvocation.incrementCount();
            this.topInvocation = newTopInvocation;
            this.currentInvocation = newCurrentInvocation;
            return oldSerial;
        }
        this.currentInvocation = this.currentInvocation.getParent();
        return oldSerial;
    }

    public void clear() {
        this.methodRecursion = new int[1000];
        this.topInvocation = this.currentInvocation = new Invocation(0);
        this.profiledMethods.clear();
    }

    public long totalTime() {
        return this.topInvocation.childTime();
    }

    public Invocation getTopInvocation() {
        return this.topInvocation;
    }

    public Invocation getCurrentInvocation() {
        return this.currentInvocation;
    }

    public ThreadContext getThreadContext() {
        return this.threadContext;
    }

    public Invocation computeResults() {
        Invocation singleTopChild;
        int serial;
        this.setRecursiveDepths();
        if (this.topInvocation.getChildren().size() != 1) {
            return ProfileData.setDuration(this.topInvocation);
        }
        if (this.topInvocation.getChildren().size() == 1 && "JRuby::Profiler.profile".equals(this.methodName(serial = (singleTopChild = this.topInvocation.getChildren().values().iterator().next()).getMethodSerialNumber()))) {
            for (Invocation inv : singleTopChild.getChildren().values()) {
                serial = inv.getMethodSerialNumber();
                if (!"JRuby::Profiler.profiled_code".equals(this.methodName(serial))) continue;
                return ProfileData.setDuration(inv.copyWithNewSerialAndParent(0, null));
            }
        }
        return ProfileData.setDuration(this.topInvocation);
    }

    private static Invocation setDuration(Invocation inv) {
        inv.setDuration(inv.childTime());
        return inv;
    }

    protected void decRecursionFor(int serial) {
        this.ensureRecursionSize(serial);
        int[] mr = this.methodRecursion;
        mr[serial] = mr[serial] - 1;
    }

    protected int incRecursionFor(int serial) {
        int inc;
        this.ensureRecursionSize(serial);
        int[] mr = this.methodRecursion;
        mr[serial] = inc = mr[serial] + 1;
        return inc;
    }

    private void ensureRecursionSize(int index2) {
        int[] mr = this.methodRecursion;
        int length2 = mr.length;
        if (length2 <= index2) {
            int[] newRecursion = new int[(int)((double)index2 * 1.5 + 1.0)];
            System.arraycopy(mr, 0, newRecursion, 0, length2);
            this.methodRecursion = newRecursion;
        }
    }

    private void setRecursiveDepths() {
        int topSerial = this.topInvocation.getMethodSerialNumber();
        int depth = this.incRecursionFor(topSerial);
        this.topInvocation.setRecursiveDepth(depth);
        this.setRecursiveDepths1(this.topInvocation);
    }

    private void setRecursiveDepths1(Invocation inv) {
        for (Invocation child : inv.getChildren().values()) {
            int childSerial = child.getMethodSerialNumber();
            int depth = this.incRecursionFor(childSerial);
            child.setRecursiveDepth(depth);
            this.setRecursiveDepths1(child);
            this.decRecursionFor(childSerial);
        }
    }

    String methodName(int serial) {
        if (serial == 0) {
            return "(top)";
        }
        return ProfilePrinter.methodName(this.getProfiledMethod(serial));
    }
}

