/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.ConvertDouble;
import org.jruby.util.Numeric;
import org.jruby.util.Sprintf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Float"}, parent="Numeric", include={"Precision"})
public class RubyFloat
extends RubyNumeric {
    public static final int ROUNDS = 1;
    public static final int RADIX = 2;
    public static final int MANT_DIG = 53;
    public static final int DIG = 15;
    public static final int MIN_EXP = -1021;
    public static final int MAX_EXP = 1024;
    public static final int MAX_10_EXP = 308;
    public static final int MIN_10_EXP = -307;
    public static final double EPSILON = 2.220446049250313E-16;
    public static final double INFINITY = Double.POSITIVE_INFINITY;
    public static final double NAN = Double.NaN;
    private final double value;
    private static final DecimalFormat FORMAT = new DecimalFormat("##############0.0##############", new DecimalFormatSymbols(Locale.ENGLISH));
    static final int DBL_MANT_DIG = 53;
    static final int FLT_RADIX = 2;
    private static final ByteList NAN_BYTELIST = new ByteList("nan".getBytes());
    private static final ByteList NEGATIVE_INFINITY_BYTELIST = new ByteList("-inf".getBytes());
    private static final ByteList INFINITY_BYTELIST = new ByteList("inf".getBytes());

    public static RubyClass createFloatClass(Ruby runtime) {
        RubyClass floatc = runtime.defineClass("Float", runtime.getNumeric(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setFloat(floatc);
        floatc.index = 11;
        floatc.setReifiedClass(RubyFloat.class);
        floatc.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyFloat;
            }
        };
        floatc.getSingletonClass().undefineMethod("new");
        if (!runtime.is1_9()) {
            floatc.includeModule(runtime.getPrecision());
        }
        floatc.defineConstant("ROUNDS", RubyFixnum.newFixnum(runtime, 1L));
        floatc.defineConstant("RADIX", RubyFixnum.newFixnum(runtime, 2L));
        floatc.defineConstant("MANT_DIG", RubyFixnum.newFixnum(runtime, 53L));
        floatc.defineConstant("DIG", RubyFixnum.newFixnum(runtime, 15L));
        floatc.defineConstant("MIN_EXP", RubyFixnum.newFixnum(runtime, -1021L));
        floatc.defineConstant("MAX_EXP", RubyFixnum.newFixnum(runtime, 1024L));
        floatc.defineConstant("MIN_10_EXP", RubyFixnum.newFixnum(runtime, -307L));
        floatc.defineConstant("MAX_10_EXP", RubyFixnum.newFixnum(runtime, 308L));
        floatc.defineConstant("MIN", RubyFloat.newFloat(runtime, Double.MIN_VALUE));
        floatc.defineConstant("MAX", RubyFloat.newFloat(runtime, Double.MAX_VALUE));
        floatc.defineConstant("EPSILON", RubyFloat.newFloat(runtime, 2.220446049250313E-16));
        if (runtime.is1_9()) {
            floatc.defineConstant("INFINITY", RubyFloat.newFloat(runtime, Double.POSITIVE_INFINITY));
            floatc.defineConstant("NAN", RubyFloat.newFloat(runtime, Double.NaN));
        }
        floatc.defineAnnotatedMethods(RubyFloat.class);
        return floatc;
    }

    @Override
    public int getNativeTypeIndex() {
        return 11;
    }

    public RubyFloat(Ruby runtime) {
        this(runtime, 0.0);
    }

    public RubyFloat(Ruby runtime, double value2) {
        super(runtime, runtime.getFloat());
        this.value = value2;
    }

    @Override
    public Class<?> getJavaClass() {
        return Double.TYPE;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public long getLongValue() {
        return (long)this.value;
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return BigInteger.valueOf((long)this.value);
    }

    @Override
    public RubyFloat convertToFloat() {
        return this;
    }

    protected int compareValue(RubyNumeric other) {
        double otherVal = other.getDoubleValue();
        return this.getValue() > otherVal ? 1 : (this.getValue() < otherVal ? -1 : 0);
    }

    public static RubyFloat newFloat(Ruby runtime, double value2) {
        return new RubyFloat(runtime, value2);
    }

    @JRubyMethod(name={"induced_from"}, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject induced_from(ThreadContext context, IRubyObject recv2, IRubyObject number) {
        if (number instanceof RubyFixnum || number instanceof RubyBignum || number instanceof RubyRational) {
            return number.callMethod(context, "to_f");
        }
        if (number instanceof RubyFloat) {
            return number;
        }
        throw recv2.getRuntime().newTypeError("failed to convert " + number.getMetaClass() + " into Float");
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        ASCIIEncoding ascii;
        Ruby runtime = this.getRuntime();
        if (Double.isInfinite(this.value)) {
            return RubyString.newString(runtime, this.value < 0.0 ? "-Infinity" : "Infinity");
        }
        if (Double.isNaN(this.value)) {
            return RubyString.newString(runtime, "NaN");
        }
        ByteList buf = new ByteList();
        if (runtime.is1_9()) {
            Sprintf.sprintf(buf, Locale.US, (CharSequence)"%#.20g", this);
        } else {
            Sprintf.sprintf(buf, Locale.US, (CharSequence)"%#.15g", this);
        }
        int e = buf.indexOf(101);
        if (e == -1) {
            e = buf.getRealSize();
        }
        if (!(ascii = ASCIIEncoding.INSTANCE).isDigit(buf.get(e - 1))) {
            buf.setRealSize(0);
            Sprintf.sprintf(buf, Locale.US, (CharSequence)"%#.14e", this);
            e = buf.indexOf(101);
            if (e == -1) {
                e = buf.getRealSize();
            }
        }
        int p2 = e;
        while (buf.get(p2 - 1) == 48 && ascii.isDigit(buf.get(p2 - 2))) {
            --p2;
        }
        System.arraycopy(buf.getUnsafeBytes(), e, buf.getUnsafeBytes(), p2, buf.getRealSize() - e);
        buf.setRealSize(p2 + buf.getRealSize() - e);
        if (this.getRuntime().is1_9()) {
            buf.setEncoding(USASCIIEncoding.INSTANCE);
        }
        return runtime.newString(buf);
    }

    @Override
    @JRubyMethod(name={"coerce"}, required=1)
    public IRubyObject coerce(IRubyObject other) {
        return this.getRuntime().newArray((IRubyObject)RubyKernel.new_float(this, other), (IRubyObject)this);
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus() {
        return RubyFloat.newFloat(this.getRuntime(), -this.value);
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyFloat.newFloat(this.getRuntime(), this.value + ((RubyNumeric)other).getDoubleValue());
            }
        }
        return this.coerceBin(context, "+", other);
    }

    public IRubyObject op_plus(ThreadContext context, double other) {
        return RubyFloat.newFloat(this.getRuntime(), this.value + other);
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_minus(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyFloat.newFloat(this.getRuntime(), this.value - ((RubyNumeric)other).getDoubleValue());
            }
        }
        return this.coerceBin(context, "-", other);
    }

    public IRubyObject op_minus(ThreadContext context, double other) {
        return RubyFloat.newFloat(this.getRuntime(), this.value - other);
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyFloat.newFloat(this.getRuntime(), this.value * ((RubyNumeric)other).getDoubleValue());
            }
        }
        return this.coerceBin(context, "*", other);
    }

    public IRubyObject op_mul(ThreadContext context, double other) {
        return RubyFloat.newFloat(this.getRuntime(), this.value * other);
    }

    @JRubyMethod(name={"/"}, required=1)
    public IRubyObject op_fdiv(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyFloat.newFloat(this.getRuntime(), this.value / ((RubyNumeric)other).getDoubleValue());
            }
        }
        return this.coerceBin(context, "/", other);
    }

    public IRubyObject op_fdiv(ThreadContext context, double other) {
        return RubyFloat.newFloat(this.getRuntime(), this.value / other);
    }

    @JRubyMethod(name={"quo"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject magnitude(ThreadContext context, IRubyObject other) {
        return this.callMethod(context, "/", other);
    }

    @JRubyMethod(name={"%", "modulo"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_mod(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double y = ((RubyNumeric)other).getDoubleValue();
                return this.op_mod(context, y);
            }
        }
        return this.coerceBin(context, "%", other);
    }

    public IRubyObject op_mod(ThreadContext context, double other) {
        double x = this.value;
        double mod = Math.IEEEremainder(x, other);
        if (other * mod < 0.0) {
            mod += other;
        }
        return RubyFloat.newFloat(this.getRuntime(), mod);
    }

    @JRubyMethod(name={"%", "modulo"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_mod19(ThreadContext context, IRubyObject other) {
        if (!other.isNil() && other instanceof RubyNumeric && ((RubyNumeric)other).getDoubleValue() == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
        return this.op_mod(context, other);
    }

    @Override
    @JRubyMethod(name={"divmod"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double y = ((RubyNumeric)other).getDoubleValue();
                double x = this.value;
                double mod = Math.IEEEremainder(x, y);
                if (Double.isNaN(mod)) {
                    throw this.getRuntime().newFloatDomainError("NaN");
                }
                double div2 = Math.floor(x / y);
                if (y * mod < 0.0) {
                    mod += y;
                }
                Ruby runtime = this.getRuntime();
                IRubyObject car = RubyFloat.dbl2num(runtime, div2);
                RubyFloat cdr = RubyFloat.newFloat(runtime, mod);
                return RubyArray.newArray(runtime, car, cdr);
            }
        }
        return this.coerceBin(context, "divmod", other);
    }

    @Override
    @JRubyMethod(name={"divmod"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject divmod19(ThreadContext context, IRubyObject other) {
        if (!other.isNil() && other instanceof RubyNumeric && ((RubyNumeric)other).getDoubleValue() == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
        return this.divmod(context, other);
    }

    @JRubyMethod(name={"**"}, required=1)
    public IRubyObject op_pow(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyFloat.newFloat(this.getRuntime(), Math.pow(this.value, ((RubyNumeric)other).getDoubleValue()));
            }
        }
        return this.coerceBin(context, "**", other);
    }

    public IRubyObject op_pow(ThreadContext context, double other) {
        return RubyFloat.newFloat(this.getRuntime(), Math.pow(this.value, other));
    }

    @JRubyMethod(name={"**"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_pow19(ThreadContext context, IRubyObject other) {
        double d_other = ((RubyNumeric)other).getDoubleValue();
        if (this.value < 0.0 && d_other != (double)Math.round(d_other)) {
            return RubyComplex.newComplexRaw(this.getRuntime(), this).callMethod(context, "**", other);
        }
        return this.op_pow(context, other);
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (Double.isNaN(this.value)) {
            return this.getRuntime().getFalse();
        }
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyBoolean.newBoolean(this.getRuntime(), this.value == ((RubyNumeric)other).getDoubleValue());
            }
        }
        return super.op_num_equal(context, other);
    }

    public IRubyObject op_equal(ThreadContext context, double other) {
        if (Double.isNaN(this.value)) {
            return this.getRuntime().getFalse();
        }
        return RubyBoolean.newBoolean(this.getRuntime(), this.value == other);
    }

    public boolean fastEqual(RubyFloat other) {
        if (Double.isNaN(this.value)) {
            return false;
        }
        return this.value == other.value;
    }

    @Override
    public final int compareTo(IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return Double.compare(this.value, ((RubyNumeric)other).getDoubleValue());
            }
        }
        return (int)this.coerceCmp(this.getRuntime().getCurrentContext(), "<=>", other).convertToInteger().getLongValue();
    }

    @Override
    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: {
                if (Double.isInfinite(this.value)) {
                    return this.value > 0.0 ? RubyFixnum.one(this.getRuntime()) : RubyFixnum.minus_one(this.getRuntime());
                }
            }
            case 11: {
                double b = ((RubyNumeric)other).getDoubleValue();
                return RubyFloat.dbl_cmp(this.getRuntime(), this.value, b);
            }
        }
        return this.coerceCmp(context, "<=>", other);
    }

    public IRubyObject op_cmp(ThreadContext context, double other) {
        return RubyFloat.dbl_cmp(this.getRuntime(), this.value, other);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double b = ((RubyNumeric)other).getDoubleValue();
                return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(b) && this.value > b);
            }
        }
        return this.coerceRelOp(context, ">", other);
    }

    public IRubyObject op_gt(ThreadContext context, double other) {
        return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(other) && this.value > other);
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double b = ((RubyNumeric)other).getDoubleValue();
                return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(b) && this.value >= b);
            }
        }
        return this.coerceRelOp(context, ">=", other);
    }

    public IRubyObject op_ge(ThreadContext context, double other) {
        return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(other) && this.value >= other);
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double b = ((RubyNumeric)other).getDoubleValue();
                return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(b) && this.value < b);
            }
        }
        return this.coerceRelOp(context, "<", other);
    }

    public IRubyObject op_lt(ThreadContext context, double other) {
        return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(other) && this.value < other);
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double b = ((RubyNumeric)other).getDoubleValue();
                return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(b) && this.value <= b);
            }
        }
        return this.coerceRelOp(context, "<=", other);
    }

    public IRubyObject op_le(ThreadContext context, double other) {
        return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(other) && this.value <= other);
    }

    @Override
    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(IRubyObject other) {
        if (other instanceof RubyFloat) {
            double b = ((RubyFloat)other).value;
            if (Double.isNaN(this.value) || Double.isNaN(b)) {
                return this.getRuntime().getFalse();
            }
            if (this.value == b) {
                return this.getRuntime().getTrue();
            }
        }
        return this.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @Override
    public final int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f() {
        return this;
    }

    @Override
    @JRubyMethod(name={"abs"})
    public IRubyObject abs(ThreadContext context) {
        if (Double.doubleToLongBits(this.value) < 0L) {
            return RubyFloat.newFloat(context.runtime, Math.abs(this.value));
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"magnitude"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject magnitude(ThreadContext context) {
        return this.abs(context);
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.value == 0.0);
    }

    @Override
    @JRubyMethod(name={"truncate", "to_i", "to_int"})
    public IRubyObject truncate() {
        double f = this.value;
        if (f > 0.0) {
            f = Math.floor(f);
        }
        if (f < 0.0) {
            f = Math.ceil(f);
        }
        return RubyFloat.dbl2num(this.getRuntime(), f);
    }

    @Override
    @JRubyMethod(name={"numerator"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject numerator(ThreadContext context) {
        if (Double.isInfinite(this.value) || Double.isNaN(this.value)) {
            return this;
        }
        return super.numerator(context);
    }

    @Override
    @JRubyMethod(name={"denominator"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject denominator(ThreadContext context) {
        if (Double.isInfinite(this.value) || Double.isNaN(this.value)) {
            return RubyFixnum.one(context.runtime);
        }
        return super.denominator(context);
    }

    @JRubyMethod(name={"to_r"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_r(ThreadContext context) {
        long[] exp2 = new long[1];
        double f = Numeric.frexp(this.value, exp2);
        f = Numeric.ldexp(f, 53L);
        long n = exp2[0] - 53L;
        Ruby runtime = context.runtime;
        IRubyObject rf = RubyNumeric.dbl2num(runtime, f);
        RubyFixnum rn = RubyFixnum.newFixnum(runtime, n);
        return Numeric.f_mul(context, rf, Numeric.f_expt(context, RubyFixnum.newFixnum(runtime, 2L), rn));
    }

    @JRubyMethod(name={"rationalize"}, optional=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject rationalize(ThreadContext context, IRubyObject[] args2) {
        IRubyObject b;
        IRubyObject a;
        if (Numeric.f_negative_p(context, this)) {
            return Numeric.f_negate(context, ((RubyFloat)Numeric.f_abs(context, this)).rationalize(context, args2));
        }
        Ruby runtime = context.runtime;
        RubyFixnum one = RubyFixnum.one(runtime);
        RubyFixnum two = RubyFixnum.two(runtime);
        if (args2.length != 0) {
            IRubyObject eps = Numeric.f_abs(context, args2[0]);
            a = Numeric.f_sub(context, this, eps);
            b = Numeric.f_add(context, this, eps);
        } else {
            long[] exp2 = new long[1];
            double f = Numeric.frexp(this.value, exp2);
            f = Numeric.ldexp(f, 53L);
            long n = exp2[0] - 53L;
            IRubyObject rf = RubyNumeric.dbl2num(runtime, f);
            RubyFixnum rn = RubyFixnum.newFixnum(runtime, n);
            if (Numeric.f_zero_p(context, rf) || !Numeric.f_negative_p(context, rn) && !Numeric.f_zero_p(context, rn)) {
                return RubyRational.newRationalRaw(runtime, Numeric.f_lshift(context, rf, rn));
            }
            a = RubyRational.newRationalRaw(runtime, Numeric.f_sub(context, Numeric.f_mul(context, two, rf), one), Numeric.f_lshift(context, one, Numeric.f_sub(context, one, rn)));
            b = RubyRational.newRationalRaw(runtime, Numeric.f_add(context, Numeric.f_mul(context, two, rf), one), Numeric.f_lshift(context, one, Numeric.f_sub(context, one, rn)));
        }
        if (RuntimeHelpers.invokedynamic(context, a, 1, b).isTrue()) {
            return Numeric.f_to_r(context, this);
        }
        IRubyObject[] ary = new IRubyObject[]{a, b};
        IRubyObject[] ans = Numeric.nurat_rationalize_internal(context, ary);
        return RubyRational.newRationalRaw(runtime, ans[0], ans[1]);
    }

    @Override
    @JRubyMethod(name={"floor"})
    public IRubyObject floor() {
        return RubyFloat.dbl2num(this.getRuntime(), Math.floor(this.value));
    }

    @Override
    @JRubyMethod(name={"ceil"})
    public IRubyObject ceil() {
        return RubyFloat.dbl2num(this.getRuntime(), Math.ceil(this.value));
    }

    @Override
    @JRubyMethod(name={"round"})
    public IRubyObject round() {
        return RubyFloat.dbl2num(this.getRuntime(), this.val2dbl());
    }

    @JRubyMethod(name={"round"}, optional=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject round(ThreadContext context, IRubyObject[] args2) {
        if (args2.length == 0) {
            return this.round();
        }
        double digits = RubyFloat.num2dbl(args2[0]);
        double magnifier = Math.pow(10.0, Math.abs(digits));
        double number = this.value;
        if (Double.isInfinite(magnifier)) {
            if (digits < 0.0) {
                number = 0.0;
            }
        } else {
            number = digits < 0.0 ? (number /= magnifier) : (number *= magnifier);
            number = Math.round(number);
            number = digits < 0.0 ? (number *= magnifier) : (number /= magnifier);
        }
        if (digits > 0.0) {
            return RubyFloat.newFloat(context.runtime, number);
        }
        return RubyFloat.dbl2num(context.runtime, (long)number);
    }

    private double val2dbl() {
        double f = this.value;
        if (f > 0.0) {
            if (this.value - (f = Math.floor(f)) >= 0.5) {
                f += 1.0;
            }
        } else if (f < 0.0 && (f = Math.ceil(f)) - this.value >= 0.5) {
            f -= 1.0;
        }
        return f;
    }

    @JRubyMethod(name={"nan?"})
    public IRubyObject nan_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), Double.isNaN(this.value));
    }

    @JRubyMethod(name={"infinite?"})
    public IRubyObject infinite_p() {
        if (Double.isInfinite(this.value)) {
            return RubyFixnum.newFixnum(this.getRuntime(), this.value < 0.0 ? -1L : 1L);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"finite?"})
    public IRubyObject finite_p() {
        if (Double.isInfinite(this.value) || Double.isNaN(this.value)) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getTrue();
    }

    private ByteList marshalDump() {
        if (Double.isInfinite(this.value)) {
            return this.value < 0.0 ? NEGATIVE_INFINITY_BYTELIST : INFINITY_BYTELIST;
        }
        if (Double.isNaN(this.value)) {
            return NAN_BYTELIST;
        }
        ByteList byteList = new ByteList();
        Sprintf.sprintf(byteList, Locale.US, (CharSequence)"%.17g", RubyArray.newArray(this.getRuntime(), this));
        return byteList;
    }

    public static void marshalTo(RubyFloat aFloat, MarshalStream output) throws IOException {
        output.registerLinkTarget(aFloat);
        output.writeString(aFloat.marshalDump());
    }

    public static RubyFloat unmarshalFrom(UnmarshalStream input) throws IOException {
        ByteList value2 = input.unmarshalString();
        RubyFloat result2 = value2.equals(NAN_BYTELIST) ? RubyFloat.newFloat(input.getRuntime(), Double.NaN) : (value2.equals(NEGATIVE_INFINITY_BYTELIST) ? RubyFloat.newFloat(input.getRuntime(), Double.NEGATIVE_INFINITY) : (value2.equals(INFINITY_BYTELIST) ? RubyFloat.newFloat(input.getRuntime(), Double.POSITIVE_INFINITY) : RubyFloat.newFloat(input.getRuntime(), ConvertDouble.byteListToDouble(value2, false))));
        input.registerLinkTarget(result2);
        return result2;
    }
}

