/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.dataflow.analyses;

import java.util.HashSet;
import java.util.Map;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRScope;
import org.jruby.ir.dataflow.DataFlowProblem;
import org.jruby.ir.dataflow.FlowGraphNode;
import org.jruby.ir.dataflow.analyses.StoreLocalVarPlacementNode;
import org.jruby.ir.instructions.ReceiveExceptionInstr;
import org.jruby.ir.instructions.StoreLocalVarInstr;
import org.jruby.ir.instructions.ThrowExceptionInstr;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreLocalVarPlacementProblem
extends DataFlowProblem {
    public static final String NAME = "Placement of local-var stores";
    private boolean scopeHasLocalVarStores;
    private boolean scopeHasUnrescuedExceptions;

    public StoreLocalVarPlacementProblem() {
        super(DataFlowProblem.DF_Direction.FORWARD);
    }

    @Override
    public String getName() {
        return "Binding Stores Placement Analysis";
    }

    @Override
    public FlowGraphNode buildFlowGraphNode(BasicBlock bb) {
        return new StoreLocalVarPlacementNode(this, bb);
    }

    @Override
    public String getDataFlowVarsForOutput() {
        return "";
    }

    public boolean scopeHasLocalVarStores() {
        return this.scopeHasLocalVarStores;
    }

    public boolean scopeHasUnrescuedExceptions() {
        return this.scopeHasUnrescuedExceptions;
    }

    public void addStores(Map<Operand, Operand> varRenameMap) {
        boolean mightRequireGlobalEnsureBlock = false;
        HashSet<LocalVariable> dirtyVars = null;
        CFG cfg = this.getScope().cfg();
        IRScope cfgScope = cfg.getScope();
        this.scopeHasLocalVarStores = false;
        this.scopeHasUnrescuedExceptions = false;
        if (cfgScope instanceof IRClosure) {
            mightRequireGlobalEnsureBlock = true;
            dirtyVars = new HashSet<LocalVariable>();
        }
        for (FlowGraphNode n : this.flowGraphNodes) {
            StoreLocalVarPlacementNode bspn = (StoreLocalVarPlacementNode)n;
            boolean bbHasUnrescuedExceptions = !bspn.hasExceptionsRescued();
            boolean bbAddedStores = mightRequireGlobalEnsureBlock && bbHasUnrescuedExceptions ? bspn.addStores(varRenameMap, dirtyVars) : bspn.addStores(varRenameMap, null);
            this.scopeHasUnrescuedExceptions = this.scopeHasUnrescuedExceptions || bbHasUnrescuedExceptions;
            this.scopeHasLocalVarStores = this.scopeHasLocalVarStores || bbAddedStores;
        }
        BasicBlock geb = null;
        if (mightRequireGlobalEnsureBlock && !dirtyVars.isEmpty()) {
            TemporaryVariable exc = cfgScope.getNewTemporaryVariable();
            geb = new BasicBlock(cfg, new Label("_GLOBAL_ENSURE_BLOCK"));
            geb.addInstr(new ReceiveExceptionInstr(exc, false));
            for (LocalVariable v : dirtyVars) {
                Operand value2 = varRenameMap.get(v);
                if (value2 == null) {
                    value2 = cfgScope.getNewTemporaryVariable("%t_" + v.getName());
                    varRenameMap.put(v, value2);
                }
                geb.addInstr(new StoreLocalVarInstr(value2, (IRClosure)cfgScope, v));
            }
            geb.addInstr(new ThrowExceptionInstr(exc));
            cfg.addGlobalEnsureBB(geb);
        }
    }
}

