/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import org.bouncycastle.mail.smime.util.SharedFileInputStream;

public class FileBackedMimeBodyPart
extends MimeBodyPart {
    private static final int BUF_SIZE = 32760;
    private final File _file;

    public FileBackedMimeBodyPart(File file2) throws MessagingException, IOException {
        super((InputStream)new SharedFileInputStream(file2));
        this._file = file2;
    }

    public FileBackedMimeBodyPart(InputStream inputStream, File file2) throws MessagingException, IOException {
        this(FileBackedMimeBodyPart.saveStreamToFile(inputStream, file2));
    }

    public FileBackedMimeBodyPart(InternetHeaders internetHeaders, InputStream inputStream, File file2) throws MessagingException, IOException {
        this(FileBackedMimeBodyPart.saveStreamToFile(internetHeaders, inputStream, file2));
    }

    public void writeTo(OutputStream outputStream) throws IOException, MessagingException {
        if (!this._file.exists()) {
            throw new IOException("file " + this._file.getCanonicalPath() + " no longer exists.");
        }
        super.writeTo(outputStream);
    }

    public void dispose() throws IOException {
        ((SharedFileInputStream)this.contentStream).getRoot().dispose();
        if (this._file.exists() && !this._file.delete()) {
            throw new IOException("deletion of underlying file <" + this._file.getCanonicalPath() + "> failed.");
        }
    }

    private static File saveStreamToFile(InputStream inputStream, File file2) throws IOException {
        FileBackedMimeBodyPart.saveContentToStream(new FileOutputStream(file2), inputStream);
        return file2;
    }

    private static File saveStreamToFile(InternetHeaders internetHeaders, InputStream inputStream, File file2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        Enumeration enumeration = internetHeaders.getAllHeaderLines();
        while (enumeration.hasMoreElements()) {
            FileBackedMimeBodyPart.writeHeader(fileOutputStream, (String)enumeration.nextElement());
        }
        FileBackedMimeBodyPart.writeSeperator(fileOutputStream);
        FileBackedMimeBodyPart.saveContentToStream(fileOutputStream, inputStream);
        return file2;
    }

    private static void writeHeader(OutputStream outputStream, String string2) throws IOException {
        for (int j = 0; j != string2.length(); ++j) {
            outputStream.write(string2.charAt(j));
        }
        FileBackedMimeBodyPart.writeSeperator(outputStream);
    }

    private static void writeSeperator(OutputStream outputStream) throws IOException {
        outputStream.write(13);
        outputStream.write(10);
    }

    private static void saveContentToStream(OutputStream outputStream, InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[32760];
        while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.close();
        inputStream.close();
    }
}

