/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import jline.console.ConsoleReader;
import jline.console.CursorBuffer;
import jline.console.completer.Completer;
import jline.console.completer.FileNameCompleter;
import jline.console.history.History;
import jline.console.history.MemoryHistory;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyModule(name={"Readline"})
public class Readline {
    public static final char ESC_KEY_CODE = '\u001b';
    private static final boolean DEBUG = false;
    private static IRubyObject COMPLETION_CASE_FOLD = null;

    public static void createReadline(Ruby runtime) throws IOException {
        ConsoleHolder holder = new ConsoleHolder();
        holder.history = new MemoryHistory();
        holder.currentCompletor = null;
        COMPLETION_CASE_FOLD = runtime.getNil();
        RubyModule mReadline = runtime.defineModule("Readline");
        mReadline.dataWrapStruct(holder);
        mReadline.defineAnnotatedMethods(Readline.class);
        IRubyObject hist = runtime.getObject().callMethod(runtime.getCurrentContext(), "new");
        mReadline.setConstant("HISTORY", hist);
        hist.getSingletonClass().includeModule(runtime.getEnumerable());
        hist.getSingletonClass().defineAnnotatedMethods(HistoryMethods.class);
        mReadline.setConstant("VERSION", runtime.newString("JLine wrapper"));
    }

    protected static void initReadline(Ruby runtime, final ConsoleHolder holder) {
        try {
            holder.readline = new ConsoleReader();
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
        holder.readline.setHistoryEnabled(false);
        holder.readline.setPaginationEnabled(true);
        holder.readline.setBellEnabled(true);
        if (holder.currentCompletor == null) {
            holder.currentCompletor = new RubyFileNameCompletor();
        }
        holder.readline.addCompleter(holder.currentCompletor);
        holder.readline.setHistory(holder.history);
        holder.readline.addTriggeredAction('\u001b', new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    holder.readline.beep();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public static History getHistory(ConsoleHolder holder) {
        return holder.history;
    }

    public static ConsoleHolder getHolder(Ruby runtime) {
        return (ConsoleHolder)runtime.getModule("Readline").dataGetStruct();
    }

    public static void setCompletor(ConsoleHolder holder, Completer completor) {
        if (holder.readline != null) {
            holder.readline.removeCompleter(holder.currentCompletor);
        }
        holder.currentCompletor = completor;
        if (holder.readline != null) {
            holder.readline.addCompleter(holder.currentCompletor);
        }
    }

    public static Completer getCompletor(ConsoleHolder holder) {
        return holder.currentCompletor;
    }

    public static IRubyObject s_readline(IRubyObject recv2, IRubyObject prompt, IRubyObject add_to_hist) {
        return Readline.s_readline(recv2.getRuntime().getCurrentContext(), recv2, prompt, add_to_hist);
    }

    @JRubyMethod(name={"readline"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_readline(ThreadContext context, IRubyObject recv2, IRubyObject prompt, IRubyObject add_to_hist) {
        Ruby runtime = context.runtime;
        ConsoleHolder holder = Readline.getHolder(runtime);
        if (holder.readline == null) {
            Readline.initReadline(runtime, holder);
        }
        holder.readline.setExpandEvents(false);
        IRubyObject line = runtime.getNil();
        String v = null;
        try {
            holder.readline.getTerminal().setEchoEnabled(false);
            v = holder.readline.readLine(prompt.toString());
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
        finally {
            holder.readline.getTerminal().setEchoEnabled(true);
        }
        if (null != v) {
            if (add_to_hist.isTrue()) {
                holder.readline.getHistory().add(v);
            }
            if (runtime.is1_9()) {
                ByteList list2 = new ByteList(v.getBytes(), runtime.getDefaultExternalEncoding());
                line = RubyString.newString(runtime, list2);
            } else {
                line = RubyString.newUnicodeString(recv2.getRuntime(), v);
            }
        }
        return line;
    }

    @JRubyMethod(name={"input="}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject setInput(ThreadContext context, IRubyObject recv2, IRubyObject input) {
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"output="}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject setOutput(ThreadContext context, IRubyObject recv2, IRubyObject output) {
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"readline"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_readline(IRubyObject recv2, IRubyObject prompt) {
        return Readline.s_readline(recv2, prompt, recv2.getRuntime().getFalse());
    }

    @JRubyMethod(name={"readline"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_readline(IRubyObject recv2) {
        return Readline.s_readline(recv2, RubyString.newEmptyString(recv2.getRuntime()), recv2.getRuntime().getFalse());
    }

    @JRubyMethod(name={"basic_word_break_characters="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_set_basic_word_break_character(IRubyObject recv2, IRubyObject achar) {
        Ruby runtime = recv2.getRuntime();
        if (!achar.respondsTo("to_str")) {
            throw runtime.newTypeError("can't convert " + achar.getMetaClass() + " into String");
        }
        ProcCompleter.setDelimiter(achar.convertToString().toString());
        return achar;
    }

    @JRubyMethod(name={"basic_word_break_characters"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_get_basic_word_break_character(IRubyObject recv2) {
        return recv2.getRuntime().newString(ProcCompleter.getDelimiter());
    }

    @JRubyMethod(name={"completion_append_character="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_set_completion_append_character(IRubyObject recv2, IRubyObject achar) {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(name={"completion_proc="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_set_completion_proc(IRubyObject recv2, IRubyObject proc2) {
        if (!proc2.respondsTo("call")) {
            throw recv2.getRuntime().newArgumentError("argument must respond to call");
        }
        Readline.setCompletor(Readline.getHolder(recv2.getRuntime()), new ProcCompleter(proc2));
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(name={"basic_quote_characters", "basic_quote_characters=", "completer_quote_characters", "completer_quote_characters=", "completer_word_break_characters", "completer_word_break_characters=", "completion_append_character", "completion_proc", "emacs_editing_mode", "filename_quote_characters", "filename_quote_characters=", "vi_editing_mode"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject unimplemented(ThreadContext context, IRubyObject recv2) {
        Ruby runtime = context.runtime;
        String err = context.getFrameName() + "() function is unimplemented on this machine";
        throw runtime.newNotImplementedError(err);
    }

    @JRubyMethod(name={"basic_quote_characters", "basic_quote_characters=", "completer_quote_characters", "completer_quote_characters=", "completer_word_break_characters", "completer_word_break_characters=", "completion_append_character", "completion_proc", "emacs_editing_mode", "emacs_editing_mode?", "filename_quote_characters", "filename_quote_characters=", "vi_editing_mode", "vi_editing_mode?", "set_screen_size"}, frame=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject unimplemented19(ThreadContext context, IRubyObject recv2) {
        Ruby runtime = context.runtime;
        String err = context.getFrameName() + "() function is unimplemented on this machine";
        throw runtime.newNotImplementedError(err);
    }

    @JRubyMethod(name={"completion_case_fold"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_get_completion_case_fold(ThreadContext context, IRubyObject recv2) {
        Ruby runtime = context.runtime;
        return COMPLETION_CASE_FOLD;
    }

    @JRubyMethod(name={"completion_case_fold="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_set_completion_case_fold(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        Ruby runtime = context.runtime;
        COMPLETION_CASE_FOLD = other;
        return COMPLETION_CASE_FOLD;
    }

    @JRubyMethod(name={"get_screen_size"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject s_get_screen_size(ThreadContext context, IRubyObject recv2) {
        Ruby runtime = context.runtime;
        ConsoleHolder holder = Readline.getHolder(runtime);
        IRubyObject[] ary = new IRubyObject[]{runtime.newFixnum(holder.readline.getTerminal().getHeight()), runtime.newFixnum(holder.readline.getTerminal().getWidth())};
        return RubyArray.newArray(runtime, ary);
    }

    @JRubyMethod(name={"line_buffer"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject s_get_line_buffer(ThreadContext context, IRubyObject recv2) {
        Ruby runtime = context.runtime;
        ConsoleHolder holder = Readline.getHolder(runtime);
        if (holder.readline == null) {
            Readline.initReadline(runtime, holder);
        }
        CursorBuffer cb = holder.readline.getCursorBuffer();
        return runtime.newString(cb.toString()).taint(context);
    }

    @JRubyMethod(name={"point"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject s_get_point(ThreadContext context, IRubyObject recv2) {
        Ruby runtime = context.runtime;
        ConsoleHolder holder = Readline.getHolder(runtime);
        if (holder.readline == null) {
            Readline.initReadline(runtime, holder);
        }
        CursorBuffer cb = holder.readline.getCursorBuffer();
        return runtime.newFixnum(cb.cursor);
    }

    @JRubyMethod(name={"refresh_line"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject s_refresh_line(ThreadContext context, IRubyObject recv2) {
        Ruby runtime = context.runtime;
        ConsoleHolder holder = Readline.getHolder(runtime);
        try {
            holder.readline.redrawLine();
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
        return runtime.getNil();
    }

    public static class RubyFileNameCompletor
    extends FileNameCompleter {
        public int complete(String buffer, int cursor, List candidates) {
            int index2 = (buffer = buffer.substring(0, cursor)).lastIndexOf(" ");
            if (index2 != -1) {
                buffer = buffer.substring(index2 + 1);
            }
            return index2 + 1 + super.complete(buffer, cursor, candidates);
        }
    }

    public static class ProcCompleter
    implements Completer {
        IRubyObject procCompleter;
        private static String[] delimiters = new String[]{" ", "\t", "\n", "\"", "\\", "'", "`", "@", "$", ">", "<", "=", ";", "|", "&", "{", "("};

        public ProcCompleter(IRubyObject procCompleter) {
            this.procCompleter = procCompleter;
        }

        public static String getDelimiter() {
            StringBuilder result2 = new StringBuilder(delimiters.length);
            for (String delimiter : delimiters) {
                result2.append(delimiter);
            }
            return result2.toString();
        }

        public static void setDelimiter(String delimiter) {
            ArrayList<String> l = new ArrayList<String>();
            CharBuffer buf = CharBuffer.wrap(delimiter);
            while (buf.hasRemaining()) {
                l.add(String.valueOf(buf.get()));
            }
            delimiters = l.toArray(new String[l.size()]);
        }

        private int wordIndexOf(String buffer) {
            int index2 = 0;
            for (String c : delimiters) {
                index2 = buffer.lastIndexOf(c);
                if (index2 == -1) continue;
                return index2;
            }
            return index2;
        }

        public int complete(String buffer, int cursor, List candidates) {
            Ruby runtime;
            ThreadContext context;
            IRubyObject result2;
            IRubyObject comps;
            int index2 = this.wordIndexOf(buffer = buffer.substring(0, cursor));
            if (index2 != -1) {
                buffer = buffer.substring(index2 + 1);
            }
            if ((comps = (result2 = this.procCompleter.callMethod(context = (runtime = this.procCompleter.getRuntime()).getCurrentContext(), "call", runtime.newString(buffer))).callMethod(context, "to_a")) instanceof List) {
                for (Object obj : (List)((Object)comps)) {
                    if (obj == null) continue;
                    candidates.add(obj.toString());
                }
                Collections.sort(candidates);
            }
            return cursor - buffer.length();
        }
    }

    public static class HistoryMethods {
        @JRubyMethod(name={"push", "<<"}, rest=true)
        public static IRubyObject s_push(IRubyObject recv2, IRubyObject[] lines2) {
            ConsoleHolder holder = Readline.getHolder(recv2.getRuntime());
            for (int i2 = 0; i2 < lines2.length; ++i2) {
                RubyString line = lines2[i2].convertToString();
                holder.history.add(line.getUnicodeValue());
            }
            return recv2;
        }

        @JRubyMethod(name={"pop"})
        public static IRubyObject s_pop(IRubyObject recv2) {
            Ruby runtime = recv2.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime);
            if (holder.history.isEmpty()) {
                return runtime.getNil();
            }
            return runtime.newString(((Object)holder.history.removeLast()).toString()).taint(runtime.getCurrentContext());
        }

        @JRubyMethod(name={"to_a"})
        public static IRubyObject s_hist_to_a(IRubyObject recv2) {
            Ruby runtime = recv2.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime);
            RubyArray histList = runtime.newArray();
            ListIterator<History.Entry> historyIterator = holder.history.entries();
            while (historyIterator.hasNext()) {
                History.Entry nextEntry = historyIterator.next();
                histList.append(runtime.newString(((Object)nextEntry.value()).toString()));
            }
            return histList;
        }

        @JRubyMethod(name={"to_s"})
        public static IRubyObject s_hist_to_s(IRubyObject recv2) {
            return recv2.getRuntime().newString("HISTORY");
        }

        @JRubyMethod(name={"[]"})
        public static IRubyObject s_hist_get(IRubyObject recv2, IRubyObject index2) {
            Ruby runtime = recv2.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime);
            int i2 = (int)index2.convertToInteger().getLongValue();
            if (i2 < 0) {
                i2 += holder.history.size();
            }
            try {
                ThreadContext context = runtime.getCurrentContext();
                return runtime.newString((String)holder.history.get(i2)).taint(context);
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw runtime.newIndexError("invalid history index: " + i2);
            }
        }

        @JRubyMethod(name={"[]="})
        public static IRubyObject s_hist_set(IRubyObject recv2, IRubyObject index2, IRubyObject val) {
            Ruby runtime = recv2.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime);
            int i2 = (int)index2.convertToInteger().getLongValue();
            if (i2 < 0) {
                i2 += holder.history.size();
            }
            try {
                holder.history.set(i2, val.asJavaString());
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw runtime.newIndexError("invalid history index: " + i2);
            }
            return runtime.getNil();
        }

        @JRubyMethod(name={"shift"})
        public static IRubyObject s_hist_shift(IRubyObject recv2) {
            Ruby runtime = recv2.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime);
            if (holder.history.isEmpty()) {
                return runtime.getNil();
            }
            try {
                return runtime.newString(((Object)holder.history.removeFirst()).toString()).taint(runtime.getCurrentContext());
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw runtime.newIndexError("history shift error");
            }
        }

        @JRubyMethod(name={"length", "size"})
        public static IRubyObject s_hist_length(IRubyObject recv2) {
            ConsoleHolder holder = Readline.getHolder(recv2.getRuntime());
            return recv2.getRuntime().newFixnum(holder.history.size());
        }

        @JRubyMethod(name={"empty?"})
        public static IRubyObject s_hist_empty_p(IRubyObject recv2) {
            ConsoleHolder holder = Readline.getHolder(recv2.getRuntime());
            return recv2.getRuntime().newBoolean(holder.history.isEmpty());
        }

        @JRubyMethod(name={"delete_at"})
        public static IRubyObject s_hist_delete_at(IRubyObject recv2, IRubyObject index2) {
            Ruby runtime = recv2.getRuntime();
            ThreadContext context = runtime.getCurrentContext();
            ConsoleHolder holder = Readline.getHolder(runtime);
            int i2 = RubyNumeric.num2int(index2);
            if (i2 < 0) {
                i2 += holder.history.size();
            }
            try {
                return runtime.newString(((Object)holder.history.remove(i2)).toString()).taint(context);
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw runtime.newIndexError("invalid history index: " + i2);
            }
        }

        @JRubyMethod(name={"each"})
        public static IRubyObject s_hist_each(IRubyObject recv2, Block block) {
            Ruby runtime = recv2.getRuntime();
            ThreadContext context = runtime.getCurrentContext();
            ConsoleHolder holder = Readline.getHolder(runtime);
            Iterator<History.Entry> i2 = holder.history.iterator();
            while (i2.hasNext()) {
                block.yield(context, runtime.newString(((Object)i2.next().value()).toString()).taint(context));
            }
            return recv2;
        }
    }

    public static class ConsoleHolder {
        public ConsoleReader readline;
        public Completer currentCompletor;
        public History history;
    }
}

