/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;

public class DERNumericString
extends ASN1Object
implements DERString {
    String string;

    public static DERNumericString getInstance(Object object) {
        if (object == null || object instanceof DERNumericString) {
            return (DERNumericString)object;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERNumericString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        DERObject dERObject = aSN1TaggedObject.getObject();
        if (bl || dERObject instanceof DERNumericString) {
            return DERNumericString.getInstance(dERObject);
        }
        return new DERNumericString(ASN1OctetString.getInstance(dERObject).getOctets());
    }

    public DERNumericString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int j = 0; j != cArray.length; ++j) {
            cArray[j] = (char)(byArray[j] & 0xFF);
        }
        this.string = new String(cArray);
    }

    public DERNumericString(String string2) {
        this(string2, false);
    }

    public DERNumericString(String string2, boolean bl) {
        if (bl && !DERNumericString.isNumericString(string2)) {
            throw new IllegalArgumentException("string contains illegal characters");
        }
        this.string = string2;
    }

    public String getString() {
        return this.string;
    }

    public String toString() {
        return this.string;
    }

    public byte[] getOctets() {
        char[] cArray = this.string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int j = 0; j != cArray.length; ++j) {
            byArray[j] = (byte)cArray[j];
        }
        return byArray;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(18, this.getOctets());
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERNumericString)) {
            return false;
        }
        DERNumericString dERNumericString = (DERNumericString)dERObject;
        return this.getString().equals(dERNumericString.getString());
    }

    public static boolean isNumericString(String string2) {
        for (int j = string2.length() - 1; j >= 0; --j) {
            char c = string2.charAt(j);
            if (c > '\u007f') {
                return false;
            }
            if ('0' <= c && c <= '9' || c == ' ') continue;
            return false;
        }
        return true;
    }
}

