/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.HashSet;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyHash;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RecursiveComparator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject compare(ThreadContext context, int method2, IRubyObject a, IRubyObject b) {
        Ruby runtime = context.getRuntime();
        if (a == b) {
            return runtime.getTrue();
        }
        boolean clear2 = false;
        try {
            Set<Pair> seen = null;
            if (a instanceof RubyHash && b instanceof RubyHash || a instanceof RubyArray && b instanceof RubyArray) {
                Pair pair = new Pair(a, b);
                seen = context.getRecursiveSet();
                if (seen == null) {
                    seen = new HashSet<Pair>();
                    context.setRecursiveSet(seen);
                    clear2 = true;
                } else if (seen.contains(pair)) {
                    RubyBoolean rubyBoolean = runtime.getTrue();
                    return rubyBoolean;
                }
                seen.add(pair);
            }
            if (a instanceof RubyHash) {
                RubyHash hash2 = (RubyHash)a;
                RubyBoolean rubyBoolean = hash2.compare(context, method2, b);
                return rubyBoolean;
            }
            if (a instanceof RubyArray) {
                RubyArray array = (RubyArray)a;
                RubyBoolean rubyBoolean = array.compare(context, method2, b);
                return rubyBoolean;
            }
            IRubyObject iRubyObject = RuntimeHelpers.invokedynamic(context, a, method2, b);
            return iRubyObject;
        }
        finally {
            if (clear2) {
                context.setRecursiveSet(null);
            }
        }
    }

    public static class Pair {
        private int a;
        private int b;

        public Pair(IRubyObject a, IRubyObject b) {
            this.a = System.identityHashCode(a);
            this.b = System.identityHashCode(b);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof Pair)) {
                return false;
            }
            Pair pair = (Pair)other;
            return this.a == pair.a && this.b == pair.b;
        }

        public int hashCode() {
            int result2 = this.a;
            result2 = 31 * result2 + this.b;
            return result2;
        }
    }
}

