/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.addons;

import java.lang.reflect.Array;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaArray;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ArrayJavaAddons {
    @JRubyMethod
    public static IRubyObject copy_data(ThreadContext context, IRubyObject rubyArray, IRubyObject javaArray, IRubyObject fillValue) {
        int i2;
        int rubyLength;
        JavaArray javaArrayJavaObj = (JavaArray)javaArray.dataGetStruct();
        Object fillJavaObject = null;
        int javaLength = (int)javaArrayJavaObj.length().getLongValue();
        Class targetType = javaArrayJavaObj.getComponentType();
        if (!fillValue.isNil()) {
            fillJavaObject = fillValue.toJava(targetType);
        }
        RubyArray array = null;
        if (rubyArray instanceof RubyArray) {
            array = (RubyArray)rubyArray;
            rubyLength = ((RubyArray)rubyArray).getLength();
        } else {
            rubyLength = 0;
            fillJavaObject = rubyArray.toJava(targetType);
        }
        for (i2 = 0; i2 < rubyLength && i2 < javaLength; ++i2) {
            javaArrayJavaObj.setWithExceptionHandling(i2, array.entry(i2).toJava(targetType));
        }
        if (i2 < javaLength && fillJavaObject != null) {
            javaArrayJavaObj.fillWithExceptionHandling(i2, javaLength, fillJavaObject);
        }
        return javaArray;
    }

    @JRubyMethod
    public static IRubyObject copy_data_simple(ThreadContext context, IRubyObject from, IRubyObject to) {
        JavaArray javaArray = (JavaArray)to.dataGetStruct();
        RubyArray rubyArray = (RubyArray)from;
        ArrayJavaAddons.copyDataToJavaArray(context, rubyArray, javaArray);
        return to;
    }

    public static void copyDataToJavaArray(ThreadContext context, RubyArray rubyArray, JavaArray javaArray) {
        int javaLength = (int)javaArray.length().getLongValue();
        Class targetType = javaArray.getComponentType();
        int rubyLength = rubyArray.getLength();
        for (int i2 = 0; i2 < rubyLength && i2 < javaLength; ++i2) {
            javaArray.setWithExceptionHandling(i2, rubyArray.entry(i2).toJava(targetType));
        }
    }

    public static void copyDataToJavaArrayDirect(ThreadContext context, RubyArray rubyArray, Object javaArray) {
        int javaLength = Array.getLength(javaArray);
        Class<?> targetType = javaArray.getClass().getComponentType();
        int rubyLength = rubyArray.getLength();
        for (int i2 = 0; i2 < rubyLength && i2 < javaLength; ++i2) {
            Array.set(javaArray, i2, rubyArray.entry(i2).toJava(targetType));
        }
    }

    public static void copyDataToJavaArray(ThreadContext context, RubyArray rubyArray, int src, JavaArray javaArray, int dest, int length2) {
        Class targetType = javaArray.getComponentType();
        int destLength = (int)javaArray.length().getLongValue();
        int srcLength = rubyArray.getLength();
        for (int i2 = 0; src + i2 < srcLength && dest + i2 < destLength && i2 < length2; ++i2) {
            javaArray.setWithExceptionHandling(dest + i2, rubyArray.entry(src + i2).toJava(targetType));
        }
    }

    @JRubyMethod
    public static IRubyObject dimensions(ThreadContext context, IRubyObject maybeArray) {
        Ruby runtime = context.getRuntime();
        if (!(maybeArray instanceof RubyArray)) {
            return runtime.newEmptyArray();
        }
        RubyArray rubyArray = (RubyArray)maybeArray;
        RubyArray dims = runtime.newEmptyArray();
        return ArrayJavaAddons.dimsRecurse(context, rubyArray, dims, 0);
    }

    @JRubyMethod
    public static IRubyObject dimensions(ThreadContext context, IRubyObject maybeArray, IRubyObject dims) {
        Ruby runtime = context.getRuntime();
        if (!(maybeArray instanceof RubyArray)) {
            return runtime.newEmptyArray();
        }
        assert (dims instanceof RubyArray);
        RubyArray rubyArray = (RubyArray)maybeArray;
        return ArrayJavaAddons.dimsRecurse(context, rubyArray, (RubyArray)dims, 0);
    }

    @JRubyMethod
    public static IRubyObject dimensions(ThreadContext context, IRubyObject maybeArray, IRubyObject dims, IRubyObject index2) {
        Ruby runtime = context.getRuntime();
        if (!(maybeArray instanceof RubyArray)) {
            return runtime.newEmptyArray();
        }
        assert (dims instanceof RubyArray);
        assert (index2 instanceof RubyFixnum);
        RubyArray rubyArray = (RubyArray)maybeArray;
        return ArrayJavaAddons.dimsRecurse(context, rubyArray, (RubyArray)dims, (int)((RubyFixnum)index2).getLongValue());
    }

    private static RubyArray dimsRecurse(ThreadContext context, RubyArray rubyArray, RubyArray dims, int index2) {
        Ruby runtime = context.getRuntime();
        while (dims.size() <= index2) {
            dims.append(RubyFixnum.zero(runtime));
        }
        if ((long)rubyArray.size() > ((RubyFixnum)dims.eltInternal(index2)).getLongValue()) {
            dims.eltInternalSet(index2, RubyFixnum.newFixnum(runtime, rubyArray.size()));
        }
        for (int i2 = 0; i2 < rubyArray.size(); ++i2) {
            if (!(rubyArray.eltInternal(i2) instanceof RubyArray)) continue;
            ArrayJavaAddons.dimsRecurse(context, (RubyArray)rubyArray.eltInternal(i2), dims, 1);
        }
        return dims;
    }
}

