/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions.ruby19;

import org.jruby.Ruby;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReceiveRestArgBase;
import org.jruby.ir.instructions.RestArgMultipleAsgnInstr;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.builtin.IRubyObject;

public class ReceiveRestArgInstr19
extends ReceiveRestArgBase {
    private final int totalRequiredArgs;
    private final int totalOptArgs;
    private IRubyObject[] NO_PARAMS = new IRubyObject[0];

    public ReceiveRestArgInstr19(Variable result2, int argIndex, int totalRequiredArgs, int totalOptArgs) {
        super(result2, argIndex);
        this.totalRequiredArgs = totalRequiredArgs;
        this.totalOptArgs = totalOptArgs;
    }

    public String toString() {
        return (this.isDead() ? "[DEAD]" : "") + (this.hasUnusedResult() ? "[DEAD-RESULT]" : "") + this.getResult() + " = " + (Object)((Object)this.getOperation()) + "(" + this.argIndex + ", " + this.totalRequiredArgs + ", " + this.totalOptArgs + ")";
    }

    public Instr cloneForInlining(InlinerInfo ii) {
        if (ii.canMapArgsStatically()) {
            return new CopyInstr(ii.getRenamedVariable(this.result), ii.getArg(this.argIndex, true));
        }
        return new RestArgMultipleAsgnInstr(ii.getRenamedVariable(this.result), ii.getArgs(), this.argIndex, this.totalRequiredArgs + this.totalOptArgs - this.argIndex, this.argIndex);
    }

    public Instr cloneForBlockCloning(InlinerInfo ii) {
        return new ReceiveRestArgInstr19(ii.getRenamedVariable(this.result), this.argIndex, this.totalRequiredArgs, this.totalOptArgs);
    }

    public IRubyObject receiveRestArg(Ruby runtime, IRubyObject[] parameters2) {
        IRubyObject[] args2;
        int numAvalableArgs = parameters2.length - (this.totalRequiredArgs + this.totalOptArgs);
        if (numAvalableArgs <= 0) {
            args2 = this.NO_PARAMS;
        } else {
            args2 = new IRubyObject[numAvalableArgs];
            System.arraycopy(parameters2, this.argIndex, args2, 0, numAvalableArgs);
        }
        return runtime.newArray(args2);
    }

    public void visit(IRVisitor visitor) {
        visitor.ReceiveRestArgInstr19(this);
    }
}

