/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.Node;
import org.jruby.compiler.ASTInspector;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.MethodArgs;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class InterpretedMethod
extends DynamicMethod
implements MethodArgs,
PositionAware {
    private StaticScope staticScope;
    private Node body;
    private ArgsNode argsNode;
    private ISourcePosition position;
    private String file;
    private int line;
    private boolean needsScope;

    public InterpretedMethod(RubyModule implementationClass, StaticScope staticScope, Node body, String name2, ArgsNode argsNode, Visibility visibility, ISourcePosition position) {
        super(implementationClass, visibility, CallConfiguration.FrameFullScopeFull, name2);
        this.body = body;
        this.staticScope = staticScope;
        this.argsNode = argsNode;
        this.position = position;
        this.file = position.getFile();
        this.line = position.getLine();
        ASTInspector inspector = new ASTInspector();
        inspector.inspect(body);
        inspector.inspect(argsNode);
        this.needsScope = true;
        assert (argsNode != null);
    }

    public Node getBodyNode() {
        return this.body;
    }

    public ArgsNode getArgsNode() {
        return this.argsNode;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        assert (args2 != null);
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            this.pre(context, name2, self, block, runtime);
            this.argsNode.checkArgCount(runtime, args2.length);
            this.argsNode.prepare(context, runtime, self, args2, block);
            IRubyObject iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, block, this.isTraceable());
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
        return this.call(context, self, clazz, name2, args2, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            this.pre(context, name2, self, Block.NULL_BLOCK, runtime);
            this.argsNode.checkArgCount(runtime, 0);
            this.argsNode.prepare(context, runtime, self, Block.NULL_BLOCK);
            IRubyObject iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK, this.isTraceable());
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, Block block) {
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            this.pre(context, name2, self, block, runtime);
            this.argsNode.checkArgCount(runtime, 0);
            this.argsNode.prepare(context, runtime, self, block);
            IRubyObject iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, block, this.isTraceable());
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0) {
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            this.pre(context, name2, self, Block.NULL_BLOCK, runtime);
            this.argsNode.checkArgCount(runtime, 1);
            this.argsNode.prepare(context, runtime, self, arg0, Block.NULL_BLOCK);
            IRubyObject iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK, this.isTraceable());
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            this.pre(context, name2, self, block, runtime);
            this.argsNode.checkArgCount(runtime, 1);
            this.argsNode.prepare(context, runtime, self, arg0, block);
            IRubyObject iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, block, this.isTraceable());
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            this.pre(context, name2, self, Block.NULL_BLOCK, runtime);
            this.argsNode.checkArgCount(runtime, 2);
            this.argsNode.prepare(context, runtime, self, arg0, arg1, Block.NULL_BLOCK);
            IRubyObject iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK, this.isTraceable());
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            this.pre(context, name2, self, block, runtime);
            this.argsNode.checkArgCount(runtime, 2);
            this.argsNode.prepare(context, runtime, self, arg0, arg1, block);
            IRubyObject iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, block, this.isTraceable());
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            this.pre(context, name2, self, Block.NULL_BLOCK, runtime);
            this.argsNode.checkArgCount(runtime, 3);
            this.argsNode.prepare(context, runtime, self, arg0, arg1, arg2, Block.NULL_BLOCK);
            IRubyObject iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK, this.isTraceable());
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            this.pre(context, name2, self, block, runtime);
            this.argsNode.checkArgCount(runtime, 3);
            this.argsNode.prepare(context, runtime, self, arg0, arg1, arg2, block);
            IRubyObject iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, block, this.isTraceable());
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            this.pre(context, name2, self, Block.NULL_BLOCK, runtime);
            this.argsNode.checkArgCount(runtime, 4);
            this.argsNode.prepare(context, runtime, self, arg0, arg1, arg2, arg3, Block.NULL_BLOCK);
            IRubyObject iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK, this.isTraceable());
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            this.pre(context, name2, self, block, runtime);
            this.argsNode.checkArgCount(runtime, 4);
            this.argsNode.prepare(context, runtime, self, arg0, arg1, arg2, arg3, block);
            IRubyObject iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, block, this.isTraceable());
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4) {
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            this.pre(context, name2, self, Block.NULL_BLOCK, runtime);
            this.argsNode.checkArgCount(runtime, 5);
            this.argsNode.prepare(context, runtime, self, arg0, arg1, arg2, arg3, arg4, Block.NULL_BLOCK);
            IRubyObject iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK, this.isTraceable());
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, Block block) {
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            this.pre(context, name2, self, block, runtime);
            this.argsNode.checkArgCount(runtime, 5);
            this.argsNode.prepare(context, runtime, self, arg0, arg1, arg2, arg3, arg4, block);
            IRubyObject iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, block, this.isTraceable());
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5) {
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            this.pre(context, name2, self, Block.NULL_BLOCK, runtime);
            this.argsNode.checkArgCount(runtime, 6);
            this.argsNode.prepare(context, runtime, self, arg0, arg1, arg2, arg3, arg4, arg5, Block.NULL_BLOCK);
            IRubyObject iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK, this.isTraceable());
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, Block block) {
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            this.pre(context, name2, self, block, runtime);
            this.argsNode.checkArgCount(runtime, 6);
            this.argsNode.prepare(context, runtime, self, arg0, arg1, arg2, arg3, arg4, arg5, block);
            IRubyObject iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, block, this.isTraceable());
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6) {
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            this.pre(context, name2, self, Block.NULL_BLOCK, runtime);
            this.argsNode.checkArgCount(runtime, 7);
            this.argsNode.prepare(context, runtime, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, Block.NULL_BLOCK);
            IRubyObject iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK, this.isTraceable());
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, Block block) {
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            this.pre(context, name2, self, block, runtime);
            this.argsNode.checkArgCount(runtime, 7);
            this.argsNode.prepare(context, runtime, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, block);
            IRubyObject iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, block, this.isTraceable());
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7) {
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            this.pre(context, name2, self, Block.NULL_BLOCK, runtime);
            this.argsNode.checkArgCount(runtime, 8);
            this.argsNode.prepare(context, runtime, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, Block.NULL_BLOCK);
            IRubyObject iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK, this.isTraceable());
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, Block block) {
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            this.pre(context, name2, self, block, runtime);
            this.argsNode.checkArgCount(runtime, 8);
            this.argsNode.prepare(context, runtime, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, block);
            IRubyObject iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, block, this.isTraceable());
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8) {
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            this.pre(context, name2, self, Block.NULL_BLOCK, runtime);
            this.argsNode.checkArgCount(runtime, 9);
            this.argsNode.prepare(context, runtime, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, Block.NULL_BLOCK);
            IRubyObject iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK, this.isTraceable());
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8, Block block) {
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            this.pre(context, name2, self, block, runtime);
            this.argsNode.checkArgCount(runtime, 9);
            this.argsNode.prepare(context, runtime, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, block);
            IRubyObject iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, block, this.isTraceable());
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8, IRubyObject arg9) {
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            this.pre(context, name2, self, Block.NULL_BLOCK, runtime);
            this.argsNode.checkArgCount(runtime, 10);
            this.argsNode.prepare(context, runtime, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, Block.NULL_BLOCK);
            IRubyObject iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK, this.isTraceable());
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8, IRubyObject arg9, Block block) {
        Ruby runtime = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            this.pre(context, name2, self, block, runtime);
            this.argsNode.checkArgCount(runtime, 10);
            this.argsNode.prepare(context, runtime, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, block);
            IRubyObject iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, block, this.isTraceable());
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    protected void pre(ThreadContext context, String name2, IRubyObject self, Block block, Ruby runtime) {
        if (this.needsScope) {
            context.preMethodFrameAndScope(this.getImplementationClass(), name2, self, block, this.staticScope);
        } else {
            context.preMethodFrameAndDummyScope(this.getImplementationClass(), name2, self, block, this.staticScope);
        }
    }

    protected void post(Ruby runtime, ThreadContext context, String name2) {
        context.postMethodFrameAndScope();
    }

    protected boolean isTraceable() {
        return false;
    }

    public ISourcePosition getPosition() {
        return this.position;
    }

    public String getFile() {
        return this.position.getFile();
    }

    public int getLine() {
        return this.position.getLine();
    }

    public Arity getArity() {
        return this.argsNode.getArity();
    }

    public DynamicMethod dup() {
        return new InterpretedMethod(this.getImplementationClass(), this.staticScope, this.body, this.name, this.argsNode, this.getVisibility(), this.position);
    }
}

