/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.hidden.jline.console.completer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jruby.hidden.jline.console.completer.Completer;
import org.jruby.hidden.jline.internal.Log;
import org.jruby.hidden.jline.internal.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentCompleter
implements Completer {
    private final ArgumentDelimiter delimiter;
    private final List<Completer> completers = new ArrayList<Completer>();
    private boolean strict = true;

    public ArgumentCompleter(ArgumentDelimiter delimiter, Collection<Completer> completers) {
        this.delimiter = Preconditions.checkNotNull(delimiter);
        Preconditions.checkNotNull(completers);
        this.completers.addAll(completers);
    }

    public ArgumentCompleter(ArgumentDelimiter delimiter, Completer ... completers) {
        this(delimiter, Arrays.asList(completers));
    }

    public ArgumentCompleter(Completer ... completers) {
        this((ArgumentDelimiter)new WhitespaceArgumentDelimiter(), completers);
    }

    public ArgumentCompleter(List<Completer> completers) {
        this((ArgumentDelimiter)new WhitespaceArgumentDelimiter(), completers);
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public ArgumentDelimiter getDelimiter() {
        return this.delimiter;
    }

    public List<Completer> getCompleters() {
        return this.completers;
    }

    @Override
    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        Preconditions.checkNotNull(candidates);
        ArgumentDelimiter delim = this.getDelimiter();
        ArgumentList list2 = delim.delimit(buffer, cursor);
        int argpos = list2.getArgumentPosition();
        int argIndex = list2.getCursorArgumentIndex();
        if (argIndex < 0) {
            return -1;
        }
        List<Completer> completers = this.getCompleters();
        Completer completer = argIndex >= completers.size() ? completers.get(completers.size() - 1) : completers.get(argIndex);
        for (int i2 = 0; this.isStrict() && i2 < argIndex; ++i2) {
            Completer sub3 = completers.get(i2 >= completers.size() ? completers.size() - 1 : i2);
            String[] args2 = list2.getArguments();
            String arg2 = args2 == null || i2 >= args2.length ? "" : args2[i2];
            LinkedList<CharSequence> subCandidates = new LinkedList<CharSequence>();
            if (sub3.complete(arg2, arg2.length(), subCandidates) == -1) {
                return -1;
            }
            if (subCandidates.size() != 0) continue;
            return -1;
        }
        int ret = completer.complete(list2.getCursorArgument(), argpos, candidates);
        if (ret == -1) {
            return -1;
        }
        int pos2 = ret + list2.getBufferPosition() - argpos;
        if (cursor != buffer.length() && delim.isDelimiter(buffer, cursor)) {
            for (int i3 = 0; i3 < candidates.size(); ++i3) {
                CharSequence val = candidates.get(i3);
                while (val.length() > 0 && delim.isDelimiter(val, val.length() - 1)) {
                    val = val.subSequence(0, val.length() - 1);
                }
                candidates.set(i3, val);
            }
        }
        Log.trace("Completing ", buffer, " (pos=", cursor, ") with: ", candidates, ": offset=", pos2);
        return pos2;
    }

    public static class ArgumentList {
        private String[] arguments;
        private int cursorArgumentIndex;
        private int argumentPosition;
        private int bufferPosition;

        public ArgumentList(String[] arguments, int cursorArgumentIndex, int argumentPosition, int bufferPosition) {
            this.arguments = Preconditions.checkNotNull(arguments);
            this.cursorArgumentIndex = cursorArgumentIndex;
            this.argumentPosition = argumentPosition;
            this.bufferPosition = bufferPosition;
        }

        public void setCursorArgumentIndex(int i2) {
            this.cursorArgumentIndex = i2;
        }

        public int getCursorArgumentIndex() {
            return this.cursorArgumentIndex;
        }

        public String getCursorArgument() {
            if (this.cursorArgumentIndex < 0 || this.cursorArgumentIndex >= this.arguments.length) {
                return null;
            }
            return this.arguments[this.cursorArgumentIndex];
        }

        public void setArgumentPosition(int pos2) {
            this.argumentPosition = pos2;
        }

        public int getArgumentPosition() {
            return this.argumentPosition;
        }

        public void setArguments(String[] arguments) {
            this.arguments = arguments;
        }

        public String[] getArguments() {
            return this.arguments;
        }

        public void setBufferPosition(int pos2) {
            this.bufferPosition = pos2;
        }

        public int getBufferPosition() {
            return this.bufferPosition;
        }
    }

    public static class WhitespaceArgumentDelimiter
    extends AbstractArgumentDelimiter {
        public boolean isDelimiterChar(CharSequence buffer, int pos2) {
            return Character.isWhitespace(buffer.charAt(pos2));
        }
    }

    public static abstract class AbstractArgumentDelimiter
    implements ArgumentDelimiter {
        private char[] quoteChars = new char[]{'\'', '\"'};
        private char[] escapeChars = new char[]{'\\'};

        public void setQuoteChars(char[] chars2) {
            this.quoteChars = chars2;
        }

        public char[] getQuoteChars() {
            return this.quoteChars;
        }

        public void setEscapeChars(char[] chars2) {
            this.escapeChars = chars2;
        }

        public char[] getEscapeChars() {
            return this.escapeChars;
        }

        public ArgumentList delimit(CharSequence buffer, int cursor) {
            LinkedList<String> args2 = new LinkedList<String>();
            StringBuilder arg2 = new StringBuilder();
            int argpos = -1;
            int bindex = -1;
            for (int i2 = 0; buffer != null && i2 <= buffer.length(); ++i2) {
                if (i2 == cursor) {
                    bindex = args2.size();
                    argpos = arg2.length();
                }
                if (i2 == buffer.length() || this.isDelimiter(buffer, i2)) {
                    if (arg2.length() <= 0) continue;
                    args2.add(arg2.toString());
                    arg2.setLength(0);
                    continue;
                }
                arg2.append(buffer.charAt(i2));
            }
            return new ArgumentList(args2.toArray(new String[args2.size()]), bindex, argpos, cursor);
        }

        public boolean isDelimiter(CharSequence buffer, int pos2) {
            return !this.isQuoted(buffer, pos2) && !this.isEscaped(buffer, pos2) && this.isDelimiterChar(buffer, pos2);
        }

        public boolean isQuoted(CharSequence buffer, int pos2) {
            return false;
        }

        public boolean isEscaped(CharSequence buffer, int pos2) {
            if (pos2 <= 0) {
                return false;
            }
            for (int i2 = 0; this.escapeChars != null && i2 < this.escapeChars.length; ++i2) {
                if (buffer.charAt(pos2) != this.escapeChars[i2]) continue;
                return !this.isEscaped(buffer, pos2 - 1);
            }
            return false;
        }

        public abstract boolean isDelimiterChar(CharSequence var1, int var2);
    }

    public static interface ArgumentDelimiter {
        public ArgumentList delimit(CharSequence var1, int var2);

        public boolean isDelimiter(CharSequence var1, int var2);
    }
}

