/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.hidden.jline;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.jruby.hidden.jline.AnsiWindowsTerminal;
import org.jruby.hidden.jline.Terminal;
import org.jruby.hidden.jline.UnixTerminal;
import org.jruby.hidden.jline.UnsupportedTerminal;
import org.jruby.hidden.jline.internal.Configuration;
import org.jruby.hidden.jline.internal.Log;
import org.jruby.hidden.jline.internal.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerminalFactory {
    public static final String JLINE_TERMINAL = "org.jruby.hidden.jline.terminal";
    public static final String AUTO = "auto";
    public static final String UNIX = "unix";
    public static final String WIN = "win";
    public static final String WINDOWS = "windows";
    public static final String NONE = "none";
    public static final String OFF = "off";
    public static final String FALSE = "false";
    private static final InheritableThreadLocal<Terminal> holder = new InheritableThreadLocal();
    private static final Map<Flavor, Class<? extends Terminal>> FLAVORS = new HashMap<Flavor, Class<? extends Terminal>>();

    public static synchronized Terminal create() {
        Terminal t;
        block12: {
            if (Log.TRACE) {
                Log.trace(new Throwable("CREATE MARKER"));
            }
            String type2 = Configuration.getString(JLINE_TERMINAL, AUTO);
            Log.debug("Creating terminal; type=", type2);
            try {
                String tmp = type2.toLowerCase();
                if (tmp.equals(UNIX)) {
                    t = TerminalFactory.getFlavor(Flavor.UNIX);
                    break block12;
                }
                if (tmp.equals(WIN) | tmp.equals(WINDOWS)) {
                    t = TerminalFactory.getFlavor(Flavor.WINDOWS);
                    break block12;
                }
                if (tmp.equals(NONE) || tmp.equals(OFF) || tmp.equals(FALSE)) {
                    t = new UnsupportedTerminal();
                    break block12;
                }
                if (tmp.equals(AUTO)) {
                    String os = Configuration.getOsName();
                    Flavor flavor = Flavor.UNIX;
                    if (os.contains(WINDOWS)) {
                        flavor = Flavor.WINDOWS;
                    }
                    t = TerminalFactory.getFlavor(flavor);
                    break block12;
                }
                try {
                    t = (Terminal)Thread.currentThread().getContextClassLoader().loadClass(type2).newInstance();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(MessageFormat.format("Invalid terminal type: {0}", type2), e);
                }
            }
            catch (Exception e) {
                Log.error("Failed to construct terminal; falling back to unsupported", e);
                t = new UnsupportedTerminal();
            }
        }
        Log.debug("Created Terminal: ", t);
        try {
            t.init();
        }
        catch (Throwable e) {
            Log.error("Terminal initialization failed; falling back to unsupported", e);
            return new UnsupportedTerminal();
        }
        return t;
    }

    public static synchronized void reset() {
        holder.remove();
    }

    public static synchronized void resetIf(Terminal t) {
        if (holder.get() == t) {
            TerminalFactory.reset();
        }
    }

    public static synchronized void configure(String type2) {
        Preconditions.checkNotNull(type2);
        System.setProperty(JLINE_TERMINAL, type2);
    }

    public static synchronized void configure(Type type2) {
        Preconditions.checkNotNull(type2);
        TerminalFactory.configure(type2.name().toLowerCase());
    }

    public static synchronized Terminal get() {
        Terminal t = (Terminal)holder.get();
        if (t == null) {
            t = TerminalFactory.create();
            holder.set(t);
        }
        return t;
    }

    public static Terminal getFlavor(Flavor flavor) throws Exception {
        Class<? extends Terminal> type2 = FLAVORS.get((Object)flavor);
        if (type2 != null) {
            return type2.newInstance();
        }
        throw new InternalError();
    }

    public static void registerFlavor(Flavor flavor, Class<? extends Terminal> type2) {
        FLAVORS.put(flavor, type2);
    }

    static {
        TerminalFactory.registerFlavor(Flavor.WINDOWS, AnsiWindowsTerminal.class);
        TerminalFactory.registerFlavor(Flavor.UNIX, UnixTerminal.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flavor {
        WINDOWS,
        UNIX;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        AUTO,
        WINDOWS,
        UNIX,
        NONE;

    }
}

