/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.SSLContext;
import org.jruby.ext.openssl.SSLSocket;
import org.jruby.ext.openssl.Utils;

public class SSL {
    public static final int VERIFY_NONE = 0;
    public static final int VERIFY_PEER = 1;
    public static final int VERIFY_FAIL_IF_NO_PEER_CERT = 2;
    public static final int VERIFY_CLIENT_ONCE = 4;
    public static final long OP_ALL = 4095L;
    public static final long OP_NO_TICKET = 16384L;
    public static final long OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION = 65536L;
    public static final long OP_SINGLE_ECDH_USE = 524288L;
    public static final long OP_SINGLE_DH_USE = 0x100000L;
    public static final long OP_EPHEMERAL_RSA = 0x200000L;
    public static final long OP_CIPHER_SERVER_PREFERENCE = 0x400000L;
    public static final long OP_TLS_ROLLBACK_BUG = 0x800000L;
    public static final long OP_NO_SSLv2 = 0x1000000L;
    public static final long OP_NO_SSLv3 = 0x2000000L;
    public static final long OP_NO_TLSv1 = 0x4000000L;
    public static final long OP_PKCS1_CHECK_1 = 0x8000000L;
    public static final long OP_PKCS1_CHECK_2 = 0x10000000L;
    public static final long OP_NETSCAPE_CA_DN_BUG = 0x20000000L;
    public static final long OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG = 0x40000000L;

    public static void createSSL(Ruby runtime, RubyModule ossl) {
        RubyModule mSSL = ossl.defineModuleUnder("SSL");
        RubyClass openSSLError = ossl.getClass("OpenSSLError");
        mSSL.defineClassUnder("SSLError", openSSLError, openSSLError.getAllocator());
        SSLContext.createSSLContext(runtime, mSSL);
        SSLSocket.createSSLSocket(runtime, mSSL);
        mSSL.setConstant("VERIFY_NONE", runtime.newFixnum(0));
        mSSL.setConstant("VERIFY_PEER", runtime.newFixnum(1));
        mSSL.setConstant("VERIFY_FAIL_IF_NO_PEER_CERT", runtime.newFixnum(2));
        mSSL.setConstant("VERIFY_CLIENT_ONCE", runtime.newFixnum(4));
        mSSL.setConstant("OP_ALL", runtime.newFixnum(4095L));
        mSSL.setConstant("OP_NO_TICKET", runtime.newFixnum(16384L));
        mSSL.setConstant("OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION", runtime.newFixnum(65536L));
        mSSL.setConstant("OP_SINGLE_ECDH_USE", runtime.newFixnum(524288L));
        mSSL.setConstant("OP_SINGLE_DH_USE", runtime.newFixnum(0x100000L));
        mSSL.setConstant("OP_EPHEMERAL_RSA", runtime.newFixnum(0x200000L));
        mSSL.setConstant("OP_CIPHER_SERVER_PREFERENCE", runtime.newFixnum(0x400000L));
        mSSL.setConstant("OP_TLS_ROLLBACK_BUG", runtime.newFixnum(0x800000L));
        mSSL.setConstant("OP_NO_SSLv2", runtime.newFixnum(0x1000000L));
        mSSL.setConstant("OP_NO_SSLv3", runtime.newFixnum(0x2000000L));
        mSSL.setConstant("OP_NO_TLSv1", runtime.newFixnum(0x4000000L));
        mSSL.setConstant("OP_PKCS1_CHECK_1", runtime.newFixnum(0x8000000L));
        mSSL.setConstant("OP_PKCS1_CHECK_2", runtime.newFixnum(0x10000000L));
        mSSL.setConstant("OP_NETSCAPE_CA_DN_BUG", runtime.newFixnum(0x20000000L));
        mSSL.setConstant("OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG", runtime.newFixnum(0x40000000L));
    }

    public static RaiseException newSSLError(Ruby runtime, Throwable t) {
        throw Utils.newError(runtime, "OpenSSL::SSL::SSLError", t.getMessage());
    }
}

