/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import javax.crypto.SecretKeyFactory;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.BN;
import org.jruby.ext.openssl.Cipher;
import org.jruby.ext.openssl.Config;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.HMAC;
import org.jruby.ext.openssl.NetscapeSPKI;
import org.jruby.ext.openssl.PKCS7;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.Random;
import org.jruby.ext.openssl.SSL;
import org.jruby.ext.openssl.X509;

public class OpenSSLReal {
    private static Provider BC_PROVIDER = null;

    public static void doWithBCProvider(final Runnable toRun) throws GeneralSecurityException {
        OpenSSLReal.getWithBCProvider(new Callable(){

            public Object call() throws GeneralSecurityException {
                toRun.run();
                return null;
            }
        });
    }

    public static Object getWithBCProvider(Callable toCall) throws GeneralSecurityException {
        try {
            if (BC_PROVIDER != null && Security.getProvider("BC") == null) {
                Security.addProvider(BC_PROVIDER);
            }
            return toCall.call();
        }
        catch (NoSuchProviderException nspe) {
            throw new GeneralSecurityException(OpenSSLReal.bcExceptionMessage(nspe), nspe);
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e.getMessage(), e);
        }
    }

    public static String bcExceptionMessage(NoSuchProviderException nspe) {
        return "You need to configure JVM/classpath to enable BouncyCastle Security Provider: " + nspe.getMessage();
    }

    public static String bcExceptionMessage(NoClassDefFoundError ncdfe) {
        return "You need to configure JVM/classpath to enable BouncyCastle Security Provider: NoClassDefFoundError: " + ncdfe.getMessage();
    }

    public static void createOpenSSL(Ruby runtime) {
        RubyModule ossl = runtime.getOrCreateModule("OpenSSL");
        RubyClass standardError = runtime.getClass("StandardError");
        ossl.defineClassUnder("OpenSSLError", standardError, standardError.getAllocator());
        PKey.createPKey(runtime, ossl);
        BN.createBN(runtime, ossl);
        Digest.createDigest(runtime, ossl);
        Cipher.createCipher(runtime, ossl);
        Random.createRandom(runtime, ossl);
        HMAC.createHMAC(runtime, ossl);
        Config.createConfig(runtime, ossl);
        try {
            ASN1.createASN1(runtime, ossl);
            X509.createX509(runtime, ossl);
            NetscapeSPKI.createNetscapeSPKI(runtime, ossl);
            PKCS7.createPKCS7(runtime, ossl);
        }
        catch (SecurityException ignore) {
            runtime.getLoadService().require("openssl/dummy");
        }
        catch (Error ignore) {
            runtime.getLoadService().require("openssl/dummy");
        }
        try {
            SSL.createSSL(runtime, ossl);
        }
        catch (SecurityException ignore) {
            runtime.getLoadService().require("openssl/dummyssl");
        }
        catch (Error ignore) {
            runtime.getLoadService().require("openssl/dummyssl");
        }
        runtime.getLoadService().require("jopenssl/version");
        String jopensslVersion = runtime.getClassFromPath("Jopenssl::Version").getConstant("VERSION").toString();
        ossl.setConstant("VERSION", runtime.newString("1.0.0"));
        ossl.setConstant("OPENSSL_VERSION", runtime.newString("jruby-ossl " + jopensslVersion));
        try {
            MessageDigest.getInstance("SHA224", BC_PROVIDER);
            ossl.setConstant("OPENSSL_VERSION_NUMBER", runtime.newFixnum(9469999));
        }
        catch (NoSuchAlgorithmException nsae) {
            ossl.setConstant("OPENSSL_VERSION_NUMBER", runtime.newFixnum(0x908000));
        }
    }

    public static javax.crypto.Cipher getCipherBC(final String algorithm) throws GeneralSecurityException {
        return (javax.crypto.Cipher)OpenSSLReal.getWithBCProvider(new Callable(){

            public Object call() throws GeneralSecurityException {
                return javax.crypto.Cipher.getInstance(algorithm, "BC");
            }
        });
    }

    public static SecretKeyFactory getSecretKeyFactoryBC(final String algorithm) throws GeneralSecurityException {
        return (SecretKeyFactory)OpenSSLReal.getWithBCProvider(new Callable(){

            public Object call() throws GeneralSecurityException {
                return SecretKeyFactory.getInstance(algorithm, "BC");
            }
        });
    }

    public static MessageDigest getMessageDigestBC(final String algorithm) throws GeneralSecurityException {
        return (MessageDigest)OpenSSLReal.getWithBCProvider(new Callable(){

            public Object call() throws GeneralSecurityException {
                return MessageDigest.getInstance(algorithm, "BC");
            }
        });
    }

    public static CertificateFactory getX509CertificateFactoryBC() throws GeneralSecurityException {
        return (CertificateFactory)OpenSSLReal.getWithBCProvider(new Callable(){

            public Object call() throws GeneralSecurityException {
                return CertificateFactory.getInstance("X.509", "BC");
            }
        });
    }

    static {
        try {
            BC_PROVIDER = (Provider)Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider").newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static interface Callable {
        public Object call() throws GeneralSecurityException;
    }

    public static interface Runnable {
        public void run() throws GeneralSecurityException;
    }
}

