/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Digest
extends RubyObject {
    private static final long serialVersionUID = 1L;
    private static ObjectAllocator DIGEST_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new Digest(runtime, klass);
        }
    };
    private MessageDigest algo = null;
    private String name = null;

    public static void createDigest(Ruby runtime, RubyModule mOSSL) {
        runtime.getLoadService().require("digest");
        RubyModule mDigest = runtime.getModule("Digest");
        RubyClass cDigestClass = mDigest.getClass("Class");
        RubyClass cDigest = mOSSL.defineClassUnder("Digest", cDigestClass, DIGEST_ALLOCATOR);
        cDigest.defineAnnotatedMethods(Digest.class);
        RubyClass openSSLError = mOSSL.getClass("OpenSSLError");
        mOSSL.defineClassUnder("DigestError", openSSLError, openSSLError.getAllocator());
    }

    static MessageDigest getDigest(String name2, Ruby runtime) {
        String algorithm = Digest.transformDigest(name2);
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            try {
                return OpenSSLReal.getMessageDigestBC(algorithm);
            }
            catch (GeneralSecurityException ignore) {
                throw runtime.newNotImplementedError("Unsupported digest algorithm (" + name2 + ")");
            }
        }
    }

    private static String transformDigest(String inp) {
        String[] sp = inp.split("::");
        if (sp.length > 1) {
            inp = sp[sp.length - 1];
        }
        if ("DSS".equalsIgnoreCase(inp)) {
            return "SHA";
        }
        if ("DSS1".equalsIgnoreCase(inp)) {
            return "SHA-1";
        }
        if (inp.toUpperCase().startsWith("SHA") && inp.length() > 3 && inp.charAt(3) != '-') {
            inp = "SHA-" + inp.substring(3);
        }
        return inp;
    }

    public Digest(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    public String getRealName() {
        return Digest.transformDigest(this.name);
    }

    public String getName() {
        return this.name;
    }

    @JRubyMethod(required=1, optional=1)
    public IRubyObject initialize(IRubyObject[] args2) {
        IRubyObject type2 = args2[0];
        IRubyObject data2 = this.getRuntime().getNil();
        if (args2.length > 1) {
            data2 = args2[1];
        }
        this.name = type2.toString();
        this.algo = Digest.getDigest(this.name, this.getRuntime());
        if (!data2.isNil()) {
            this.update(data2.convertToString());
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject initialize_copy(IRubyObject obj) {
        this.checkFrozen();
        if (this == obj) {
            return this;
        }
        this.name = ((Digest)obj).algo.getAlgorithm();
        try {
            this.algo = (MessageDigest)((Digest)obj).algo.clone();
        }
        catch (CloneNotSupportedException e) {
            throw this.getRuntime().newTypeError("Could not initialize copy of digest (" + this.name + ")");
        }
        return this;
    }

    @JRubyMethod(name={"update", "<<"})
    public IRubyObject update(IRubyObject obj) {
        ByteList bytes2 = obj.convertToString().getByteList();
        this.algo.update(bytes2.unsafeBytes(), bytes2.begin(), bytes2.getRealSize());
        return this;
    }

    @JRubyMethod
    public IRubyObject reset() {
        this.algo.reset();
        return this;
    }

    @JRubyMethod
    public IRubyObject finish() {
        RubyString digest2 = RubyString.newStringNoCopy(this.getRuntime(), this.algo.digest());
        this.algo.reset();
        return digest2;
    }

    @JRubyMethod
    public IRubyObject name() {
        return this.getRuntime().newString(this.name);
    }

    @JRubyMethod
    public IRubyObject digest_length() {
        return RubyFixnum.newFixnum(this.getRuntime(), this.algo.getDigestLength());
    }

    @JRubyMethod
    public IRubyObject block_length() {
        throw this.getRuntime().newRuntimeError(this.getMetaClass() + " doesn't implement block_length()");
    }

    String getAlgorithm() {
        return this.algo.getAlgorithm();
    }

    String getShortAlgorithm() {
        return this.getAlgorithm().replace("-", "");
    }
}

