/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.Aggregate;
import com.kenai.jffi.Array;
import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.Struct;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.MappedType;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.StructByValue;
import org.jruby.ext.ffi.StructLayout;
import org.jruby.ext.ffi.Type;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FFIUtil {
    private static final MemoryIO IO = MemoryIO.getInstance();
    private static final Map<NativeType, com.kenai.jffi.Type> typeMap = FFIUtil.buildTypeMap();

    private FFIUtil() {
    }

    private static final Map<NativeType, com.kenai.jffi.Type> buildTypeMap() {
        EnumMap<NativeType, com.kenai.jffi.Type> m = new EnumMap<NativeType, com.kenai.jffi.Type>(NativeType.class);
        m.put(NativeType.VOID, com.kenai.jffi.Type.VOID);
        m.put(NativeType.BOOL, com.kenai.jffi.Type.UINT8);
        m.put(NativeType.CHAR, com.kenai.jffi.Type.SCHAR);
        m.put(NativeType.SHORT, com.kenai.jffi.Type.SSHORT);
        m.put(NativeType.INT, com.kenai.jffi.Type.SINT);
        m.put(NativeType.LONG, com.kenai.jffi.Type.SLONG);
        m.put(NativeType.LONG_LONG, com.kenai.jffi.Type.SLONG_LONG);
        m.put(NativeType.UCHAR, com.kenai.jffi.Type.UCHAR);
        m.put(NativeType.USHORT, com.kenai.jffi.Type.USHORT);
        m.put(NativeType.UINT, com.kenai.jffi.Type.UINT);
        m.put(NativeType.ULONG, com.kenai.jffi.Type.ULONG);
        m.put(NativeType.ULONG_LONG, com.kenai.jffi.Type.ULONG_LONG);
        m.put(NativeType.FLOAT, com.kenai.jffi.Type.FLOAT);
        m.put(NativeType.DOUBLE, com.kenai.jffi.Type.DOUBLE);
        m.put(NativeType.POINTER, com.kenai.jffi.Type.POINTER);
        m.put(NativeType.BUFFER_IN, com.kenai.jffi.Type.POINTER);
        m.put(NativeType.BUFFER_OUT, com.kenai.jffi.Type.POINTER);
        m.put(NativeType.BUFFER_INOUT, com.kenai.jffi.Type.POINTER);
        m.put(NativeType.STRING, com.kenai.jffi.Type.POINTER);
        m.put(NativeType.TRANSIENT_STRING, com.kenai.jffi.Type.POINTER);
        return m;
    }

    static final com.kenai.jffi.Type getFFIType(Type type2) {
        Object jffiType = type2.getFFIHandle();
        if (jffiType instanceof com.kenai.jffi.Type) {
            return (com.kenai.jffi.Type)jffiType;
        }
        return FFIUtil.cacheFFIType(type2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static com.kenai.jffi.Type cacheFFIType(Type type2) {
        Object ffiType;
        Type type3 = type2;
        synchronized (type3) {
            ffiType = type2.getFFIHandle();
            if (ffiType instanceof com.kenai.jffi.Type) {
                return (com.kenai.jffi.Type)ffiType;
            }
            if (type2 instanceof Type.Builtin || type2 instanceof CallbackInfo) {
                ffiType = FFIUtil.getFFIType(type2.getNativeType());
            } else if (type2 instanceof StructLayout) {
                ffiType = FFIUtil.newStruct((StructLayout)type2);
            } else if (type2 instanceof StructByValue) {
                ffiType = FFIUtil.newStruct(((StructByValue)type2).getStructLayout());
            } else if (type2 instanceof Type.Array) {
                ffiType = FFIUtil.newArray((Type.Array)type2);
            } else if (type2 instanceof MappedType) {
                ffiType = FFIUtil.getFFIType(((MappedType)type2).getRealType());
            } else {
                return null;
            }
            type2.setFFIHandle(ffiType);
        }
        return (com.kenai.jffi.Type)ffiType;
    }

    static final com.kenai.jffi.Type getFFIType(NativeType type2) {
        return typeMap.get((Object)type2);
    }

    static final Aggregate newStruct(StructLayout layout2) {
        if (layout2.isUnion()) {
            com.kenai.jffi.Type[] alignmentTypes = new com.kenai.jffi.Type[]{com.kenai.jffi.Type.SINT8, com.kenai.jffi.Type.SINT16, com.kenai.jffi.Type.SINT32, com.kenai.jffi.Type.SINT64, com.kenai.jffi.Type.FLOAT, com.kenai.jffi.Type.DOUBLE, com.kenai.jffi.Type.LONGDOUBLE};
            com.kenai.jffi.Type alignmentType = null;
            for (com.kenai.jffi.Type t : alignmentTypes) {
                if (t.alignment() != layout2.getNativeAlignment()) continue;
                alignmentType = t;
                break;
            }
            if (alignmentType == null) {
                throw layout2.getRuntime().newRuntimeError("cannot discern base alignment type for union of alignment " + layout2.getNativeAlignment());
            }
            Object[] fields2 = new com.kenai.jffi.Type[layout2.getNativeSize() / alignmentType.size()];
            Arrays.fill(fields2, alignmentType);
            return Struct.newStruct((com.kenai.jffi.Type[])fields2);
        }
        Collection<StructLayout.Member> structMembers = layout2.getMembers();
        com.kenai.jffi.Type[] fields3 = new com.kenai.jffi.Type[structMembers.size()];
        int i2 = 0;
        for (StructLayout.Member m : structMembers) {
            com.kenai.jffi.Type fieldType = FFIUtil.getFFIType(m.type());
            if (fieldType == null) {
                throw layout2.getRuntime().newTypeError("unsupported Struct field type " + m);
            }
            fields3[i2++] = fieldType;
        }
        return Struct.newStruct(fields3);
    }

    static Array newArray(Type.Array arrayType) {
        com.kenai.jffi.Type componentType = FFIUtil.getFFIType(arrayType.getComponentType());
        if (componentType == null) {
            throw arrayType.getRuntime().newTypeError("unsupported array element type " + arrayType.getComponentType());
        }
        return Array.newArray(componentType, arrayType.length());
    }

    static final IRubyObject getString(Ruby runtime, long address2) {
        if (address2 == 0L) {
            return runtime.getNil();
        }
        byte[] bytes2 = FFIUtil.getZeroTerminatedByteArray(address2);
        if (bytes2.length == 0) {
            return RubyString.newEmptyString(runtime);
        }
        RubyString s2 = RubyString.newStringNoCopy(runtime, bytes2);
        s2.setTaint(true);
        return s2;
    }

    static final byte[] getZeroTerminatedByteArray(long address2) {
        return IO.getZeroTerminatedByteArray(address2);
    }

    static final byte[] getZeroTerminatedByteArray(long address2, int maxlen) {
        return IO.getZeroTerminatedByteArray(address2, maxlen);
    }

    static final void putZeroTerminatedByteArray(long address2, byte[] bytes2, int off, int len) {
        IO.putByteArray(address2, bytes2, off, len);
        IO.putByte(address2 + (long)len, (byte)0);
    }

    static final Type resolveType(ThreadContext context, IRubyObject obj) {
        if (obj instanceof Type) {
            return (Type)obj;
        }
        RubyModule ffi2 = context.getRuntime().getModule("FFI");
        IRubyObject typeDefs = ffi2.fetchConstant("TypeDefs");
        if (!(typeDefs instanceof RubyHash)) {
            throw context.getRuntime().newRuntimeError("invalid or corrupted FFI::TypeDefs");
        }
        IRubyObject type2 = ((RubyHash)typeDefs).fastARef(obj);
        if (type2 == null || type2.isNil()) {
            type2 = ffi2.callMethod(context, "find_type", obj);
        }
        if (!(type2 instanceof Type)) {
            throw context.getRuntime().newTypeError("Could not resolve type: " + obj);
        }
        return (Type)type2;
    }
}

