/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.cext;

import org.jruby.RubyModule;
import org.jruby.cext.GIL;
import org.jruby.cext.Native;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public class NativeMethod
extends DynamicMethod {
    protected final Arity arity;
    protected final long function;
    private final Native nativeInstance;

    public NativeMethod(RubyModule clazz, int arity2, long function) {
        super(clazz, Visibility.PUBLIC, CallConfiguration.FrameBacktraceScopeFull);
        this.arity = Arity.createArity(arity2);
        this.function = function;
        this.nativeInstance = Native.getInstance(clazz.getRuntime());
    }

    public final DynamicMethod dup() {
        return this;
    }

    public final Arity getArity() {
        return this.arity;
    }

    public final boolean isNative() {
        return true;
    }

    static void pre(ThreadContext context, IRubyObject self, RubyModule klazz, String name2) {
        context.preMethodFrameOnly(klazz, name2, self, Block.NULL_BLOCK);
        DynamicScope currentScope = context.getCurrentScope();
        context.pushScope(new ManyVarsDynamicScope(currentScope.getStaticScope(), currentScope));
        GIL.acquire();
    }

    static void pre(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, Block block) {
        context.preMethodFrameOnly(klazz, name2, self, block);
        DynamicScope currentScope = context.getCurrentScope();
        context.pushScope(new ManyVarsDynamicScope(currentScope.getStaticScope(), currentScope));
        GIL.acquire();
    }

    static void post(ThreadContext context) {
        GIL.release();
        context.postMethodFrameAndScope();
    }

    final Native getNativeInstance() {
        return this.nativeInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject recv2, RubyModule clazz, String name2, IRubyObject[] args2) {
        NativeMethod.pre(context, recv2, this.getImplementationClass(), name2);
        try {
            IRubyObject iRubyObject = this.getNativeInstance().callMethod(context, this.function, recv2, this.arity.getValue(), args2);
            return iRubyObject;
        }
        finally {
            NativeMethod.post(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject recv2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        NativeMethod.pre(context, recv2, this.getImplementationClass(), name2, block);
        try {
            IRubyObject iRubyObject = this.getNativeInstance().callMethod(context, this.function, recv2, this.arity.getValue(), args2);
            return iRubyObject;
        }
        finally {
            NativeMethod.post(context);
        }
    }
}

