/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.IScopingNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleNode
extends Node
implements IScopingNode {
    private final Colon3Node cpath;
    private final StaticScope scope;
    private final Node bodyNode;

    public ModuleNode(ISourcePosition position, Colon3Node cpath, StaticScope scope, Node bodyNode) {
        super(position);
        assert (cpath != null) : "cpath is not null";
        assert (scope != null) : "scope is not null";
        assert (bodyNode != null) : "bodyNode is not null";
        this.cpath = cpath;
        this.scope = scope;
        this.bodyNode = bodyNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MODULENODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitModuleNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public StaticScope getScope() {
        return this.scope;
    }

    @Override
    public Colon3Node getCPath() {
        return this.cpath;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.cpath, this.bodyNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        RubyModule enclosingModule = this.cpath.getEnclosingModule(runtime, context, self, aBlock);
        if (enclosingModule == null) {
            throw runtime.newTypeError("no outer class/module");
        }
        String name2 = this.cpath.getName();
        RubyModule module = enclosingModule.defineOrGetModuleUnder(name2);
        this.scope.setModule(module);
        return ASTInterpreter.evalClassDefinitionBody(runtime, context, this.scope, this.bodyNode, module, self, aBlock);
    }
}

